"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Job = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const job_data_1 = require("./job-data");
class Job extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.runsOn = 'ubuntu-latest';
        this.dependsOn = [];
        this.permissions = { contents: job_data_1.JobPermission.WRITE };
        this.timeoutMinutes = 3600;
        this.secrets = [];
        if (props.jobRefereneName) {
            this.id = props.jobRefereneName;
        }
        else {
            this.id = id;
        }
        if (props.steps.length === 0) {
            throw new Error('Job must have at least one step');
        }
        for (const step of props.steps) {
            if (step.withSecrets) {
                this.secrets.push(...step.withSecrets);
            }
        }
        this.steps = props.steps;
        if (props.runsOn) {
            this.runsOn = props.runsOn;
        }
        if (props.dependsOn) {
            for (const job of props.dependsOn) {
                this.dependsOn.push(job.id);
            }
        }
        if (props.permissions) {
            this.permissions = props.permissions;
        }
        if (props.timeoutMinutes) {
            this.timeoutMinutes = props.timeoutMinutes;
        }
        if (props.name) {
            this.name = props.name;
        }
        if (props.environment) {
            this.environment = props.environment;
        }
        if (props.concurrency) {
            this.concurrency = props.concurrency;
        }
        if (props.strategy) {
            this.strategy = props.strategy;
        }
        if (props.outputs) {
            this.outputs = props.outputs;
        }
        if (props.env) {
            this.env = props.env;
        }
        if (props.defaults) {
            this.defaults = props.defaults;
        }
        if (props.runIf) {
            this.runIf = props.runIf;
        }
        if (props.continueOnError) {
            this.continueOnError = props.continueOnError;
        }
        if (props.container) {
            this.container = props.container;
        }
        if (props.services) {
            this.services = props.services;
        }
    }
    addDependency(job) {
        this.dependsOn.push(job.id);
    }
    toObject() {
        return {
            runsOn: this.runsOn,
            steps: this.steps,
            name: this.name,
            needs: this.dependsOn,
            permissions: this.permissions,
            environment: this.environment,
            concurrency: this.concurrency,
            outputs: this.outputs,
            env: this.env,
            defaults: this.defaults,
            if: this.runIf,
            timeoutMinutes: this.timeoutMinutes,
            strategy: this.strategy,
            continueOnError: this.continueOnError,
            container: this.container,
            services: this.services,
        };
    }
}
exports.Job = Job;
_a = JSII_RTTI_SYMBOL_1;
Job[_a] = { fqn: "@awlsring/cdktf-github-actions.Job", version: "0.0.17" };
//# sourceMappingURL=data:application/json;base64,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