# coding: utf-8

"""
    trieve-server

    Trieve REST API OpenAPI Documentation

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, StrictInt
from typing import Any, ClassVar, Dict, List
from trieve_python_client.models.bookmark_chunks import BookmarkChunks
from trieve_python_client.models.chunk_collection import ChunkCollection
from typing import Optional, Set
from typing_extensions import Self

class BookmarkData(BaseModel):
    """
    BookmarkData
    """ # noqa: E501
    bookmarks: List[BookmarkChunks]
    collection: ChunkCollection
    total_pages: StrictInt
    __properties: ClassVar[List[str]] = ["bookmarks", "collection", "total_pages"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BookmarkData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in bookmarks (list)
        _items = []
        if self.bookmarks:
            for _item in self.bookmarks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['bookmarks'] = _items
        # override the default output from pydantic by calling `to_dict()` of collection
        if self.collection:
            _dict['collection'] = self.collection.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BookmarkData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bookmarks": [BookmarkChunks.from_dict(_item) for _item in obj["bookmarks"]] if obj.get("bookmarks") is not None else None,
            "collection": ChunkCollection.from_dict(obj["collection"]) if obj.get("collection") is not None else None,
            "total_pages": obj.get("total_pages")
        })
        return _obj


