# coding: utf-8

"""
    trieve-server

    Trieve REST API OpenAPI Documentation

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from trieve_python_client.models.chat_message_proxy import ChatMessageProxy
from typing import Optional, Set
from typing_extensions import Self

class GenerateChunksRequest(BaseModel):
    """
    GenerateChunksRequest
    """ # noqa: E501
    chunk_ids: List[StrictStr] = Field(description="The ids of the chunks to be retrieved and injected into the context window for RAG.")
    model: Optional[StrictStr] = Field(default=None, description="The model to use for the chat. This can be any model from the model list. If no model is provided, the gryphe/mythomax-l2-13b will be used.")
    prev_messages: List[ChatMessageProxy] = Field(description="The previous messages to be placed into the chat history. The last message in this array will be the prompt for the model to inference on.")
    __properties: ClassVar[List[str]] = ["chunk_ids", "model", "prev_messages"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GenerateChunksRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in prev_messages (list)
        _items = []
        if self.prev_messages:
            for _item in self.prev_messages:
                if _item:
                    _items.append(_item.to_dict())
            _dict['prev_messages'] = _items
        # set to None if model (nullable) is None
        # and model_fields_set contains the field
        if self.model is None and "model" in self.model_fields_set:
            _dict['model'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GenerateChunksRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chunk_ids": obj.get("chunk_ids"),
            "model": obj.get("model"),
            "prev_messages": [ChatMessageProxy.from_dict(_item) for _item in obj["prev_messages"]] if obj.get("prev_messages") is not None else None
        })
        return _obj


