////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2010-2024 60East Technologies Inc., All Rights Reserved.
//
// This computer software is owned by 60East Technologies Inc. and is
// protected by U.S. copyright laws and other laws and by international
// treaties.  This computer software is furnished by 60East Technologies
// Inc. pursuant to a written license agreement and may be used, copied,
// transmitted, and stored only in accordance with the terms of such
// license agreement and with the inclusion of the above copyright notice.
// This computer software or any other copies thereof may not be provided
// or otherwise made available to any other person.
//
// U.S. Government Restricted Rights.  This computer software: (a) was
// developed at private expense and is in all respects the proprietary
// information of 60East Technologies Inc.; (b) was not developed with
// government funds; (c) is a trade secret of 60East Technologies Inc.
// for all purposes of the Freedom of Information Act; and (d) is a
// commercial item and thus, pursuant to Section 12.212 of the Federal
// Acquisition Regulations (FAR) and DFAR Supplement Section 227.7202,
// Government's use, duplication or disclosure of the computer software
// is subject to the restrictions set forth by 60East Technologies Inc..
//
////////////////////////////////////////////////////////////////////////////

static const char* client_class_doc = "\n"
                                      " The base AMPS Client object used in AMPS applications. Each Client"
                                      " object manages a single connection to AMPS. Each AMPS connection has"
                                      " a name, a specific transport (such as tcp), a protocol (used for framing"
                                      " messages to AMPS), and a message type (such as FIX or JSON)."
                                      " \n\n"
                                      " The Client object creates and manages a background thread, and sends and "
                                      " receives messages on that thread. The object provides both a synchronous "
                                      " interface for processing messages on the calling thread, and an "
                                      " asynchronous interface suitable for populating a queue to be processed by"
                                      " worker threads.\n\n"
                                      " Each Client has a name. The AMPS server uses this name for duplicate"
                                      " message detection, so the name of each instance of the client application"
                                      " should be unique.\n\n"
                                      "  An example of a simple Python client publishing a JSON message is listed below::\n\n"
                                      "    c = Client(\"test_client\")\n\n"
                                      "    try:\n"
                                      "        c.connect(\"tcp://127.0.0.1:9004/json\")\n"
                                      "        cid = c.logon()\n"
                                      "        c.publish(\"topic_name\",'{\"a\":1,\"b\":\"2\"}')\n"
                                      "    finally:\n"
                                      "        c.close()\n\n"
                                      "Constructor arguments:\n\n"
                                      ":param name: the unique name for this client. AMPS does not enforce "
                                      " specific restrictions on the character set used, however some protocols"
                                      " (for example, XML) may not allow specific characters. 60East recommends"
                                      " that the client name be meaningful, short, human readable, and avoid"
                                      " using control characters, newline characters, or square brackets.\n\n"
                                      ;

static const char* bookmark_class_doc = "This class provides special values for bookmark subscriptions:\n\n"
                                        "  * ``EPOCH`` begin the subscription at the beginning of the journal\n"
                                        "  * ``MOST_RECENT`` begin the subscription at the first undiscarded message in the bookmark store, or at the end of the bookmark store if all messages have been discarded\n"
                                        "  * ``NOW`` begin the subscription at the time that AMPS processes the subscription\n\n"
                                        "For example, to begin a bookmark subscription at the beginning of the journal,"
                                        " provide ``AMPS.Client.Bookmarks.EPOCH`` as the bookmark in the call to "
                                        " :meth:`AMPS.Client.bookmark_subscribe`." ;

static const char* allocateMessage_doc = "allocateMessage()\n\n"
                                         " A legacy method name for :meth:`allocate_message`.\n"
                                         "\n"
                                         "        \n"
                                         ;
static const char* allocate_message_doc = "allocate_message()\n\n"
                                          " Creates a new :class:`Message` appropriate for this client.\n"
                                          "\n"
                                          "        This function should be called rarely, since it does allocate a handful        of small objects.\n"
                                          "\n"
                                          ":returns: A new `Message` instance.\n"
                                          "        \n"
                                          ;
static const char* execute_doc = "Executes a Command on self."
                                 "\n\n:param: An AMPS.Command to execute.\n"
                                 ":returns: A MessageStream to iterate over.\n\n";
static const char* execute_async_doc = "Execute the provided command and process"
                                       " responses on the client receive thread using the provided handler.\n\n"
                                       "This method creates a ``Message`` based on the provided ``Command``, sends the "
                                       " ``Message`` to AMPS, and invokes the provided handler to process messages returned"
                                       " in response to the command. Rather than providing messages on the calling thread,"
                                       " the AMPS Python client runs the handler directly on the client receive thread.\n\n"
                                       "When the provided handler is not ``None``, this function blocks until AMPS"
                                       " acknowledges that the command has been processed. The results of the command"
                                       " after that acknowledgement are provided to the handler.\n\n"
                                       ":type on_message: a function or other callable object.\n"
                                       ":type command: AMPS.Command\n"
                                       ":param command: The command to execute.\n"
                                       ":param on_message: A handler for messages returned by this command execution.\n"
                                       ":returns: The command ID assigned to the executed command.\n\n";

static const char* get_unpersisted_count_doc = "Returns the count of unpersisted publishes.\n\n:returns: count of unpersisted publishes.";

static const char* get_server_version_doc = "get_server_version()\n\n"
                                            "Returns the connected server's version as a numeric value.\n\n"
                                            ":returns: The version converted to a number: server version 3.8.1.7 would be 3080107";

static const char* get_server_version_info_doc = "get_server_version_info()\n\n"
                                                 "Returns the connected server's version as a VersionInfo.\n\n"
                                                 ":returns: The version in a VersionInfo";

static const char* convert_version_to_number_doc = "convert_version_to_number(version)"
                                                   "Converts the provided version string to a number using 2 digits for each dot.\n"
                                                   "A value such as 4.0 will become 4000000 while 3.8.1.7 will return 3080107.\n\n"
                                                   ":param version: The version string to convert.\n"
                                                   ":type version: str\n"
                                                   ":returns: The numeric value for the version string.";

static const char* bookmark_subscribe_doc = "bookmark_subscribe(on_message,topic,bookmark,filter=None,sub_id=None,options=None,timeout=0)\n\n"
                                            " Places a bookmark subscription with AMPS. Starts replay at the most\n"
                                            "        recent message reported by the `bookmark` parameter.\n"
                                            "\n"
                                            ":param on_message: The message handler to invoke with matching messages.\n"
                                            ":type on_message: :class:`MessageHandler`\n"
                                            ":param topic: The `Topic` to subscribe to.\n"
                                            ":type topic: str\n"
                                            ":param bookmark: A bookmark identifier, or one of the constants from\n"
                                            "           :class:`Bookmarks`\n"
                                            ":type bookmark: str\n"
                                            ":param filter: The filter.\n"
                                            ":type filter: str\n"
                                            ":param sub_id: The subscription ID.  You may optionally provide a\n"
                                            "           subscription ID to ease recovery scenarios, instead of having the\n"
                                            "           system automatically generate one for you.\n"
                                            "           When used with the 'replace' option, this is the subscription to\n"
                                            "           be replaced.\n"
                                            "           With a bookmark store, this is the subscription ID used for\n"
                                            "           recovery. So, when using a persistent bookmark store, provide an explicit\n"
                                            "           subscription id that is consistent across application restarts.\n"
                                            ":type sub_id: str\n"
                                            ":param options: A comma separated string of options. Default is `None`.\n"
                                            ":type options: str\n"
                                            ":param timeout: The maximum time to wait for the client to receive and\n"
                                            "           and consume a processed ack for this subscription\n"
                                            "           (in milliseconds). ``0`` indicates to wait indefinitely.\n"
                                            ":type timeout: int\n"
                                            "\n"
                                            ":raises: :exc:`SubscriptionAlreadyExistsException`,\n"
                                            "        :exc:`BadFilterException`, :exc:`BadRegexTopicException`,\n"
                                            "        :exc:`TimedOutException`, :exc:`DisconnectedException`.\n"
                                            "\n"
                                            "        \n"
                                            ;

static const char* close_doc = "close()\n\n"
                               "Disconnect from the AMPS server.\n"
                               ;
static const char* connect_doc = "connect(uri)\n\n"
                                 " Connects to the AMPS instance through the provided :class:`URI`.\n"
                                 "\n"
                                 "        The :class:`URI` is a string with the format:\n"
                                 "           ``transport://userId:password@host:port/protocol`` where:\n"
                                 "\n"
                                 "        * *transport* -- The network transport used for the connection.\n"
                                 "        * *userId* -- If authentication is enabled, this is the unique user ID\n"
                                 "           used to authenticate the connection.\n"
                                 "        * *password* -- If authentication is enabled, this is the password used\n"
                                 "           to authenticate the connection.\n"
                                 "        * *host* -- The hostname or IP address of the host where AMPS is\n"
                                 "           installed.\n"
                                 "        * *port* -- The port to connect to the AMPS instance.\n"
                                 "        * *protocol* -- The protocol used by this connection.\n"
                                 "\n"
                                 "        .. note:: Authentication is optional, if the system is using the\n"
                                 "          default authentication with AMPS which allows all users in without\n"
                                 "          regard for their ``userId`` or ``password``, then the\n"
                                 "          ``userId:password@`` string can be omitted from the connect URI.\n"
                                 "\n"
                                 ":param uri: The :class`URI` used to connect to AMPS.\n"
                                 ":type uri: str\n"
                                 ":raises: :class:`ConnectionException`\n"
                                 "\n"
                                 "        \n"
                                 ;
static const char* deltaPublish_doc = "deltaPublish(topic,data)\n\n"
                                      " This is a legacy method name for :meth:`delta_publish`.\n\n"
                                      "  .. deprecated:: 3.2.0.0\n"
                                      "   Use :func:`delta_publish` instead.\n"
                                      "\n"
                                      "        \n"
                                      ;
static const char* deltaSubscribe_doc = "deltaSubscribe(on_message,topic,filter=None,options=0,timeout=0)\n\n"
                                        " A legacy method name for :meth:`delta_subscribe`.\n\n"
                                        "  .. deprecated:: 3.2.0.0\n"
                                        "   Use :func:`delta_subscribe` instead.\n"
                                        "\n"
                                        ;
static const char* delta_publish_doc = "delta_publish(topic,data,expiration=None)\n\n"
                                       "Delta publish a message to an AMPS topic.\n"
                                       "This method does not wait for a response from the AMPS server.\n"
                                       "To detect failure, install a failed write handler.\n"
                                       "If the client was created with a persistent store on construction,\n"
                                       "then the client will store before forwarding the message to AMPS.\n"
                                       "\n"
                                       ":param topic: `Topic` to publish the data to.\n"
                                       ":type topic: str\n"
                                       ":param data: `Data` to publish to the topic.\n"
                                       ":type data: str\n"
                                       ":param expiration: Number of seconds until published message should expire.\n"
                                       ":type expiration: int\n"
                                       "\n"
                                       ":returns: The sequence number assigned to this message by the publish store\n"
                                       "           or 0 if there is no publish store and the server is assigning sequence numbers.\n"
                                       "\n"
                                       ":raises: :exc:`DisconnectedException`\n"
                                       "\n"
                                       "        \n"
                                       ;
static const char* delta_subscribe_doc = "delta_subscribe(on_message,topic,filter=None,options=0,timeout=0, sub_id=None)\n\n"
                                         "Places a delta subscription with AMPS.\n"
                                         "\n"
                                         ":param on_message: The message handler to invoke with matching\n"
                                         "           messages.\n"
                                         ":type on_message: str\n"
                                         ":param topic: The topic to subscribe to.\n"
                                         ":type topic: str\n"
                                         ":param filter: The filter.\n"
                                         ":type filter: str\n"
                                         ":param options: A comma separated list of values indicating additional\n"
                                         "           processing options.\n"
                                         ":type options: str\n"
                                         ":param timeout:  The maximum time to wait for the client to receive and\n"
                                         "           consume the processed ack for this subscription\n"
                                         "           (in milliseconds). ``0`` indicates to wait indefinitely.\n"
                                         ":type timeout: int\n"
                                         ":param sub_id: The subscription ID.  You may optionally provide a\n"
                                         "           subscription ID to ease recovery scenarios, instead of having the\n"
                                         "           system automatically generate one for you.\n"
                                         "           When used with the 'replace' option, this is the subscription to\n"
                                         "           be replaced.\n"
                                         ":type sub_id: str\n"
                                         "\n"
                                         ":returns: The command identifier assigned to this command.\n"
                                         "\n"
                                         ":raises: :exc:`SubscriptionAlreadyExistsException`,\n"
                                         "            :exc:`BadFilterException`, :exc:`BadRegexTopicException`,\n"
                                         "            :exc:`TimedOutException`, :exc:`DisconnectedException`\n"
                                         "\n"
                                         "        \n"
                                         ;
static const char* disconnect_doc = "disconnect()\n\n"
                                    " Disconnects and closes any active connections.\n"
                                    "\n"
                                    "        \n"
                                    ;
static const char* getName_doc = "getName()\n\n"
                                 " A legacy method name for :meth:`get_name`.\n"
                                 "\n"
                                 "        \n"
                                 ;
static const char* get_name_doc = "get_name()\n\n"
                                  "Returns the name of the `Client` object.\n"
                                  "\n"
                                  ":returns: name\n"
                                  "\n"
                                  "        \n"
                                  ;
static const char* get_name_hash_doc = "get_name_hash()\n\n"
                                       "Returns the string name hash of the `Client` object.\n"
                                       "\n"
                                       ":returns: name hash string\n"
                                       "\n"
                                       "        \n"
                                       ;
static const char* get_name_hash_value_doc = "get_name_hash_value()\n\n"
                                             "Returns the numeric name hash of the `Client` object.\n"
                                             "\n"
                                             ":returns: name hash int\n"
                                             "\n"
                                             "        \n"
                                             ;
static const char* setName_doc = "setName(name)\n\n"
                                 " A legacy method name for :meth:`set_name`.\n"
                                 "  .. deprecated:: 3.2.0.0\n"
                                 "   Use :func:`set_name` instead.\n"
                                 "\n"
                                 ;
static const char* set_name_doc = "set_name(name)\n\n"
                                  " A legacy method name for :meth:`set_name`.\n"
                                  "\n"
                                  "        \n"
                                  ;
static const char* get_logon_correlation_data_doc = "get_logon_correlation_data()\n\n"
                                                    "Returns the data used to correlate the logon of this Client to the server.\n"
                                                    "\n"
                                                    ":returns: logon correlation data\n"
                                                    "\n"
                                                    "        \n"
                                                    ;
static const char* set_logon_correlation_data_doc = "set_logon_correlation_data()\n\n"
                                                    "Sets the data used to correlate the logon of this Client in the server.\n"
                                                    "\n"
                                                    ":param logonCorrelationData: The base64 data string to send with the logon.\n"
                                                    "\n"
                                                    "        \n"
                                                    ;
static const char* logon_doc = "logon(timeout=0,authenticator=AMPS.DefaultAuthenticator,options='')\n\n"
                               "Logs into AMPS with the parameters provided in the :meth:`connect` method.\n"
                               "\n"
                               ":param timeout: The maximum time to wait for the command to\n"
                               "           receive a processed ack from AMPS for the logon command\n"
                               "           (in milliseconds). ``0``` indicates to wait indefinitely.\n"
                               ":type timeout: int\n"
                               "\n"
                               ":param authenticator: An `Authenticator` object used to negotiate logon.\n"
                               ":type authenticator: Authenticator\n"
                               "\n"
                               ":param options: An options string to pass to the server such as ack_conflation=10ms\n"
                               "           execute (milliseconds). ``0`` indicates to wait indefinitely.\n"
                               ":type options: string\n"
                               "\n"
                               ":returns: The command identifier.\n"
                               "\n"
                               ":raises: :exc:`ConnectionException`\n"
                               "\n"
                               "        \n"
                               ;
static const char* name_doc = "name()\n\n"
                              "Returns the name of the `Client` object.\n"
                              "\n"
                              ":returns: name\n"
                              "\n"
                              "        \n"
                              ;
static const char* publish_doc = "publish(topic,data,expiration=None)\n\n"
                                 "Publish a mesage to an AMPS topic.\n"
                                 "This method does not wait for a response from the AMPS server.\n"
                                 "To detect failure, install a failed write handler.\n"
                                 "If the client was created with a persistent store on construction,\n"
                                 "then the client will store before forwarding the message to AMPS.\n"
                                 "If a DisconnectException occurs, the message\n"
                                 "is still stored in the publish store.\n"
                                 "\n"
                                 ":param topic: The topic to publish to.\n"
                                 ":type topic: str\n"
                                 ":param data: The data to publish.\n"
                                 ":type data: str\n"
                                 ":param expiration: Number of seconds until published message should expire.\n"
                                 ":type expiration: int\n"
                                 "\n"
                                 ":returns: The sequence number assigned to this message by the publish store\n"
                                 "           or 0 if there is no publish store and the server is assigning sequence numbers.\n"
                                 "\n"
                                 ":raises: :exc:`DisconnectedException` "
                                 "The client is not connected; the program needs to call connect()\n\n"
                                 "\n"
                                 ;
static const char* send_doc = "send(message,message_handler=None,timeout=None)\n\n"
                              " Send a :class:`Message` to AMPS via the :class:`Transport` used in\n"
                              "        the :class:`Client`.\n"
                              "\n"
                              ":param message: The message to send.\n"
                              ":type message: :class:`Message`\n"
                              ":param message_handler: The message handler that will receive messages\n"
                              "           for this command.\n"
                              ":type message_handler: :class:`MessageHandler`\n"
                              ":param timeout: The maximum time to wait for the client to receive and\n"
                              "           consume a processed ack for this command (in milliseconds).\n"
                              "           ``0`` indicates to wait indefinitely.\n"
                              ":type timeout: int\n"
                              ":returns: The command identifier assigned to this command, or `None` if\n"
                              "           one is not assigned.\n"
                              "\n"
                              "        \n"
                              ;
static const char* add_message_handler_doc = "add_message_handler(command_id,message_handler,acks,is_subscribe)\n\n"
                                             " Add a message handler to the :class:`Client` to handle messages and the\n"
                                             " requested acks sent in response to the given command_id.\n"
                                             "\n"
                                             ":param command_id: The command, query, or sub id for messages and acks.\n"
                                             ":type command_id: str\n"
                                             ":param message_handler: The message handler that will receive messages\n"
                                             "           for the command_id.\n"
                                             ":type message_handler: :class:`MessageHandler`\n"
                                             ":param acks: The acks requested to go to the message_handler.\n"
                                             ":type acks: int\n"
                                             ":param is_subscribe: If the message_handler is for a subscribe command.\n"
                                             ":type is_subscribe: int\n"
                                             "\n"
                                             "        \n"
                                             ;
static const char* remove_message_handler_doc = "remove_message_handler(command_id)\n\n"
                                                " Remove a message handler from the :class:`Client.`\n"
                                                "\n"
                                                ":param command_id: The command_id for the handler to remove.\n"
                                                ":type command_id: str\n"
                                                "\n"
                                                "        \n"
                                                ;
static const char* setOnDisconnectHandler_doc = "setOnDisconnectHandler(client_disconnect_handler)\n\n"
                                                " A legacy method name for :meth:`set_disconnect_handler`\n"
                                                "  .. deprecated:: 3.2.0.0\n"
                                                "   Use :func:`set_disconnect_handler` instead.\n"
                                                "\n"
                                                ;
static const char* setDisconnectHandler_doc = "setDisconnectHandler(client_disconnect_handler)\n\n"
                                              " A legacy method name for :meth:`set_disconnect_handler`\n"
                                              "  .. deprecated:: 3.2.0.0\n"
                                              "   Use :func:`set_disconnect_handler` instead.\n"
                                              "\n"
                                              ;
static const char* setExceptionListener_doc = "setExceptionListener(exception_listener)\n\n"
                                              " A legacy method name for :meth:`set_exception_listener`.\n"
                                              "  .. deprecated:: 3.2.0.0\n"
                                              "   Use :func:`set_exception_listener` instead.\n"
                                              "\n"
                                              ;
static const char* setUnhandledMessageHandler_doc = "setUnhandledMessageHandler(message_handler)\n\n"
                                                    " A legacy method name for :meth:`set_last_chance_message_handler`.\n"
                                                    "  .. deprecated:: 3.2.0.0\n"
                                                    "   Use :func:`set_last_chance_message_handler` instead.\n"
                                                    "\n"
                                                    ;
static const char* set_unhandled_message_handler_doc = "set_unhandled_message_handler(message_handler)\n\n"
                                                       " A legacy method name for :meth:`set_last_chance_message_handler`.\n"
                                                       "  .. deprecated:: 4.0.0.0\n"
                                                       "   Use :func:`set_last_chance_message_handler` instead.\n"
                                                       "\n"
                                                       ;
static const char* set_disconnect_handler_doc = "set_disconnect_handler(client_disconnect_handler)\n\n"
                                                " Sets the :class:`DisconnectHandler` used by the :class:`Client`. In\n"
                                                "        the event that the `Client` is unintentionally disconnected from AMPS, the invoke\n"
                                                "        method from the :class:`ClientDisconnectHandler` will be invoked.\n"
                                                "\n"
                                                ":param client_disconnect_handler: The disconnect handler.\n"
                                                ":type client_disconnect_handler: :class:`DisconnectHandler`\n"
                                                "\n"
                                                "        \n"
                                                ;
static const char* set_exception_listener_doc = "set_exception_listener(exception_listener)\n\n"
                                                " Sets the exception listener instance used for communicating\n"
                                                "        absorbed exceptions.\n"
                                                "\n"
                                                ":param exception_listener: The exception listener instance to invoke\n"
                                                "           for exceptions.\n"
                                                ":type exception_listener: :exc:`Exception`\n"
                                                "\n"
                                                "        \n"
                                                ;

static const char* get_exception_listener_doc =
  "get_exception_listener()\n\n"
  " Returns the exception listener callable set on self, or None.\n\n";

static const char* set_heartbeat_doc = "set_heartbeat(interval_seconds,timeout_seconds=None)\n\n"
                                       "Used to enable heartbeating between the client and the AMPS Server.  When a\n"
                                       "        :class:`Client` sends a heartbeat message to an AMPS instance, the AMPS\n"
                                       "        instance will send back an acknowledgment message.  From this point forward the\n"
                                       "        :class:`Client` and AMPS instance will each monitor that the other is still active.\n"
                                       "        AMPS sends heartbeat messages to the client at the specified interval.\n"
                                       "        If the :class:`Client` does not receive a heartbeat message within\n"
                                       "        the time interval specified in :`timeout_seconds`, then the `Client`\n"
                                       "        will assume that the connection has ended, close the connection and\n"
                                       "        invoke the :exc:`DisconnectHandler`. Likewise, if the server\n"
                                       "        sends a heartbeat and does not receive a response within the timeout,\n"
                                       "        the server will consider the client to be nonresponsive and close\n"
                                       "        the connection.\n"
                                       "\n"
                                       "       Heartbeats are processed in the client receive thread. If you use\n"
                                       "       asynchronous message processing, your message handler must process\n"
                                       "       messages within the timeout interval, or risk being disconnected\n"
                                       "       by the server.\n"
                                       "\n"
                                       ":param interval_seconds: The time between heartbeat messages being sent\n"
                                       "           to AMPS.\n"
                                       ":type interval_seconds: int\n"
                                       ":param timeout: The maximum time to wait for AMPS to acknowledge the start of "
                                       "                heartbeating (in seconds)\n"
                                       ":type timeout_seconds: int\n"
                                       "\n"
                                       "        \n"
                                       ;

static const char* start_timer_doc = "start_timer()\n\n"
                                     "Deprecated in version 5.3.2.0. Used to start a timer on an AMPS Server for the client.\n"
                                     ;

static const char* stop_timer_doc = "stop_timer(handler)\n\n"
                                    "Deprecated in version 5.3.2.0. Used to stop a timer on an AMPS Server previously started for the client.\n"
                                    ":param handler: The handler to be invoked with the timer response.\n"
                                    ;

static const char* set_last_chance_message_handler_doc = "set_last_chance_message_handler(message_handler)\n\n"
                                                         " Sets the :class:`MessageHandler` instance called when no other incoming message handler matches.\n"
                                                         "\n"
                                                         ":param message_handler: The message handler to invoke when no other incoming message handler matches.\n"
                                                         ":type message_handler: :class:`MessageHandler`\n"
                                                         "\n"
                                                         "        \n"
                                                         ;
static const char* set_duplicate_message_handler_doc = "set_duplicate_message_handler(message_handler)\n\n"
                                                       " Sets the :class:`MessageHandler` instance used for messages that arrive from AMPS\n"
                                                       "        that are deemed to be duplicates of previous messages, according to the local bookmark store.\n"
                                                       "\n"
                                                       ":param message_handler: The message handler to invoke for duplicates\n"
                                                       "           messages.\n"
                                                       ":type message_handler: :class:`MessageHandler`\n"
                                                       "\n"
                                                       "        \n"
                                                       ;
static const char* get_duplicate_message_handler_doc =
  "get_duplicate_message_handler()\n\n"
  " Returns the message handler object set with set_duplicate_message_handler.\n";

static const char* sow_doc = "sow(on_message,topic,filter=None,batch_size=10,timeout=0,top_n=None,order_by=None,bookmark=None,options=None)\n\n"
                             "Executes a SOW query. There are two ways to use this method.\n"
                             "First, you can provide a topic, filter, and options for the subscription.\n"
                             "In this case, the method returns a message stream that you can iterate over.\n"
                             "For example::\n\n"
                             "    c = Client(\"test_client\")\n\n"
                             "    try:\n"
                             "        c.connect(\"tcp://127.0.0.1:9004/fix\")\n"
                             "        cid = c.logon(timeout=0)\n"
                             "        for aMessage in c.sow(\"MySowTopic\"):\n"
                             "            print aMessage.get_data()\n"
                             "    finally:\n"
                             "        c.close()\n\n"
                             "Second, you can provide a message handler. In this case, the method creates\n"
                             "a background thread and calls the message handler with each message\n"
                             "received from AMPS, including the `group_begin` and `group_end` messages\n"
                             "that indicate the beginning and end of the SOW query.\n"
                             "\n"
                             ":param on_message: The message handler to invoke with matching\n"
                             "           messages. If this parameter is not present, AMPS creates a \n"
                             "           :class: `MessageStream` and returns that message stream\n"
                             "           from the call to sow.\n"
                             ":type on_message: :class:`MessageHandler`\n"
                             ":param topic: The topic to execute the SOW query against.\n"
                             ":type topic: str\n"
                             ":param filter: The filter.\n"
                             ":type filter: str\n"
                             ":param batch_size: The batching parameter to use for the results.\n"
                             ":type batch_size: int\n"
                             ":param timeout: The maximum time to wait for the client to receive and \n"
                             "           consume a processed ack for this command (in milliseconds).\n"
                             "           ``0`` indicates to wait indefinitely.\n"
                             ":type timeout: int\n"
                             ":param top_n: The maximum number of records to return from the sow.\n"
                             ":type top_n: int\n"
                             ":param order_by: To have the records ordered by the server.\n"
                             ":type order_by: str\n"
                             ":param bookmark: The bookmark for historical query of the sow.\n"
                             ":type bookmark: int\n"
                             ":param options: A comma separated list of values indicating additional\n"
                             "           processing options.\n"
                             ":type options: str\n"
                             "\n"
                             ":returns: If a message handler is provided, returns the command identifier\n"
                             "          assigned to this command. If no message handler is present, "
                             "          returns a MessageStream containing the results of the command.\n"
                             "\n"
                             ":raises: :exc:`BadFilterException`, :exc:`BadRegexTopicException`,\n"
                             "            :exc:`TimedOutException`, :exc:`DisconnectedException`\n"
                             "\n"
                             "        \n"
                             ;
static const char* sowAndDeltaSubscribe_doc = "sowAndDeltaSubscribe(on_message,topic,filter=None,batch_size=1,oof_enabled=False,send_empties=False,options=0,timeout=0,top_n=None)\n\n"
                                              " A legacy method name for :meth:`sow_and_delta_subscribe`.\n"
                                              "  .. deprecated:: 3.2.0.0\n"
                                              "   Use :func:`sow_and_delta_subscribe` instead.\n"
                                              "\n"
                                              ;
static const char* sowAndSubscribe_doc = "sowAndSubscribe(on_message,topic,filter,batch_size=1,oof_enabled=False,options=0,timeout=0,top_n=None)\n\n"
                                         " A legacy method name for :meth:`sow_and_subscribe`.\n"
                                         "  .. deprecated:: 3.2.0.0\n"
                                         "   Use :func:`sow_and_subscribe` instead.\n"
                                         "\n"
                                         ;
static const char* sowDelete_doc = "sowDelete(on_message,topic,filter=None,options=0,timeout=0)\n\n"
                                   " A legacy method name for :meth:`sow_delete`.\n"
                                   "  .. deprecated:: 3.2.0.0\n"
                                   "   Use :func:`sow_delete` instead.\n"
                                   "\n"
                                   ;

static const char* sow_and_delta_subscribe_doc = "sow_and_delta_subscribe(on_message,topic,filter=None,batch_size=1,oof_enabled=False,send_empties=False,options=0,timeout=0,top_n=None)\n\n"
                                                 "Executes a SOW query and places a delta subscription.\n"
                                                 "\n"
                                                 ":param on_message: The message handler to invoke with matching\n"
                                                 "           messages.\n"
                                                 ":type on_message: :class:`MessageHandler`\n"
                                                 ":param topic: The `Topic` to execute the SOW query against.\n"
                                                 ":type topic: str\n"
                                                 ":param filter: The filter.\n"
                                                 ":type filter: str\n"
                                                 ":param batch_size: The batch sizing parameter to use for the results.\n"
                                                 ":type batch_size: int\n"
                                                 ":param oof_enabled: Specifies whether or not Out-of-Focus processing is\n"
                                                 "           enabled.\n"
                                                 ":type oof_enabled: boolean\n"
                                                 ":param send_empties: Specifies whether or not unchanged records are\n"
                                                 "           received on the delta subscription.\n"
                                                 ":type send_empties: boolean\n"
                                                 ":param timeout: The maximum time to wait for the client to receive and \n"
                                                 "           consume the processed ack for this command (in milliseconds).\n"
                                                 "           ``0`` indicates to wait indefinitely.\n"
                                                 ":type timeout: int\n"
                                                 ":param top_n: The maximum number of records to return from the sow.\n"
                                                 ":type top_n: int\n"
                                                 ":param order_by: To have the records ordered by the server.\n"
                                                 ":type order_by: str\n"
                                                 ":param options: A comma separated list of values indicating additional\n"
                                                 "           processing options.\n"
                                                 ":type options: str\n"
                                                 "\n"
                                                 ":returns: The command identifier assigned to this command.\n"
                                                 "\n"
                                                 ":raises: :exc:`SubscriptionAlreadyExistsException`,\n"
                                                 "            :exc:`BadFilterException`, :exc:`BadRegexTopicException`,\n"
                                                 "            :exc:`TimedOutException`, :exc:`DisconnectedException`\n"
                                                 "        \n"
                                                 ;
static const char* sow_and_subscribe_doc = "sow_and_subscribe(on_message,topic,filter,batch_size=1,oof_enabled=False,timeout=0,top_n=None, order_by="", bookmark="", options="" )\n\n"
                                           "Executes a SOW query and places a subscription.\n"
                                           "\n"
                                           ":param on_message: The message handler to invoke with matching\n"
                                           "           messages.\n"
                                           ":type on_message: :class:`MessageHandler`\n"
                                           ":param topic: The topic to execute the SOW query against.\n"
                                           ":type topic: str\n"
                                           ":param filter: The filter.\n"
                                           ":type filter: str\n"
                                           ":param batch_size: The batching parameter to use for the results.\n"
                                           ":type batch_size: int\n"
                                           ":param oof_enabled: Specifies whether or not Out-of-Focus processing is\n"
                                           "           enabled.\n"
                                           ":type oof_enabled: boolean\n"
                                           ":param timeout: The maximum time to wait for the client to receive and\n"
                                           "           consume the processed ack for this command\n"
                                           "           (in milliseconds). ``0`` indicates to wait indefinitely.\n"
                                           ":type timeout: int\n"
                                           ":param top_n: The maximum number of records to return from the sow.\n"
                                           ":type top_n: int\n"
                                           ":param order_by: To have the records ordered by the server.\n"
                                           ":type order_by: str\n"
                                           ":param bookmark: The bookmark for historical query of the sow.\n"
                                           ":type bookmark: str\n"
                                           ":param options: A comma separated list of values indicating additional\n"
                                           "           processing options.\n"
                                           ":type options: str\n"
                                           "\n"
                                           ":returns: The command identifier assigned to this command.\n"
                                           "\n"
                                           ":raises: :exc:`SubscriptionAlreadyExistsException`,\n"
                                           "            :exc:`BadFilterException`, :exc:`BadRegexTopicException`,\n"
                                           "            :exc:`TimedOutException`, :exc:`DisconnectedException`\n"
                                           "\n"
                                           "        \n"
                                           ;
static const char* sow_delete_doc = "sow_delete(on_message,topic,filter=None,options=0,timeout=0)\n\n"
                                    "Executes a SOW delete with a filter.\n\n"
                                    "There are two ways to use this method. When no message handler is provided,\n"
                                    "the method returns a :class:`Message` that will receive the results\n"
                                    "of the delete command.\n\n"
                                    "When a message handler is provided, this method submits the SOW delete on a\n"
                                    "background thread and calls the message handler with the results of the\n"
                                    "delete.\n"
                                    "\n"
                                    "For example, to delete all messages that match a filter::\n\n"
                                    "   ...\n"
                                    "   ackMessage = client.sow_delete(\"sow_topic\",\"/status = 'obsolete'\")\n"
                                    "   print \"%s: %s\" % (ackMessage.get_ack_type(), ackMessage.get_status())\n"
                                    "   ...\n"

                                    "\n"
                                    ":param on_message: The message handler to invoke with `stats` and\n"
                                    "           `completed` acknowledgments\n"
                                    ":type on_message: :exc:`MessageHandler`\n"
                                    ":param topic: The topic to execute the SOW delete against.\n"
                                    ":type topic: str\n"
                                    ":param filter: The filter. To delete all records, set a filter that is always true ('1=1')\n"
                                    ":type filter: str\n"
                                    ":param options: A comma separated list of values indicating additional\n"
                                    "           processing options.\n"
                                    ":type options: str\n"
                                    ":param timeout: The maximum time to wait for the client to receive and\n"
                                    "           consume the processed ack for this command (in milliseconds).\n"
                                    "           ``0`` indicates to wait indefinitely.\n"
                                    ":type timeout: int\n"
                                    "\n"
                                    ":returns: The command identifier assigned to this command.\n"
                                    "\n"
                                    ":raises: :exc:`BadFilterException`, :exc:`BadRegexTopicException`,\n"
                                    "            :exc:`TimedOutException`, :exc:`DisconnectedException`\n"
                                    "\n"
                                    "\n"
                                    "\n"
                                    "        \n"
                                    ;
static const char* sow_delete_by_keys_doc = "sow_delete_by_keys(on_message,topic,keys,timeout=0)\n\n"
                                            "Executes a SOW delete with sow keys.\n\n"
                                            "There are two ways to use this method. When no message handler is provided,\n"
                                            "the method returns a :class:`Message` that will receive the results\n"
                                            "of the delete command.\n\n"
                                            "When a message handler is provided, this method submits the SOW delete on a\n"
                                            "background thread and calls the message handler with the results of the\n"
                                            "delete.\n"
                                            "\n"
                                            ":param on_message: The message handler to invoke with `stats` and\n"
                                            "           `completed` acknowledgments\n"
                                            ":type on_message: :exc:`MessageHandler`\n"
                                            ":param topic: The topic to execute the SOW delete against.\n"
                                            ":type topic: str\n"
                                            ":param keys: A comma separated list of SOW keys to be deleted\n"
                                            ":type keys: str\n"
                                            ":param timeout: The maximum time to wait for the client to receive and\n"
                                            "           consume the processed ack for this command (in millseconds).\n"
                                            "           ``0`` indicates to wait indefinitely.\n"
                                            ":type timeout: int\n"
                                            "\n"
                                            ":returns: The command identifier assigned to this command.\n"
                                            "\n"
                                            "        \n"
                                            ;
static const char* sow_delete_by_data_doc = "sow_delete_by_data(on_message,topic,data,timeout=0)\n\n"
                                            "Delete a message from a SOW, using data supplied to locate a SOW entry with  matching keys.\n\n"
                                            "There are two ways to use this method. When no message handler is provided,\n"
                                            "the method returns a :class:`Message` that will receive the results\n"
                                            "of the delete command.\n\n"
                                            "When a message handler is provided, this method submits the SOW delete on a\n"
                                            "background thread and calls the message handler with the results of the\n"
                                            "delete.\n"
                                            "\n"
                                            "For example, to efficiently delete a message that your program has\n"
                                            "received from AMPS::\n\n"
                                            "   ...\n"
                                            "   topic= aMessage.get_topic()\n"
                                            "   data = aMessage.get_data()\n"
                                            "   ackMessage = client.sow_delete_by_data(topic,data)\n"
                                            "   print \"%s: %s\" % (ackMessage.get_ack_type(), ackMessage.get_status())\n"
                                            "   ...\n"
                                            "\n"
                                            "In addition to deleting a message from AMPS, this method allows deletion of \n"
                                            "a message whose keys match one that is already stored, for example::\n\n"
                                            "   ...\n"
                                            "   data = orders[orderId]\n"
                                            "   ackMessage = client.sow_delete_by_data('orders', data)\n"
                                            "   del orders[orderId]\n"
                                            "   ...\n\n"
                                            ":param on_message: The message handler to invoke with `stats` and\n"
                                            "           `completed` acknowledgments\n"
                                            ":type on_message: :exc:`MessageHandler`\n"
                                            ":param topic: The topic to execute the SOW delete against.\n"
                                            ":type topic: str\n"
                                            ":param data: A message whose keys match the message to be deleted in the server's SOW.\n"
                                            ":type data: str\n"
                                            ":param timeout: The maximum time to wait for the client to receive and\n"
                                            "           consume the processed ack for this command (in milliseconds).\n"
                                            "           ``0`` indicates to wait indefinitely.\n"
                                            ":type timeout: int\n"
                                            "\n"
                                            ":returns: The command identifier assigned to this command.\n"
                                            "\n"
                                            "        \n"
                                            ;
static const char* subscribe_doc = "subscribe(on_message,topic,filter=None,options=None,timeout=0, sub_id=None)\n\n"
                                   "Places a subscription with AMPS.\n"
                                   "\n"
                                   ":param on_message: The message handler to invoke with matching\n"
                                   "           messages.\n"
                                   ":type on_message: str\n"
                                   ":param topic: The topic to subscribe to.\n"
                                   ":type topic: str\n"
                                   ":param filter: The filter.\n"
                                   ":type filter: str\n"
                                   ":param options: A comma separated list of values indicating additional\n"
                                   "           processing options.\n"
                                   ":type options: str\n"
                                   ":param timeout:  The maximum time to wait for the client to receive and \n"
                                   "           consume the processed ack for this command (in milliseconds).\n"
                                   "           ``0`` indicates to wait indefinitely.\n"
                                   ":type timeout: int\n"
                                   ":param sub_id: The subscription ID.  You may optionally provide a\n"
                                   "           subscription ID to ease recovery scenarios, instead of having the\n"
                                   "           system automatically generate one for you.\n"
                                   "           When used with the 'replace' option, this is the subscription to\n"
                                   "           be replaced.\n"
                                   ":type sub_id: str\n"
                                   "\n"
                                   ":returns: The command identifier assigned to this command.\n"
                                   "\n"
                                   ":raises: :exc:`SubscriptionAlreadyExistsException`,\n"
                                   "            :exc:`BadFilterException`, :exc:`BadRegexTopicException`,\n"
                                   "            :exc:`TimedOutException`, :exc:`DisconnectedException`\n"
                                   "\n"
                                   "        \n"
                                   ;
static const char* unsubscribe_doc = "unsubscribe(sub_id=None)\n\n"
                                     " Remove a subscription from AMPS.\n"
                                     "\n"
                                     ":param sub_id: The subscription id to remove.\n"
                                     ":type sub_id: str\n"
                                     "\n"
                                     "        ..note: The `sub_id` *all* will remove all subsciptions to AMPS.\n"
                                     "\n"
                                     "        \n"
                                     ;
static const char* get_uri_doc = " Returns the :class:`URI` string passed into the :class:`Client`\n"
                                 "       during the :meth:`connect` invocation.\n\n"
                                 "       :returns: uri\n\n";

static const char* publish_flush_doc = "publish_flush(timeout = 0, ack_type = Message.AckType.ProcessedEnum)\n\n"
                                       " Ensures that pending AMPS messages are sent and have been processed by the"
                                       " AMPS server. When the client has a publish store configured, waits until"
                                       " all messages that are in the store at the time the command is called have"
                                       " been acknowledged by AMPS. Otherwise, issues a ``flush`` command"
                                       " and waits for the server to acknowledge that command."
                                       " This method blocks until messages have been processed or "
                                       " until the timeout expires, and is most useful when the application reaches"
                                       " a point at which it is acceptable to block to ensure that messages are"
                                       " delivered to the AMPS server. For example, an application might call"
                                       " publish_flush before exiting."
                                       " One thing to note is that if AMPS is unavailable (HA Client), publish_flush"
                                       "  needs to wait for a connection to come back up which may look like it's hanging."
                                       "\n\n"
                                       ":param timeout: The maximum time to wait for the messages to be acknowledged\n"
                                       "                as persisted, or for the flush command to be acknowledged\n"
                                       "                by AMPS (in milliseconds), or 0 to wait indefinitely.\n"
                                       ":type timeout: int\n"
                                       ":param ack_type: Whether the command should wait for a Processed or a\n"
                                       "                 Persisted ack when sending the `flush` command.\n"
                                       ":type ack_type: int\n"
                                       "\n\n";


static const char* flush_doc = "flush(timeout = 0)\n\n Another name for :meth:`publish_flush`.";

static const char* set_publish_store_doc = "set_publish_store(publishStore)\n\n"
                                           "Sets a publish store on self.\n\n"
                                           ":param publishStore: an :class:`PublishStore` or :class:`MemoryPublishStore` instance.\n";

static const char* set_bookmark_store_doc = "set_bookmark_store(bookmarkStore)\n\n"
                                            "Sets a bookmark store on self.\n\n"
                                            ":param bookmarkStore: an :class:`MMapBookmarkStore` or\n"
                                            "     :class:`MemoryBookmarkStore` instance, or a custom object that\n"
                                            "     implements the required bookmark store methods.\n\n";


static const char* set_failed_write_handler_doc = "set_failed_write_handler(failedWriteHandler)\n\n"
                                                  "Sets a failed write handler on self.\n\n"
                                                  ":param failedWriteHandler: a callable object to be invoked when AMPS indicates that a published message is not written. This could be because a duplicate message already exists in the transaction log, this client is not entitled to publish  to the topic, the message failed to parse, or other similar reasons.\n"
                                                  "                           Parameters to this callable are an AMPS *message* when the client has a message saved in the publish store, and a string that contains the *reason* the publish failed.\n\n"
                                                  "For example, you might implement a function like::\n\n"
                                                  "  def PrintFailedWrites(message, reason):\n"
                                                  "      output = \"Uh-oh, something went wrong writing to AMPS. (%s) \" % reason\n"
                                                  "      if (message != None):\n"
                                                  "            output += \"Topic: %s, Data snippet: %s...\" % \\\n"
                                                  "                    (message.get_topic(), message.get_data()[0:20])\n"
                                                  "      print output\n\n" ;

static const char* add_connection_state_listener_doc = "add_connection_state_listener(listener_callable)\n\n"
                                                       "Sets a function to be called when this client connects or disconnects from AMPS.\n\n"
                                                       ":type listener_callable: A python function or other callable that takes a single value\n"
                                                       ":param listener_callable: The function or callable to be called. This function will be passed True if a connection is established, False if a disconnect occurs. Notice that when a connection is established, the client has not yet logged in or completed any recovery steps. The application should not issue commands on the client until recovery is completed.\n";

static const char* remove_connection_state_listener_doc = "remove_connection_state_listener(listener_callable)\n\n"
                                                          "Removes a listener function previously supplied to add_connection_state_listener.\n";

static const char* set_transport_filter_doc = "set_transport_filter(transport_filter_callable)\n\n"
                                              "Sets a function to be called when this client sends or receives data.\n\n"
                                              ":type transport_filter_callable: A python function or other callable that takes two parameters: data and direction."
                                              ":param transport_filter_callable: The function or callable to be called. This function is passed a string ('data') containing the raw bytes sent or received."
                                              "The 'direction' parameter is False if the data is being sent to the server, or True if data is received from the server.\n";

static const char* set_thread_created_callback_doc = "set_thread_created_callback(thread_created_callable)\n\n"
                                                     "Sets a function to be called when this client creates a thread used to receive data from the server.\n\n"
                                                     ":type thread_created_callable: A python function or other callable that takes no parameters.\n"
                                                     ":param thread_created_callable: The function or callable to be called. This function is called by the newly created thread.\n";

static const char* ack_doc = "ack(message,options=None) OR ack(topic,bookmark,options=None)\n\n"
                             "ACKs a message queue message.\n\n"
                             ":param message an AMPS.Message object to ack, OR\n"
                             ":param topic The topic of the message to ACK\n"
                             ":param bookmark The bookmark of the message to ACK.\n"
                             ":param options An optional string to include in the ACK such as 'cancel'.\n";

static const char* set_ack_batch_size_doc = "set_ack_batch_size(batch_size)\n\n"
                                            "Sets the batch size used for batching message queue ACK messages.\n\n"
                                            ":param batch_size The number of ACK messages to batch before sending.\n";

static const char* get_ack_batch_size_doc = "get_ack_batch_size()\n\n"
                                            "Returns the current batch size used for batching message queue ACK messages.\n\n";

static const char* set_auto_ack_doc = "set_auto_ack(enabled)\n\n"
                                      "Enables or disables auto-acknowledgement of message queue messages.\n\n"
                                      ":param enabled True to enable auto-acknowledgement of message queue messages.\n";

static const char* get_auto_ack_doc = "get_auto_ack()\n\n"
                                      "Returns True if auto-acknowledgement of message queue messages is enabled.\n\n";

static const char* get_ack_timeout_doc = "get_ack_timeout()\n\n"
                                         "Returns the current time (milliseconds) before queued ack messages are sent.\n\n";

static const char* set_ack_timeout_doc = "set_ack_timeout(timeout)\n\n"
                                         "Sets the time before queued ack messages are sent.\n\n"
                                         ":param timeout The maximum amount of time to wait after adding the first message to an acknowledgement batch before sending the batch, in milliseconds. 0 indicates that the client will wait until the batch is full. A value of 0 is not recommended unless the batch size is set to 1.\n";

static const char* set_retry_on_disconnect_doc = "set_retry_on_disconnect(enabled)\n\n"
                                                 " Enables or disables automatic retry of a command to AMPS after a\n"
                                                 "        reconnect. This behavior is enabled by default.\n"
                                                 "        NOTE: Clients using a publish store will have all publish\n"
                                                 "        messages sent, regardless of this setting. Also, Clients with\n"
                                                 "        a subscription manager, including all HAClients, will have all\n"
                                                 "        subscribe calls placed.\n"
                                                 "\n"
                                                 ":param enabled False to disable automatic retry of commands to AMPS.\n"
                                                 ":type enabled: Boolean.\n"
                                                 "\n"
                                                 "        \n";

static const char* get_retry_on_disconnect_doc = "get_retry_on_disconnect()\n\n"
                                                 "Returns True if automatic retry of a command to AMPS after a reconnect is enabled.\n\n";

static const char* set_default_max_depth_doc = "set_default_max_depth(depth)\n\n"
                                               " Sets a default maximum depth for all new MessageStream objects\n"
                                               "        that are returned from synchronous API calls such as execute().\n"
                                               "\n"
                                               ":param depth The new depth to use. A depth of 0 means no max and is the default.\n"
                                               ":type depth: int.\n"
                                               "\n"
                                               "        \n";

static const char* get_default_max_depth_doc = "get_default_max_depth()\n\n"
                                               ":returns The current maximum depth for new MessageStreams, 0 is no maximum.\n\n";

static const char* set_global_command_type_message_handler_doc = "set_global_command_type_message_handler(command,message_handler)\n\n"
                                                                 " Add a message handler to the :class:`Client` to handle messages from the\n"
                                                                 " server with the specified command.\n"
                                                                 "\n"
                                                                 ":param command: The command to send to the handler.\n"
                                                                 "           Valid values are 'ack' and 'heartbeat'.\n"
                                                                 ":type command: str\n"
                                                                 ":param message_handler: The message handler that will receive messages\n"
                                                                 "           of the command specified.\n"
                                                                 ":type message_handler: :class:`MessageHandler`\n"
                                                                 "\n"
                                                                 "        \n"
                                                                 ;

static const char* get_error_on_publish_gap_doc = "get_error_on_publish_gap()\n\n"
                                                  " Called to check if the Store will throw PublishStoreGapException.\n"
                                                  "\n"
                                                  ":returns If true, PublishStoreGapException can be thrown\n"
                                                  "           by the client publish store if the client logs onto a server that\n"
                                                  "           appears to be missing messages no longer held in the store.\n";

static const char* set_error_on_publish_gap_doc = "set_error_on_publish_gap(error_on_publish_gap)\n\n"
                                                  " Called to enable or disable throwing PublishStoreGapException.\n"
                                                  "\n"
                                                  ":param error_on_publish_gap: If true, PublishStoreGapException can be thrown\n"
                                                  "           by the client publish store if the client logs onto a server that\n"
                                                  "           appears to be missing messages no longer held in the store.\n"
                                                  ":type error_on_publish_gap: Boolean\n";
