"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
/**
 * Use a S3 as an alias record target
 */
class BucketWebsiteTarget {
    constructor(bucket) {
        this.bucket = bucket;
    }
    bind(_record) {
        const { region } = core_1.Stack.of(this.bucket.stack);
        if (core_1.Token.isUnresolved(region)) {
            throw new Error([
                'Cannot use an S3 record alias in region-agnostic stacks.',
                'You must specify a specific region when you define the stack',
                '(see https://docs.aws.amazon.com/cdk/latest/guide/environments.html)'
            ].join(' '));
        }
        const { s3StaticWebsiteHostedZoneId: hostedZoneId, s3StaticWebsiteEndpoint: dnsName } = region_info_1.RegionInfo.get(region);
        if (!hostedZoneId || !dnsName) {
            throw new Error(`Bucket website target is not supported for the "${region}" region`);
        }
        return { hostedZoneId, dnsName };
    }
}
exports.BucketWebsiteTarget = BucketWebsiteTarget;
//# sourceMappingURL=data:application/json;base64,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