#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apig = require("@aws-cdk/aws-apigateway");
const acm = require("@aws-cdk/aws-certificatemanager");
const lambda = require("@aws-cdk/aws-lambda");
const route53 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
const targets = require("../lib");
class TestStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        const domainName = 'example.com';
        const certArn = 'arn:aws:acm:us-east-1:111111111111:certificate';
        const hostedZoneId = 'AAAAAAAAAAAAA';
        const handler = new lambda.Function(this, 'Handler', {
            code: lambda.Code.fromInline(`exports.handler = async () => {
        return {
          statusCode: '200',
          body: 'hello, world!'
        };
      };`),
            runtime: lambda.Runtime.NODEJS_8_10,
            handler: 'index.handler'
        });
        const certificate = acm.Certificate.fromCertificateArn(this, 'cert', certArn);
        const api = new apig.LambdaRestApi(this, 'api', {
            handler,
            domainName: {
                certificate,
                domainName,
                endpointType: apig.EndpointType.REGIONAL,
            }
        });
        const zone = route53.HostedZone.fromHostedZoneAttributes(this, 'hosted-zone', {
            zoneName: domainName,
            hostedZoneId
        });
        new route53.ARecord(this, 'Alias', {
            zone,
            target: route53.AddressRecordTarget.fromAlias(new targets.ApiGateway(api))
        });
    }
}
const app = new core_1.App();
new TestStack(app, 'aws-cdk-apigw-alias-integ');
app.synth();
//# sourceMappingURL=data:application/json;base64,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