from marshmallow import Schema, fields


class MaxarFeatureAttrsSchema(Schema):
    acquisition_date = fields.Str(allow_none=True)
    acquisition_time = fields.Int()
    acquisition_type = fields.Str(allow_none=True)
    antenna_look_direction = fields.Str(allow_none=True)
    age_days = fields.Int()
    asset_name = fields.Str(allow_none=True)
    asset_type = fields.Str(allow_none=True)
    beam_mode = fields.Str(allow_none=True)
    ce_90_accuracy = fields.Str(allow_none=True)
    cloud_cover = fields.Float()
    color_band_order = fields.Str(allow_none=True)
    company_name = fields.Str(allow_none=True)
    copyright = fields.Str(allow_none=True)
    crs_from_pixels = fields.Str(allow_none=True)
    data_layer = fields.Str(allow_none=True)
    earliest_acquisition_date = fields.Str(allow_none=True)
    factory_order_number = fields.Str(allow_none=True)
    feature_id = fields.Str(allow_none=True)
    formatted_date = fields.Str(allow_none=True)
    ground_sample_distance = fields.Float()
    ground_sample_distance_unit = fields.Str(allow_none=True)
    ingest_date = fields.Str(allow_none=True)
    is_browse = fields.Bool()
    is_mirrored = fields.Bool()
    is_multiple_wkb = fields.Bool()
    latest_acquisition_date = fields.Str(allow_none=True)
    legacy_description = fields.Str(allow_none=True)
    legacy_id = fields.Str(allow_none=True)
    license_type = fields.Str(allow_none=True)
    niirs = fields.Float()
    off_nadir_angle = fields.Float()
    orbit_direction = fields.Str(allow_none=True)
    output_mosaic = fields.Bool()
    per_pixel_x = fields.Float()
    per_pixel_y = fields.Float()
    pixels_ingested = fields.Bool()
    polarisation_channel = fields.Str(allow_none=True)
    polarisation_mode = fields.Str(allow_none=True)
    precise_geometry = fields.Bool()
    product_type = fields.Str(allow_none=True)
    rmse_accuracy = fields.Str(allow_none=True)
    sensor_type = fields.Str(allow_none=True)
    source = fields.Str(allow_none=True)
    source_unit = fields.Str(allow_none=True)
    spatial_accuracy = fields.Str(allow_none=True)
    sun_azimuth = fields.Float()
    sun_elevation = fields.Float()
    tags_as_string = fields.Str(allow_none=True)
    url = fields.Str(allow_none=True)
    vendor_name = fields.Str(allow_none=True)
    vendor_reference = fields.Str(allow_none=True)
    vertical_accuracy = fields.Str(allow_none=True)


class MaxarFeatureSchema(Schema):
    feature = fields.Nested(MaxarFeatureAttrsSchema())
