from message.upstream.status.SubDeviceLoginRequest import SubDeviceLoginRequest
from core.MqttClient import MqttClient
from message.upstream.topo.TopoAddRequest import TopoAddRequest
from message.upstream.topo.SubDeviceInfo import SubDeviceInfo
from message.upstream.tsl.MeasurepointPostRequest import MeasurepointPostRequest
from message.upstream.topo.TopoGetRequest import TopoGetRequest
from message.upstream.topo.TopoDeleteRequest import TopoDeleteRequest
import random
import time

# mqtt broker url
enos_mqtt_url = "tcp://{HOST}:11883" # for tcp connection

# gateway parameters
gateway_product_key = "GATEWAY_PRODUCT_KEY"
gateway_product_secret = 'GATEWAY_PRODUCT_SECRET'
gateway_device_key = "GATEWAY_DEVICE_KEY"
gateway_device_secret = "GATEWAY_DEVICE_SECRET"

# sub-device parameters
sub_product_key = 'SUB_PRODUCT_KEY'
sub_device_key = "SUB_DEVICE_KEY"
sub_device_secret = "SUB_DEVICE_SECRET"

# these file are generated by get_cert.py via EnOS cert tool, for tls connection
ca_file = 'edge_ca.pem'
key_file = 'edge.key'
cer_file = 'edge.pem'
key_file_password = 'PRIVATE_KEY_PASSWORD'


def onConnectFailed():
    print('connect failed...')
    time.sleep(10)
    client.connect()

def onOnline():
    global connected
    connected = True
    login_sub_device(client)                          # login the sub-device if exists sub-device
    print('connected...')

def onOffine():
    global connected
    connected = False
    print('disconnected...')

def get_topo(mqtt_client):
    topo_get_req = TopoGetRequest.builder().build()
    topo_get_res = mqtt_client.publish(topo_get_req)
    if topo_get_res:
        print('topo_response: code: %s' % topo_get_res.getCode())
        print(topo_get_res.getData())


def add_topo(mqtt_client):
    topo_req = TopoAddRequest.builder().addSubDevice(SubDeviceInfo(sub_product_key, sub_device_key, sub_device_secret)).build()
    topo_res = mqtt_client.publish(topo_req)
    if topo_res:
        print('topo_response: code: %s' % topo_res.getCode())
        print('topo_response: message: %s' % topo_res.getMessage())


def delete_topo(mqtt_client):
    topo_del_req = TopoDeleteRequest.builder().addSubDevice(sub_product_key, sub_device_key).build()
    topo_del_res = mqtt_client.publish(topo_del_req)
    if topo_del_res:
        print('topo_delete_response: %s' % topo_del_res.getCode())


def login_sub_device(mqtt_client):
    login_req = SubDeviceLoginRequest.builder().setSubDeviceInfo(sub_product_key, sub_device_key, sub_device_secret).build()
    login_res = mqtt_client.publish(login_req)
    if login_res:
        print('login_response: code: %s' % login_res.getCode())
        print('login_response: message: %s' % login_res.getMessage())


# post measure points data via MQTT
def post_measure_points(mqtt_client, timestamp):
    meapt_req = MeasurepointPostRequest.builder() \
        .setProductKey(sub_product_key).setDeviceKey(sub_device_key) \
        .addMeasurePoint('MeasurePoint1', random.randint(100, 200)) \
        .addMeasurePoint('MeasurePoint2', random.randint(100, 200)) \
        .setTimestamp(timestamp) \
        .build()
    meapt_res = mqtt_client.publish(meapt_req)
    if meapt_res:
        print('measurepointPost_response: %s' % meapt_res.getCode())

# handle the received downstream message and implement your logic
def handle_msg(arrivedMessage, replyHandler):
    '''
    :param arrivedMessage: <attributes:deviceKey,prodectKey,id,messageTopic,method,params,version>
    :param replyHandler: <method:replyWithPayload>
    '''
    # handle logic
    success = 1
    print(arrivedMessage.params)
    # set reply payload
    if success:
        code = 200
        message = 'test'
        data = 0
    else:
        code = 2000
        message = 'test'
        data = 1
    replyHandler.reply_with_payload(code=code, message=message, data=data)


if __name__ == "__main__":

    client = MqttClient(enos_mqtt_url, gateway_product_key, gateway_device_key, gateway_device_secret)
    client.getProfile().setAutoReconnect(True)       # if connection interrupted, the client can automaticlly reconnect
    # set the certificate files for bi-directional certification
    client.getProfile().setSSLContext(ca_file, cer_file, key_file, key_file_password)
    client.setupBasicLogger('INFO')
    client.onOnline = onOnline
    client.onOffline = onOffine
    client.onConnectFailed = onConnectFailed

    connected = False                            # iniciate the connect status
    client.connect()                             # connect in sync

    client.onMessage(handle_msg)                 # register a handle_msg to handle the downstream received measurepoint
    add_topo(client)                             # add the device to the gateway as sub-device if exists sub-device
    while True:
        timestamp = int(time.time() * 1000)      # timestamp in milliseconds
        post_measure_points(client, timestamp)   # publish measure points data
        time.sleep(10)
