import abc
import logging
from ..utils import import_name as import_name, import_uri as import_uri
from .config import ValueExtractor as ValueExtractor
from _typeshed import Incomplete
from abc import ABC, abstractmethod
from typing import Any, Optional, Type, Union

class AbstractEntity(ABC):
    def __init__(self, config: Incomplete | None = ..., *, context: Incomplete | None = ..., **kwargs) -> None: ...
    @property
    def config(self): ...
    def set_config(self, config) -> None: ...
    @property
    def context(self): ...
    def set_context(self, context) -> None: ...
    async def init(self) -> None: ...
    @property
    def loop(self): ...

class Link:
    def __init__(self, *path: Union[str, int], nullable: bool = ..., key: str = ...) -> None: ...
    def __set_name__(self, owner, name) -> None: ...
    def __get__(self, obj: AbstractEntity, owner: Type[AbstractEntity]) -> Any: ...

def link(*path, nullable: bool = ...) -> Any: ...

class AbstractNamedEntity(AbstractEntity):
    def set_config(self, config) -> None: ...
    @property
    def name(self): ...

class AbstractNestedEntity(AbstractEntity):
    cache_factory: Incomplete
    item_factory: Incomplete
    def __init__(self, config: Incomplete | None = ..., **kwargs) -> None: ...
    def set_context(self, context) -> None: ...
    def set_config(self, config) -> None: ...
    async def init(self) -> None: ...
    def get_child_config(self, item: str, config: Optional[ValueExtractor] = ...) -> Optional[ValueExtractor]: ...
    def factory(self, item, config: Incomplete | None = ...): ...
    def __getattr__(self, item): ...
    def __getitem__(self, item): ...

class AbstractReader(AbstractEntity, metaclass=abc.ABCMeta):
    @abstractmethod
    async def get(self): ...

class AbstractWriter(AbstractEntity, metaclass=abc.ABCMeta):
    @abstractmethod
    async def put(self, value): ...

class ExecutorEntity(AbstractEntity):
    PARAM_EXECUTOR: str
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def loop(self): ...
    def executor_factory(self, *args, **kwargs): ...
    def set_config(self, config) -> None: ...
    def set_context(self, context) -> None: ...
    def run_in_executor(self, f, *args, **kwargs): ...
    @property
    def executor(self): ...

class MultiExecutorEntity(AbstractEntity):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def loop(self): ...
    def executor_factory(self, *args, **kwargs): ...
    async def init(self) -> None: ...
    def run_in_executor(self, name: str, f, *args, **kwargs): ...

class NameLogger(logging.LoggerAdapter):
    @classmethod
    def from_instance(cls, logger, instance): ...
    def process(self, msg, kwargs): ...

class LoggingEntity(AbstractNamedEntity):
    logging_adapter: Incomplete
    logger: Incomplete
    def set_config(self, config) -> None: ...

class AbstractConnector(LoggingEntity, metaclass=abc.ABCMeta):
    async def init(self) -> None: ...
    async def robust_connect(self) -> None: ...
    @abstractmethod
    async def connect(self): ...
    @abstractmethod
    async def disconnect(self): ...
    async def cleanup(self) -> None: ...
