import abc
from .. import humanize as humanize, utils as utils
from ..utils import mapping_repr as mapping_repr
from _typeshed import Incomplete
from abc import abstractmethod
from aioworkers.http import URL as URL
from aioworkers.net.uri import URI as URI
from typing import Any, Callable, Iterator, Mapping, MutableMapping, Tuple, TypeVar, Union

logger: Incomplete

class MergeDict(dict):
    def __init__(self, iterable: Incomplete | None = ..., **kwargs) -> None: ...
    def __getattr__(self, item): ...
    def __setattr__(self, key, value) -> None: ...
    def __setitem__(self, key, value) -> None: ...
    def update(self, d, *args, **kwargs) -> None: ...
    def get(self, key, default: Incomplete | None = ...): ...
    def __getitem__(self, item): ...
    def __contains__(self, key) -> bool: ...
    def __call__(self, *args, **kwargs) -> None: ...
    def __dir__(self): ...
    def copy(self): ...

def merge(source: Mapping, destination: MutableMapping): ...

class ConfigFileLoader(metaclass=abc.ABCMeta):
    extensions: Tuple[str, ...]
    mime_types: Tuple[str, ...]
    @abstractmethod
    def load_str(self, s): ...
    def load_bytes(self, b): ...
    def load_fd(self, fd): ...
    def load_path(self, path): ...
    def load_url(self, url): ...

class YamlLoader(ConfigFileLoader):
    extensions: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    def load_str(self, s): ...

class JsonLoader(ConfigFileLoader):
    extensions: Incomplete
    mime_types: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    def load_str(self, s): ...
TValueMatcher = TypeVar('TValueMatcher', bound='ValueMatcher')

class ValueMatcher(metaclass=abc.ABCMeta):
    fn: Callable
    def __init__(self, value: Any) -> None: ...
    @classmethod
    @abstractmethod
    def match(cls, value: Any) -> TValueMatcher: ...
    @abstractmethod
    def get_value(self): ...

class IntValueMatcher(ValueMatcher):
    fn: Incomplete
    @classmethod
    def match(cls, value): ...
    def get_value(self): ...

class BooleanValueMatcher(IntValueMatcher):
    true: Incomplete
    false: Incomplete
    @classmethod
    def fn(cls, value): ...

class FloatValueMatcher(IntValueMatcher):
    fn: Incomplete

class MultilineValueMatcher(ValueMatcher):
    re: Incomplete
    @classmethod
    def match(cls, value): ...
    def get_value(self): ...

class ListValueMatcher(ValueMatcher):
    @classmethod
    def match(cls, value): ...
    def get_value(self): ...

class StringReplaceLoader(ConfigFileLoader, metaclass=abc.ABCMeta):
    matchers: Incomplete

class IniLoader(StringReplaceLoader):
    extensions: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    def new_configparser(self, **kwargs): ...
    def load_fd(self, fd): ...
    def load_path(self, path): ...
    def load_str(self, string): ...

class Registry(dict):
    def __call__(self, cls) -> None: ...
    def get(self, key): ...

registry: Incomplete
extractors: Mapping[str, Callable]
TValueExtractor = TypeVar('TValueExtractor', bound='ValueExtractor')

class ValueExtractor(abc.Mapping):
    def __init__(self, mapping: Union[TValueExtractor, Mapping, None] = ..., **kwargs) -> None: ...
    def __setattr__(self, key, value) -> None: ...
    def new_child(self, *mappings: Mapping, **kwargs) -> TValueExtractor: ...
    def new_parent(self, *mappings: Mapping, **kwargs) -> TValueExtractor: ...
    def __getitem__(self, item: str) -> Any: ...
    def get(self, item, default: Incomplete | None = ...): ...
    def __contains__(self, item) -> bool: ...
    def __getattr__(self, item): ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator: ...

class Config(ValueExtractor):
    env: Incomplete
    logging: Incomplete
    search_dirs: Incomplete
    uris: Incomplete
    def __init__(self, search_dirs=..., **kwargs) -> None: ...
    def load_conf(self, fd, *, path: Incomplete | None = ..., mime_type: Incomplete | None = ..., response: Incomplete | None = ...): ...
    def load(self, *filenames, base: Incomplete | None = ...): ...
    def update(self, *mappings, **kwargs) -> None: ...
    def load_plugins(self, *modules, force: bool = ...): ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator: ...
    def __getitem__(self, item): ...
    def __contains__(self, item) -> bool: ...
