from typing import Any, Final, Generic, Tuple, TypeVar
from .lexer import BaseLexer, Token

T_cmdSet = TypeVar("T_cmdSet")


class Parser(Generic[T_cmdSet]):
    lexer: Final[BaseLexer]
    command_set: Final[T_cmdSet]

    def __init__(self, lexer: BaseLexer, command_set: T_cmdSet) -> None: ...
    def push(self, token: Token) -> None: ...
    def pop(self) -> Token: ...
    def parse_args(self) -> Tuple[tuple, dict]: ...
    def exec_once(self) -> Any: ...
    def exec_(self) -> None: ...
    def __iter__(self) -> "Parser": ...
    def __next__(self) -> Any: ...