"use strict";
// Copyright (c) Mariana Meireles
// Distributed under the terms of the Modified BSD License.
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("@jupyter-widgets/base");
const version_1 = require("./version");
// Import the CSS
require("../css/widget.css");
const cytoscape_1 = __importDefault(require("cytoscape"));
// @ts-ignore
const cytoscape_cola_1 = __importDefault(require("cytoscape-cola"));
// @ts-ignore
const cytoscape_popper_1 = __importDefault(require("cytoscape-popper"));
// @ts-ignore
const tippy_js_1 = __importDefault(require("tippy.js"));
// @ts-ignore
const cytoscape_dagre_1 = __importDefault(require("cytoscape-dagre"));
require("tippy.js/themes/material.css");
cytoscape_1.default.use(cytoscape_popper_1.default);
cytoscape_1.default.use(cytoscape_dagre_1.default);
cytoscape_1.default.use(cytoscape_cola_1.default);
class CytoscapeModel extends base_1.DOMWidgetModel {
    defaults() {
        return Object.assign({}, super.defaults(), { _model_name: CytoscapeModel.model_name, _model_module: CytoscapeModel.model_module, _model_module_version: CytoscapeModel.model_module_version, _view_name: CytoscapeModel.view_name, _view_module: CytoscapeModel.view_module, _view_module_version: CytoscapeModel.view_module_version, auto_unselectify: true, box_selection_enabled: false, cytoscape_layout: {}, cytoscape_style: [], elements: [], zoom: 0, rendered_position: {} });
    }
}
CytoscapeModel.serializers = Object.assign({}, base_1.DOMWidgetModel.serializers);
CytoscapeModel.model_name = 'CytoscapeModel';
CytoscapeModel.model_module = version_1.MODULE_NAME;
CytoscapeModel.model_module_version = version_1.MODULE_VERSION;
CytoscapeModel.view_name = 'CytoscapeView'; // Set to null if no view
CytoscapeModel.view_module = version_1.MODULE_NAME; // Set to null if no view
CytoscapeModel.view_module_version = version_1.MODULE_VERSION;
exports.CytoscapeModel = CytoscapeModel;
class CytoscapeView extends base_1.DOMWidgetView {
    constructor() {
        super(...arguments);
        this.is_rendered = false;
    }
    render() {
        this.el.classList.add('custom-widget');
        this.value_changed();
        this.model.on('change:auto_unselectify', this.value_changed, this);
        this.model.on('change:box_selection_enabled', this.value_changed, this);
        this.model.on('change:cytoscape_layout', this.value_changed, this);
        this.model.on('change:cytoscape_style', this.value_changed, this);
        this.model.on('change:elements', this.value_changed, this);
        this.model.on('change:zoom', this.zoom_change, this);
        this.model.on('change:rendered_position', this.rendered_position_change, this);
        this.displayed.then(() => {
            this.init_render();
        });
    }
    value_changed() {
        if (this.is_rendered) {
            this.init_render();
        }
    }
    init_render() {
        this.is_rendered = true;
        this.cytoscape_obj = cytoscape_1.default({
            container: this.el,
            autounselectify: this.model.get('auto_unselectify'),
            boxSelectionEnabled: this.model.get('box_selection_enabled'),
            layout: this.model.get('cytoscape_layout'),
            style: this.model.get('cytoscape_style'),
            elements: this.model.get('elements'),
        });
        this.cytoscape_obj.on('click', 'node', (e) => {
            let node = e.target;
            let ref = node.popperRef();
            let dummyDomEle = document.createElement('div');
            if (node.data().name) {
                let tip = tippy_js_1.default(dummyDomEle, {
                    //TODO: add a pretty tippy
                    trigger: 'manual',
                    lazy: false,
                    arrow: true,
                    theme: 'material',
                    placement: 'bottom',
                    content: () => {
                        //TODO: modularize this, add a function to edit this somehow
                        let content = document.createElement('div');
                        content.innerHTML = node.data().name;
                        return content;
                    },
                    onCreate: instance => { instance.popperInstance.reference = ref; }
                });
                tip.show();
            }
        });
        this.cytoscape_obj.on('zoom', () => {
            this.model.set('zoom', { 'level': this.cytoscape_obj.zoom() });
            this.model.save_changes();
        });
        this.cytoscape_obj.on('rendered_position', () => {
            this.model.set('rendered_position', { 'renderedPosition': this.cytoscape_obj.rendered_position() });
            this.model.save_changes();
        });
    }
    zoom_change() {
        this.cytoscape_obj.zoom(this.model.get('zoom'));
    }
    rendered_position_change() {
        this.cytoscape_obj.rendered_position(this.model.get('rendered_position'));
    }
}
exports.CytoscapeView = CytoscapeView;
//# sourceMappingURL=widget.js.map