"""
SNID Line Detection
===================

Line detection and analysis utilities.
"""

from .fwhm_analysis import (
    FWHMAnalyzer,
    perform_line_fitting,
    gaussian_line_fit,
    empirical_line_fit
)

from .line_selection_utils import (
    calculate_redshift_from_velocity,
    is_line_in_spectrum_range,
    get_line_color,
    find_closest_line,
    add_nearby_lines,
    add_lines_by_type,
    add_lines_by_category,
    add_lines_by_origin,
    add_lines_by_strength,
    add_lines_by_type_and_phase,
    add_lines_by_phase,
    add_lines_by_name_pattern,
    add_lines_by_category_and_strength,
    add_lines_by_category_and_phase,
    add_lines_by_line_type,
    get_faint_overlay_lines
)

from .line_presets import (
    get_type_ia_lines,
    get_type_ii_lines,
    get_type_ibc_lines,
    get_hydrogen_lines,
    get_helium_lines,
    get_silicon_lines,
    get_calcium_lines,
    get_oxygen_lines,
    get_iron_lines,
    get_main_galaxy_lines,
    get_strong_lines,
    get_early_type_ii,
    get_peak_type_ii,
    get_nebular_type_ii,
    get_type_iin_lines,
    get_type_iib_lines,
    get_balmer_lines,
    get_paschen_lines,
    get_halpha_only,
    get_hbeta_only,
    get_strong_hydrogen,
    get_fe_ii_lines,
    get_fe_iii_lines,
    get_early_iron,
    get_late_iron,
    get_early_sn_lines,
    get_maximum_lines,
    get_late_phase_lines,
    get_nebular_lines,
    get_diagnostic_lines,
    get_emission_lines,
    get_absorption_lines,
    get_very_strong_lines,
    get_common_lines,
    get_flash_lines,
    get_interaction_lines
)

from .interactive_fwhm_analyzer import InteractiveFWHMAnalyzer

__all__ = [
    'FWHMAnalyzer',
    'perform_line_fitting',
    'gaussian_line_fit',
    'empirical_line_fit',
    'calculate_redshift_from_velocity',
    'is_line_in_spectrum_range',
    'get_line_color',
    'find_closest_line',
    'add_nearby_lines',
    'add_lines_by_type',
    'add_lines_by_category',
    'add_lines_by_origin',
    'add_lines_by_strength',
    'add_lines_by_type_and_phase',
    'add_lines_by_phase',
    'add_lines_by_name_pattern',
    'add_lines_by_category_and_strength',
    'add_lines_by_category_and_phase',
    'add_lines_by_line_type',
    'get_faint_overlay_lines',
    'get_type_ia_lines',
    'get_type_ii_lines',
    'get_type_ibc_lines',
    'get_hydrogen_lines',
    'get_helium_lines',
    'get_silicon_lines',
    'get_calcium_lines',
    'get_oxygen_lines',
    'get_iron_lines',
    'get_main_galaxy_lines',
    'get_strong_lines',
    'get_early_type_ii',
    'get_peak_type_ii',
    'get_nebular_type_ii',
    'get_type_iin_lines',
    'get_type_iib_lines',
    'get_balmer_lines',
    'get_paschen_lines',
    'get_halpha_only',
    'get_hbeta_only',
    'get_strong_hydrogen',
    'get_fe_ii_lines',
    'get_fe_iii_lines',
    'get_early_iron',
    'get_late_iron',
    'get_early_sn_lines',
    'get_maximum_lines',
    'get_late_phase_lines',
    'get_nebular_lines',
    'get_diagnostic_lines',
    'get_emission_lines',
    'get_absorption_lines',
    'get_very_strong_lines',
    'get_common_lines',
    'get_flash_lines',
    'get_interaction_lines',
    'InteractiveFWHMAnalyzer'
] 