/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.exceptions.InvalidException;

public class Limits {
    public static final long LIMIT_MAX = 0x100000000L;
    private static final Limits UNBOUNDED = new Limits(0L);
    private final long min;
    private final long max;

    public Limits(long min) {
        this(min, 0x100000000L);
    }

    public Limits(long min, long max) {
        if (min > max) {
            throw new InvalidException("size minimum must not be greater than maximum");
        }
        this.min = Math.min(Math.max(0L, min), 0x100000000L);
        this.max = Math.min(Math.max(min, max), 0x100000000L);
    }

    public long min() {
        return this.min;
    }

    public long max() {
        return this.max;
    }

    public boolean equals(Object obj2) {
        return obj2 instanceof Limits && this.equals((Limits)obj2);
    }

    public boolean equals(Limits other) {
        return this == other || other != null && this.min == other.min && this.max == other.max;
    }

    public int hashCode() {
        return Long.hashCode(this.min) * 19 + Long.hashCode(this.max);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder b) {
        b.append("[").append(this.min).append(',');
        if (this.max == 0x100000000L) {
            b.append("max");
        } else {
            b.append(this.max);
        }
        return b.append(']');
    }

    public static Limits unbounded() {
        return UNBOUNDED;
    }
}

