/*
 * Decompiled with CFR 0.152.
 */
package compiler;

import compiler.ABI;
import compiler.ABIComponent;
import compiler.FunctionHashesKt;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.komputing.khash.keccak.Keccak;
import org.komputing.khash.keccak.KeccakParameter;
import utils.ExtStdlibKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001f\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u001f\u0010\t\u001a\u00020\u00012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0004\u001a\u0014\u0010\n\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0007\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\fH\u0007\u001a\u001c\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a8\u0006\u0015"}, d2={"applyKeccak", "Ljava/math/BigInteger;", "words", "", "([Ljava/math/BigInteger;)Ljava/math/BigInteger;", "byteArray", "", "", "Lkotlin/UByte;", "applyKeccakByHexStringConversion", "applyKeccakList", "calculateHash", "", "abi", "Lcompiler/ABI;", "calculateHashFromCanonicalName", "canonicalName", "calculateHashFromCanonicalNameBigInt", "calculateHashFromNameAndArgTypes", "name", "argTypes", "Shared"})
@SourceDebugExtension(value={"SMAP\nFunctionHashes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionHashes.kt\ncompiler/FunctionHashesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1549#2:111\n1620#2,3:112\n1549#2:115\n1620#2,3:116\n2661#2,7:119\n*S KotlinDebug\n*F\n+ 1 FunctionHashes.kt\ncompiler/FunctionHashesKt\n*L\n57#1:111\n57#1:112,3\n82#1:115\n82#1:116,3\n93#1:119,7\n*E\n"})
public final class FunctionHashesKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String calculateHash(@NotNull ABI abi) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(abi, "abi");
        String name = abi.getName();
        Iterable $this$map$iv = abi.getInputs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            ABIComponent aBIComponent = (ABIComponent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getType());
        }
        List inputTypes = (List)destination$iv$iv;
        return FunctionHashesKt.calculateHashFromNameAndArgTypes(name, inputTypes);
    }

    @NotNull
    public static final String calculateHashFromNameAndArgTypes(@NotNull String name, @NotNull List<String> argTypes) {
        String stringToHash;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(argTypes, "argTypes");
        String string = stringToHash = name + "(" + CollectionsKt.joinToString$default(argTypes, ",", null, null, 0, null, null, 62, null) + ")";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] hash2 = Keccak.INSTANCE.digest(byArray, KeccakParameter.KECCAK_256);
        return ExtStdlibKt.toHexString(ArraysKt.take(hash2, 4));
    }

    @Deprecated(message="probably shouldn't be used; we are computing sighashes on python level (stored in certora_build.json), so this is duplicate functionality")
    @NotNull
    public static final String calculateHashFromCanonicalName(@NotNull String canonicalName) {
        Intrinsics.checkNotNullParameter(canonicalName, "canonicalName");
        String string = canonicalName;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] hash2 = Keccak.INSTANCE.digest(byArray, KeccakParameter.KECCAK_256);
        return ExtStdlibKt.toHexString(ArraysKt.take(hash2, 4));
    }

    @Deprecated(message="probably shouldn't be used; we are computing sighashes on python level (stored in certora_build.json), so this is duplicate functionality")
    @NotNull
    public static final BigInteger calculateHashFromCanonicalNameBigInt(@NotNull String canonicalName) {
        Intrinsics.checkNotNullParameter(canonicalName, "canonicalName");
        return new BigInteger(FunctionHashesKt.calculateHashFromCanonicalName(canonicalName), CharsKt.checkRadix(16));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BigInteger applyKeccakList(@NotNull List<? extends BigInteger> words) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(words, "words");
        Iterable $this$map$iv = words;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            byte[] byArray;
            void it2;
            BigInteger bigInteger = (BigInteger)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            byte[] ba = it2.toByteArray();
            boolean bl2 = false;
            Intrinsics.checkNotNull(ba);
            List<Byte> lsbs = ArraysKt.takeLast(ba, Math.min(ba.length, 32));
            if (lsbs.size() <= 32) {
                byte[] byteArray = new byte[32 - lsbs.size()];
                byArray = ArraysKt.plus(byteArray, CollectionsKt.toByteArray((Collection<Byte>)lsbs));
            } else {
                byArray = CollectionsKt.toByteArray((Collection<Byte>)lsbs);
            }
            collection.add(byArray);
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void y;
            byte[] $i$f$mapTo2 = (byte[])iterator$iv.next();
            byte[] x = (byte[])accumulator$iv;
            boolean bl = false;
            accumulator$iv = ArraysKt.plus(x, (byte[])y);
        }
        byte[] input = (byte[])accumulator$iv;
        return FunctionHashesKt.applyKeccak(input);
    }

    @NotNull
    public static final BigInteger applyKeccak(BigInteger ... words) {
        Intrinsics.checkNotNullParameter(words, "words");
        return FunctionHashesKt.applyKeccakList(ArraysKt.toList(words));
    }

    @NotNull
    public static final BigInteger applyKeccakByHexStringConversion(BigInteger ... words) {
        Intrinsics.checkNotNullParameter(words, "words");
        String str2 = ArraysKt.joinToString$default(words, (CharSequence)"", null, null, 0, null, (Function1)applyKeccakByHexStringConversion.str.1.INSTANCE, 30, null);
        return FunctionHashesKt.applyKeccak(ExtStdlibKt.hexStringToBytes(str2));
    }

    @NotNull
    public static final BigInteger applyKeccak(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        return new BigInteger(ArraysKt.joinToString$default(Keccak.INSTANCE.digest(byteArray, KeccakParameter.KECCAK_256), (CharSequence)"", null, null, 0, null, (Function1)applyKeccak.1.INSTANCE, 30, null), CharsKt.checkRadix(16));
    }

    @NotNull
    public static final BigInteger applyKeccak(@NotNull List<UByte> byteArray) {
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        return FunctionHashesKt.applyKeccak(ExtStdlibKt.toByteArray(byteArray));
    }
}

