/*
 * Decompiled with CFR 0.152.
 */
package ksp.hooks;

import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSValueArgument;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import ksp.CertoraAnnotationProcessor;
import ksp.hooks.CVLHookProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0017B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lksp/hooks/CVLHookProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "Lksp/CertoraAnnotationProcessor;", "environment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "(Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;)V", "accountIdType", "", "annotationName", "annotationPackage", "getAnnotationPackage", "()Ljava/lang/String;", "getEnvironment", "()Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "evmTypes", "parseHookCVLType", "tyName", "parseHookEVMType", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "Instrumentation", "KspGeneration"})
@SourceDebugExtension(value={"SMAP\nCVLHookProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CVLHookProcessor.kt\nksp/hooks/CVLHookProcessor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,434:1\n37#2,2:435\n1855#3,2:437\n1855#3,2:439\n1855#3,2:441\n1855#3,2:443\n*S KotlinDebug\n*F\n+ 1 CVLHookProcessor.kt\nksp/hooks/CVLHookProcessor\n*L\n316#1:435,2\n344#1:437,2\n359#1:439,2\n377#1:441,2\n418#1:443,2\n*E\n"})
public final class CVLHookProcessor
implements SymbolProcessor,
CertoraAnnotationProcessor {
    @NotNull
    private final SymbolProcessorEnvironment environment;
    @NotNull
    private final String annotationName;
    @NotNull
    private final String accountIdType;
    @NotNull
    private final String evmTypes;

    public CVLHookProcessor(@NotNull SymbolProcessorEnvironment environment) {
        Intrinsics.checkNotNullParameter(environment, "environment");
        this.environment = environment;
        this.annotationName = "OpcodeHookType";
        this.accountIdType = "spec.cvlast.CVLType.PureCVLType.Primitive.AccountIdentifier";
        this.evmTypes = "spec.cvlast.typedescriptors.EVMTypeDescriptor";
    }

    @NotNull
    public final SymbolProcessorEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    @NotNull
    public String getAnnotationPackage() {
        return "annotation";
    }

    private final String parseHookCVLType(String tyName) {
        String string;
        switch (tyName) {
            case "address": {
                string = this.accountIdType;
                break;
            }
            case "uint256": {
                string = "spec.cvlast.CVLType.PureCVLType.Primitive.UIntK(256)";
                break;
            }
            case "bytes32": {
                string = "spec.cvlast.CVLType.PureCVLType.Primitive.BytesK(32)";
                break;
            }
            case "bytes4": {
                string = "spec.cvlast.CVLType.PureCVLType.Primitive.BytesK(4)";
                break;
            }
            case "uint32": {
                string = "spec.cvlast.CVLType.PureCVLType.Primitive.UIntK(32)";
                break;
            }
            default: {
                KSPLogger.error$default(this.environment.getLogger(), "Could not understand type " + tyName + ": we only support address, bytes32, bytes4, and uint256", null, 2, null);
                return null;
            }
        }
        return string;
    }

    private final String parseHookEVMType(String tyName) {
        String string;
        switch (tyName) {
            case "address": {
                string = this.evmTypes + ".address";
                break;
            }
            case "uint256": {
                string = this.evmTypes + ".UIntK(256)";
                break;
            }
            case "bytes32": {
                string = this.evmTypes + ".BytesK(256)";
                break;
            }
            case "bytes4": {
                string = this.evmTypes + ".BytesK(4)";
                break;
            }
            case "uint32": {
                string = this.evmTypes + ".UIntK(32)";
                break;
            }
            default: {
                KSPLogger.error$default(this.environment.getLogger(), "Could not understand evm type " + tyName + ": we only support address, bytes32, bytes4, and uint256, uint32", null, 2, null);
                return null;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        int n;
        Instrumentation it2;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        int n2;
        Object writer2;
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Set files = new LinkedHashSet();
        List instr2 = SequencesKt.toList(SequencesKt.mapNotNull(Resolver.getSymbolsWithAnnotation$default(resolver, this.getAnnotationPackage() + "." + this.annotationName, false, 2, null), (Function1)new Function1<KSAnnotated, Instrumentation>((Set<KSFile>)files, this){
            final /* synthetic */ Set<KSFile> $files;
            final /* synthetic */ CVLHookProcessor this$0;
            {
                this.$files = $files;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Instrumentation invoke(@NotNull KSAnnotated enumEntry) {
                void $this$mapTo$iv$iv;
                Object object;
                void $this$mapTo$iv$iv2;
                Collection collection;
                List<T> allHookParams;
                List<T> list;
                Iterable typeName;
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Object object2;
                Object element$iv$iv$iv2;
                void $this$mapNotNullTo$iv$iv2;
                void $this$mapNotNull$iv2;
                Object v19;
                List envParams;
                boolean dependentOnStorageSplitting;
                String valueType;
                Object it2;
                List parameters;
                boolean hasOutput;
                String declarationName;
                String opcodeName;
                block39: {
                    KSValueArgument kSValueArgument;
                    Object object32;
                    KSAnnotation opcodeAnnotation;
                    block38: {
                        Object v13;
                        Object it32;
                        block37: {
                            Object v11;
                            Object it4;
                            block36: {
                                Object object4;
                                block35: {
                                    KSAnnotation kSAnnotation;
                                    Object object5;
                                    Object object62;
                                    Object object7;
                                    block34: {
                                        Object object8;
                                        block33: {
                                            Object object9;
                                            Object p0;
                                            Object object10;
                                            Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
                                            KSClassDeclaration hookableOpcodeEntry = (KSClassDeclaration)enumEntry;
                                            opcodeName = hookableOpcodeEntry.getSimpleName().asString();
                                            KSFile kSFile = ((KSClassDeclaration)enumEntry).getContainingFile();
                                            if (kSFile != null) {
                                                object10 = kSFile;
                                                object7 = this.$files;
                                                p0 = object10;
                                                boolean object62 = false;
                                                object9 = object7.add((KSFile)p0);
                                            } else {
                                                this.this$0.getEnvironment().getLogger().warn("Could not find Kotlin file containing " + ((KSClassDeclaration)enumEntry).getQualifiedName(), enumEntry);
                                                object9 = Unit.INSTANCE;
                                            }
                                            String string = opcodeName.substring(0, 1);
                                            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                                            String string2 = opcodeName.substring(1);
                                            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                                            String string3 = string2.toLowerCase(Locale.ROOT);
                                            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                                            declarationName = string + string3;
                                            object10 = enumEntry.getAnnotations();
                                            object7 = this.this$0;
                                            p0 = object10;
                                            object62 = p0.iterator();
                                            while (object62.hasNext()) {
                                                object5 = object62.next();
                                                it4 = (KSAnnotation)object5;
                                                boolean bl = false;
                                                if (!((CVLHookProcessor)object7).isAnnotation((KSAnnotation)it4, CVLHookProcessor.access$getAnnotationName$p((CVLHookProcessor)object7))) continue;
                                                object8 = object5;
                                                break block33;
                                            }
                                            object8 = null;
                                        }
                                        Intrinsics.checkNotNull(object8);
                                        opcodeAnnotation = (KSAnnotation)object8;
                                        object62 = opcodeAnnotation.getArguments();
                                        object5 = object62.iterator();
                                        while (object5.hasNext()) {
                                            it4 = object5.next();
                                            KSValueArgument it5 = (KSValueArgument)it4;
                                            boolean bl = false;
                                            KSName kSName = it5.getName();
                                            if (!Intrinsics.areEqual(kSName != null ? kSName.asString() : null, "withOutput")) continue;
                                            kSAnnotation = it4;
                                            break block34;
                                        }
                                        kSAnnotation = null;
                                    }
                                    Intrinsics.checkNotNull(kSAnnotation);
                                    object7 = ((KSValueArgument)((Object)kSAnnotation)).getValue();
                                    Intrinsics.checkNotNull(object7, "null cannot be cast to non-null type kotlin.Boolean");
                                    hasOutput = (Boolean)object7;
                                    object62 = opcodeAnnotation.getArguments();
                                    object5 = object62.iterator();
                                    while (object5.hasNext()) {
                                        it4 = object5.next();
                                        KSValueArgument it32 = (KSValueArgument)it4;
                                        boolean object32 = false;
                                        KSName kSName = it32.getName();
                                        if (!Intrinsics.areEqual(kSName != null ? kSName.asString() : null, "params")) continue;
                                        object4 = it4;
                                        break block35;
                                    }
                                    object4 = null;
                                }
                                Intrinsics.checkNotNull(object4);
                                Object $this$uncheckedAs$iv = ((KSValueArgument)object4).getValue();
                                boolean $i$f$uncheckedAs = false;
                                parameters = (List)$this$uncheckedAs$iv;
                                it4 = opcodeAnnotation.getArguments();
                                it32 = it4.iterator();
                                while (it32.hasNext()) {
                                    T object32 = it32.next();
                                    it2 = (KSValueArgument)object32;
                                    boolean bl = false;
                                    KSName kSName = it2.getName();
                                    if (!Intrinsics.areEqual(kSName != null ? kSName.asString() : null, "valueType")) continue;
                                    v11 = object32;
                                    break block36;
                                }
                                v11 = null;
                            }
                            Intrinsics.checkNotNull(v11);
                            Object $i$f$uncheckedAs = ((KSValueArgument)v11).getValue();
                            Intrinsics.checkNotNull($i$f$uncheckedAs, "null cannot be cast to non-null type kotlin.String");
                            valueType = (String)$i$f$uncheckedAs;
                            it4 = opcodeAnnotation.getArguments();
                            it32 = it4.iterator();
                            while (it32.hasNext()) {
                                T object32 = it32.next();
                                it2 = (KSValueArgument)object32;
                                boolean bl = false;
                                KSName kSName = it2.getName();
                                if (!Intrinsics.areEqual(kSName != null ? kSName.asString() : null, "onlyNoStorageSplitting")) continue;
                                v13 = object32;
                                break block37;
                            }
                            v13 = null;
                        }
                        Intrinsics.checkNotNull(v13);
                        Object object11 = ((KSValueArgument)v13).getValue();
                        Intrinsics.checkNotNull(object11);
                        dependentOnStorageSplitting = (Boolean)object11;
                        it32 = opcodeAnnotation.getArguments();
                        object32 = it32.iterator();
                        while (object32.hasNext()) {
                            it2 = object32.next();
                            KSValueArgument it6 = it2;
                            boolean bl = false;
                            KSName kSName = it6.getName();
                            if (!Intrinsics.areEqual(kSName != null ? kSName.asString() : null, "envParams")) continue;
                            kSValueArgument = it2;
                            break block38;
                        }
                        kSValueArgument = null;
                    }
                    Intrinsics.checkNotNull(kSValueArgument);
                    Object object12 = ((KSValueArgument)kSValueArgument).getValue();
                    Intrinsics.checkNotNull(object12);
                    Object $this$uncheckedAs$iv = object12;
                    boolean $i$f$uncheckedAs = false;
                    envParams = (List)$this$uncheckedAs$iv;
                    object32 = opcodeAnnotation.getArguments();
                    it2 = object32.iterator();
                    while (it2.hasNext()) {
                        E it6 = it2.next();
                        KSValueArgument it7 = (KSValueArgument)it6;
                        boolean bl = false;
                        KSName kSName = it7.getName();
                        if (!Intrinsics.areEqual(kSName != null ? kSName.asString() : null, "extraInterfaces")) continue;
                        v19 = it6;
                        break block39;
                    }
                    v19 = null;
                }
                Intrinsics.checkNotNull(v19);
                Object object13 = ((KSValueArgument)v19).getValue();
                Intrinsics.checkNotNull(object13);
                Object $this$uncheckedAs$iv = object13;
                boolean $i$f$uncheckedAs22 = false;
                List extraInterfaces = (List)$this$uncheckedAs$iv;
                Iterable $i$f$uncheckedAs22 = parameters;
                it2 = this.this$0;
                boolean $i$f$mapNotNull22 = false;
                void it7 = $this$mapNotNull$iv2;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
                    Pair<String, String> pair2;
                    T element$iv$iv = element$iv$iv$iv2;
                    boolean bl = false;
                    String it8 = (String)element$iv$iv;
                    boolean bl2 = false;
                    object2 = new Regex("\\s+");
                    CharSequence charSequence = it8;
                    int n = 0;
                    List<String> parsed = ((Regex)object2).split(charSequence, n);
                    if (parsed.size() != 2) {
                        ((CVLHookProcessor)it2).getEnvironment().getLogger().error("Could not parse parameter declaration " + it8, enumEntry);
                        pair2 = null;
                    } else {
                        String typeName2;
                        pair2 = CVLHookProcessor.access$parseHookCVLType((CVLHookProcessor)it2, parsed.get(0)) == null ? null : TuplesKt.to(parsed.get(1), typeName2);
                    }
                    if (pair2 == null) continue;
                    Pair<String, String> it$iv$iv = pair2;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List<T> opcodeParamsAndTypes = (List<T>)destination$iv$iv;
                it2 = envParams;
                String[] $i$f$mapNotNull22 = this.this$0;
                boolean $i$f$mapNotNull = false;
                destination$iv$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$mapNotNullTo2 = false;
                KSType $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
                while (element$iv$iv$iv2.hasNext()) {
                    Pair<String, String> pair3;
                    E element$iv$iv$iv3;
                    E element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
                    boolean bl = false;
                    String it9 = (String)element$iv$iv;
                    boolean bl4 = false;
                    Regex regex = new Regex("\\s+");
                    object2 = it9;
                    int parsed = 0;
                    List<String> parsed2 = regex.split((CharSequence)object2, parsed);
                    if (parsed2.size() != 2) {
                        $i$f$mapNotNull22.getEnvironment().getLogger().error("Could not parse parameter declaration " + it9, enumEntry);
                        pair3 = null;
                    } else {
                        pair3 = CVLHookProcessor.access$parseHookEVMType((CVLHookProcessor)$i$f$mapNotNull22, parsed2.get(0)) == null ? null : TuplesKt.to(parsed2.get(1), typeName);
                    }
                    if (pair3 == null) continue;
                    Pair<String, String> it$iv$iv = pair3;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List envParamsAndTypes = (List)destination$iv$iv2;
                $i$f$mapNotNull22 = new String[]{"GeneratedOpcodeHook"};
                List<String> extendsList = CollectionsKt.mutableListOf($i$f$mapNotNull22);
                if (!((Collection)envParamsAndTypes).isEmpty()) {
                    extendsList.add("OpcodeHookWithEnv");
                }
                if (hasOutput) {
                    extendsList.add("spec.cvlast.PatternWithValue");
                    String string = CVLHookProcessor.access$parseHookCVLType(this.this$0, valueType);
                    if (string == null) {
                        return null;
                    }
                    list = CollectionsKt.plus((Collection)CollectionsKt.listOf(TuplesKt.to("value", string)), (Iterable)opcodeParamsAndTypes);
                } else {
                    list = allHookParams = opcodeParamsAndTypes;
                }
                if (!((Collection)extraInterfaces).isEmpty()) {
                    Iterable $this$mapTo$iv = extraInterfaces;
                    boolean $i$f$mapTo = false;
                    for (E item$iv : $this$mapTo$iv) {
                        void it10;
                        $this$forEach$iv$iv$iv2 = (KSType)item$iv;
                        collection = extendsList;
                        boolean bl = false;
                        KSName kSName = it10.getDeclaration().getQualifiedName();
                        String string = kSName != null ? kSName.asString() : null;
                        Intrinsics.checkNotNull(string);
                        collection.add(string);
                    }
                    Collection cfr_ignored_0 = (Collection)extendsList;
                }
                Iterable $this$map$iv = allHookParams;
                boolean $i$f$map = false;
                Iterable item$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (E item$iv$iv : $this$mapTo$iv$iv2) {
                    void it11;
                    Pair element$iv$iv = (Pair)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl = false;
                    String prefix = Intrinsics.areEqual(it11.getFirst(), "value") && hasOutput ? "override " : "";
                    collection.add(prefix + "val " + it11.getFirst() + ": VMParam.Named");
                }
                List paramList = (List)destination$iv$iv3;
                String paramProperty2 = opcodeParamsAndTypes.isEmpty() ? "emptyList()" : "listOf(" + CollectionsKt.joinToString$default(opcodeParamsAndTypes, ", ", null, null, 0, null, process.instr.paramProperty.1.INSTANCE, 30, null) + ")";
                Object prettyPrint2 = "$name";
                if (!((Collection)opcodeParamsAndTypes).isEmpty()) {
                    prettyPrint2 = (String)prettyPrint2 + CollectionsKt.joinToString$default(opcodeParamsAndTypes, ",", "(", ")", 0, null, process.instr.3.INSTANCE, 24, null);
                }
                if (hasOutput) {
                    prettyPrint2 = (String)prettyPrint2 + " = $value";
                }
                if (envParamsAndTypes.isEmpty()) {
                    object = "";
                } else {
                    String envFields2 = CollectionsKt.joinToString$default(envParamsAndTypes, "\n", null, null, 0, null, process.instr.envParamDecl.envFields.1.INSTANCE, 30, null);
                    String fieldGenerator2 = "override fun environmentParams() = listOf(" + CollectionsKt.joinToString$default(envParamsAndTypes, ", ", null, null, 0, null, process.instr.envParamDecl.fieldGenerator.1.INSTANCE, 30, null) + ")";
                    object = envFields2 + " \n " + fieldGenerator2;
                }
                String envParamDecl2 = object;
                String hookDeclaration2 = StringsKt.trimIndent("\n                @kotlinx.serialization.Serializable\n                data class " + declarationName + "(" + CollectionsKt.joinToString$default(paramList, ", ", null, null, 0, null, null, 62, null) + ") : CVLHookPattern.Opcode(), " + CollectionsKt.joinToString$default(extendsList, ", ", null, null, 0, null, null, 62, null) + " {\n                   override val name: String = \"" + opcodeName + "\"\n                   override val params: List<VMParam.Named> = " + paramProperty2 + "\n                   override fun toString(): String = \"" + (String)prettyPrint2 + "\"\n                   " + envParamDecl2 + "\n                }\n            ");
                String fqn = "spec.cvlast." + declarationName;
                CVLHookProcessor $this$invoke_u24lambda_u2412 = this.this$0;
                boolean bl = false;
                Iterable $this$map$iv2 = allHookParams;
                boolean $i$f$map2 = false;
                typeName = $this$map$iv2;
                Collection destination$iv$iv4 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (E item$iv$iv : $this$mapTo$iv$iv) {
                    void it12;
                    Pair bl5 = (Pair)item$iv$iv;
                    Collection collection2 = destination$iv$iv4;
                    boolean bl6 = false;
                    collection2.add("val " + it12.getFirst() + " = namedVMParam(pattern." + it12.getFirst() + ")");
                }
                List remappings = (List)destination$iv$iv4;
                String rebuild2 = StringsKt.trimIndent("\n                pattern.copy(\n                   " + CollectionsKt.joinToString$default(allHookParams, ",\n", null, null, 0, null, process.instr.hookMapper.1.rebuild.1.INSTANCE, 30, null) + "\n                ).lift()\n            ");
                String hookMapper2 = StringsKt.trimIndent("\n                    is " + fqn + " -> {\n                        " + CollectionsKt.joinToString$default(remappings, "\n", null, null, 0, null, null, 62, null) + "\n                        bindMany(" + CollectionsKt.joinToString$default(allHookParams, ", ", null, null, 0, null, process.instr.hookMapper.1.1.INSTANCE, 30, null) + ") { -> " + rebuild2 + " }\n                    }\n                ");
                CVLHookProcessor $this$invoke_u24lambda_u2414 = this.this$0;
                boolean bl7 = false;
                List fieldChecks = new ArrayList<E>();
                Iterable $this$mapTo$iv = allHookParams;
                boolean $i$f$mapTo3 = false;
                for (T item$iv2 : $this$mapTo$iv) {
                    Pair item$iv$iv = (Pair)item$iv2;
                    Collection it12 = fieldChecks;
                    boolean bl8 = false;
                    String fld = (String)item$iv$iv.component1();
                    String type = (String)item$iv$iv.component2();
                    it12.add(StringsKt.trimIndent("\n                        checkHookParam(pattern." + fld + ".type, " + type + ", \"" + fld + "\", pattern)\n                    "));
                }
                Collection cfr_ignored_1 = (Collection)fieldChecks;
                if (dependentOnStorageSplitting) {
                    fieldChecks.add("if (Config.EnableStorageSplitting.get() && !Config.IsTypeChecking.get()) {\n                            CVLError.General(cvlRange, \"Must disable storage splitting to handle hook " + opcodeName + "\").asError()\n                        } else {\n                            ok\n                        }");
                }
                String hookTypeChecker = StringsKt.trimIndent("\n                    is " + fqn + " -> {\n                        bindMany(\n                            " + CollectionsKt.joinToString$default(fieldChecks, ",\n", null, null, 0, null, null, 62, null) + "\n                        ) { pattern.lift() }\n                    }\n                ");
                String qualifiedEnumName = "com.certora.certoraprover.cvl.HookType." + opcodeName;
                CVLHookProcessor $this$invoke_u24lambda_u2416 = this.this$0;
                boolean bl9 = false;
                List argumentParsers = new ArrayList<E>();
                List prefix = new ArrayList<E>();
                if (hasOutput) {
                    prefix.add(StringsKt.trimIndent("\n                        if(valueParam == null) {\n                           return CVLError.General(\n                              message = \"Opcode " + opcodeName + " produces a value, but no output was declared\",\n                              cvlRange = cvlRange\n                           ).asError()\n                        }\n                    "));
                }
                prefix.add(StringsKt.trimIndent("\n                    if(params.size != " + opcodeParamsAndTypes.size() + ") {\n                       return CVLError.General(\n                          message = \"Opcode " + opcodeName + " expects " + opcodeParamsAndTypes.size() + " parameters, got \" + params.size,\n                          cvlRange = cvlRange\n                       ).asError()\n                    }\n                "));
                if (hasOutput) {
                    argumentParsers.add(TuplesKt.to("value", "valueParam.kotlinize(resolver, scope)"));
                }
                Iterable $this$forEachIndexed$iv = opcodeParamsAndTypes;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv3 : $this$forEachIndexed$iv) {
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Pair pair4 = (Pair)item$iv3;
                    int idx = n;
                    boolean bl10 = false;
                    String paramName = (String)pair4.component1();
                    argumentParsers.add(TuplesKt.to(paramName, StringsKt.trimIndent("\n                            params[" + idx + "].kotlinize(resolver, scope)\n                        ")));
                }
                String hookParser2 = StringsKt.trimIndent("\n                    " + qualifiedEnumName + " -> {\n                       " + CollectionsKt.joinToString$default(prefix, "\n", null, null, 0, null, null, 62, null) + "\n\n                       " + CollectionsKt.joinToString$default(argumentParsers, "\n", null, null, 0, null, process.instr.hookParser.1.2.INSTANCE, 30, null) + "\n                        bindMany(" + CollectionsKt.joinToString$default(argumentParsers, ", ", null, null, 0, null, process.instr.hookParser.1.3.INSTANCE, 30, null) + ") {\n                            " + fqn + "(\n                                " + CollectionsKt.joinToString$default(argumentParsers, ",\n", null, null, 0, null, process.instr.hookParser.1.4.INSTANCE, 30, null) + "\n                            ).lift()\n                        }\n                    }\n                ");
                return new Instrumentation(hookDeclaration2, hookMapper2, hookTypeChecker, parameters.size(), hookParser2, qualifiedEnumName);
            }
        }));
        if (instr2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = files;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv22 = $this$toTypedArray$iv;
        Object object = thisCollection$iv22.toArray(new KSFile[0]);
        Dependencies deps = new Dependencies(true, Arrays.copyOf(object, ((KSFile[])object).length));
        object = this.environment.getCodeGenerator().createNewFile(deps, "spec.cvlast", "GeneratedHookHelpers", "kt");
        Object object2 = Charsets.UTF_8;
        Writer $i$f$toTypedArray22 = new OutputStreamWriter((OutputStream)object, (Charset)object2);
        int thisCollection$iv22 = 8192;
        object = $i$f$toTypedArray22 instanceof BufferedWriter ? (BufferedWriter)$i$f$toTypedArray22 : new BufferedWriter($i$f$toTypedArray22, thisCollection$iv22);
        object2 = null;
        try {
            writer2 = (BufferedWriter)object;
            n2 = 0;
            ((Writer)writer2).write("package spec.cvlast\n\nimport config.Config\nimport datastructures.stdcollections.*\nimport spec.cvlast.typedescriptors.*\nimport spec.cvlast.typechecker.CVLError\nimport utils.CollectingResult.Companion.bindMany\nimport utils.CollectingResult.Companion.lift\nimport utils.CollectingResult\nimport utils.VoidResult\nimport utils.CollectingResult.Companion.asError\nimport utils.CollectingResult.Companion.ok\n\nobject GeneratedHookHelpers {");
            ((Writer)writer2).write("fun typeCheckPattern(\n    cvlRange: CVLRange,\n    pattern: GeneratedOpcodeHook,\n    checkHookParam: (VMTypeDescriptor, CVLType.PureCVLType, String, CVLHookPattern.Opcode) -> VoidResult<CVLError>\n) : CollectingResult<CVLHookPattern.Opcode, CVLError> {\n   return when(pattern) {");
            $this$forEach$iv = instr2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (Instrumentation)element$iv;
                boolean bl = false;
                ((BufferedWriter)writer2).newLine();
                ((Writer)writer2).write(it2.getHookPatternChecker());
            }
            ((Writer)writer2).write("    } // end when\n} // end function");
            ((BufferedWriter)writer2).newLine();
            ((Writer)writer2).write("fun <E> mapPattern(pattern: GeneratedOpcodeHook, namedVMParam: (VMParam.Named) -> CollectingResult<VMParam.Named, E>): CollectingResult<CVLHookPattern, E> {\n    return when(pattern) {");
            $this$forEach$iv = instr2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (Instrumentation)element$iv;
                boolean bl = false;
                ((BufferedWriter)writer2).newLine();
                ((Writer)writer2).write(it2.getHookMapper());
            }
            ((Writer)writer2).write("   } // end when\n} // end function\n} // end object");
            writer2 = Unit.INSTANCE;
        }
        catch (Throwable writer2) {
            object2 = writer2;
            throw writer2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        object = this.environment.getCodeGenerator().createNewFile(deps, "spec.cvlast", "GeneratedOpcodeHooks", "kt");
        object2 = Charsets.UTF_8;
        writer2 = new OutputStreamWriter((OutputStream)object, (Charset)object2);
        n2 = 8192;
        object = writer2 instanceof BufferedWriter ? (BufferedWriter)writer2 : new BufferedWriter((Writer)writer2, n2);
        object2 = null;
        try {
            writer2 = (BufferedWriter)object;
            n = 0;
            ((Writer)writer2).write("package spec.cvlast\n\nimport datastructures.stdcollections.*");
            $this$forEach$iv = instr2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (Instrumentation)element$iv;
                boolean bl = false;
                ((BufferedWriter)writer2).newLine();
                ((Writer)writer2).write(it2.getHookDeclaration());
            }
            writer2 = Unit.INSTANCE;
        }
        catch (Throwable writer2) {
            object2 = writer2;
            throw writer2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        object = this.environment.getCodeGenerator().createNewFile(deps, "spec.cvlast.parser", "GeneratedOpcodeParsers", "kt");
        object2 = Charsets.UTF_8;
        writer2 = new OutputStreamWriter((OutputStream)object, (Charset)object2);
        n = 8192;
        object = writer2 instanceof BufferedWriter ? (BufferedWriter)writer2 : new BufferedWriter((Writer)writer2, n);
        object2 = null;
        try {
            writer2 = (BufferedWriter)object;
            boolean bl = false;
            ((Writer)writer2).write(StringsKt.trimIndent("\n                @file:Suppress(\"ReplaceSizeCheckWithIsNotEmpty\", \"ConvertToStringTemplate\") // we generate const checks that might be against 0\n                   package spec.cvlast.parser\n\n                import datastructures.stdcollections.*\n                import spec.cvlast.*\n                import utils.CollectingResult.Companion.bindMany\n                import utils.CollectingResult.Companion.lift\n                import utils.CollectingResult.Companion.asError\n                import spec.cvlast.typechecker.CVLError\n                import utils.CollectingResult\n                import spec.TypeResolver\n                import spec.cvlast.CVLScope\n\n                object GeneratedOpcodeParsers {\n                   fun supportsAutoParse(\n                      hookType: com.certora.certoraprover.cvl.HookType\n                   ) : Boolean {\n                      return " + CollectionsKt.joinToString$default(instr2, " ||\n", null, null, 0, null, process.3.1.INSTANCE, 30, null) + "\n                   }\n\n                   fun handleParse(\n                      resolver: TypeResolver,\n                      scope: CVLScope,\n                      hookType: com.certora.certoraprover.cvl.HookType,\n                      valueParam: com.certora.certoraprover.cvl.NamedVMParam?,\n                      params: List<com.certora.certoraprover.cvl.NamedVMParam>,\n                      cvlRange: CVLRange\n                   ) : CollectingResult<CVLHookPattern, CVLError> {\n                      return when(hookType) {\n            "));
            $this$forEach$iv = instr2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (Instrumentation)element$iv;
                boolean bl2 = false;
                ((BufferedWriter)writer2).newLine();
                ((Writer)writer2).write(it2.getHookParser());
            }
            ((BufferedWriter)writer2).newLine();
            ((Writer)writer2).write("        else -> throw UnsupportedOperationException(\"cannot auto parse \" + hookType)\n    }\n   }\n}");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isAnnotation(@NotNull KSAnnotation $this$isAnnotation, @NotNull String shortName) {
        return CertoraAnnotationProcessor.DefaultImpls.isAnnotation(this, $this$isAnnotation, shortName);
    }

    @Override
    public boolean isAnnotation(@NotNull KSAnnotation it2, @NotNull String shortName, @NotNull String qualified) {
        return CertoraAnnotationProcessor.DefaultImpls.isAnnotation(this, it2, shortName, qualified);
    }

    @Override
    public boolean hasAnnotation(@NotNull KSAnnotated $this$hasAnnotation, @NotNull String shortName) {
        return CertoraAnnotationProcessor.DefaultImpls.hasAnnotation(this, $this$hasAnnotation, shortName);
    }

    public static final /* synthetic */ String access$parseHookCVLType(CVLHookProcessor $this, String tyName) {
        return $this.parseHookCVLType(tyName);
    }

    public static final /* synthetic */ String access$getAnnotationName$p(CVLHookProcessor $this) {
        return $this.annotationName;
    }

    public static final /* synthetic */ String access$parseHookEVMType(CVLHookProcessor $this, String tyName) {
        return $this.parseHookEVMType(tyName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lksp/hooks/CVLHookProcessor$Instrumentation;", "", "hookDeclaration", "", "hookMapper", "hookPatternChecker", "numParamsDeclared", "", "hookParser", "enumEntry", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getEnumEntry", "()Ljava/lang/String;", "getHookDeclaration", "getHookMapper", "getHookParser", "getHookPatternChecker", "getNumParamsDeclared", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "KspGeneration"})
    public static final class Instrumentation {
        @NotNull
        private final String hookDeclaration;
        @NotNull
        private final String hookMapper;
        @NotNull
        private final String hookPatternChecker;
        private final int numParamsDeclared;
        @NotNull
        private final String hookParser;
        @NotNull
        private final String enumEntry;

        public Instrumentation(@NotNull String hookDeclaration2, @NotNull String hookMapper2, @NotNull String hookPatternChecker, int numParamsDeclared, @NotNull String hookParser2, @NotNull String enumEntry) {
            Intrinsics.checkNotNullParameter(hookDeclaration2, "hookDeclaration");
            Intrinsics.checkNotNullParameter(hookMapper2, "hookMapper");
            Intrinsics.checkNotNullParameter(hookPatternChecker, "hookPatternChecker");
            Intrinsics.checkNotNullParameter(hookParser2, "hookParser");
            Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            this.hookDeclaration = hookDeclaration2;
            this.hookMapper = hookMapper2;
            this.hookPatternChecker = hookPatternChecker;
            this.numParamsDeclared = numParamsDeclared;
            this.hookParser = hookParser2;
            this.enumEntry = enumEntry;
        }

        @NotNull
        public final String getHookDeclaration() {
            return this.hookDeclaration;
        }

        @NotNull
        public final String getHookMapper() {
            return this.hookMapper;
        }

        @NotNull
        public final String getHookPatternChecker() {
            return this.hookPatternChecker;
        }

        public final int getNumParamsDeclared() {
            return this.numParamsDeclared;
        }

        @NotNull
        public final String getHookParser() {
            return this.hookParser;
        }

        @NotNull
        public final String getEnumEntry() {
            return this.enumEntry;
        }

        @NotNull
        public final String component1() {
            return this.hookDeclaration;
        }

        @NotNull
        public final String component2() {
            return this.hookMapper;
        }

        @NotNull
        public final String component3() {
            return this.hookPatternChecker;
        }

        public final int component4() {
            return this.numParamsDeclared;
        }

        @NotNull
        public final String component5() {
            return this.hookParser;
        }

        @NotNull
        public final String component6() {
            return this.enumEntry;
        }

        @NotNull
        public final Instrumentation copy(@NotNull String hookDeclaration2, @NotNull String hookMapper2, @NotNull String hookPatternChecker, int numParamsDeclared, @NotNull String hookParser2, @NotNull String enumEntry) {
            Intrinsics.checkNotNullParameter(hookDeclaration2, "hookDeclaration");
            Intrinsics.checkNotNullParameter(hookMapper2, "hookMapper");
            Intrinsics.checkNotNullParameter(hookPatternChecker, "hookPatternChecker");
            Intrinsics.checkNotNullParameter(hookParser2, "hookParser");
            Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            return new Instrumentation(hookDeclaration2, hookMapper2, hookPatternChecker, numParamsDeclared, hookParser2, enumEntry);
        }

        public static /* synthetic */ Instrumentation copy$default(Instrumentation instrumentation, String string, String string2, String string3, int n, String string4, String string5, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = instrumentation.hookDeclaration;
            }
            if ((n2 & 2) != 0) {
                string2 = instrumentation.hookMapper;
            }
            if ((n2 & 4) != 0) {
                string3 = instrumentation.hookPatternChecker;
            }
            if ((n2 & 8) != 0) {
                n = instrumentation.numParamsDeclared;
            }
            if ((n2 & 0x10) != 0) {
                string4 = instrumentation.hookParser;
            }
            if ((n2 & 0x20) != 0) {
                string5 = instrumentation.enumEntry;
            }
            return instrumentation.copy(string, string2, string3, n, string4, string5);
        }

        @NotNull
        public String toString() {
            return "Instrumentation(hookDeclaration=" + this.hookDeclaration + ", hookMapper=" + this.hookMapper + ", hookPatternChecker=" + this.hookPatternChecker + ", numParamsDeclared=" + this.numParamsDeclared + ", hookParser=" + this.hookParser + ", enumEntry=" + this.enumEntry + ")";
        }

        public int hashCode() {
            int result2 = this.hookDeclaration.hashCode();
            result2 = result2 * 31 + this.hookMapper.hashCode();
            result2 = result2 * 31 + this.hookPatternChecker.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.numParamsDeclared);
            result2 = result2 * 31 + this.hookParser.hashCode();
            result2 = result2 * 31 + this.enumEntry.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Instrumentation)) {
                return false;
            }
            Instrumentation instrumentation = (Instrumentation)other;
            if (!Intrinsics.areEqual(this.hookDeclaration, instrumentation.hookDeclaration)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.hookMapper, instrumentation.hookMapper)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.hookPatternChecker, instrumentation.hookPatternChecker)) {
                return false;
            }
            if (this.numParamsDeclared != instrumentation.numParamsDeclared) {
                return false;
            }
            if (!Intrinsics.areEqual(this.hookParser, instrumentation.hookParser)) {
                return false;
            }
            return Intrinsics.areEqual(this.enumEntry, instrumentation.enumEntry);
        }
    }
}

