/*
 * Decompiled with CFR 0.152.
 */
package log;

import java.io.File;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import log.ArtifactLocation;
import log.DynamicArtifactLocation;
import log.StaticArtifactLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.cvlast.IRule;
import spec.cvlast.RuleIdentifier;
import utils.ArtifactFileUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001:\u0001#B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\r\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J\t\u0010\"\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\r\u00a8\u0006$"}, d2={"Llog/RuleTestArtifactKey;", "", "rule", "Lspec/cvlast/IRule;", "kind", "Llog/RuleTestArtifactKey$TestArtifactKind;", "(Lspec/cvlast/IRule;Llog/RuleTestArtifactKey$TestArtifactKind;)V", "ruleIdentifier", "Lspec/cvlast/RuleIdentifier;", "declarationId", "", "(Lspec/cvlast/RuleIdentifier;Ljava/lang/String;Llog/RuleTestArtifactKey$TestArtifactKind;)V", "getDeclarationId", "()Ljava/lang/String;", "filename", "getFilename$Shared", "getKind", "()Llog/RuleTestArtifactKey$TestArtifactKind;", "getRuleIdentifier", "()Lspec/cvlast/RuleIdentifier;", "ruleNameSanitize", "getRuleNameSanitize$Shared", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toArtifactLocation", "Llog/ArtifactLocation;", "toArtifactLocation$Shared", "toString", "TestArtifactKind", "Shared"})
public final class RuleTestArtifactKey {
    @NotNull
    private final RuleIdentifier ruleIdentifier;
    @NotNull
    private final String declarationId;
    @NotNull
    private final TestArtifactKind kind;
    @NotNull
    private final String ruleNameSanitize;
    @NotNull
    private final String filename;

    public RuleTestArtifactKey(@NotNull RuleIdentifier ruleIdentifier, @NotNull String declarationId, @NotNull TestArtifactKind kind) {
        Intrinsics.checkNotNullParameter(ruleIdentifier, "ruleIdentifier");
        Intrinsics.checkNotNullParameter(declarationId, "declarationId");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        this.ruleIdentifier = ruleIdentifier;
        this.declarationId = declarationId;
        this.kind = kind;
        this.ruleNameSanitize = new ArtifactFileUtils.SanitizedPath(this.declarationId).getSanitizedFileBaseName();
        this.filename = this.ruleNameSanitize + "_" + this.kind.getSuffixFileName();
    }

    @NotNull
    public final RuleIdentifier getRuleIdentifier() {
        return this.ruleIdentifier;
    }

    @NotNull
    public final String getDeclarationId() {
        return this.declarationId;
    }

    @NotNull
    public final TestArtifactKind getKind() {
        return this.kind;
    }

    public RuleTestArtifactKey(@NotNull IRule rule2, @NotNull TestArtifactKind kind) {
        Intrinsics.checkNotNullParameter(rule2, "rule");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        this(rule2.getRuleIdentifier(), rule2.getDeclarationId(), kind);
    }

    @NotNull
    public final String getRuleNameSanitize$Shared() {
        return this.ruleNameSanitize;
    }

    @NotNull
    public final String getFilename$Shared() {
        return this.filename;
    }

    @NotNull
    public final ArtifactLocation toArtifactLocation$Shared() {
        return new DynamicArtifactLocation(StaticArtifactLocation.VerifierResults.INSTANCE, new File(this.ruleNameSanitize));
    }

    @NotNull
    public final RuleIdentifier component1() {
        return this.ruleIdentifier;
    }

    @NotNull
    public final String component2() {
        return this.declarationId;
    }

    @NotNull
    public final TestArtifactKind component3() {
        return this.kind;
    }

    @NotNull
    public final RuleTestArtifactKey copy(@NotNull RuleIdentifier ruleIdentifier, @NotNull String declarationId, @NotNull TestArtifactKind kind) {
        Intrinsics.checkNotNullParameter(ruleIdentifier, "ruleIdentifier");
        Intrinsics.checkNotNullParameter(declarationId, "declarationId");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        return new RuleTestArtifactKey(ruleIdentifier, declarationId, kind);
    }

    public static /* synthetic */ RuleTestArtifactKey copy$default(RuleTestArtifactKey ruleTestArtifactKey, RuleIdentifier ruleIdentifier, String string, TestArtifactKind testArtifactKind, int n, Object object) {
        if ((n & 1) != 0) {
            ruleIdentifier = ruleTestArtifactKey.ruleIdentifier;
        }
        if ((n & 2) != 0) {
            string = ruleTestArtifactKey.declarationId;
        }
        if ((n & 4) != 0) {
            testArtifactKind = ruleTestArtifactKey.kind;
        }
        return ruleTestArtifactKey.copy(ruleIdentifier, string, testArtifactKind);
    }

    @NotNull
    public String toString() {
        return "RuleTestArtifactKey(ruleIdentifier=" + this.ruleIdentifier + ", declarationId=" + this.declarationId + ", kind=" + this.kind + ")";
    }

    public int hashCode() {
        int result2 = this.ruleIdentifier.hashCode();
        result2 = result2 * 31 + this.declarationId.hashCode();
        result2 = result2 * 31 + this.kind.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RuleTestArtifactKey)) {
            return false;
        }
        RuleTestArtifactKey ruleTestArtifactKey = (RuleTestArtifactKey)other;
        if (!Intrinsics.areEqual(this.ruleIdentifier, ruleTestArtifactKey.ruleIdentifier)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.declarationId, ruleTestArtifactKey.declarationId)) {
            return false;
        }
        return this.kind == ruleTestArtifactKey.kind;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Llog/RuleTestArtifactKey$TestArtifactKind;", "", "suffixFileName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getSuffixFileName", "()Ljava/lang/String;", "EXAMPLES_INFO", "CORE_TAC_PROGRAM", "VIOLATED_ASSERT", "SINGLE_RULE", "EXPECTED", "Shared"})
    public static final class TestArtifactKind
    extends Enum<TestArtifactKind> {
        @NotNull
        private final String suffixFileName;
        public static final /* enum */ TestArtifactKind EXAMPLES_INFO = new TestArtifactKind("examplesInfo.json");
        public static final /* enum */ TestArtifactKind CORE_TAC_PROGRAM = new TestArtifactKind("CoreTACProgram.tac");
        public static final /* enum */ TestArtifactKind VIOLATED_ASSERT = new TestArtifactKind("ViolatedAssert.json");
        public static final /* enum */ TestArtifactKind SINGLE_RULE = new TestArtifactKind("SingleRule.json");
        public static final /* enum */ TestArtifactKind EXPECTED = new TestArtifactKind("expected.json");
        private static final /* synthetic */ TestArtifactKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private TestArtifactKind(String suffixFileName) {
            this.suffixFileName = suffixFileName;
        }

        @NotNull
        public final String getSuffixFileName() {
            return this.suffixFileName;
        }

        public static TestArtifactKind[] values() {
            return (TestArtifactKind[])$VALUES.clone();
        }

        public static TestArtifactKind valueOf(String value2) {
            return Enum.valueOf(TestArtifactKind.class, value2);
        }

        @NotNull
        public static EnumEntries<TestArtifactKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = testArtifactKindArray = new TestArtifactKind[]{TestArtifactKind.EXAMPLES_INFO, TestArtifactKind.CORE_TAC_PROGRAM, TestArtifactKind.VIOLATED_ASSERT, TestArtifactKind.SINGLE_RULE, TestArtifactKind.EXPECTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

