/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.html.AttributeGuardIntermediates;
import org.owasp.html.AttributeGuardMaker;
import org.owasp.html.AttributePolicy;
import org.owasp.html.CssSchema;
import org.owasp.html.ElementAndAttributePolicies;
import org.owasp.html.ElementPolicy;
import org.owasp.html.FilterUrlByProtocolAttributePolicy;
import org.owasp.html.HtmlChangeListener;
import org.owasp.html.HtmlElementTables;
import org.owasp.html.HtmlLexer;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventProcessor;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlTagSkipType;
import org.owasp.html.Joinable;
import org.owasp.html.PolicyFactory;
import org.owasp.html.SrcsetAttributePolicy;
import org.owasp.html.StandardUrlAttributePolicy;
import org.owasp.html.Strings;
import org.owasp.html.StylingPolicy;
import org.owasp.html.TCB;
import org.owasp.shim.Java8Shim;

@TCB
@NotThreadSafe
public class HtmlPolicyBuilder {
    public static final Set<String> DEFAULT_SKIP_IF_EMPTY = Java8Shim.j8().setOf((T[])new String[]{"a", "font", "img", "input", "span"});
    static final Map<String, HtmlTagSkipType> DEFAULT_SKIP_TAG_MAP_IF_EMPTY_ATTR;
    public static final List<String> DEFAULT_RELS_ON_TARGETTED_LINKS;
    static final String DEFAULT_RELS_ON_TARGETTED_LINKS_STR;
    private final Map<String, ElementPolicy> elPolicies = new LinkedHashMap<String, ElementPolicy>();
    private final Map<String, Map<String, AttributePolicy>> attrPolicies = new LinkedHashMap<String, Map<String, AttributePolicy>>();
    private final Map<String, AttributePolicy> globalAttrPolicies = new LinkedHashMap<String, AttributePolicy>();
    private final Set<String> allowedProtocols = new HashSet<String>();
    private final Map<String, HtmlTagSkipType> skipIssueTagMap = new LinkedHashMap<String, HtmlTagSkipType>(DEFAULT_SKIP_TAG_MAP_IF_EMPTY_ATTR);
    private final Map<String, Boolean> textContainers = new LinkedHashMap<String, Boolean>();
    private HtmlStreamEventProcessor postprocessor = HtmlStreamEventProcessor.Processors.IDENTITY;
    private HtmlStreamEventProcessor preprocessor = HtmlStreamEventProcessor.Processors.IDENTITY;
    private CssSchema stylingPolicySchema = null;
    private AttributePolicy styleUrlPolicy = AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY;
    private Set<String> extraRelsForLinks;
    private Set<String> skipRelsForLinks;
    private static HtmlElementTables METADATA;
    private static final Map<String, AttributeGuardMaker> ATTRIBUTE_GUARDS;
    private transient CompiledState compiledState;

    public HtmlPolicyBuilder allowElements(String ... elementNames2) {
        return this.allowElements(ElementPolicy.IDENTITY_ELEMENT_POLICY, elementNames2);
    }

    public HtmlPolicyBuilder disallowElements(String ... elementNames2) {
        return this.allowElements(ElementPolicy.REJECT_ALL_ELEMENT_POLICY, elementNames2);
    }

    public HtmlPolicyBuilder allowElements(ElementPolicy policy, String ... elementNames2) {
        this.invalidateCompiledState();
        for (String elementName : elementNames2) {
            elementName = HtmlLexer.canonicalElementName(elementName);
            ElementPolicy newPolicy = ElementPolicy.Util.join(this.elPolicies.get(elementName), policy);
            this.elPolicies.put(elementName, newPolicy);
            if (this.textContainers.containsKey(elementName) || !METADATA.canContainPlainText(METADATA.indexForName(elementName))) continue;
            this.textContainers.put(elementName, true);
        }
        return this;
    }

    public HtmlPolicyBuilder allowCommonInlineFormattingElements() {
        return this.allowElements("b", "i", "font", "s", "u", "o", "sup", "sub", "ins", "del", "strong", "strike", "tt", "code", "big", "small", "br", "span", "em");
    }

    public HtmlPolicyBuilder allowCommonBlockElements() {
        return this.allowElements("p", "div", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "li", "blockquote");
    }

    public HtmlPolicyBuilder allowTextIn(String ... elementNames2) {
        this.invalidateCompiledState();
        for (String elementName : elementNames2) {
            elementName = HtmlLexer.canonicalElementName(elementName);
            this.textContainers.put(elementName, true);
        }
        return this;
    }

    public HtmlPolicyBuilder disallowTextIn(String ... elementNames2) {
        this.invalidateCompiledState();
        for (String elementName : elementNames2) {
            elementName = HtmlLexer.canonicalElementName(elementName);
            this.textContainers.put(elementName, false);
        }
        return this;
    }

    public HtmlPolicyBuilder allowWithoutAttributes(String ... elementNames2) {
        this.invalidateCompiledState();
        for (String elementName : elementNames2) {
            elementName = HtmlLexer.canonicalElementName(elementName);
            this.skipIssueTagMap.put(elementName, HtmlTagSkipType.DO_NOT_SKIP);
        }
        return this;
    }

    public HtmlPolicyBuilder disallowWithoutAttributes(String ... elementNames2) {
        this.invalidateCompiledState();
        for (String elementName : elementNames2) {
            elementName = HtmlLexer.canonicalElementName(elementName);
            this.skipIssueTagMap.put(elementName, HtmlTagSkipType.SKIP);
        }
        return this;
    }

    public AttributeBuilder allowAttributes(String ... attributeNames) {
        ArrayList<String> builder = new ArrayList<String>();
        for (String attributeName : attributeNames) {
            builder.add(HtmlLexer.canonicalAttributeName(attributeName));
        }
        return new AttributeBuilder(Collections.unmodifiableList(builder));
    }

    public AttributeBuilder disallowAttributes(String ... attributeNames) {
        return this.allowAttributes(attributeNames).matching(AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY);
    }

    private HtmlPolicyBuilder allowAttributesGlobally(AttributePolicy policy, List<String> attributeNames) {
        this.invalidateCompiledState();
        for (String attributeName : attributeNames) {
            AttributePolicy oldPolicy = this.globalAttrPolicies.get(attributeName);
            this.globalAttrPolicies.put(attributeName, AttributePolicy.Util.join(oldPolicy, policy));
        }
        return this;
    }

    private HtmlPolicyBuilder allowAttributesOnElements(AttributePolicy policy, List<String> attributeNames, List<String> elementNames2) {
        this.invalidateCompiledState();
        for (String elementName : elementNames2) {
            Map<String, AttributePolicy> policies = this.attrPolicies.get(elementName);
            if (policies == null) {
                policies = new LinkedHashMap<String, AttributePolicy>();
                this.attrPolicies.put(elementName, policies);
            }
            for (String attributeName : attributeNames) {
                AttributePolicy oldPolicy = policies.get(attributeName);
                policies.put(attributeName, AttributePolicy.Util.join(oldPolicy, policy));
            }
        }
        return this;
    }

    public HtmlPolicyBuilder requireRelNofollowOnLinks() {
        return this.requireRelsOnLinks("nofollow");
    }

    public HtmlPolicyBuilder requireRelsOnLinks(String ... linkValues) {
        this.invalidateCompiledState();
        if (this.extraRelsForLinks == null) {
            this.extraRelsForLinks = new HashSet<String>();
        }
        for (String linkValue : linkValues) {
            if (Strings.containsHtmlSpace(linkValue = HtmlLexer.canonicalKeywordAttributeValue(linkValue))) {
                throw new IllegalArgumentException("spaces in input.  use f(\"foo\", \"bar\") not f(\"foo bar\")");
            }
            this.extraRelsForLinks.add(linkValue);
        }
        if (this.skipRelsForLinks != null) {
            this.skipRelsForLinks.removeAll(this.extraRelsForLinks);
        }
        return this;
    }

    public HtmlPolicyBuilder skipRelsOnLinks(String ... linkValues) {
        this.invalidateCompiledState();
        if (this.skipRelsForLinks == null) {
            this.skipRelsForLinks = new HashSet<String>();
        }
        for (String linkValue : linkValues) {
            if (Strings.containsHtmlSpace(linkValue = HtmlLexer.canonicalKeywordAttributeValue(linkValue))) {
                throw new IllegalArgumentException("spaces in input.  use f(\"foo\", \"bar\") not f(\"foo bar\")");
            }
            this.skipRelsForLinks.add(linkValue);
        }
        if (this.extraRelsForLinks != null) {
            this.extraRelsForLinks.removeAll(this.skipRelsForLinks);
        }
        return this;
    }

    public HtmlPolicyBuilder allowUrlProtocols(String ... protocols) {
        this.invalidateCompiledState();
        for (String protocol : protocols) {
            protocol = Strings.toLowerCase(protocol);
            this.allowedProtocols.add(protocol);
        }
        return this;
    }

    public HtmlPolicyBuilder disallowUrlProtocols(String ... protocols) {
        this.invalidateCompiledState();
        for (String protocol : protocols) {
            protocol = Strings.toLowerCase(protocol);
            this.allowedProtocols.remove(protocol);
        }
        return this;
    }

    public HtmlPolicyBuilder allowStandardUrlProtocols() {
        return this.allowUrlProtocols("http", "https", "mailto");
    }

    public HtmlPolicyBuilder allowStyling() {
        this.allowStyling(CssSchema.DEFAULT);
        return this;
    }

    public HtmlPolicyBuilder allowStyling(CssSchema whitelist) {
        this.invalidateCompiledState();
        this.stylingPolicySchema = this.stylingPolicySchema == null ? whitelist : CssSchema.union(this.stylingPolicySchema, whitelist);
        this.allowAttributesGlobally(AttributePolicy.IDENTITY_ATTRIBUTE_POLICY, Java8Shim.j8().listOf("style"));
        return this;
    }

    public HtmlPolicyBuilder allowUrlsInStyles(AttributePolicy newStyleUrlPolicy) {
        this.invalidateCompiledState();
        this.styleUrlPolicy = newStyleUrlPolicy;
        return this;
    }

    public HtmlPolicyBuilder withPreprocessor(HtmlStreamEventProcessor pp) {
        this.preprocessor = HtmlStreamEventProcessor.Processors.compose(this.preprocessor, pp);
        return this;
    }

    public HtmlPolicyBuilder withPostprocessor(HtmlStreamEventProcessor pp) {
        this.postprocessor = HtmlStreamEventProcessor.Processors.compose(this.postprocessor, pp);
        return this;
    }

    public HtmlSanitizer.Policy build(HtmlStreamEventReceiver out2) {
        return this.toFactory().apply(out2);
    }

    public <CTX> HtmlSanitizer.Policy build(HtmlStreamEventReceiver out2, @Nullable HtmlChangeListener<? super CTX> listener, @Nullable CTX context) {
        return this.toFactory().apply(out2, listener, context);
    }

    public PolicyFactory toFactory() {
        HashSet<String> textContainerSetBuilder = new HashSet<String>();
        for (Map.Entry<String, Boolean> textContainer : this.textContainers.entrySet()) {
            if (!Boolean.TRUE.equals(textContainer.getValue())) continue;
            textContainerSetBuilder.add(textContainer.getKey());
        }
        CompiledState compiled = this.compilePolicies();
        return new PolicyFactory(compiled.compiledPolicies, Collections.unmodifiableSet(textContainerSetBuilder), Java8Shim.j8().mapCopyOf(compiled.globalAttrPolicies), this.preprocessor, this.postprocessor);
    }

    private void invalidateCompiledState() {
        this.compiledState = null;
    }

    private CompiledState compilePolicies() {
        if (this.compiledState != null) {
            return this.compiledState;
        }
        LinkedHashMap<String, ElementPolicy> elPolicies = new LinkedHashMap<String, ElementPolicy>(this.elPolicies);
        LinkedHashMap<String, Map<String, AttributePolicy>> attrPolicies = new LinkedHashMap<String, Map<String, AttributePolicy>>(this.attrPolicies);
        for (Map.Entry entry2 : attrPolicies.entrySet()) {
            entry2.setValue(new LinkedHashMap((Map)entry2.getValue()));
        }
        LinkedHashMap<String, AttributePolicy> globalAttrPolicies = new LinkedHashMap<String, AttributePolicy>(this.globalAttrPolicies);
        Set<String> set2 = Java8Shim.j8().setCopyOf(this.allowedProtocols);
        ElementPolicy linkPolicy = (ElementPolicy)elPolicies.get("a");
        if (linkPolicy != null) {
            RelsOnLinksPolicy relsOnLinksPolicy = RelsOnLinksPolicy.create(this.extraRelsForLinks != null ? this.extraRelsForLinks : Java8Shim.j8().setOf(), this.skipRelsForLinks != null ? this.skipRelsForLinks : Java8Shim.j8().setOf());
            elPolicies.put("a", ElementPolicy.Util.join(linkPolicy, relsOnLinksPolicy));
        }
        AttributePolicy urlAttributePolicy = set2.size() == 3 && set2.contains("mailto") && set2.contains("http") && set2.contains("https") ? StandardUrlAttributePolicy.INSTANCE : new FilterUrlByProtocolAttributePolicy(set2);
        HashSet<String> toGuard = new HashSet<String>(ATTRIBUTE_GUARDS.keySet());
        AttributeGuardIntermediates intermediates = new AttributeGuardIntermediates(urlAttributePolicy, this.styleUrlPolicy, this.stylingPolicySchema);
        for (Map.Entry<String, AttributeGuardMaker> entry3 : ATTRIBUTE_GUARDS.entrySet()) {
            String attributeName = entry3.getKey();
            if (!globalAttrPolicies.containsKey(attributeName)) continue;
            toGuard.remove(attributeName);
            AttributePolicy guard = entry3.getValue().makeGuard(intermediates);
            globalAttrPolicies.put(attributeName, AttributePolicy.Util.join(guard, (AttributePolicy)globalAttrPolicies.get(attributeName)));
        }
        for (Map.Entry<String, AttributeGuardMaker> entry4 : attrPolicies.entrySet()) {
            Map policies = (Map)((Object)entry4.getValue());
            for (String attributeName : toGuard) {
                if (!policies.containsKey(attributeName)) continue;
                AttributePolicy guard = ATTRIBUTE_GUARDS.get(attributeName).makeGuard(intermediates);
                policies.put(attributeName, AttributePolicy.Util.join(guard, (AttributePolicy)policies.get(attributeName)));
            }
        }
        HashMap<String, ElementAndAttributePolicies> policiesBuilder = new HashMap<String, ElementAndAttributePolicies>();
        for (Map.Entry e : elPolicies.entrySet()) {
            AttributePolicy policy;
            String attributeName;
            String elementName = (String)e.getKey();
            ElementPolicy elementPolicy = (ElementPolicy)e.getValue();
            if (ElementPolicy.REJECT_ALL_ELEMENT_POLICY.equals(elementPolicy)) continue;
            Map elAttrPolicies = (Map)attrPolicies.get(elementName);
            if (elAttrPolicies == null) {
                elAttrPolicies = Java8Shim.j8().mapOfEntries(new Map.Entry[0]);
            }
            HashMap<String, AttributePolicy> attrsBuilder = new HashMap<String, AttributePolicy>();
            for (Map.Entry ape : elAttrPolicies.entrySet()) {
                attributeName = (String)ape.getKey();
                if (globalAttrPolicies.containsKey(attributeName) || AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY.equals(policy = (AttributePolicy)ape.getValue())) continue;
                attrsBuilder.put(attributeName, policy);
            }
            for (Map.Entry ape : globalAttrPolicies.entrySet()) {
                attributeName = (String)ape.getKey();
                policy = AttributePolicy.Util.join((AttributePolicy)elAttrPolicies.get(attributeName), (AttributePolicy)ape.getValue());
                if (AttributePolicy.REJECT_ALL_ATTRIBUTE_POLICY.equals(policy)) continue;
                attrsBuilder.put(attributeName, policy);
            }
            policiesBuilder.put(elementName, new ElementAndAttributePolicies(elementName, elementPolicy, Collections.unmodifiableMap(attrsBuilder), this.getHtmlTagSkipType(elementName)));
        }
        this.compiledState = new CompiledState(globalAttrPolicies, Collections.unmodifiableMap(policiesBuilder));
        return this.compiledState;
    }

    private HtmlTagSkipType getHtmlTagSkipType(String elementName) {
        HtmlTagSkipType htmlTagSkipType = this.skipIssueTagMap.get(elementName);
        if (htmlTagSkipType == null) {
            if (DEFAULT_SKIP_TAG_MAP_IF_EMPTY_ATTR.containsKey(elementName)) {
                return HtmlTagSkipType.SKIP_BY_DEFAULT;
            }
            return HtmlTagSkipType.DO_NOT_SKIP_BY_DEFAULT;
        }
        return htmlTagSkipType;
    }

    static {
        HashMap<String, Object> builder = new HashMap<String, Object>();
        for (String elementName : DEFAULT_SKIP_IF_EMPTY) {
            builder.put(elementName, (Object)HtmlTagSkipType.SKIP_BY_DEFAULT);
        }
        DEFAULT_SKIP_TAG_MAP_IF_EMPTY_ATTR = Collections.unmodifiableMap(builder);
        DEFAULT_RELS_ON_TARGETTED_LINKS = Java8Shim.j8().listOf("noopener", "noreferrer");
        DEFAULT_RELS_ON_TARGETTED_LINKS_STR = DEFAULT_RELS_ON_TARGETTED_LINKS.stream().collect(Collectors.joining(" "));
        METADATA = HtmlElementTables.get();
        builder = new HashMap();
        AttributeGuardMaker identityGuard = new AttributeGuardMaker(){

            @Override
            AttributePolicy makeGuard(AttributeGuardIntermediates intermediates) {
                return intermediates.urlAttributePolicy;
            }
        };
        for (String urlAttributeName : new String[]{"action", "archive", "background", "cite", "classid", "codebase", "data", "dsync", "formaction", "href", "icon", "longdesc", "manifest", "poster", "profile", "src", "usemap"}) {
            builder.put(urlAttributeName, identityGuard);
        }
        builder.put("style", new AttributeGuardMaker(){

            @Override
            AttributePolicy makeGuard(AttributeGuardIntermediates intermediates) {
                if (intermediates.cssSchema == null) {
                    return null;
                }
                final AttributePolicy styleUrlPolicyFinal = AttributePolicy.Util.join(intermediates.styleUrlPolicy, intermediates.urlAttributePolicy);
                return new StylingPolicy(intermediates.cssSchema, new Function<String, String>(){

                    @Override
                    public String apply(String url) {
                        return styleUrlPolicyFinal.apply("img", "src", url != null ? url : "about:invalid");
                    }
                });
            }
        });
        builder.put("srcset", new AttributeGuardMaker(){

            @Override
            AttributePolicy makeGuard(AttributeGuardIntermediates intermediates) {
                return new SrcsetAttributePolicy(intermediates.urlAttributePolicy);
            }
        });
        ATTRIBUTE_GUARDS = Collections.unmodifiableMap(builder);
    }

    static final class JoinRelsOnLinksPolicies
    implements Joinable.JoinStrategy<ElementPolicy.JoinableElementPolicy> {
        static final JoinRelsOnLinksPolicies INSTANCE = new JoinRelsOnLinksPolicies();

        JoinRelsOnLinksPolicies() {
        }

        @Override
        public ElementPolicy.JoinableElementPolicy join(Iterable<? extends ElementPolicy.JoinableElementPolicy> toJoin) {
            HashSet<String> extra = new HashSet<String>();
            HashSet<String> skip = new HashSet<String>();
            for (ElementPolicy.JoinableElementPolicy joinableElementPolicy : toJoin) {
                RelsOnLinksPolicy p2 = (RelsOnLinksPolicy)joinableElementPolicy;
                extra.addAll(p2.extra);
                skip.addAll(p2.skip);
            }
            extra.removeAll(skip);
            return RelsOnLinksPolicy.create(extra, skip);
        }
    }

    private static final class RelsOnLinksPolicy
    implements ElementPolicy.JoinableElementPolicy {
        final Set<String> extra;
        final Set<String> skip;
        final List<String> whenTargetPresent;
        static final RelsOnLinksPolicy EMPTY = new RelsOnLinksPolicy(Java8Shim.j8().setOf(), Java8Shim.j8().setOf());

        static RelsOnLinksPolicy create(Set<? extends String> extra, Set<? extends String> skip) {
            if (extra.isEmpty() && skip.isEmpty()) {
                return EMPTY;
            }
            return new RelsOnLinksPolicy(extra, skip);
        }

        RelsOnLinksPolicy(Set<? extends String> extra, Set<? extends String> skip) {
            this.extra = Java8Shim.j8().setCopyOf(extra);
            this.skip = Java8Shim.j8().setCopyOf(skip);
            HashSet<String> targetOnly = new HashSet<String>();
            targetOnly.addAll(DEFAULT_RELS_ON_TARGETTED_LINKS);
            targetOnly.removeAll(extra);
            targetOnly.removeAll(skip);
            this.whenTargetPresent = Java8Shim.j8().listCopyOf(targetOnly);
        }

        private static int indexOfAttributeValue(String canonAttrName, List<String> attrs) {
            int n = attrs.size();
            for (int i = 0; i < n; i += 2) {
                if (!canonAttrName.equals(attrs.get(i))) continue;
                return i + 1;
            }
            return -1;
        }

        @Override
        public String apply(String elementName, List<String> attrs) {
            if (RelsOnLinksPolicy.indexOfAttributeValue("href", attrs) >= 0) {
                boolean hasTarget;
                boolean bl = hasTarget = RelsOnLinksPolicy.indexOfAttributeValue("target", attrs) >= 0;
                if (hasTarget || !this.extra.isEmpty()) {
                    String relValue;
                    int relIndex = RelsOnLinksPolicy.indexOfAttributeValue("rel", attrs);
                    if (relIndex < 0 && hasTarget && this.extra.isEmpty() && this.skip.isEmpty()) {
                        relValue = DEFAULT_RELS_ON_TARGETTED_LINKS_STR;
                    } else {
                        int sblen;
                        StringBuilder sb = new StringBuilder();
                        HashSet<String> present = new HashSet<String>();
                        if (relIndex >= 0) {
                            Iterator<String> rels = attrs.get(relIndex);
                            int left = 0;
                            int n = ((String)((Object)rels)).length();
                            for (int i = 0; i <= n; ++i) {
                                if (i != n && !Strings.isHtmlSpace(((String)((Object)rels)).charAt(i))) continue;
                                if (left < i) {
                                    String rel = ((String)((Object)rels)).substring(left, i);
                                    String lowerCaseRel = Strings.toLowerCase(rel);
                                    if (!(!this.skip.isEmpty() && this.skip.contains(lowerCaseRel) || present.contains(lowerCaseRel))) {
                                        present.add(lowerCaseRel);
                                        sb.append(lowerCaseRel).append(' ');
                                    }
                                }
                                left = i + 1;
                            }
                        }
                        for (String s : this.extra) {
                            if (present.contains(s)) continue;
                            sb.append(s).append(' ');
                            present.add(s);
                        }
                        if (hasTarget) {
                            for (String s : this.whenTargetPresent) {
                                if (present.contains(s)) continue;
                                sb.append(s).append(' ');
                                present.add(s);
                            }
                        }
                        relValue = (sblen = sb.length()) == 0 ? "" : sb.substring(0, sb.length() - 1);
                    }
                    if (relValue.isEmpty()) {
                        if (relIndex >= 0) {
                            attrs.subList(relIndex - 1, relIndex + 1).clear();
                        }
                    } else if (relIndex < 0) {
                        attrs.add("rel");
                        attrs.add(relValue);
                    } else {
                        attrs.set(relIndex, relValue);
                    }
                }
            }
            return elementName;
        }

        @Override
        public Joinable.JoinStrategy<ElementPolicy.JoinableElementPolicy> getJoinStrategy() {
            return JoinRelsOnLinksPolicies.INSTANCE;
        }
    }

    public final class AttributeBuilder {
        private final List<String> attributeNames;
        private AttributePolicy policy = AttributePolicy.IDENTITY_ATTRIBUTE_POLICY;

        AttributeBuilder(List<? extends String> attributeNames) {
            this.attributeNames = Java8Shim.j8().listCopyOf(attributeNames);
        }

        public AttributeBuilder matching(AttributePolicy attrPolicy) {
            this.policy = AttributePolicy.Util.join(this.policy, attrPolicy);
            return this;
        }

        public AttributeBuilder matching(final Pattern pattern) {
            return this.matching(new AttributePolicy(){

                @Override
                @Nullable
                public String apply(String elementName, String attributeName, String value2) {
                    return pattern.matcher(value2).matches() ? value2 : null;
                }
            });
        }

        public AttributeBuilder matching(final Predicate<? super String> filter2) {
            return this.matching(new AttributePolicy(){

                @Override
                @Nullable
                public String apply(String elementName, String attributeName, String value2) {
                    return filter2.test(value2) ? value2 : null;
                }
            });
        }

        public AttributeBuilder matching(boolean ignoreCase, String ... allowedValues) {
            return this.matching(ignoreCase, Java8Shim.j8().setOf((T[])allowedValues));
        }

        public AttributeBuilder matching(final boolean ignoreCase, Set<? extends String> allowedValues) {
            final Set<? extends String> allowed = Java8Shim.j8().setCopyOf(allowedValues);
            return this.matching(new AttributePolicy(){

                @Override
                @Nullable
                public String apply(String elementName, String attributeName, String uncanonValue) {
                    String value2 = ignoreCase ? Strings.toLowerCase(uncanonValue) : uncanonValue;
                    return allowed.contains(value2) ? value2 : null;
                }
            });
        }

        public HtmlPolicyBuilder globally() {
            if (this.attributeNames.contains("style")) {
                HtmlPolicyBuilder.this.allowStyling();
            }
            return HtmlPolicyBuilder.this.allowAttributesGlobally(this.policy, this.attributeNames);
        }

        public HtmlPolicyBuilder onElements(String ... elementNames2) {
            ArrayList<String> builder = new ArrayList<String>();
            for (String elementName : elementNames2) {
                builder.add(HtmlLexer.canonicalElementName(elementName));
            }
            return HtmlPolicyBuilder.this.allowAttributesOnElements(this.policy, this.attributeNames, Collections.unmodifiableList(builder));
        }
    }

    private static final class CompiledState {
        final Map<String, AttributePolicy> globalAttrPolicies;
        final Map<String, ElementAndAttributePolicies> compiledPolicies;

        CompiledState(Map<String, AttributePolicy> globalAttrPolicies, Map<String, ElementAndAttributePolicies> compiledPolicies) {
            this.globalAttrPolicies = globalAttrPolicies;
            this.compiledPolicies = compiledPolicies;
        }
    }
}

