/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.owasp.html.AttributePolicy;

@Immutable
final class JoinedAttributePolicy
implements AttributePolicy {
    final List<AttributePolicy> policies;

    JoinedAttributePolicy(Collection<? extends AttributePolicy> policies) {
        this.policies = Collections.unmodifiableList(policies.stream().collect(Collectors.toList()));
    }

    @Override
    @Nullable
    public String apply(String elementName, String attributeName, @Nullable String rawValue) {
        String value2 = rawValue;
        for (AttributePolicy p2 : this.policies) {
            if (value2 == null) break;
            value2 = p2.apply(elementName, attributeName, value2);
        }
        return value2;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.policies.equals(((JoinedAttributePolicy)o).policies);
    }

    public int hashCode() {
        return this.policies.hashCode();
    }
}

