/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import org.owasp.html.AttributePolicy;
import org.owasp.html.Strings;

final class SrcsetAttributePolicy
implements AttributePolicy {
    private final AttributePolicy srcPolicy;

    SrcsetAttributePolicy(AttributePolicy srcPolicy) {
        this.srcPolicy = srcPolicy;
    }

    @Override
    public String apply(String elementName, String attributeName, String value2) {
        int i;
        StringBuilder sb = new StringBuilder();
        int n = value2.length();
        for (i = 0; i < n && Strings.isHtmlSpace(value2.charAt(i)); ++i) {
        }
        while (i < n) {
            int ch;
            int floatEnd;
            int urlStart = i;
            while (i < n && !Strings.isHtmlSpace(value2.charAt(i))) {
                ++i;
            }
            int urlEnd = i;
            while (i < n && Strings.isHtmlSpace(value2.charAt(i))) {
                ++i;
            }
            int metadataStart = i;
            if (urlEnd >= i || (floatEnd = Strings.skipValidFloatingPointNumber(value2, i)) < 0 || (i = floatEnd) >= n || 97 > (ch = value2.charAt(i) | 0x20) || ch <= 122) {
                // empty if block
            }
            int metadataEnd = ++i;
            if (urlStart < urlEnd) {
                if (value2.charAt(urlStart) == ',' || value2.charAt(urlEnd - 1) == ',') {
                    return null;
                }
                String okUrl = this.srcPolicy.apply(elementName, "src", value2.substring(urlStart, urlEnd));
                if (okUrl != null && !okUrl.isEmpty()) {
                    if (sb.length() != 0) {
                        sb.append(" , ");
                    }
                    sb.append(okUrl.replace(",", "%2c"));
                    if (metadataStart < metadataEnd) {
                        sb.append(' ');
                        sb.append(value2, metadataStart, metadataEnd);
                    }
                }
            }
            while (i < n && Strings.isHtmlSpace(value2.charAt(i))) {
                ++i;
            }
            if (i == n || value2.charAt(i) != ',') break;
            ++i;
            while (i < n && Strings.isHtmlSpace(value2.charAt(i))) {
                ++i;
            }
        }
        if (i < n || sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }
}

