/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import config.Config;
import datastructures.stdcollections.IterablesKt;
import datastructures.stdcollections.ListsKt;
import datastructures.stdcollections.SetsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import log.Logger;
import log.LoggerTypes;
import org.jetbrains.annotations.NotNull;
import spec.CalculateMethodParamFilters;
import spec.cvlast.CVLAst;
import spec.cvlast.CVLInvariant;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLRuleAndMethodChoiceValidationKt;
import spec.cvlast.ContractFunction;
import spec.cvlast.DistanceToName;
import spec.cvlast.IRule;
import spec.cvlast.UseDeclaration;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.NoSuchMethodChoice;
import utils.CollectingResult;
import utils.HasKSerializable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001af\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\t\u001a\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004\u001a2\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\b\u0012\u0004\u0012\u00020\u0015`\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u0004\u001a$\u0010\u001b\u001a\u0018\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\b\u0012\u0004\u0012\u00020\u0015`\u00162\u0006\u0010\u001c\u001a\u00020\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"logger", "Llog/Logger;", "getClosestStrings", "", "", "illegalWord", "legalWords", "distanceFunc", "Lkotlin/Function2;", "", "maxDist", "maxDistRatio", "", "maxSuggestions", "maxDelta", "inputStringDistance", "_input_str", "_dict_str", "validateMethodChoices", "Lutils/CollectingResult;", "", "Lspec/cvlast/typechecker/CVLError;", "Lutils/VoidResult;", "knownFunctions", "", "Lspec/cvlast/ContractFunction;", "mainContract", "validateRuleChoices", "cvlAst", "Lspec/cvlast/CVLAst;", "Shared"})
@SourceDebugExtension(value={"SMAP\nCVLRuleAndMethodChoiceValidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CVLRuleAndMethodChoiceValidation.kt\nspec/cvlast/CVLRuleAndMethodChoiceValidationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ExtStdlib.kt\nutils/ExtStdlibKt\n+ 4 Iterables.kt\ndatastructures/stdcollections/IterablesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n766#2:212\n857#2,2:213\n766#2:215\n857#2,2:216\n1549#2:223\n1620#2,3:224\n1549#2:227\n1620#2,3:228\n1549#2:231\n1620#2,3:232\n1360#2:236\n1446#2,5:237\n514#3:218\n38#4,4:219\n1#5:235\n*S KotlinDebug\n*F\n+ 1 CVLRuleAndMethodChoiceValidation.kt\nspec/cvlast/CVLRuleAndMethodChoiceValidationKt\n*L\n29#1:212\n29#1:213,2\n30#1:215\n30#1:216,2\n33#1:223\n33#1:224,3\n56#1:227\n56#1:228,3\n57#1:231\n57#1:232,3\n68#1:236\n68#1:237,5\n31#1:218\n31#1:219,4\n*E\n"})
public final class CVLRuleAndMethodChoiceValidationKt {
    @NotNull
    private static final Logger logger = Logger.Companion.invoke(LoggerTypes.SPEC);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CollectingResult<Unit, CVLError> validateMethodChoices(@NotNull List<ContractFunction> knownFunctions, @NotNull String mainContract) {
        void $this$map$iv;
        String it$iv;
        void $this$mapTo$iv$iv;
        ContractFunction it2;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(knownFunctions, "knownFunctions");
        Intrinsics.checkNotNullParameter(mainContract, "mainContract");
        if (Config.INSTANCE.getMethodChoices() == null) {
            return CollectingResult.Companion.getOk();
        }
        Iterable $this$filter$iv = knownFunctions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (ContractFunction)element$iv$iv;
            boolean bl = false;
            if (!(!ListsKt.listOf("constructor", "certorafallback_0").contains(it2.getMethodSignature().getFunctionName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (ContractFunction)element$iv$iv;
            boolean bl = false;
            if (!it2.isPublicMethod()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapToSet$iv = (List)destination$iv$iv;
        boolean $i$f$mapToSet = false;
        $this$filterTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = SetsKt.mutableSetOf();
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = item$iv$iv;
            Collection bl = destination$iv$iv;
            boolean bl2 = false;
            ContractFunction it3 = (ContractFunction)((Object)it$iv);
            boolean bl3 = false;
            bl.add(it3.getMethodInfo().toExternalABINameWithContract());
        }
        Set relevantFunctions = (Set)destination$iv$iv;
        Set<String> set2 = Config.INSTANCE.getMethodChoices();
        Intrinsics.checkNotNull(set2);
        $this$mapToSet$iv = set2;
        CollectingResult.Companion companion = CollectingResult.Companion;
        boolean $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CollectingResult collectingResult;
            void methodChoice;
            it$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair<String, String> pair2 = CalculateMethodParamFilters.Companion.splitToContractAndMethod((String)methodChoice, mainContract);
            String contract = pair2.component1();
            String method = pair2.component2();
            boolean found = CalculateMethodParamFilters.Companion.containsMethod(relevantFunctions, method, contract, mainContract);
            if (found) {
                collectingResult = CollectingResult.Companion.getOk();
            } else {
                Set suggestions = CVLRuleAndMethodChoiceValidationKt.getClosestStrings$default(contract + "." + method, relevantFunctions, null, 0, 0.0, 0, 0, 124, null);
                collectingResult = CollectingResult.Companion.asError(new NoSuchMethodChoice((String)methodChoice, suggestions));
            }
            collection.add(collectingResult);
        }
        return companion.flattenToVoid((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CollectingResult<Unit, CVLError> validateRuleChoices(@NotNull CVLAst cvlAst2) {
        Set<String> unknownRules;
        Set<String> set2;
        Collection<Object> collection;
        HasKSerializable it2;
        Set set3;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(cvlAst2, "cvlAst");
        Iterable $this$map$iv = cvlAst2.getRules();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection<Object> destination$iv$iv = (Set)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10)));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IRule iRule = (IRule)item$iv$iv;
            set3 = destination$iv$iv;
            boolean bl = false;
            set3.add(((IRule)it2).getDeclarationId());
        }
        $this$map$iv = cvlAst2.getInvs();
        set3 = IterablesKt.toSet((List)destination$iv$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (CVLInvariant)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((CVLInvariant)it2).getId());
        }
        $this$map$iv = cvlAst2.getUseDeclarations().getBuiltInRulesInUse();
        set3 = SetsKt.plus(set3, IterablesKt.toSet((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (UseDeclaration.BuiltInRule)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((UseDeclaration.BuiltInRule)it2).getId());
        }
        Set<String> allRules = SetsKt.plus(set3, (List)destination$iv$iv);
        HashSet<String> hashSet = Config.INSTANCE.getNonPatternRuleChoices();
        if (hashSet != null) {
            HashSet<String> it3 = hashSet;
            boolean bl = false;
            set2 = SetsKt.minus((Set)it3, (Iterable)allRules);
        } else {
            set2 = null;
        }
        Set<String> set4 = unknownRules = set2;
        boolean bl = set4 != null ? !((Collection)set4).isEmpty() : false;
        if (bl) {
            void $this$flatMapTo$iv$iv;
            logger.info((Function0<? extends Object>)new Function0<Object>(unknownRules, allRules){
                final /* synthetic */ Set<String> $unknownRules;
                final /* synthetic */ Set<String> $allRules;
                {
                    this.$unknownRules = $unknownRules;
                    this.$allRules = $allRules;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Could not find rules: " + this.$unknownRules + ". Starting to offer replacement rules names. All rule names are " + this.$allRules;
                }
            });
            String errStr = "The rules: " + unknownRules + " were not found in any of the specification files.";
            Iterable $this$flatMap$iv = unknownRules;
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                String it4 = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = CVLRuleAndMethodChoiceValidationKt.getClosestStrings$default(it4, allRules, null, 0, 0.0, 0, 0, 124, null);
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            List allSuggestions = (List)destination$iv$iv2;
            if (allSuggestions.size() == 1) {
                errStr = errStr + " Did you mean rule " + allSuggestions.get(0) + "?";
            } else if (allSuggestions.size() >= 2) {
                errStr = errStr + " Did you mean rule " + allSuggestions.get(0) + " or " + allSuggestions.get(1) + "?";
            }
            return CollectingResult.Companion.asError(new CVLError.General(new CVLRange.Empty(null, 1, null), errStr));
        }
        Set<String> ruleChoices = Config.INSTANCE.getRuleChoices(allRules);
        if (!((Collection)allRules).isEmpty() && ruleChoices.isEmpty()) {
            return CollectingResult.Companion.asError(new CVLError.General(new CVLRange.Empty(null, 1, null), "the '--rule' and '--exclude_rule' patterns filtered out all rules"));
        }
        return CollectingResult.Companion.getOk();
    }

    @NotNull
    public static final Set<String> getClosestStrings(@NotNull String illegalWord, @NotNull Set<String> legalWords, @NotNull Function2<? super String, ? super String, Integer> distanceFunc, int maxDist, double maxDistRatio, int maxSuggestions, int maxDelta) {
        DistanceToName currentTuple;
        int currDist;
        Intrinsics.checkNotNullParameter(illegalWord, "illegalWord");
        Intrinsics.checkNotNullParameter(legalWords, "legalWords");
        Intrinsics.checkNotNullParameter(distanceFunc, "distanceFunc");
        Comparator compareByDistance = CVLRuleAndMethodChoiceValidationKt::getClosestStrings$lambda$9;
        PriorityQueue<DistanceToName> distanceQueue = new PriorityQueue<DistanceToName>(compareByDistance);
        for (String legalWord : legalWords) {
            int distance = ((Number)distanceFunc.invoke(illegalWord, legalWord)).intValue();
            distanceQueue.add(new DistanceToName(distance, legalWord));
        }
        Set<String> allSuggestions = SetsKt.mutableSetOf();
        int lastDist = Integer.MAX_VALUE;
        while (!distanceQueue.isEmpty() && allSuggestions.size() <= maxSuggestions && (currDist = (currentTuple = (DistanceToName)distanceQueue.poll()).getDistance()) <= maxDist && !((double)currDist / ((double)illegalWord.length() * 10.0) > maxDistRatio)) {
            if (lastDist != Integer.MAX_VALUE && Math.abs(currDist - lastDist) > maxDelta) continue;
            allSuggestions.add(currentTuple.getName());
            lastDist = currDist;
        }
        return allSuggestions;
    }

    public static /* synthetic */ Set getClosestStrings$default(String string, Set set2, Function2 function2, int n, double d2, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            function2 = getClosestStrings.1.INSTANCE;
        }
        if ((n4 & 8) != 0) {
            n = 40;
        }
        if ((n4 & 0x10) != 0) {
            d2 = 0.5;
        }
        if ((n4 & 0x20) != 0) {
            n2 = 2;
        }
        if ((n4 & 0x40) != 0) {
            n3 = 2;
        }
        return CVLRuleAndMethodChoiceValidationKt.getClosestStrings(string, set2, function2, n, d2, n2, n3);
    }

    public static final int inputStringDistance(@NotNull String _input_str, @NotNull String _dict_str) {
        int row;
        Intrinsics.checkNotNullParameter(_input_str, "_input_str");
        Intrinsics.checkNotNullParameter(_dict_str, "_dict_str");
        String string = _input_str.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String inputStr = string;
        String string2 = _dict_str.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String dictStr = string2;
        if (Intrinsics.areEqual(inputStr, dictStr)) {
            return 0;
        }
        if (StringsKt.startsWith$default(inputStr, dictStr, false, 2, null) || StringsKt.startsWith$default(dictStr, inputStr, false, 2, null)) {
            return Math.abs(dictStr.length() - inputStr.length());
        }
        int numRows = inputStr.length() + 1;
        int numCols = dictStr.length() + 1;
        int n = 0;
        int[][] nArrayArray = new int[numRows][];
        while (n < numRows) {
            int n2 = n++;
            nArrayArray[n2] = new int[numCols];
        }
        int[][] distanceMatrix = nArrayArray;
        for (row = 1; row < numRows; ++row) {
            distanceMatrix[row][0] = row;
        }
        for (int col = 1; col < numCols; ++col) {
            distanceMatrix[0][col] = col;
        }
        for (row = 1; row < numRows; ++row) {
            for (int col = 1; col < numCols; ++col) {
                char dictChar;
                char inputChar = inputStr.charAt(row - 1);
                int cost = inputChar == (dictChar = dictStr.charAt(col - 1)) ? 0 : (inputChar == '_' || dictChar == '_' ? 1 : 10);
                distanceMatrix[row][col] = cost + Math.min(distanceMatrix[row - 1][col], Math.min(distanceMatrix[row][col - 1], distanceMatrix[row - 1][col - 1]));
            }
        }
        return distanceMatrix[numRows - 1][numCols - 1];
    }

    private static final int getClosestStrings$lambda$9(DistanceToName t12, DistanceToName t22) {
        Intrinsics.checkNotNullParameter(t12, "t1");
        Intrinsics.checkNotNullParameter(t22, "t2");
        return t12.getDistance() - t22.getDistance();
    }
}

