/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.typechecker;

import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLType;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.CVLErrorCategory;
import spec.cvlast.typechecker.CVLErrorExample;
import spec.cvlast.typechecker.CVLErrorType;
import spec.cvlast.typechecker.NonBoolExpression$;

@Serializable
@CVLErrorType(category=CVLErrorCategory.TYPECHECKING, description="Certain expressions must have a boolean type")
@CVLErrorExample.Container(value={@CVLErrorExample(exampleCVLWithRange="\n    function returnsVoid() {\n        return;\n    }\n    function f {\n        assert #returnsVoid()#;\n    }\n    ", exampleMessage="Assert command must have type `bool`, got `void`"), @CVLErrorExample(exampleCVLWithRange="\n    function f {\n        bool b = forall uint8 x. #3#;\n    }\n    ", exampleMessage="The body of quantified expression must have type `bool`, got `3`"), @CVLErrorExample(exampleCVLWithRange="\n    ghost uint8 byteGhost;\n    function f {\n        havoc byteGhost assuming #\"not boolean\"#;\n    }\n    ", exampleMessage="Assuming expression of Havoc command must have type `bool`, got `string`"), @CVLErrorExample(exampleCVLWithRange="\n        function f {\n            uint x;\n            if (#x#) {\n                return;\n            }\n        }\n    ", exampleMessage="If condition must have type `bool`, got `uint256`")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 #2\u00020\u0001:\u0003\"#$B7\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u00c1\u0001\u00a2\u0006\u0002\b!R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lspec/cvlast/typechecker/NonBoolExpression;", "Lspec/cvlast/typechecker/CVLError;", "seen1", "", "exp", "Lspec/cvlast/CVLExp;", "kind", "Lspec/cvlast/typechecker/NonBoolExpression$Kind;", "actualType", "Lspec/cvlast/CVLType;", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILspec/cvlast/CVLExp;Lspec/cvlast/typechecker/NonBoolExpression$Kind;Lspec/cvlast/CVLType;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lspec/cvlast/CVLExp;Lspec/cvlast/typechecker/NonBoolExpression$Kind;)V", "getExp", "()Lspec/cvlast/CVLExp;", "getKind", "()Lspec/cvlast/typechecker/NonBoolExpression$Kind;", "location", "Lspec/cvlast/CVLRange;", "getLocation", "()Lspec/cvlast/CVLRange;", "message", "", "getMessage", "()Ljava/lang/String;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$Shared", "$serializer", "Companion", "Kind", "Shared"})
public final class NonBoolExpression
extends CVLError {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CVLExp exp;
    @NotNull
    private final Kind kind;
    @NotNull
    private final CVLType actualType;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    public NonBoolExpression(@NotNull CVLExp exp, @NotNull Kind kind) {
        Intrinsics.checkNotNullParameter(exp, "exp");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        super(null);
        this.exp = exp;
        this.kind = kind;
        this.actualType = this.exp.getCVLType();
    }

    @NotNull
    public final CVLExp getExp() {
        return this.exp;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public CVLRange getLocation() {
        return this.exp.getRangeOrEmpty();
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.kind.getDescription() + " must have type `bool`, got `" + this.actualType + "`";
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$Shared(NonBoolExpression self, CompositeEncoder output, SerialDescriptor serialDesc) {
        CVLError.write$Self(self, output, serialDesc);
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.exp);
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)kSerializerArray[1], self.kind);
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : !Intrinsics.areEqual(self.actualType, self.exp.getCVLType())) {
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)kSerializerArray[2], self.actualType);
        }
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ NonBoolExpression(int seen1, CVLExp exp, Kind kind, CVLType actualType, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException(seen1, 3, $serializer.INSTANCE.getDescriptor());
        }
        super(seen1, serializationConstructorMarker);
        this.exp = exp;
        this.kind = kind;
        this.actualType = (seen1 & 4) == 0 ? this.exp.getCVLType() : actualType;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{CVLExp.Companion.serializer(), EnumsKt.createSimpleEnumSerializer((String)"spec.cvlast.typechecker.NonBoolExpression.Kind", (Enum[])Kind.values()), CVLType.Companion.serializer()};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lspec/cvlast/typechecker/NonBoolExpression$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lspec/cvlast/typechecker/NonBoolExpression;", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<NonBoolExpression> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lspec/cvlast/typechecker/NonBoolExpression$Kind;", "", "description", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "ASSUME_CMD", "ASSERT_CMD", "SATISFY_CMD", "QUANTIFIER_BODY", "ASSUMING_EXPR_OF_HAVOC", "IF_COND", "Shared"})
    public static final class Kind
    extends Enum<Kind> {
        @NotNull
        private final String description;
        public static final /* enum */ Kind ASSUME_CMD = new Kind("Require command");
        public static final /* enum */ Kind ASSERT_CMD = new Kind("Assert command");
        public static final /* enum */ Kind SATISFY_CMD = new Kind("Satisfy command");
        public static final /* enum */ Kind QUANTIFIER_BODY = new Kind("The body of quantified expression");
        public static final /* enum */ Kind ASSUMING_EXPR_OF_HAVOC = new Kind("Assuming expression of Havoc command");
        public static final /* enum */ Kind IF_COND = new Kind("If condition");
        private static final /* synthetic */ Kind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Kind(String description) {
            this.description = description;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value2) {
            return Enum.valueOf(Kind.class, value2);
        }

        @NotNull
        public static EnumEntries<Kind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = kindArray = new Kind[]{Kind.ASSUME_CMD, Kind.ASSERT_CMD, Kind.SATISFY_CMD, Kind.QUANTIFIER_BODY, Kind.ASSUMING_EXPR_OF_HAVOC, Kind.IF_COND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

