from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore

VTK_MAX_SPHERE_TREE_LEVELS:int
VTK_MAX_SPHERE_TREE_RESOLUTION:int
VTK_UPDATE_EXTENT_COMBINE:int
VTK_UPDATE_EXTENT_REPLACE:int

class vtkExecutionAggregator(vtkmodules.vtkCommonCore.vtkObject):
    output_data_object:'getset_descriptor'
    def Aggregate(self, input:'vtkDataObject') -> bool: ...
    def Clear(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputDataObject(self) -> 'vtkDataObject': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExecutionAggregator': ...
    def RequestDataObject(self, input:'vtkDataObject') -> 'vtkDataObject': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExecutionAggregator': ...

class vtkAggregateToPartitionedDataSetCollection(vtkExecutionAggregator):
    output_data_object:'getset_descriptor'
    def Aggregate(self, input:'vtkDataObject') -> bool: ...
    def Clear(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputDataObject(self) -> 'vtkDataObject': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAggregateToPartitionedDataSetCollection': ...
    def RequestDataObject(self, input:'vtkDataObject') -> 'vtkDataObject': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAggregateToPartitionedDataSetCollection': ...

class vtkAlgorithm(vtkmodules.vtkCommonCore.vtkObject):
    class DesiredOutputPrecision(int): ...
    DEFAULT_PRECISION:'DesiredOutputPrecision'
    DOUBLE_PRECISION:'DesiredOutputPrecision'
    SINGLE_PRECISION:'DesiredOutputPrecision'
    abort_execute:'getset_descriptor'
    abort_output:'getset_descriptor'
    container_algorithm:'getset_descriptor'
    default_executive_prototype:'getset_descriptor'
    error_code:'getset_descriptor'
    executive:'getset_descriptor'
    information:'getset_descriptor'
    input_algorithm:'getset_descriptor'
    input_array_to_process:'getset_descriptor'
    input_connection:'getset_descriptor'
    input_data_object:'getset_descriptor'
    input_executive:'getset_descriptor'
    input_information:'getset_descriptor'
    no_prior_temporal_access_information_key:'getset_descriptor'
    number_of_input_ports:'getset_descriptor'
    output_port:'getset_descriptor'
    progress:'getset_descriptor'
    progress_observer:'getset_descriptor'
    progress_scale:'getset_descriptor'
    progress_shift:'getset_descriptor'
    progress_shift_scale:'getset_descriptor'
    progress_text:'getset_descriptor'
    release_data_flag:'getset_descriptor'
    total_number_of_input_connections:'getset_descriptor'
    update_extent:'getset_descriptor'
    update_ghost_level:'getset_descriptor'
    update_number_of_pieces:'getset_descriptor'
    update_piece:'getset_descriptor'
    @staticmethod
    def ABORTED() -> 'vtkInformationIntegerKey': ...
    def AbortExecuteOff(self) -> None: ...
    def AbortExecuteOn(self) -> None: ...
    @overload
    def AddInputConnection(self, port:int, input:'vtkAlgorithmOutput') -> None: ...
    @overload
    def AddInputConnection(self, input:'vtkAlgorithmOutput') -> None: ...
    @overload
    def AddInputDataObject(self, port:int, data:'vtkDataObject') -> None: ...
    @overload
    def AddInputDataObject(self, data:'vtkDataObject') -> None: ...
    @staticmethod
    def CAN_HANDLE_PIECE_REQUEST() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def CAN_PRODUCE_SUB_EXTENT() -> 'vtkInformationIntegerKey': ...
    def CheckAbort(self) -> bool: ...
    def ConvertTotalInputToPortConnection(self, ind:int, port:int, conn:int) -> None: ...
    def GetAbortExecute(self) -> int: ...
    def GetAbortOutput(self) -> bool: ...
    def GetContainerAlgorithm(self) -> 'vtkAlgorithm': ...
    def GetErrorCode(self) -> int: ...
    def GetExecutive(self) -> 'vtkExecutive': ...
    def GetInformation(self) -> 'vtkInformation': ...
    @overload
    def GetInputAlgorithm(self, port:int, index:int, algPort:int) -> 'vtkAlgorithm': ...
    @overload
    def GetInputAlgorithm(self, port:int, index:int) -> 'vtkAlgorithm': ...
    @overload
    def GetInputAlgorithm(self) -> 'vtkAlgorithm': ...
    def GetInputArrayInformation(self, idx:int) -> 'vtkInformation': ...
    def GetInputConnection(self, port:int, index:int) -> 'vtkAlgorithmOutput': ...
    def GetInputDataObject(self, port:int, connection:int) -> 'vtkDataObject': ...
    @overload
    def GetInputExecutive(self, port:int, index:int) -> 'vtkExecutive': ...
    @overload
    def GetInputExecutive(self) -> 'vtkExecutive': ...
    @overload
    def GetInputInformation(self, port:int, index:int) -> 'vtkInformation': ...
    @overload
    def GetInputInformation(self) -> 'vtkInformation': ...
    def GetInputPortInformation(self, port:int) -> 'vtkInformation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfInputConnections(self, port:int) -> int: ...
    def GetNumberOfInputPorts(self) -> int: ...
    def GetNumberOfOutputPorts(self) -> int: ...
    def GetOutputDataObject(self, port:int) -> 'vtkDataObject': ...
    def GetOutputInformation(self, port:int) -> 'vtkInformation': ...
    @overload
    def GetOutputPort(self, index:int) -> 'vtkAlgorithmOutput': ...
    @overload
    def GetOutputPort(self) -> 'vtkAlgorithmOutput': ...
    def GetOutputPortInformation(self, port:int) -> 'vtkInformation': ...
    def GetProgress(self) -> float: ...
    def GetProgressObserver(self) -> 'vtkProgressObserver': ...
    def GetProgressScale(self) -> float: ...
    def GetProgressShift(self) -> float: ...
    def GetProgressText(self) -> str: ...
    def GetReleaseDataFlag(self) -> int: ...
    def GetTotalNumberOfInputConnections(self) -> int: ...
    @overload
    def GetUpdateExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    @overload
    def GetUpdateExtent(self, port:int) -> Tuple[int, int, int, int, int, int]: ...
    @overload
    def GetUpdateExtent(self, x0:int, x1:int, y0:int, y1:int, z0:int, z1:int) -> None: ...
    @overload
    def GetUpdateExtent(self, port:int, x0:int, x1:int, y0:int, y1:int, z0:int, z1:int) -> None: ...
    @overload
    def GetUpdateExtent(self, extent:MutableSequence[int]) -> None: ...
    @overload
    def GetUpdateExtent(self, port:int, extent:MutableSequence[int]) -> None: ...
    @overload
    def GetUpdateGhostLevel(self) -> int: ...
    @overload
    def GetUpdateGhostLevel(self, port:int) -> int: ...
    @overload
    def GetUpdateNumberOfPieces(self) -> int: ...
    @overload
    def GetUpdateNumberOfPieces(self, port:int) -> int: ...
    @overload
    def GetUpdatePiece(self) -> int: ...
    @overload
    def GetUpdatePiece(self, port:int) -> int: ...
    def HasExecutive(self) -> int: ...
    @staticmethod
    def INPUT_ARRAYS_TO_PROCESS() -> 'vtkInformationInformationVectorKey': ...
    @staticmethod
    def INPUT_CONNECTION() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def INPUT_IS_OPTIONAL() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def INPUT_IS_REPEATABLE() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def INPUT_PORT() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def INPUT_REQUIRED_DATA_TYPE() -> 'vtkInformationStringVectorKey': ...
    @staticmethod
    def INPUT_REQUIRED_FIELDS() -> 'vtkInformationInformationVectorKey': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def ModifyRequest(self, request:'vtkInformation', when:int) -> int: ...
    def NewInstance(self) -> 'vtkAlgorithm': ...
    def ProcessRequest(self, request:'vtkInformation', inInfo:'vtkCollection', outInfo:'vtkInformationVector') -> int: ...
    def PropagateUpdateExtent(self) -> None: ...
    def ReleaseDataFlagOff(self) -> None: ...
    def ReleaseDataFlagOn(self) -> None: ...
    def RemoveAllInputConnections(self, port:int) -> None: ...
    def RemoveAllInputs(self) -> None: ...
    @overload
    def RemoveInputConnection(self, port:int, input:'vtkAlgorithmOutput') -> None: ...
    @overload
    def RemoveInputConnection(self, port:int, idx:int) -> None: ...
    def RemoveNoPriorTemporalAccessInformationKey(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAlgorithm': ...
    def SetAbortExecute(self, _arg:int) -> None: ...
    def SetAbortExecuteAndUpdateTime(self) -> None: ...
    def SetAbortOutput(self, _arg:bool) -> None: ...
    def SetContainerAlgorithm(self, containerAlg:'vtkAlgorithm') -> None: ...
    @staticmethod
    def SetDefaultExecutivePrototype(proto:'vtkExecutive') -> None: ...
    def SetExecutive(self, executive:'vtkExecutive') -> None: ...
    def SetInformation(self, __a:'vtkInformation') -> None: ...
    @overload
    def SetInputArrayToProcess(self, idx:int, port:int, connection:int, fieldAssociation:int, name:str) -> None: ...
    @overload
    def SetInputArrayToProcess(self, idx:int, port:int, connection:int, fieldAssociation:int, fieldAttributeType:int) -> None: ...
    @overload
    def SetInputArrayToProcess(self, idx:int, info:'vtkInformation') -> None: ...
    @overload
    def SetInputArrayToProcess(self, idx:int, port:int, connection:int, fieldAssociation:str, attributeTypeorName:str) -> None: ...
    @overload
    def SetInputConnection(self, port:int, input:'vtkAlgorithmOutput') -> None: ...
    @overload
    def SetInputConnection(self, input:'vtkAlgorithmOutput') -> None: ...
    @overload
    def SetInputDataObject(self, port:int, data:'vtkDataObject') -> None: ...
    @overload
    def SetInputDataObject(self, data:'vtkDataObject') -> None: ...
    @overload
    def SetNoPriorTemporalAccessInformationKey(self, key:int) -> None: ...
    @overload
    def SetNoPriorTemporalAccessInformationKey(self) -> None: ...
    def SetProgressObserver(self, __a:'vtkProgressObserver') -> None: ...
    def SetProgressShiftScale(self, shift:float, scale:float) -> None: ...
    def SetProgressText(self, ptext:str) -> None: ...
    def SetReleaseDataFlag(self, __a:int) -> None: ...
    @overload
    def Update(self, port:int) -> None: ...
    @overload
    def Update(self) -> None: ...
    @overload
    def Update(self, port:int, requests:'vtkInformationVector') -> int: ...
    @overload
    def Update(self, requests:'vtkInformation') -> int: ...
    def UpdateDataObject(self) -> None: ...
    def UpdateExtent(self, extents:Sequence[int]) -> int: ...
    @overload
    def UpdateExtentIsEmpty(self, pinfo:'vtkInformation', output:'vtkDataObject') -> int: ...
    @overload
    def UpdateExtentIsEmpty(self, pinfo:'vtkInformation', extentType:int) -> int: ...
    def UpdateInformation(self) -> None: ...
    def UpdatePiece(self, piece:int, numPieces:int, ghostLevels:int, extents:Sequence[int]=...) -> int: ...
    def UpdateProgress(self, amount:float) -> None: ...
    def UpdateTimeStep(self, time:float, piece:int=-1, numPieces:int=1, ghostLevels:int=0, extents:Sequence[int]=...) -> int: ...
    def UpdateWholeExtent(self) -> None: ...
    def UsesGarbageCollector(self) -> bool: ...

class vtkAlgorithmOutput(vtkmodules.vtkCommonCore.vtkObject):
    index:'getset_descriptor'
    producer:'getset_descriptor'
    def GetIndex(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProducer(self) -> 'vtkAlgorithm': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAlgorithmOutput': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAlgorithmOutput': ...
    def SetIndex(self, index:int) -> None: ...
    def SetProducer(self, producer:'vtkAlgorithm') -> None: ...

class vtkAnnotationLayersAlgorithm(vtkAlgorithm):
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkAnnotationLayers': ...
    @overload
    def GetOutput(self, index:int) -> 'vtkAnnotationLayers': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAnnotationLayersAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAnnotationLayersAlgorithm': ...
    @overload
    def SetInputData(self, obj:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, index:int, obj:'vtkDataObject') -> None: ...

class vtkArrayDataAlgorithm(vtkAlgorithm):
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkArrayData': ...
    @overload
    def GetOutput(self, index:int) -> 'vtkArrayData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayDataAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayDataAlgorithm': ...
    @overload
    def SetInputData(self, obj:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, index:int, obj:'vtkDataObject') -> None: ...

class vtkExecutive(vtkmodules.vtkCommonCore.vtkObject):
    AfterForward:int
    BeforeForward:int
    RequestDownstream:int
    RequestUpstream:int
    algorithm:'getset_descriptor'
    number_of_input_ports:'getset_descriptor'
    number_of_output_ports:'getset_descriptor'
    output_information:'getset_descriptor'
    shared_output_information:'getset_descriptor'
    @staticmethod
    def ALGORITHM_AFTER_FORWARD() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def ALGORITHM_BEFORE_FORWARD() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def ALGORITHM_DIRECTION() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def CONSUMERS() -> 'vtkInformationExecutivePortVectorKey': ...
    @staticmethod
    def FORWARD_DIRECTION() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def FROM_OUTPUT_PORT() -> 'vtkInformationIntegerKey': ...
    def GetAlgorithm(self) -> 'vtkAlgorithm': ...
    def GetInputData(self, port:int, connection:int) -> 'vtkDataObject': ...
    def GetInputExecutive(self, port:int, connection:int) -> 'vtkExecutive': ...
    @overload
    def GetInputInformation(self, port:int, connection:int) -> 'vtkInformation': ...
    @overload
    def GetInputInformation(self, port:int) -> 'vtkInformationVector': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfInputConnections(self, port:int) -> int: ...
    def GetNumberOfInputPorts(self) -> int: ...
    def GetNumberOfOutputPorts(self) -> int: ...
    def GetOutputData(self, port:int) -> 'vtkDataObject': ...
    @overload
    def GetOutputInformation(self, port:int) -> 'vtkInformation': ...
    @overload
    def GetOutputInformation(self) -> 'vtkInformationVector': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def KEYS_TO_COPY() -> 'vtkInformationKeyVectorKey': ...
    def NewInstance(self) -> 'vtkExecutive': ...
    @staticmethod
    def PRODUCER() -> 'vtkInformationExecutivePortKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExecutive': ...
    @overload
    def SetOutputData(self, port:int, __b:'vtkDataObject', info:'vtkInformation') -> None: ...
    @overload
    def SetOutputData(self, port:int, __b:'vtkDataObject') -> None: ...
    def SetSharedOutputInformation(self, outInfoVec:'vtkInformationVector') -> None: ...
    @overload
    def Update(self) -> int: ...
    @overload
    def Update(self, port:int) -> int: ...
    def UpdateInformation(self) -> int: ...
    def UsesGarbageCollector(self) -> bool: ...

class vtkDemandDrivenPipeline(vtkExecutive):
    pipeline_m_time:'getset_descriptor'
    @staticmethod
    def DATA_NOT_GENERATED() -> 'vtkInformationIntegerKey': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPipelineMTime(self) -> int: ...
    def GetReleaseDataFlag(self, port:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def NewDataObject(type:str) -> 'vtkDataObject': ...
    def NewInstance(self) -> 'vtkDemandDrivenPipeline': ...
    @staticmethod
    def RELEASE_DATA() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def REQUEST_DATA() -> 'vtkInformationRequestKey': ...
    @staticmethod
    def REQUEST_DATA_NOT_GENERATED() -> 'vtkInformationRequestKey': ...
    @staticmethod
    def REQUEST_DATA_OBJECT() -> 'vtkInformationRequestKey': ...
    @staticmethod
    def REQUEST_INFORMATION() -> 'vtkInformationRequestKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDemandDrivenPipeline': ...
    def SetReleaseDataFlag(self, port:int, n:int) -> int: ...
    @overload
    def Update(self) -> int: ...
    @overload
    def Update(self, port:int) -> int: ...
    def UpdateData(self, outputPort:int) -> int: ...
    def UpdateDataObject(self) -> int: ...
    def UpdateInformation(self) -> int: ...
    def UpdatePipelineMTime(self) -> int: ...

class vtkStreamingDemandDrivenPipeline(vtkDemandDrivenPipeline):
    class NO_PRIOR_TEMPORAL_ACCESS_STATES(int): ...
    NO_PRIOR_TEMPORAL_ACCESS_CONTINUE:'NO_PRIOR_TEMPORAL_ACCESS_STATES'
    NO_PRIOR_TEMPORAL_ACCESS_RESET:'NO_PRIOR_TEMPORAL_ACCESS_STATES'
    @staticmethod
    def BOUNDS() -> 'vtkInformationDoubleVectorKey': ...
    @staticmethod
    def COMBINED_UPDATE_EXTENT() -> 'vtkInformationIntegerVectorKey': ...
    @staticmethod
    def CONTINUE_EXECUTING() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def EXACT_EXTENT() -> 'vtkInformationIntegerKey': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRequestExactExtent(self, port:int) -> int: ...
    @overload
    @staticmethod
    def GetUpdateExtent(__a:'vtkInformation', extent:MutableSequence[int]) -> None: ...
    @overload
    @staticmethod
    def GetUpdateExtent(__a:'vtkInformation') -> Pointer: ...
    @staticmethod
    def GetUpdateGhostLevel(__a:'vtkInformation') -> int: ...
    @staticmethod
    def GetUpdateNumberOfPieces(__a:'vtkInformation') -> int: ...
    @staticmethod
    def GetUpdatePiece(__a:'vtkInformation') -> int: ...
    @overload
    @staticmethod
    def GetWholeExtent(__a:'vtkInformation', extent:MutableSequence[int]) -> None: ...
    @overload
    @staticmethod
    def GetWholeExtent(__a:'vtkInformation') -> Tuple[int, int, int, int, int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def NO_PRIOR_TEMPORAL_ACCESS() -> 'vtkInformationIntegerKey': ...
    def NewInstance(self) -> 'vtkStreamingDemandDrivenPipeline': ...
    def PropagateTime(self, outputPort:int) -> int: ...
    def PropagateUpdateExtent(self, outputPort:int) -> int: ...
    @staticmethod
    def REQUEST_TIME_DEPENDENT_INFORMATION() -> 'vtkInformationRequestKey': ...
    @staticmethod
    def REQUEST_UPDATE_EXTENT() -> 'vtkInformationRequestKey': ...
    @staticmethod
    def REQUEST_UPDATE_TIME() -> 'vtkInformationRequestKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStreamingDemandDrivenPipeline': ...
    def SetRequestExactExtent(self, port:int, flag:int) -> int: ...
    @staticmethod
    def SetWholeExtent(__a:'vtkInformation', extent:MutableSequence[int]) -> int: ...
    @staticmethod
    def TIME_DEPENDENT_INFORMATION() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def TIME_RANGE() -> 'vtkInformationDoubleVectorKey': ...
    @staticmethod
    def TIME_STEPS() -> 'vtkInformationDoubleVectorKey': ...
    @staticmethod
    def UNRESTRICTED_UPDATE_EXTENT() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def UPDATE_EXTENT() -> 'vtkInformationIntegerVectorKey': ...
    @staticmethod
    def UPDATE_EXTENT_INITIALIZED() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def UPDATE_NUMBER_OF_GHOST_LEVELS() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def UPDATE_NUMBER_OF_PIECES() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def UPDATE_PIECE_NUMBER() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def UPDATE_TIME_STEP() -> 'vtkInformationDoubleKey': ...
    @overload
    def Update(self) -> int: ...
    @overload
    def Update(self, port:int) -> int: ...
    @overload
    def Update(self, port:int, requests:'vtkInformationVector') -> int: ...
    def UpdateTimeDependentInformation(self, outputPort:int) -> int: ...
    def UpdateWholeExtent(self) -> int: ...
    @staticmethod
    def WHOLE_EXTENT() -> 'vtkInformationIntegerVectorKey': ...

class vtkCachedStreamingDemandDrivenPipeline(vtkStreamingDemandDrivenPipeline):
    cache_size:'getset_descriptor'
    def GetCacheSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCachedStreamingDemandDrivenPipeline': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCachedStreamingDemandDrivenPipeline': ...
    def SetCacheSize(self, size:int) -> None: ...

class vtkDataSetAlgorithm(vtkAlgorithm):
    image_data_output:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    poly_data_output:'getset_descriptor'
    rectilinear_grid_output:'getset_descriptor'
    structured_grid_output:'getset_descriptor'
    structured_points_output:'getset_descriptor'
    unstructured_grid_output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:'vtkDataSet') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataSet') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def GetImageDataOutput(self) -> 'vtkImageData': ...
    def GetInput(self) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkDataSet': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkDataSet': ...
    def GetPolyDataOutput(self) -> 'vtkPolyData': ...
    def GetRectilinearGridOutput(self) -> 'vtkRectilinearGrid': ...
    def GetStructuredGridOutput(self) -> 'vtkStructuredGrid': ...
    def GetStructuredPointsOutput(self) -> 'vtkStructuredPoints': ...
    def GetUnstructuredGridOutput(self) -> 'vtkUnstructuredGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataSetAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:'vtkDataSet') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataSet') -> None: ...

class vtkCastToConcrete(vtkDataSetAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCastToConcrete': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCastToConcrete': ...

class vtkCellGridAlgorithm(vtkAlgorithm):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    @overload
    def GetInput(self, port:int) -> 'vtkDataObject': ...
    @overload
    def GetInputCellAttributeToProcess(self, idx:int, input:'vtkCellGrid') -> 'vtkCellAttribute': ...
    @overload
    def GetInputCellAttributeToProcess(self, idx:int, input:'vtkCellGrid', association:int) -> 'vtkCellAttribute': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkCellGrid': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkCellGrid': ...
    def GetPolyDataInput(self, port:int) -> 'vtkCellGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridAlgorithm': ...
    def SetInputAttributeToProcess(self, idx:int, port:int, connection:int, name:str) -> None: ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def SetOutput(self, d:'vtkDataObject') -> None: ...

class vtkCompositeDataPipeline(vtkStreamingDemandDrivenPipeline):
    @staticmethod
    def BLOCK_AMOUNT_OF_DETAIL() -> 'vtkInformationDoubleKey': ...
    @staticmethod
    def COMPOSITE_DATA_META_DATA() -> 'vtkInformationObjectBaseKey': ...
    def GetCompositeOutputData(self, port:int) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def LOAD_REQUESTED_BLOCKS() -> 'vtkInformationIntegerKey': ...
    def NewInstance(self) -> 'vtkCompositeDataPipeline': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeDataPipeline': ...
    @staticmethod
    def UPDATE_COMPOSITE_INDICES() -> 'vtkInformationIntegerVectorKey': ...

class vtkCompositeDataSetAlgorithm(vtkAlgorithm):
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkCompositeDataSet': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkCompositeDataSet': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeDataSetAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeDataSetAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...

class vtkDataObjectAlgorithm(vtkAlgorithm):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    @overload
    def GetInput(self, port:int) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkDataObject': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkDataObject': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataObjectAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataObjectAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def SetOutput(self, d:'vtkDataObject') -> None: ...

class vtkDirectedGraphAlgorithm(vtkAlgorithm):
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkDirectedGraph': ...
    @overload
    def GetOutput(self, index:int) -> 'vtkDirectedGraph': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDirectedGraphAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDirectedGraphAlgorithm': ...
    @overload
    def SetInputData(self, obj:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, index:int, obj:'vtkDataObject') -> None: ...

class vtkEndFor(vtkDataObjectAlgorithm):
    aggregator:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEndFor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEndFor': ...
    def SetAggregator(self, __a:'vtkExecutionAggregator') -> None: ...

class vtkEnsembleSource(vtkAlgorithm):
    current_member:'getset_descriptor'
    meta_data:'getset_descriptor'
    number_of_members:'getset_descriptor'
    def AddMember(self, __a:'vtkAlgorithm') -> None: ...
    def GetCurrentMember(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfMembers(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def META_DATA() -> 'vtkInformationDataObjectMetaDataKey': ...
    def NewInstance(self) -> 'vtkEnsembleSource': ...
    def RemoveAllMembers(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEnsembleSource': ...
    def SetCurrentMember(self, _arg:int) -> None: ...
    def SetMetaData(self, __a:'vtkTable') -> None: ...
    @staticmethod
    def UPDATE_MEMBER() -> 'vtkInformationIntegerRequestKey': ...

class vtkExecutionRange(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExecutionRange': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExecutionRange': ...
    def Size(self) -> int: ...

class vtkExplicitStructuredGridAlgorithm(vtkAlgorithm):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def GetExplicitStructuredGridInput(self, port:int) -> 'vtkExplicitStructuredGrid': ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    @overload
    def GetInput(self, port:int) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkExplicitStructuredGrid': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkExplicitStructuredGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExplicitStructuredGridAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExplicitStructuredGridAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def SetOutput(self, d:'vtkDataObject') -> None: ...

class vtkExtentRCBPartitioner(vtkmodules.vtkCommonCore.vtkObject):
    duplicate_nodes:'getset_descriptor'
    global_extent:'getset_descriptor'
    num_extents:'getset_descriptor'
    number_of_ghost_layers:'getset_descriptor'
    number_of_partitions:'getset_descriptor'
    def DuplicateNodesOff(self) -> None: ...
    def DuplicateNodesOn(self) -> None: ...
    def GetDuplicateNodes(self) -> int: ...
    def GetNumExtents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfGhostLayers(self) -> int: ...
    def GetPartitionExtent(self, idx:int, ext:MutableSequence[int]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtentRCBPartitioner': ...
    def Partition(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtentRCBPartitioner': ...
    def SetDuplicateNodes(self, _arg:int) -> None: ...
    @overload
    def SetGlobalExtent(self, imin:int, imax:int, jmin:int, jmax:int, kmin:int, kmax:int) -> None: ...
    @overload
    def SetGlobalExtent(self, ext:MutableSequence[int]) -> None: ...
    def SetNumberOfGhostLayers(self, _arg:int) -> None: ...
    def SetNumberOfPartitions(self, N:int) -> None: ...

class vtkExtentSplitter(vtkmodules.vtkCommonCore.vtkObject):
    point_mode:'getset_descriptor'
    @overload
    def AddExtent(self, x0:int, x1:int, y0:int, y1:int, z0:int, z1:int) -> None: ...
    @overload
    def AddExtent(self, extent:MutableSequence[int]) -> None: ...
    @overload
    def AddExtentSource(self, id:int, priority:int, x0:int, x1:int, y0:int, y1:int, z0:int, z1:int) -> None: ...
    @overload
    def AddExtentSource(self, id:int, priority:int, extent:MutableSequence[int]) -> None: ...
    def ComputeSubExtents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSubExtents(self) -> int: ...
    def GetPointMode(self) -> int: ...
    @overload
    def GetSubExtent(self, index:int) -> Tuple[int, int, int, int, int, int]: ...
    @overload
    def GetSubExtent(self, index:int, extent:MutableSequence[int]) -> None: ...
    def GetSubExtentSource(self, index:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtentSplitter': ...
    def PointModeOff(self) -> None: ...
    def PointModeOn(self) -> None: ...
    def RemoveAllExtentSources(self) -> None: ...
    def RemoveExtentSource(self, id:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtentSplitter': ...
    def SetPointMode(self, _arg:int) -> None: ...

class vtkExtentTranslator(vtkmodules.vtkCommonCore.vtkObject):
    class Modes(int): ...
    BLOCK_MODE:'Modes'
    X_SLAB_MODE:'Modes'
    Y_SLAB_MODE:'Modes'
    Z_SLAB_MODE:'Modes'
    extent:'getset_descriptor'
    ghost_level:'getset_descriptor'
    piece:'getset_descriptor'
    split_mode:'getset_descriptor'
    whole_extent:'getset_descriptor'
    def GetExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetGhostLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetPiece(self) -> int: ...
    def GetSplitMode(self) -> int: ...
    def GetWholeExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtentTranslator': ...
    def PieceToExtent(self) -> int: ...
    def PieceToExtentByPoints(self) -> int: ...
    def PieceToExtentThreadSafe(self, piece:int, numPieces:int, ghostLevel:int, wholeExtent:MutableSequence[int], resultExtent:MutableSequence[int], splitMode:int, byPoints:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtentTranslator': ...
    @overload
    def SetExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetExtent(self, _arg:Sequence[int]) -> None: ...
    def SetGhostLevel(self, _arg:int) -> None: ...
    def SetNumberOfPieces(self, _arg:int) -> None: ...
    def SetPiece(self, _arg:int) -> None: ...
    def SetSplitModeToBlock(self) -> None: ...
    def SetSplitModeToXSlab(self) -> None: ...
    def SetSplitModeToYSlab(self) -> None: ...
    def SetSplitModeToZSlab(self) -> None: ...
    def SetSplitPath(self, len:int, splitpath:MutableSequence[int]) -> None: ...
    @overload
    def SetWholeExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetWholeExtent(self, _arg:Sequence[int]) -> None: ...
    @staticmethod
    def UPDATE_SPLIT_MODE() -> 'vtkInformationIntegerRequestKey': ...

class vtkFilteringInformationKeyManager(object):
    def __init__(self) -> None: ...

class vtkForEach(vtkDataObjectAlgorithm):
    range:'getset_descriptor'
    @staticmethod
    def FOR_EACH_FILTER() -> 'vtkInformationObjectBaseKey': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsIterating(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkForEach': ...
    def RegisterEndFor(self, __a:'vtkEndFor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkForEach': ...
    def SetRange(self, __a:'vtkExecutionRange') -> None: ...

class vtkGraphAlgorithm(vtkAlgorithm):
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkGraph': ...
    @overload
    def GetOutput(self, index:int) -> 'vtkGraph': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphAlgorithm': ...
    @overload
    def SetInputData(self, obj:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, index:int, obj:'vtkDataObject') -> None: ...

class vtkHierarchicalBoxDataSetAlgorithm(vtkAlgorithm):
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkHierarchicalBoxDataSet': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkHierarchicalBoxDataSet': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHierarchicalBoxDataSetAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHierarchicalBoxDataSetAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...

class vtkHyperTreeGridAlgorithm(vtkAlgorithm):
    hyper_tree_grid_output:'getset_descriptor'
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    poly_data_output:'getset_descriptor'
    unstructured_grid_output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    @overload
    def GetHyperTreeGridOutput(self) -> 'vtkHyperTreeGrid': ...
    @overload
    def GetHyperTreeGridOutput(self, __a:int) -> 'vtkHyperTreeGrid': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkDataObject': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkDataObject': ...
    @overload
    def GetPolyDataOutput(self) -> 'vtkPolyData': ...
    @overload
    def GetPolyDataOutput(self, __a:int) -> 'vtkPolyData': ...
    @overload
    def GetUnstructuredGridOutput(self) -> 'vtkUnstructuredGrid': ...
    @overload
    def GetUnstructuredGridOutput(self, __a:int) -> 'vtkUnstructuredGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def SetOutput(self, __a:'vtkDataObject') -> None: ...

class vtkImageAlgorithm(vtkAlgorithm):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def GetImageDataInput(self, port:int) -> 'vtkImageData': ...
    @overload
    def GetInput(self, port:int) -> 'vtkDataObject': ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkImageData': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkImageData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def SetOutput(self, d:'vtkDataObject') -> None: ...

class vtkImageInPlaceFilter(vtkImageAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageInPlaceFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageInPlaceFilter': ...

class vtkStructuredGridAlgorithm(vtkAlgorithm):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    @overload
    def GetInput(self, port:int) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkStructuredGrid': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkStructuredGrid': ...
    def GetStructuredGridInput(self, port:int) -> 'vtkStructuredGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredGridAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredGridAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def SetOutput(self, d:'vtkDataObject') -> None: ...

class vtkImageToStructuredGrid(vtkStructuredGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageToStructuredGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageToStructuredGrid': ...

class vtkImageToStructuredPoints(vtkImageAlgorithm):
    structured_points_output:'getset_descriptor'
    vector_input:'getset_descriptor'
    vector_input_data:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStructuredPointsOutput(self) -> 'vtkStructuredPoints': ...
    def GetVectorInput(self) -> 'vtkImageData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageToStructuredPoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageToStructuredPoints': ...
    def SetVectorInputData(self, input:'vtkImageData') -> None: ...

class vtkInformationDataObjectMetaDataKey(vtkmodules.vtkCommonCore.vtkInformationDataObjectKey):
    def CopyDefaultInformation(self, request:'vtkInformation', fromInfo:'vtkInformation', toInfo:'vtkInformation') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str) -> 'vtkInformationDataObjectMetaDataKey': ...
    def NewInstance(self) -> 'vtkInformationDataObjectMetaDataKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationDataObjectMetaDataKey': ...

class vtkInformationExecutivePortKey(vtkmodules.vtkCommonCore.vtkInformationKey):
    def GetExecutive(self, info:'vtkInformation') -> 'vtkExecutive': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPort(self, info:'vtkInformation') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str) -> 'vtkInformationExecutivePortKey': ...
    def NewInstance(self) -> 'vtkInformationExecutivePortKey': ...
    def Report(self, info:'vtkInformation', collector:'vtkGarbageCollector') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationExecutivePortKey': ...
    def Set(self, info:'vtkInformation', __b:'vtkExecutive', __c:int) -> None: ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationExecutivePortVectorKey(vtkmodules.vtkCommonCore.vtkInformationKey):
    def Append(self, info:'vtkInformation', executive:'vtkExecutive', port:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPorts(self, info:'vtkInformation') -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Length(self, info:'vtkInformation') -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str) -> 'vtkInformationExecutivePortVectorKey': ...
    def NewInstance(self) -> 'vtkInformationExecutivePortVectorKey': ...
    @overload
    def Remove(self, info:'vtkInformation', executive:'vtkExecutive', port:int) -> None: ...
    @overload
    def Remove(self, info:'vtkInformation') -> None: ...
    def Report(self, info:'vtkInformation', collector:'vtkGarbageCollector') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationExecutivePortVectorKey': ...
    def ShallowCopy(self, from_:'vtkInformation', to:'vtkInformation') -> None: ...

class vtkInformationIntegerRequestKey(vtkmodules.vtkCommonCore.vtkInformationIntegerKey):
    def CopyDefaultInformation(self, request:'vtkInformation', fromInfo:'vtkInformation', toInfo:'vtkInformation') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MakeKey(name:str, location:str) -> 'vtkInformationIntegerRequestKey': ...
    def NeedToExecute(self, pipelineInfo:'vtkInformation', dobjInfo:'vtkInformation') -> bool: ...
    def NewInstance(self) -> 'vtkInformationIntegerRequestKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInformationIntegerRequestKey': ...
    def StoreMetaData(self, request:'vtkInformation', pipelineInfo:'vtkInformation', dobjInfo:'vtkInformation') -> None: ...

class vtkMoleculeAlgorithm(vtkAlgorithm):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    @overload
    def GetInput(self, port:int) -> 'vtkDataObject': ...
    def GetMoleculeInput(self, port:int) -> 'vtkMolecule': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkMolecule': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkMolecule': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMoleculeAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMoleculeAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def SetOutput(self, d:'vtkMolecule') -> None: ...

class vtkMultiBlockDataSetAlgorithm(vtkAlgorithm):
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkMultiBlockDataSet': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkMultiBlockDataSet': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMultiBlockDataSetAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiBlockDataSetAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...

class vtkMultiTimeStepAlgorithm(vtkAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMultiTimeStepAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiTimeStepAlgorithm': ...

class vtkUniformGridAMRAlgorithm(vtkAlgorithm):
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkUniformGridAMR': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkUniformGridAMR': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUniformGridAMRAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUniformGridAMRAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...

class vtkNonOverlappingAMRAlgorithm(vtkUniformGridAMRAlgorithm):
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkNonOverlappingAMR': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkNonOverlappingAMR': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkNonOverlappingAMRAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkNonOverlappingAMRAlgorithm': ...

class vtkOverlappingAMRAlgorithm(vtkUniformGridAMRAlgorithm):
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkOverlappingAMR': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkOverlappingAMR': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOverlappingAMRAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOverlappingAMRAlgorithm': ...

class vtkReaderAlgorithm(vtkAlgorithm):
    def CreateOutput(self, currentOutput:'vtkDataObject') -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkReaderAlgorithm': ...
    def ReadArrays(self, piece:int, npieces:int, nghosts:int, timestep:int, output:'vtkDataObject') -> int: ...
    def ReadMesh(self, piece:int, npieces:int, nghosts:int, timestep:int, output:'vtkDataObject') -> int: ...
    def ReadMetaData(self, metadata:'vtkInformation') -> int: ...
    def ReadPoints(self, piece:int, npieces:int, nghosts:int, timestep:int, output:'vtkDataObject') -> int: ...
    def ReadTimeDependentMetaData(self, __a:int, __b:'vtkInformation') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkReaderAlgorithm': ...

class vtkParallelReader(vtkReaderAlgorithm):
    current_file_name:'getset_descriptor'
    def AddFileName(self, fname:str) -> None: ...
    def ClearFileNames(self) -> None: ...
    def GetCurrentFileName(self) -> str: ...
    def GetFileName(self, i:int) -> str: ...
    def GetNumberOfFileNames(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkParallelReader': ...
    def ReadArrays(self, piece:int, npieces:int, nghosts:int, timestep:int, output:'vtkDataObject') -> int: ...
    def ReadMesh(self, piece:int, npieces:int, nghosts:int, timestep:int, output:'vtkDataObject') -> int: ...
    def ReadMetaData(self, metadata:'vtkInformation') -> int: ...
    def ReadPoints(self, piece:int, npieces:int, nghosts:int, timestep:int, output:'vtkDataObject') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkParallelReader': ...

class vtkPartitionedDataSetAlgorithm(vtkAlgorithm):
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkPartitionedDataSet': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkPartitionedDataSet': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPartitionedDataSetAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPartitionedDataSetAlgorithm': ...

class vtkPartitionedDataSetCollectionAlgorithm(vtkAlgorithm):
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkPartitionedDataSetCollection': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkPartitionedDataSetCollection': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPartitionedDataSetCollectionAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPartitionedDataSetCollectionAlgorithm': ...

class vtkPassInputTypeAlgorithm(vtkAlgorithm):
    graph_output:'getset_descriptor'
    hyper_tree_grid_output:'getset_descriptor'
    image_data_output:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    molecule_output:'getset_descriptor'
    output:'getset_descriptor'
    poly_data_output:'getset_descriptor'
    rectilinear_grid_output:'getset_descriptor'
    structured_grid_output:'getset_descriptor'
    structured_points_output:'getset_descriptor'
    table_output:'getset_descriptor'
    unstructured_grid_output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def GetGraphOutput(self) -> 'vtkGraph': ...
    def GetHyperTreeGridOutput(self) -> 'vtkHyperTreeGrid': ...
    def GetImageDataOutput(self) -> 'vtkImageData': ...
    def GetInput(self) -> 'vtkDataObject': ...
    def GetMoleculeOutput(self) -> 'vtkMolecule': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkDataObject': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkDataObject': ...
    def GetPolyDataOutput(self) -> 'vtkPolyData': ...
    def GetRectilinearGridOutput(self) -> 'vtkRectilinearGrid': ...
    def GetStructuredGridOutput(self) -> 'vtkStructuredGrid': ...
    def GetStructuredPointsOutput(self) -> 'vtkStructuredPoints': ...
    def GetTableOutput(self) -> 'vtkTable': ...
    def GetUnstructuredGridOutput(self) -> 'vtkUnstructuredGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPassInputTypeAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPassInputTypeAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...

class vtkPiecewiseFunctionAlgorithm(vtkAlgorithm):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    @overload
    def GetInput(self, port:int) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkDataObject': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkDataObject': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPiecewiseFunctionAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPiecewiseFunctionAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def SetOutput(self, d:'vtkDataObject') -> None: ...

class vtkPiecewiseFunctionShiftScale(vtkPiecewiseFunctionAlgorithm):
    position_scale:'getset_descriptor'
    position_shift:'getset_descriptor'
    value_scale:'getset_descriptor'
    value_shift:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPositionScale(self) -> float: ...
    def GetPositionShift(self) -> float: ...
    def GetValueScale(self) -> float: ...
    def GetValueShift(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPiecewiseFunctionShiftScale': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPiecewiseFunctionShiftScale': ...
    def SetPositionScale(self, _arg:float) -> None: ...
    def SetPositionShift(self, _arg:float) -> None: ...
    def SetValueScale(self, _arg:float) -> None: ...
    def SetValueShift(self, _arg:float) -> None: ...

class vtkPointSetAlgorithm(vtkAlgorithm):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    poly_data_output:'getset_descriptor'
    structured_grid_output:'getset_descriptor'
    unstructured_grid_output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:'vtkPointSet') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkPointSet') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def GetInput(self) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkPointSet': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkPointSet': ...
    def GetPolyDataOutput(self) -> 'vtkPolyData': ...
    def GetStructuredGridOutput(self) -> 'vtkStructuredGrid': ...
    def GetUnstructuredGridOutput(self) -> 'vtkUnstructuredGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointSetAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointSetAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:'vtkPointSet') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkPointSet') -> None: ...

class vtkPolyDataAlgorithm(vtkAlgorithm):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    @overload
    def GetInput(self, port:int) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkPolyData': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkPolyData': ...
    def GetPolyDataInput(self, port:int) -> 'vtkPolyData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def SetOutput(self, d:'vtkDataObject') -> None: ...

class vtkProgressObserver(vtkmodules.vtkCommonCore.vtkObject):
    progress:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProgress(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProgressObserver': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProgressObserver': ...
    def UpdateProgress(self, amount:float) -> None: ...

class vtkRectilinearGridAlgorithm(vtkAlgorithm):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    @overload
    def GetInput(self, port:int) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkRectilinearGrid': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkRectilinearGrid': ...
    def GetRectilinearGridInput(self, port:int) -> 'vtkRectilinearGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRectilinearGridAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRectilinearGridAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def SetOutput(self, d:'vtkDataObject') -> None: ...

class vtkSMPProgressObserver(vtkProgressObserver):
    local_observer:'getset_descriptor'
    def GetLocalObserver(self) -> 'vtkProgressObserver': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSMPProgressObserver': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSMPProgressObserver': ...
    def UpdateProgress(self, progress:float) -> None: ...

class vtkScalarTree(vtkmodules.vtkCommonCore.vtkObject):
    data_set:'getset_descriptor'
    scalar_value:'getset_descriptor'
    scalars:'getset_descriptor'
    def BuildTree(self) -> None: ...
    def GetCellBatch(self, batchNum:int, numCells:int) -> Pointer: ...
    def GetDataSet(self) -> 'vtkDataSet': ...
    def GetNumberOfCellBatches(self, scalarValue:float) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarValue(self) -> float: ...
    def GetScalars(self) -> 'vtkDataArray': ...
    def InitTraversal(self, scalarValue:float) -> None: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkScalarTree': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkScalarTree': ...
    def SetDataSet(self, __a:'vtkDataSet') -> None: ...
    def SetScalars(self, __a:'vtkDataArray') -> None: ...
    def ShallowCopy(self, stree:'vtkScalarTree') -> None: ...

class vtkSelectionAlgorithm(vtkAlgorithm):
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkSelection': ...
    @overload
    def GetOutput(self, index:int) -> 'vtkSelection': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSelectionAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSelectionAlgorithm': ...
    @overload
    def SetInputData(self, obj:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, index:int, obj:'vtkDataObject') -> None: ...

class vtkSimpleImageToImageFilter(vtkImageAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSimpleImageToImageFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSimpleImageToImageFilter': ...

class vtkSimpleReader(vtkReaderAlgorithm):
    current_file_name:'getset_descriptor'
    def AddFileName(self, fname:str) -> None: ...
    def ClearFileNames(self) -> None: ...
    def GetCurrentFileName(self) -> str: ...
    def GetFileName(self, i:int) -> str: ...
    def GetNumberOfFileNames(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTimeValue(self, fname:str) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSimpleReader': ...
    def ReadArrays(self, piece:int, npieces:int, nghosts:int, timestep:int, output:'vtkDataObject') -> int: ...
    def ReadArraysSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    def ReadMesh(self, piece:int, npieces:int, nghosts:int, timestep:int, output:'vtkDataObject') -> int: ...
    def ReadMeshSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    def ReadMetaData(self, metadata:'vtkInformation') -> int: ...
    def ReadMetaDataSimple(self, __a:str, __b:'vtkInformation') -> int: ...
    def ReadPoints(self, piece:int, npieces:int, nghosts:int, timestep:int, output:'vtkDataObject') -> int: ...
    def ReadPointsSimple(self, fname:str, output:'vtkDataObject') -> int: ...
    def ReadTimeDependentMetaData(self, timestep:int, metadata:'vtkInformation') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSimpleReader': ...

class vtkSimpleScalarTree(vtkScalarTree):
    branching_factor:'getset_descriptor'
    level:'getset_descriptor'
    max_level:'getset_descriptor'
    def BuildTree(self) -> None: ...
    def GetBranchingFactor(self) -> int: ...
    def GetBranchingFactorMaxValue(self) -> int: ...
    def GetBranchingFactorMinValue(self) -> int: ...
    def GetCellBatch(self, batchNum:int, numCells:int) -> Pointer: ...
    def GetLevel(self) -> int: ...
    def GetMaxLevel(self) -> int: ...
    def GetMaxLevelMaxValue(self) -> int: ...
    def GetMaxLevelMinValue(self) -> int: ...
    def GetNumberOfCellBatches(self, scalarValue:float) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InitTraversal(self, scalarValue:float) -> None: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSimpleScalarTree': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSimpleScalarTree': ...
    def SetBranchingFactor(self, _arg:int) -> None: ...
    def SetMaxLevel(self, _arg:int) -> None: ...
    def ShallowCopy(self, stree:'vtkScalarTree') -> None: ...

class vtkSpanSpace(vtkScalarTree):
    batch_size:'getset_descriptor'
    compute_resolution:'getset_descriptor'
    compute_scalar_range:'getset_descriptor'
    number_of_cells_per_bucket:'getset_descriptor'
    resolution:'getset_descriptor'
    scalar_range:'getset_descriptor'
    def BuildTree(self) -> None: ...
    def ComputeResolutionOff(self) -> None: ...
    def ComputeResolutionOn(self) -> None: ...
    def ComputeScalarRangeOff(self) -> None: ...
    def ComputeScalarRangeOn(self) -> None: ...
    def GetBatchSize(self) -> int: ...
    def GetBatchSizeMaxValue(self) -> int: ...
    def GetBatchSizeMinValue(self) -> int: ...
    def GetCellBatch(self, batchNum:int, numCells:int) -> Pointer: ...
    def GetComputeResolution(self) -> int: ...
    def GetComputeScalarRange(self) -> int: ...
    def GetNumberOfCellBatches(self, scalarValue:float) -> int: ...
    def GetNumberOfCellsPerBucket(self) -> int: ...
    def GetNumberOfCellsPerBucketMaxValue(self) -> int: ...
    def GetNumberOfCellsPerBucketMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetResolution(self) -> int: ...
    def GetResolutionMaxValue(self) -> int: ...
    def GetResolutionMinValue(self) -> int: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def InitTraversal(self, scalarValue:float) -> None: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSpanSpace': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSpanSpace': ...
    def SetBatchSize(self, _arg:int) -> None: ...
    def SetComputeResolution(self, _arg:int) -> None: ...
    def SetComputeScalarRange(self, _arg:int) -> None: ...
    def SetNumberOfCellsPerBucket(self, _arg:int) -> None: ...
    def SetResolution(self, _arg:int) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...
    def ShallowCopy(self, stree:'vtkScalarTree') -> None: ...

class vtkSphereTree(vtkmodules.vtkCommonCore.vtkObject):
    build_hierarchy:'getset_descriptor'
    cell_spheres:'getset_descriptor'
    data_set:'getset_descriptor'
    max_level:'getset_descriptor'
    number_of_levels:'getset_descriptor'
    resolution:'getset_descriptor'
    @overload
    def Build(self) -> None: ...
    @overload
    def Build(self, input:'vtkDataSet') -> None: ...
    def BuildHierarchyOff(self) -> None: ...
    def BuildHierarchyOn(self) -> None: ...
    def GetBuildHierarchy(self) -> bool: ...
    def GetCellSpheres(self) -> Pointer: ...
    def GetDataSet(self) -> 'vtkDataSet': ...
    def GetMaxLevel(self) -> int: ...
    def GetMaxLevelMaxValue(self) -> int: ...
    def GetMaxLevelMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLevels(self) -> int: ...
    def GetResolution(self) -> int: ...
    def GetResolutionMaxValue(self) -> int: ...
    def GetResolutionMinValue(self) -> int: ...
    def GetTreeSpheres(self, level:int, numSpheres:int) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSphereTree': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSphereTree': ...
    @overload
    def SelectLine(self, origin:MutableSequence[float], ray:MutableSequence[float], numSelected:int) -> Pointer: ...
    @overload
    def SelectLine(self, origin:MutableSequence[float], ray:MutableSequence[float], cellIds:'vtkIdList') -> None: ...
    @overload
    def SelectPlane(self, origin:MutableSequence[float], normal:MutableSequence[float], numSelected:int) -> Pointer: ...
    @overload
    def SelectPlane(self, origin:MutableSequence[float], normal:MutableSequence[float], cellIds:'vtkIdList') -> None: ...
    @overload
    def SelectPoint(self, point:MutableSequence[float], numSelected:int) -> Pointer: ...
    @overload
    def SelectPoint(self, point:MutableSequence[float], cellIds:'vtkIdList') -> None: ...
    def SetBuildHierarchy(self, _arg:bool) -> None: ...
    def SetDataSet(self, __a:'vtkDataSet') -> None: ...
    def SetMaxLevel(self, _arg:int) -> None: ...
    def SetResolution(self, _arg:int) -> None: ...
    def UsesGarbageCollector(self) -> bool: ...

class vtkTableAlgorithm(vtkAlgorithm):
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkTable': ...
    @overload
    def GetOutput(self, index:int) -> 'vtkTable': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTableAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTableAlgorithm': ...
    @overload
    def SetInputData(self, obj:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, index:int, obj:'vtkDataObject') -> None: ...

class vtkThreadedCompositeDataPipeline(vtkCompositeDataPipeline):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkThreadedCompositeDataPipeline': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkThreadedCompositeDataPipeline': ...

class vtkThreadedImageAlgorithm(vtkImageAlgorithm):
    desired_bytes_per_piece:'getset_descriptor'
    enable_smp:'getset_descriptor'
    global_default_enable_smp:'getset_descriptor'
    minimum_piece_size:'getset_descriptor'
    number_of_threads:'getset_descriptor'
    number_of_threads_max_value:'getset_descriptor'
    number_of_threads_min_value:'getset_descriptor'
    split_mode:'getset_descriptor'
    def GetDesiredBytesPerPiece(self) -> int: ...
    def GetEnableSMP(self) -> bool: ...
    @staticmethod
    def GetGlobalDefaultEnableSMP() -> bool: ...
    def GetMinimumPieceSize(self) -> Tuple[int, int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreads(self) -> int: ...
    def GetNumberOfThreadsMaxValue(self) -> int: ...
    def GetNumberOfThreadsMinValue(self) -> int: ...
    def GetSplitMode(self) -> int: ...
    def GetSplitModeMaxValue(self) -> int: ...
    def GetSplitModeMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkThreadedImageAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkThreadedImageAlgorithm': ...
    def SetDesiredBytesPerPiece(self, _arg:int) -> None: ...
    def SetEnableSMP(self, _arg:bool) -> None: ...
    @staticmethod
    def SetGlobalDefaultEnableSMP(enable:bool) -> None: ...
    @overload
    def SetMinimumPieceSize(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetMinimumPieceSize(self, _arg:Sequence[int]) -> None: ...
    def SetNumberOfThreads(self, _arg:int) -> None: ...
    def SetSplitMode(self, _arg:int) -> None: ...
    def SetSplitModeToBeam(self) -> None: ...
    def SetSplitModeToBlock(self) -> None: ...
    def SetSplitModeToSlab(self) -> None: ...
    def SplitExtent(self, splitExt:MutableSequence[int], startExt:MutableSequence[int], num:int, total:int) -> int: ...
    def ThreadedExecute(self, inData:'vtkImageData', outData:'vtkImageData', extent:MutableSequence[int], threadId:int) -> None: ...

class vtkTimeRange(vtkExecutionRange):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTimeRange': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTimeRange': ...
    def Size(self) -> int: ...

class vtkTreeAlgorithm(vtkAlgorithm):
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkTree': ...
    @overload
    def GetOutput(self, index:int) -> 'vtkTree': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTreeAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTreeAlgorithm': ...
    @overload
    def SetInputData(self, obj:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, index:int, obj:'vtkDataObject') -> None: ...

class vtkTrivialConsumer(vtkAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTrivialConsumer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTrivialConsumer': ...

class vtkTrivialProducer(vtkAlgorithm):
    m_time:'getset_descriptor'
    output:'getset_descriptor'
    whole_extent:'getset_descriptor'
    @staticmethod
    def FillOutputDataInformation(output:'vtkDataObject', outInfo:'vtkInformation') -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWholeExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTrivialProducer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTrivialProducer': ...
    def SetOutput(self, output:'vtkDataObject') -> None: ...
    @overload
    def SetWholeExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetWholeExtent(self, _arg:Sequence[int]) -> None: ...

class vtkUndirectedGraphAlgorithm(vtkAlgorithm):
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkUndirectedGraph': ...
    @overload
    def GetOutput(self, index:int) -> 'vtkUndirectedGraph': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUndirectedGraphAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUndirectedGraphAlgorithm': ...
    @overload
    def SetInputData(self, obj:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, index:int, obj:'vtkDataObject') -> None: ...

class vtkUniformGridPartitioner(vtkMultiBlockDataSetAlgorithm):
    duplicate_nodes:'getset_descriptor'
    number_of_ghost_layers:'getset_descriptor'
    number_of_partitions:'getset_descriptor'
    def DuplicateNodesOff(self) -> None: ...
    def DuplicateNodesOn(self) -> None: ...
    def GetDuplicateNodes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfGhostLayers(self) -> int: ...
    def GetNumberOfPartitions(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUniformGridPartitioner': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUniformGridPartitioner': ...
    def SetDuplicateNodes(self, _arg:int) -> None: ...
    def SetNumberOfGhostLayers(self, _arg:int) -> None: ...
    def SetNumberOfPartitions(self, _arg:int) -> None: ...

class vtkUnstructuredGridAlgorithm(vtkAlgorithm):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    @overload
    def GetInput(self, port:int) -> 'vtkDataObject': ...
    @overload
    def GetInput(self) -> 'vtkDataObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkUnstructuredGrid': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkUnstructuredGrid': ...
    def GetUnstructuredGridInput(self, port:int) -> 'vtkUnstructuredGrid': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def SetOutput(self, d:'vtkDataObject') -> None: ...

class vtkUnstructuredGridBaseAlgorithm(vtkAlgorithm):
    input_data:'getset_descriptor'
    output:'getset_descriptor'
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkUnstructuredGridBase': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkUnstructuredGridBase': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridBaseAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridBaseAlgorithm': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def SetOutput(self, d:'vtkDataObject') -> None: ...

