from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel

class vtkDGSideType(int): ...

class vtkDGSharingType(int): ...

class vtkDGShapeModifier(int): ...

Cells:'vtkDGSideType'
Discontinuous:'vtkDGSharingType'
InverseJacobian:'vtkDGShapeModifier'
None_:'vtkDGShapeModifier'
ScaledJacobian:'vtkDGShapeModifier'
SharedDOF:'vtkDGSharingType'
Sides:'vtkDGSideType'

class vtkCellAttributeInformation(vtkmodules.vtkCommonDataModel.vtkCellAttributeCalculator):
    basis_name:'getset_descriptor'
    basis_order:'getset_descriptor'
    basis_value_size:'getset_descriptor'
    degree_of_freedom_size:'getset_descriptor'
    number_of_basis_functions:'getset_descriptor'
    shared_degrees_of_freedom:'getset_descriptor'
    def GetBasisName(self) -> str: ...
    def GetBasisOrder(self) -> int: ...
    def GetBasisValueSize(self) -> int: ...
    def GetDegreeOfFreedomSize(self) -> int: ...
    def GetNumberOfBasisFunctions(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSharedDegreesOfFreedom(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellAttributeInformation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellAttributeInformation': ...

class vtkCellGridCellCenters(vtkmodules.vtkCommonExecutionModel.vtkCellGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridCellCenters': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridCellCenters': ...

class vtkCellGridCellSource(vtkmodules.vtkCommonExecutionModel.vtkCellGridAlgorithm):
    cell_type:'getset_descriptor'
    def GetCellType(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridCellSource': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridCellSource': ...
    def SetCellType(self, cellType:str) -> None: ...

class vtkCellGridComputeSides(vtkmodules.vtkCommonExecutionModel.vtkCellGridAlgorithm):
    omit_sides_for_renderable_inputs:'getset_descriptor'
    output_dimension_control:'getset_descriptor'
    preserve_renderable_inputs:'getset_descriptor'
    selection_type:'getset_descriptor'
    side_attribute:'getset_descriptor'
    strategy:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOmitSidesForRenderableInputs(self) -> bool: ...
    def GetOutputDimensionControl(self) -> int: ...
    def GetPreserveRenderableInputs(self) -> bool: ...
    def GetSelectionType(self) -> vtkCellGridSidesQuery.SelectionMode: ...
    @staticmethod
    def GetSideAttribute() -> 'vtkStringToken': ...
    def GetStrategy(self) -> vtkCellGridSidesQuery.SummaryStrategy: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridComputeSides': ...
    def OmitSidesForRenderableInputsOff(self) -> None: ...
    def OmitSidesForRenderableInputsOn(self) -> None: ...
    def PreserveRenderableInputsOff(self) -> None: ...
    def PreserveRenderableInputsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridComputeSides': ...
    def SetOmitSidesForRenderableInputs(self, omit:bool) -> None: ...
    def SetOutputDimensionControl(self, flags:int) -> None: ...
    def SetPreserveRenderableInputs(self, preserve:bool) -> None: ...
    @overload
    def SetSelectionType(self, selectionType:vtkCellGridSidesQuery.SelectionMode) -> None: ...
    @overload
    def SetSelectionType(self, selnType:int) -> None: ...
    @overload
    def SetStrategy(self, strategy:vtkCellGridSidesQuery.SummaryStrategy) -> None: ...
    @overload
    def SetStrategy(self, strategy:int) -> None: ...

class vtkCellGridElevation(vtkmodules.vtkCommonExecutionModel.vtkCellGridAlgorithm):
    attribute_name:'getset_descriptor'
    axis:'getset_descriptor'
    number_of_axes:'getset_descriptor'
    number_of_axes_max_value:'getset_descriptor'
    number_of_axes_min_value:'getset_descriptor'
    origin:'getset_descriptor'
    shock:'getset_descriptor'
    def GetAttributeName(self) -> str: ...
    def GetAxis(self) -> Tuple[float, float, float]: ...
    def GetNumberOfAxes(self) -> int: ...
    def GetNumberOfAxesMaxValue(self) -> int: ...
    def GetNumberOfAxesMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetShock(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridElevation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridElevation': ...
    def SetAttributeName(self, _arg:str) -> None: ...
    @overload
    def SetAxis(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAxis(self, _arg:Sequence[float]) -> None: ...
    def SetNumberOfAxes(self, _arg:int) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:Sequence[float]) -> None: ...
    def SetShock(self, _arg:float) -> None: ...

class vtkCellGridElevationQuery(vtkmodules.vtkCommonDataModel.vtkCellGridQuery):
    def Finalize(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridElevationQuery': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridElevationQuery': ...

class vtkCellGridPointProbe(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    attribute_name:'getset_descriptor'
    source_connection:'getset_descriptor'
    def GetAttributeName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridPointProbe': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridPointProbe': ...
    def SetAttributeName(self, _arg:str) -> None: ...
    def SetSourceConnection(self, source:'vtkAlgorithmOutput') -> None: ...

class vtkCellGridToUnstructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridToUnstructuredGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridToUnstructuredGrid': ...

class vtkCellGridTransform(vtkmodules.vtkCommonExecutionModel.vtkCellGridAlgorithm):
    cell_attribute:'getset_descriptor'
    m_time:'getset_descriptor'
    transform:'getset_descriptor'
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridTransform': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridTransform': ...
    def SetCellAttribute(self, att:'vtkCellAttribute') -> None: ...
    def SetTransform(self, tfm:'vtkAbstractTransform') -> None: ...

class vtkCellGridWarp(vtkmodules.vtkCommonExecutionModel.vtkCellGridAlgorithm):
    m_time:'getset_descriptor'
    scale_factor:'getset_descriptor'
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaleFactor(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridWarp': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridWarp': ...
    def SetScaleFactor(self, scaleFactor:float) -> None: ...

class vtkDGArrayOutputAccessor(object):
    key:'getset_descriptor'
    @overload
    def __init__(self, result:'vtkDoubleArray') -> None: ...
    @overload
    def __init__(self, other:'vtkDGArrayOutputAccessor') -> None: ...
    def GetKey(self) -> int: ...
    def IsAtEnd(self) -> bool: ...
    def Restart(self) -> None: ...
    def size(self) -> int: ...

class vtkDGArraysInputAccessor(object):
    key:'getset_descriptor'
    @overload
    def __init__(self, cellIds:'vtkDataArray', rst:'vtkDataArray') -> None: ...
    @overload
    def __init__(self, other:'vtkDGArraysInputAccessor') -> None: ...
    def GetCellId(self, iteration:int) -> int: ...
    def GetKey(self) -> int: ...
    def GetParameter(self, iteration:int) -> 'vtkVector3d': ...
    def IsAtEnd(self) -> bool: ...
    def Restart(self) -> None: ...
    def size(self) -> int: ...

class vtkDGAttributeInformation(vtkCellAttributeInformation):
    basis_name:'getset_descriptor'
    basis_order:'getset_descriptor'
    basis_value_size:'getset_descriptor'
    degree_of_freedom_size:'getset_descriptor'
    number_of_basis_functions:'getset_descriptor'
    shared_degrees_of_freedom:'getset_descriptor'
    @staticmethod
    def BasisShapeName(cellType:'vtkDGCell') -> str: ...
    def GetBasisName(self) -> str: ...
    def GetBasisOrder(self) -> int: ...
    def GetBasisValueSize(self) -> int: ...
    def GetDegreeOfFreedomSize(self) -> int: ...
    def GetNumberOfBasisFunctions(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSharedDegreesOfFreedom(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGAttributeInformation': ...
    def PrepareForGrid(self, cell:'vtkCellMetadata', attribute:'vtkCellAttribute') -> 'vtkCellAttributeCalculator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGAttributeInformation': ...

class vtkDGBoundsResponder(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGBoundsResponder': ...
    def Query(self, query:'vtkCellGridBoundsQuery', cellType:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGBoundsResponder': ...

class vtkDGCell(vtkmodules.vtkCommonDataModel.vtkCellMetadata):
    class Shape(int): ...
    Edge:'Shape'
    Hexahedron:'Shape'
    None_:'Shape'
    Pyramid:'Shape'
    Quadrilateral:'Shape'
    Tetrahedron:'Shape'
    Triangle:'Shape'
    Vertex:'Shape'
    Wedge:'Shape'
    dimension:'getset_descriptor'
    number_of_cells:'getset_descriptor'
    number_of_corners:'getset_descriptor'
    number_of_side_types:'getset_descriptor'
    reference_points:'getset_descriptor'
    shape:'getset_descriptor'
    side_connectivity:'getset_descriptor'
    side_offsets_and_shapes:'getset_descriptor'
    def DeepCopy(self, other:'vtkCellMetadata') -> None: ...
    def FillReferencePoints(self, arr:'vtkTypeFloat32Array') -> None: ...
    def FillSideConnectivity(self, arr:'vtkTypeInt32Array') -> None: ...
    def FillSideOffsetsAndShapes(self, arr:'vtkTypeInt32Array') -> None: ...
    def GetCellSourceConnectivity(self, sideType:int=-1) -> 'vtkDataArray': ...
    def GetCellSourceIsBlanked(self, sideType:int=-1) -> bool: ...
    def GetCellSourceNodalGhostMarks(self, sideType:int=-1) -> 'vtkDataArray': ...
    def GetCellSourceOffset(self, sideType:int=-1) -> int: ...
    def GetCellSourceSelectionType(self, sideType:int=-1) -> int: ...
    def GetCellSourceShape(self, sideType:int=-1) -> 'Shape': ...
    def GetCellSourceSideType(self, sideType:int=-1) -> int: ...
    def GetDimension(self) -> int: ...
    def GetNumberOfCellSources(self) -> int: ...
    def GetNumberOfCells(self) -> int: ...
    def GetNumberOfCorners(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSideTypes(self) -> int: ...
    def GetNumberOfSidesOfDimension(self, dimension:int) -> int: ...
    def GetParametricCenterOfSide(self, sideId:int) -> 'vtkVector3d': ...
    def GetReferencePoints(self) -> 'vtkTypeFloat32Array': ...
    def GetShape(self) -> 'Shape': ...
    @staticmethod
    def GetShapeCornerCount(shape:'Shape') -> int: ...
    @staticmethod
    def GetShapeDimension(shape:'Shape') -> int: ...
    @staticmethod
    def GetShapeEnum(shapeName:'vtkStringToken') -> 'Shape': ...
    @staticmethod
    def GetShapeName(shape:'Shape') -> 'vtkStringToken': ...
    @overload
    def GetSideConnectivity(self, side:int) -> Tuple[int, int]: ...
    @overload
    def GetSideConnectivity(self) -> 'vtkTypeInt32Array': ...
    def GetSideOffsetsAndShapes(self) -> 'vtkTypeInt32Array': ...
    def GetSideRangeForSideDimension(self, sideDimension:int) -> Tuple[int, int]: ...
    def GetSideRangeForSideType(self, sideType:int) -> Tuple[int, int]: ...
    def GetSideShape(self, side:int) -> 'Shape': ...
    def GetSideTypeForShape(self, s:'Shape') -> int: ...
    def GetSidesOfSide(self, side:int) -> Tuple[int, int]: ...
    def IsA(self, type:str) -> int: ...
    def IsInside(self, rst:'vtkVector3d', tolerance:float=1e-6) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGCell': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGCell': ...
    def ShallowCopy(self, other:'vtkCellMetadata') -> None: ...

class vtkDGCellCenterResponder(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGCellCenterResponder': ...
    def Query(self, query:vtkCellGridCellCenters.Query, cellType:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGCellCenterResponder': ...

class vtkDGCellSourceResponder(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGCellSourceResponder': ...
    def Query(self, query:vtkCellGridCellSource.Query, cellType:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGCellSourceResponder': ...

class vtkDGCopyResponder(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGCopyResponder': ...
    def Query(self, query:'vtkCellGridCopyQuery', cellType:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGCopyResponder': ...

class vtkDGEdge(vtkDGCell):
    dimension:'getset_descriptor'
    number_of_side_types:'getset_descriptor'
    reference_points:'getset_descriptor'
    side_connectivity:'getset_descriptor'
    side_offsets_and_shapes:'getset_descriptor'
    def GetDimension(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSideTypes(self) -> int: ...
    def GetNumberOfSidesOfDimension(self, dimension:int) -> int: ...
    def GetReferencePoints(self) -> 'vtkTypeFloat32Array': ...
    @overload
    def GetSideConnectivity(self, side:int) -> Tuple[int, int]: ...
    @overload
    def GetSideConnectivity(self) -> 'vtkTypeInt32Array': ...
    def GetSideOffsetsAndShapes(self) -> 'vtkTypeInt32Array': ...
    def GetSidesOfSide(self, side:int) -> Tuple[int, int]: ...
    def IsA(self, type:str) -> int: ...
    def IsInside(self, rst:'vtkVector3d', tolerance:float) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGEdge': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGEdge': ...

class vtkDGElevationResponder(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGElevationResponder': ...
    def Query(self, query:'vtkCellGridElevationQuery', cellType:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGElevationResponder': ...

class vtkDGEvaluator(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGEvaluator': ...
    def Query(self, query:'vtkCellGridEvaluator', cellType:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGEvaluator': ...

class vtkDeRhamCell(vtkDGCell):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDeRhamCell': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDeRhamCell': ...

class vtkDGHex(vtkDeRhamCell):
    dimension:'getset_descriptor'
    number_of_side_types:'getset_descriptor'
    reference_points:'getset_descriptor'
    side_connectivity:'getset_descriptor'
    side_offsets_and_shapes:'getset_descriptor'
    def GetDimension(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSideTypes(self) -> int: ...
    def GetNumberOfSidesOfDimension(self, dimension:int) -> int: ...
    def GetReferencePoints(self) -> 'vtkTypeFloat32Array': ...
    @overload
    def GetSideConnectivity(self, side:int) -> Tuple[int, int]: ...
    @overload
    def GetSideConnectivity(self) -> 'vtkTypeInt32Array': ...
    def GetSideOffsetsAndShapes(self) -> 'vtkTypeInt32Array': ...
    def GetSidesOfSide(self, side:int) -> Tuple[int, int]: ...
    def IsA(self, type:str) -> int: ...
    def IsInside(self, rst:'vtkVector3d', tolerance:float) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGHex': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGHex': ...

class vtkInterpolateCalculator(vtkmodules.vtkCommonDataModel.vtkCellAttributeCalculator):
    def AnalyticDerivative(self) -> bool: ...
    @overload
    def Evaluate(self, cellId:int, rst:'vtkVector3d', value:MutableSequence[float]) -> None: ...
    @overload
    def Evaluate(self, cellIds:'vtkIdTypeArray', rst:'vtkDataArray', result:'vtkDataArray') -> None: ...
    @overload
    def EvaluateDerivative(self, cellId:int, rst:'vtkVector3d', jacobian:MutableSequence[float], neighborhood:float=1e-3) -> None: ...
    @overload
    def EvaluateDerivative(self, cellIds:'vtkIdTypeArray', rst:'vtkDataArray', result:'vtkDataArray') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInterpolateCalculator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInterpolateCalculator': ...

class vtkDGInterpolateCalculator(vtkInterpolateCalculator):
    def AnalyticDerivative(self) -> bool: ...
    @overload
    def Evaluate(self, cellId:int, rst:'vtkVector3d', value:MutableSequence[float]) -> None: ...
    @overload
    def Evaluate(self, cellIds:'vtkIdTypeArray', rst:'vtkDataArray', result:'vtkDataArray') -> None: ...
    @overload
    def EvaluateDerivative(self, cellId:int, rst:'vtkVector3d', jacobian:MutableSequence[float], neighborhood:float) -> None: ...
    @overload
    def EvaluateDerivative(self, cellIds:'vtkIdTypeArray', rst:'vtkDataArray', result:'vtkDataArray') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGInterpolateCalculator': ...
    def PrepareForGrid(self, cell:'vtkCellMetadata', field:'vtkCellAttribute') -> 'vtkCellAttributeCalculator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGInterpolateCalculator': ...

class vtkDGOperationBase(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkDGOperationBase') -> None: ...

class vtkDGOperationState(object):
    def CloneInto(self, entry:'vtkDGOperationStateEntryBase') -> None: ...

class vtkDGOperationStateEntryBase(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkDGOperationStateEntryBase') -> None: ...

class vtkDGOperatorEntry(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkDGOperatorEntry') -> None: ...
    def GetShaderString(self, functionName:str, parameterName:str) -> str: ...

class vtkDGPyr(vtkDGCell):
    dimension:'getset_descriptor'
    number_of_side_types:'getset_descriptor'
    reference_points:'getset_descriptor'
    side_connectivity:'getset_descriptor'
    side_offsets_and_shapes:'getset_descriptor'
    def GetDimension(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSideTypes(self) -> int: ...
    def GetNumberOfSidesOfDimension(self, dimension:int) -> int: ...
    def GetReferencePoints(self) -> 'vtkTypeFloat32Array': ...
    @overload
    def GetSideConnectivity(self, side:int) -> Tuple[int, int]: ...
    @overload
    def GetSideConnectivity(self) -> 'vtkTypeInt32Array': ...
    def GetSideOffsetsAndShapes(self) -> 'vtkTypeInt32Array': ...
    def GetSidesOfSide(self, side:int) -> Tuple[int, int]: ...
    def IsA(self, type:str) -> int: ...
    def IsInside(self, rst:'vtkVector3d', tolerance:float) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGPyr': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGPyr': ...

class vtkDGQuad(vtkDeRhamCell):
    dimension:'getset_descriptor'
    number_of_side_types:'getset_descriptor'
    reference_points:'getset_descriptor'
    side_connectivity:'getset_descriptor'
    side_offsets_and_shapes:'getset_descriptor'
    def GetDimension(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSideTypes(self) -> int: ...
    def GetNumberOfSidesOfDimension(self, dimension:int) -> int: ...
    def GetReferencePoints(self) -> 'vtkTypeFloat32Array': ...
    @overload
    def GetSideConnectivity(self, side:int) -> Tuple[int, int]: ...
    @overload
    def GetSideConnectivity(self) -> 'vtkTypeInt32Array': ...
    def GetSideOffsetsAndShapes(self) -> 'vtkTypeInt32Array': ...
    def GetSidesOfSide(self, side:int) -> Tuple[int, int]: ...
    def IsA(self, type:str) -> int: ...
    def IsInside(self, rst:'vtkVector3d', tolerance:float) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGQuad': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGQuad': ...

class vtkDGRangeResponder(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGRangeResponder': ...
    def Query(self, query:'vtkCellGridRangeQuery', cellType:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGRangeResponder': ...

class vtkDGSidesResponder(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGSidesResponder': ...
    def Query(self, query:'vtkCellGridSidesQuery', cellType:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGSidesResponder': ...

class vtkDGTet(vtkDeRhamCell):
    dimension:'getset_descriptor'
    number_of_side_types:'getset_descriptor'
    reference_points:'getset_descriptor'
    side_connectivity:'getset_descriptor'
    side_offsets_and_shapes:'getset_descriptor'
    def GetDimension(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSideTypes(self) -> int: ...
    def GetNumberOfSidesOfDimension(self, dimension:int) -> int: ...
    def GetReferencePoints(self) -> 'vtkTypeFloat32Array': ...
    @overload
    def GetSideConnectivity(self, side:int) -> Tuple[int, int]: ...
    @overload
    def GetSideConnectivity(self) -> 'vtkTypeInt32Array': ...
    def GetSideOffsetsAndShapes(self) -> 'vtkTypeInt32Array': ...
    def GetSidesOfSide(self, side:int) -> Tuple[int, int]: ...
    def IsA(self, type:str) -> int: ...
    def IsInside(self, rst:'vtkVector3d', tolerance:float) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGTet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGTet': ...

class vtkDGTranscribeCellGridCells(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGTranscribeCellGridCells': ...
    def Query(self, query:vtkCellGridToUnstructuredGrid.Query, cellType:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGTranscribeCellGridCells': ...

class vtkDGTranscribeUnstructuredCells(object):
    def ClaimMatchingCells(self, query:vtkUnstructuredGridToCellGrid.TranscribeQuery, cellType:'vtkDGCell') -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGTranscribeUnstructuredCells': ...
    def Query(self, query:vtkUnstructuredGridToCellGrid.TranscribeQuery, cellType:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGTranscribeUnstructuredCells': ...
    def TranscribeMatchingCells(self, query:vtkUnstructuredGridToCellGrid.TranscribeQuery, cellType:'vtkDGCell') -> bool: ...

class vtkDGTransformResponder(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGTransformResponder': ...
    def Query(self, query:vtkCellGridTransform.Query, cellType:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGTransformResponder': ...

class vtkDGTri(vtkDeRhamCell):
    dimension:'getset_descriptor'
    number_of_side_types:'getset_descriptor'
    reference_points:'getset_descriptor'
    side_connectivity:'getset_descriptor'
    side_offsets_and_shapes:'getset_descriptor'
    def GetDimension(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSideTypes(self) -> int: ...
    def GetNumberOfSidesOfDimension(self, dimension:int) -> int: ...
    def GetReferencePoints(self) -> 'vtkTypeFloat32Array': ...
    @overload
    def GetSideConnectivity(self, side:int) -> Tuple[int, int]: ...
    @overload
    def GetSideConnectivity(self) -> 'vtkTypeInt32Array': ...
    def GetSideOffsetsAndShapes(self) -> 'vtkTypeInt32Array': ...
    def GetSidesOfSide(self, side:int) -> Tuple[int, int]: ...
    def IsA(self, type:str) -> int: ...
    def IsInside(self, rst:'vtkVector3d', tolerance:float) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGTri': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGTri': ...

class vtkDGVert(vtkDGCell):
    dimension:'getset_descriptor'
    number_of_side_types:'getset_descriptor'
    reference_points:'getset_descriptor'
    side_connectivity:'getset_descriptor'
    side_offsets_and_shapes:'getset_descriptor'
    def GetDimension(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSideTypes(self) -> int: ...
    def GetNumberOfSidesOfDimension(self, dimension:int) -> int: ...
    def GetReferencePoints(self) -> 'vtkTypeFloat32Array': ...
    @overload
    def GetSideConnectivity(self, side:int) -> Tuple[int, int]: ...
    @overload
    def GetSideConnectivity(self) -> 'vtkTypeInt32Array': ...
    def GetSideOffsetsAndShapes(self) -> 'vtkTypeInt32Array': ...
    def GetSidesOfSide(self, side:int) -> Tuple[int, int]: ...
    def IsA(self, type:str) -> int: ...
    def IsInside(self, rst:'vtkVector3d', tolerance:float) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGVert': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGVert': ...

class vtkDGWarp(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGWarp': ...
    def Query(self, query:vtkCellGridWarp.Query, cellType:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGWarp': ...

class vtkDGWdg(vtkDeRhamCell):
    dimension:'getset_descriptor'
    number_of_side_types:'getset_descriptor'
    reference_points:'getset_descriptor'
    side_connectivity:'getset_descriptor'
    side_offsets_and_shapes:'getset_descriptor'
    def GetDimension(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSideTypes(self) -> int: ...
    def GetNumberOfSidesOfDimension(self, dimension:int) -> int: ...
    def GetReferencePoints(self) -> 'vtkTypeFloat32Array': ...
    @overload
    def GetSideConnectivity(self, side:int) -> Tuple[int, int]: ...
    @overload
    def GetSideConnectivity(self) -> 'vtkTypeInt32Array': ...
    def GetSideOffsetsAndShapes(self) -> 'vtkTypeInt32Array': ...
    def GetSidesOfSide(self, side:int) -> Tuple[int, int]: ...
    def IsA(self, type:str) -> int: ...
    def IsInside(self, rst:'vtkVector3d', tolerance:float) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGWdg': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGWdg': ...

class vtkFiltersCellGrid(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFiltersCellGrid': ...
    @staticmethod
    def RegisterCellsAndResponders() -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFiltersCellGrid': ...

class vtkUnstructuredGridFieldAnnotations(vtkmodules.vtkCommonCore.vtkObject):
    def AddAnnotations(self, fieldData:'vtkFieldData', assembly:'vtkDataAssembly') -> None: ...
    def FetchAnnotations(self, fieldData:'vtkFieldData', assembly:'vtkDataAssembly') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridFieldAnnotations': ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridFieldAnnotations': ...

class vtkUnstructuredGridToCellGrid(vtkmodules.vtkCommonExecutionModel.vtkPartitionedDataSetCollectionAlgorithm):
    def AddPreferredOutputType(self, inputCellType:int, preferredOutputType:'vtkStringToken', priority:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUnstructuredGridToCellGrid': ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUnstructuredGridToCellGrid': ...

