from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkCommonMath

class vtkAbstractInterpolatedVelocityField(vtkmodules.vtkCommonMath.vtkFunctionSet):
    class VelocityFieldInitializationState(int): ...
    INITIALIZE_ALL_DATASETS:'VelocityFieldInitializationState'
    NOT_INITIALIZED:'VelocityFieldInitializationState'
    SELF_INITIALIZE:'VelocityFieldInitializationState'
    cache_hit:'getset_descriptor'
    cache_miss:'getset_descriptor'
    caching:'getset_descriptor'
    find_cell_strategy:'getset_descriptor'
    force_surface_tangent_vector:'getset_descriptor'
    initialization_state:'getset_descriptor'
    last_cell_id:'getset_descriptor'
    last_data_set:'getset_descriptor'
    normalize_vector:'getset_descriptor'
    surface_dataset:'getset_descriptor'
    vectors_selection:'getset_descriptor'
    vectors_type:'getset_descriptor'
    def ClearLastCellId(self) -> None: ...
    def CopyParameters(self, from_:'vtkAbstractInterpolatedVelocityField') -> None: ...
    @overload
    def FunctionValues(self, x:MutableSequence[float], f:MutableSequence[float]) -> int: ...
    @overload
    def FunctionValues(self, x:MutableSequence[float], f:MutableSequence[float], userData:Pointer) -> int: ...
    def GetCacheHit(self) -> int: ...
    def GetCacheMiss(self) -> int: ...
    def GetCaching(self) -> bool: ...
    def GetFindCellStrategy(self) -> 'vtkFindCellStrategy': ...
    def GetForceSurfaceTangentVector(self) -> bool: ...
    def GetInitializationState(self) -> int: ...
    def GetLastCellId(self) -> int: ...
    def GetLastDataSet(self) -> 'vtkDataSet': ...
    def GetLastLocalCoordinates(self, pcoords:MutableSequence[float]) -> int: ...
    def GetLastWeights(self, w:MutableSequence[float]) -> int: ...
    def GetNormalizeVector(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSurfaceDataset(self) -> bool: ...
    def GetVectorsSelection(self) -> str: ...
    def GetVectorsType(self) -> int: ...
    def Initialize(self, compDS:'vtkCompositeDataSet', initStrategy:int=...) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractInterpolatedVelocityField': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractInterpolatedVelocityField': ...
    def SelectVectors(self, fieldAssociation:int, fieldName:str) -> None: ...
    def SetCaching(self, _arg:bool) -> None: ...
    def SetFindCellStrategy(self, __a:'vtkFindCellStrategy') -> None: ...
    def SetForceSurfaceTangentVector(self, _arg:bool) -> None: ...
    @overload
    def SetLastCellId(self, c:int) -> None: ...
    @overload
    def SetLastCellId(self, c:int, dataindex:int) -> None: ...
    def SetNormalizeVector(self, _arg:bool) -> None: ...
    def SetSurfaceDataset(self, _arg:bool) -> None: ...

class vtkAMRInterpolatedVelocityField(vtkAbstractInterpolatedVelocityField):
    amr_data:'getset_descriptor'
    amr_data_set:'getset_descriptor'
    last_cell_id:'getset_descriptor'
    def CopyParameters(self, from_:'vtkAbstractInterpolatedVelocityField') -> None: ...
    @staticmethod
    def FindGrid(q:MutableSequence[float], amrds:'vtkOverlappingAMR', level:int, gridId:int) -> bool: ...
    @overload
    def FunctionValues(self, x:MutableSequence[float], f:MutableSequence[float]) -> int: ...
    @overload
    def FunctionValues(self, x:MutableSequence[float], f:MutableSequence[float], userData:Pointer) -> int: ...
    def GetAmrDataSet(self) -> 'vtkOverlappingAMR': ...
    def GetLastDataSetLocation(self, level:int, id:int) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAMRInterpolatedVelocityField': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAMRInterpolatedVelocityField': ...
    def SetAMRData(self, amr:'vtkOverlappingAMR') -> None: ...
    def SetAmrDataSet(self, __a:'vtkOverlappingAMR') -> None: ...
    @overload
    def SetLastCellId(self, c:int) -> None: ...
    @overload
    def SetLastCellId(self, c:int, dataindex:int) -> None: ...
    def SetLastDataSet(self, level:int, id:int) -> bool: ...

class vtkCompositeInterpolatedVelocityField(vtkAbstractInterpolatedVelocityField):
    cache_data_set_hit:'getset_descriptor'
    cache_data_set_miss:'getset_descriptor'
    last_cell_id:'getset_descriptor'
    last_data_set_index:'getset_descriptor'
    def AddDataSet(self, dataset:'vtkDataSet', maxCellSize:int=0) -> None: ...
    def CopyParameters(self, from_:'vtkAbstractInterpolatedVelocityField') -> None: ...
    @overload
    def FunctionValues(self, x:MutableSequence[float], f:MutableSequence[float]) -> int: ...
    @overload
    def FunctionValues(self, x:MutableSequence[float], f:MutableSequence[float], userData:Pointer) -> int: ...
    def GetCacheDataSetHit(self) -> int: ...
    def GetCacheDataSetMiss(self) -> int: ...
    def GetLastDataSetIndex(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InsideTest(self, x:MutableSequence[float]) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeInterpolatedVelocityField': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeInterpolatedVelocityField': ...
    @overload
    def SetLastCellId(self, c:int, dataindex:int) -> None: ...
    @overload
    def SetLastCellId(self, c:int) -> None: ...
    def SnapPointOnCell(self, pOrigin:MutableSequence[float], pProj:MutableSequence[float]) -> int: ...

class vtkEvenlySpacedStreamlines2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    closed_loop_maximum_distance:'getset_descriptor'
    compute_vorticity:'getset_descriptor'
    initial_integration_step:'getset_descriptor'
    integration_step_unit:'getset_descriptor'
    integrator:'getset_descriptor'
    integrator_type:'getset_descriptor'
    interpolator_prototype:'getset_descriptor'
    interpolator_type:'getset_descriptor'
    loop_angle:'getset_descriptor'
    maximum_number_of_steps:'getset_descriptor'
    minimum_number_of_loop_points:'getset_descriptor'
    separating_distance:'getset_descriptor'
    separating_distance_ratio:'getset_descriptor'
    start_position:'getset_descriptor'
    terminal_speed:'getset_descriptor'
    def GetClosedLoopMaximumDistance(self) -> float: ...
    def GetComputeVorticity(self) -> bool: ...
    def GetInitialIntegrationStep(self) -> float: ...
    def GetIntegrationStepUnit(self) -> int: ...
    def GetIntegrator(self) -> 'vtkInitialValueProblemSolver': ...
    def GetIntegratorType(self) -> int: ...
    def GetLoopAngle(self) -> float: ...
    def GetMaximumNumberOfSteps(self) -> int: ...
    def GetMinimumNumberOfLoopPoints(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSeparatingDistance(self) -> float: ...
    def GetSeparatingDistanceRatio(self) -> float: ...
    def GetStartPosition(self) -> Tuple[float, float, float]: ...
    def GetTerminalSpeed(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEvenlySpacedStreamlines2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEvenlySpacedStreamlines2D': ...
    def SetClosedLoopMaximumDistance(self, _arg:float) -> None: ...
    def SetComputeVorticity(self, _arg:bool) -> None: ...
    def SetInitialIntegrationStep(self, _arg:float) -> None: ...
    def SetIntegrationStepUnit(self, unit:int) -> None: ...
    def SetIntegrator(self, __a:'vtkInitialValueProblemSolver') -> None: ...
    def SetIntegratorType(self, type:int) -> None: ...
    def SetIntegratorTypeToRungeKutta2(self) -> None: ...
    def SetIntegratorTypeToRungeKutta4(self) -> None: ...
    def SetInterpolatorPrototype(self, ivf:'vtkAbstractInterpolatedVelocityField') -> None: ...
    def SetInterpolatorType(self, interpType:int) -> None: ...
    def SetInterpolatorTypeToCellLocator(self) -> None: ...
    def SetInterpolatorTypeToDataSetPointLocator(self) -> None: ...
    def SetLoopAngle(self, _arg:float) -> None: ...
    def SetMaximumNumberOfSteps(self, _arg:int) -> None: ...
    def SetMinimumNumberOfLoopPoints(self, _arg:int) -> None: ...
    def SetSeparatingDistance(self, _arg:float) -> None: ...
    def SetSeparatingDistanceRatio(self, _arg:float) -> None: ...
    @overload
    def SetStartPosition(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetStartPosition(self, _arg:Sequence[float]) -> None: ...
    def SetTerminalSpeed(self, _arg:float) -> None: ...

class vtkIntervalInformation(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkIntervalInformation') -> None: ...
    @overload
    @staticmethod
    def ConvertToLength(interval:float, unit:int, cellLength:float) -> float: ...
    @overload
    @staticmethod
    def ConvertToLength(interval:'vtkIntervalInformation', cellLength:float) -> float: ...

class vtkLagrangianBasicIntegrationModel(vtkmodules.vtkCommonMath.vtkFunctionSet):
    class SurfaceType(int): ...
    class VariableStep(int): ...
    SURFACE_TYPE_BOUNCE:'SurfaceType'
    SURFACE_TYPE_BREAK:'SurfaceType'
    SURFACE_TYPE_MODEL:'SurfaceType'
    SURFACE_TYPE_PASS:'SurfaceType'
    SURFACE_TYPE_TERM:'SurfaceType'
    VARIABLE_STEP_CURRENT:'VariableStep'
    VARIABLE_STEP_NEXT:'VariableStep'
    VARIABLE_STEP_PREV:'VariableStep'
    locator:'getset_descriptor'
    locator_tolerance:'getset_descriptor'
    locators_built:'getset_descriptor'
    non_planar_quad_support:'getset_descriptor'
    number_of_tracked_user_data:'getset_descriptor'
    seed_array_comps:'getset_descriptor'
    seed_array_names:'getset_descriptor'
    seed_array_types:'getset_descriptor'
    surface_array_comps:'getset_descriptor'
    surface_array_default_values:'getset_descriptor'
    surface_array_enum_values:'getset_descriptor'
    surface_array_names:'getset_descriptor'
    surface_array_types:'getset_descriptor'
    tolerance:'getset_descriptor'
    tracker:'getset_descriptor'
    use_initial_integration_time:'getset_descriptor'
    weights_size:'getset_descriptor'
    def AddDataSet(self, dataset:'vtkDataSet', surface:bool=False, surfaceFlatIndex:int=0) -> None: ...
    def ClearDataSets(self, surface:bool=False) -> None: ...
    def FinalizeOutputs(self, particlePathsOutput:'vtkPolyData', interractionOutput:'vtkDataObject') -> bool: ...
    @overload
    def FunctionValues(self, x:MutableSequence[float], f:MutableSequence[float], userData:Pointer) -> int: ...
    @overload
    def FunctionValues(self, x:MutableSequence[float], f:MutableSequence[float]) -> int: ...
    def GetLocator(self) -> 'vtkAbstractCellLocator': ...
    def GetLocatorTolerance(self) -> float: ...
    def GetLocatorsBuilt(self) -> bool: ...
    def GetNonPlanarQuadSupport(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTrackedUserData(self) -> int: ...
    def GetSeedArray(self, idx:int, pointData:'vtkPointData') -> 'vtkAbstractArray': ...
    def GetSeedArrayComps(self) -> 'vtkIntArray': ...
    def GetSeedArrayNames(self) -> 'vtkStringArray': ...
    def GetSeedArrayTypes(self) -> 'vtkIntArray': ...
    def GetSurfaceArrayComps(self) -> 'vtkIntArray': ...
    def GetSurfaceArrayDefaultValues(self) -> 'vtkDoubleArray': ...
    def GetSurfaceArrayEnumValues(self) -> 'vtkStringArray': ...
    def GetSurfaceArrayNames(self) -> 'vtkStringArray': ...
    def GetSurfaceArrayTypes(self) -> 'vtkIntArray': ...
    def GetTolerance(self) -> float: ...
    def GetUseInitialIntegrationTime(self) -> bool: ...
    def GetWeightsSize(self) -> int: ...
    def InitializeInteractionData(self, data:'vtkFieldData') -> None: ...
    def InitializeParticleData(self, particleData:'vtkFieldData', maxTuples:int=0) -> None: ...
    def InitializePathData(self, data:'vtkFieldData') -> None: ...
    def InitializeThreadedData(self) -> 'vtkLagrangianThreadedData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLagrangianBasicIntegrationModel': ...
    def NonPlanarQuadSupportOff(self) -> None: ...
    def NonPlanarQuadSupportOn(self) -> None: ...
    def PreParticleInitalization(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLagrangianBasicIntegrationModel': ...
    def SetInputArrayToProcess(self, idx:int, port:int, connection:int, fieldAssociation:int, name:str) -> None: ...
    def SetLocator(self, locator:'vtkAbstractCellLocator') -> None: ...
    def SetLocatorsBuilt(self, _arg:bool) -> None: ...
    def SetNonPlanarQuadSupport(self, _arg:bool) -> None: ...
    def SetNumberOfTrackedUserData(self, _arg:int) -> None: ...
    def SetTracker(self, Tracker:'vtkLagrangianParticleTracker') -> None: ...
    def SetUseInitialIntegrationTime(self, _arg:bool) -> None: ...
    def UseInitialIntegrationTimeOff(self) -> None: ...
    def UseInitialIntegrationTimeOn(self) -> None: ...

class vtkLagrangianMatidaIntegrationModel(vtkLagrangianBasicIntegrationModel):
    gravity:'getset_descriptor'
    @overload
    def FunctionValues(self, x:MutableSequence[float], f:MutableSequence[float], userData:Pointer) -> int: ...
    @overload
    def FunctionValues(self, x:MutableSequence[float], f:MutableSequence[float]) -> int: ...
    def GetGravity(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLagrangianMatidaIntegrationModel': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLagrangianMatidaIntegrationModel': ...
    @overload
    def SetGravity(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetGravity(self, _arg:Sequence[float]) -> None: ...

class vtkLagrangianParticle(object):
    class ParticleTermination(int): ...
    class SurfaceInteraction(int): ...
    PARTICLE_TERMINATION_ABORTED:'ParticleTermination'
    PARTICLE_TERMINATION_FLIGHT_TERMINATED:'ParticleTermination'
    PARTICLE_TERMINATION_NOT_TERMINATED:'ParticleTermination'
    PARTICLE_TERMINATION_OUT_OF_DOMAIN:'ParticleTermination'
    PARTICLE_TERMINATION_OUT_OF_STEPS:'ParticleTermination'
    PARTICLE_TERMINATION_OUT_OF_TIME:'ParticleTermination'
    PARTICLE_TERMINATION_SURF_BREAK:'ParticleTermination'
    PARTICLE_TERMINATION_SURF_TERMINATED:'ParticleTermination'
    PARTICLE_TERMINATION_TRANSFERRED:'ParticleTermination'
    SURFACE_INTERACTION_BOUNCE:'SurfaceInteraction'
    SURFACE_INTERACTION_BREAK:'SurfaceInteraction'
    SURFACE_INTERACTION_NO_INTERACTION:'SurfaceInteraction'
    SURFACE_INTERACTION_OTHER:'SurfaceInteraction'
    SURFACE_INTERACTION_PASS:'SurfaceInteraction'
    SURFACE_INTERACTION_TERMINATED:'SurfaceInteraction'
    equation_variables:'getset_descriptor'
    id:'getset_descriptor'
    integration_time:'getset_descriptor'
    interaction:'getset_descriptor'
    last_surface_cell_id:'getset_descriptor'
    last_surface_data_set:'getset_descriptor'
    next_equation_variables:'getset_descriptor'
    next_position:'getset_descriptor'
    next_tracked_user_data:'getset_descriptor'
    next_user_variables:'getset_descriptor'
    next_velocity:'getset_descriptor'
    number_of_steps:'getset_descriptor'
    number_of_user_variables:'getset_descriptor'
    number_of_variables:'getset_descriptor'
    p_insert_previous_position:'getset_descriptor'
    p_manual_shift:'getset_descriptor'
    parent_id:'getset_descriptor'
    position:'getset_descriptor'
    position_vector_magnitude:'getset_descriptor'
    prev_equation_variables:'getset_descriptor'
    prev_integration_time:'getset_descriptor'
    prev_position:'getset_descriptor'
    prev_tracked_user_data:'getset_descriptor'
    prev_user_variables:'getset_descriptor'
    prev_velocity:'getset_descriptor'
    seed_array_tuple_index:'getset_descriptor'
    seed_data:'getset_descriptor'
    seed_id:'getset_descriptor'
    step_time_ref:'getset_descriptor'
    termination:'getset_descriptor'
    threaded_data:'getset_descriptor'
    tracked_user_data:'getset_descriptor'
    user_flag:'getset_descriptor'
    user_variables:'getset_descriptor'
    velocity:'getset_descriptor'
    def __init__(self, numberOfVariables:int, seedId:int, particleId:int, seedArrayTupleIndex:int, integrationTime:float, seedData:'vtkPointData', numberOfTrackedUserData:int) -> None: ...
    def GetEquationVariables(self) -> Pointer: ...
    def GetId(self) -> int: ...
    def GetIntegrationTime(self) -> float: ...
    def GetInteraction(self) -> int: ...
    def GetLastSurfaceCellId(self) -> int: ...
    def GetLastSurfaceDataSet(self) -> 'vtkDataSet': ...
    def GetNextEquationVariables(self) -> Pointer: ...
    def GetNextPosition(self) -> Pointer: ...
    def GetNextTrackedUserData(self) -> Tuple[float, float]: ...
    def GetNextUserVariables(self) -> Pointer: ...
    def GetNextVelocity(self) -> Pointer: ...
    def GetNumberOfSteps(self) -> int: ...
    def GetNumberOfUserVariables(self) -> int: ...
    def GetNumberOfVariables(self) -> int: ...
    def GetPInsertPreviousPosition(self) -> bool: ...
    def GetPManualShift(self) -> bool: ...
    def GetParentId(self) -> int: ...
    def GetPosition(self) -> Pointer: ...
    def GetPositionVectorMagnitude(self) -> float: ...
    def GetPrevEquationVariables(self) -> Pointer: ...
    def GetPrevIntegrationTime(self) -> float: ...
    def GetPrevPosition(self) -> Pointer: ...
    def GetPrevTrackedUserData(self) -> Tuple[float, float]: ...
    def GetPrevUserVariables(self) -> Pointer: ...
    def GetPrevVelocity(self) -> Pointer: ...
    def GetSeedArrayTupleIndex(self) -> int: ...
    def GetSeedData(self) -> 'vtkPointData': ...
    def GetSeedId(self) -> int: ...
    def GetStepTimeRef(self) -> float: ...
    def GetTermination(self) -> int: ...
    def GetThreadedData(self) -> 'vtkLagrangianThreadedData': ...
    def GetTrackedUserData(self) -> Tuple[float, float]: ...
    def GetUserFlag(self) -> int: ...
    def GetUserVariables(self) -> Pointer: ...
    def GetVelocity(self) -> Pointer: ...
    def MoveToNextPosition(self) -> None: ...
    def SetIntegrationTime(self, time:float) -> None: ...
    def SetInteraction(self, interaction:int) -> None: ...
    def SetLastSurfaceCell(self, dataset:'vtkDataSet', cellId:int) -> None: ...
    def SetPInsertPreviousPosition(self, val:bool) -> None: ...
    def SetPManualShift(self, val:bool) -> None: ...
    def SetParentId(self, parentId:int) -> None: ...
    def SetTermination(self, termination:int) -> None: ...
    def SetThreadedData(self, threadedData:'vtkLagrangianThreadedData') -> None: ...
    def SetUserFlag(self, flag:int) -> None: ...

class vtkLagrangianParticleTracker(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    class CellLengthComputation(int): ...
    STEP_CUR_CELL_DIV_THEO:'CellLengthComputation'
    STEP_CUR_CELL_LENGTH:'CellLengthComputation'
    STEP_CUR_CELL_VEL_DIR:'CellLengthComputation'
    adaptive_step_reintegration:'getset_descriptor'
    cell_length_computation_mode:'getset_descriptor'
    generate_particle_paths_output:'getset_descriptor'
    generate_poly_vertex_interaction_output:'getset_descriptor'
    integration_model:'getset_descriptor'
    integrator:'getset_descriptor'
    m_time:'getset_descriptor'
    maximum_integration_time:'getset_descriptor'
    maximum_number_of_steps:'getset_descriptor'
    new_particle_id:'getset_descriptor'
    source:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    step_factor:'getset_descriptor'
    step_factor_max:'getset_descriptor'
    step_factor_min:'getset_descriptor'
    surface:'getset_descriptor'
    surface_connection:'getset_descriptor'
    surface_data:'getset_descriptor'
    def AdaptiveStepReintegrationOff(self) -> None: ...
    def AdaptiveStepReintegrationOn(self) -> None: ...
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def FillOutputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GenerateParticlePathsOutputOff(self) -> None: ...
    def GenerateParticlePathsOutputOn(self) -> None: ...
    def GetAdaptiveStepReintegration(self) -> bool: ...
    def GetCellLengthComputationMode(self) -> int: ...
    def GetGenerateParticlePathsOutput(self) -> bool: ...
    def GetGeneratePolyVertexInteractionOutput(self) -> bool: ...
    def GetIntegrationModel(self) -> 'vtkLagrangianBasicIntegrationModel': ...
    def GetIntegrator(self) -> 'vtkInitialValueProblemSolver': ...
    def GetMTime(self) -> int: ...
    def GetMaximumIntegrationTime(self) -> float: ...
    def GetMaximumNumberOfSteps(self) -> int: ...
    def GetNewParticleId(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSource(self) -> 'vtkDataObject': ...
    def GetStepFactor(self) -> float: ...
    def GetStepFactorMax(self) -> float: ...
    def GetStepFactorMin(self) -> float: ...
    def GetSurface(self) -> 'vtkDataObject': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLagrangianParticleTracker': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLagrangianParticleTracker': ...
    def SetAdaptiveStepReintegration(self, _arg:bool) -> None: ...
    def SetCellLengthComputationMode(self, _arg:int) -> None: ...
    def SetGenerateParticlePathsOutput(self, _arg:bool) -> None: ...
    def SetGeneratePolyVertexInteractionOutput(self, _arg:bool) -> None: ...
    def SetIntegrationModel(self, integrationModel:'vtkLagrangianBasicIntegrationModel') -> None: ...
    def SetIntegrator(self, integrator:'vtkInitialValueProblemSolver') -> None: ...
    def SetMaximumIntegrationTime(self, _arg:float) -> None: ...
    def SetMaximumNumberOfSteps(self, _arg:int) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkDataObject') -> None: ...
    def SetStepFactor(self, _arg:float) -> None: ...
    def SetStepFactorMax(self, _arg:float) -> None: ...
    def SetStepFactorMin(self, _arg:float) -> None: ...
    def SetSurfaceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSurfaceData(self, source:'vtkDataObject') -> None: ...

class vtkLinearTransformCellLocator(vtkmodules.vtkCommonDataModel.vtkAbstractCellLocator):
    cell_locator:'getset_descriptor'
    is_linear_transformation:'getset_descriptor'
    use_all_points:'getset_descriptor'
    def BuildLocator(self) -> None: ...
    @overload
    def FindCell(self, x:MutableSequence[float], tol2:float, cell:'vtkGenericCell', subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float], tol2:float, GenCell:'vtkGenericCell', pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def FindCellsAlongLine(self, p1:Sequence[float], p2:Sequence[float], tolerance:float, cellsIds:'vtkIdList') -> None: ...
    def FindCellsAlongPlane(self, o:Sequence[float], n:Sequence[float], tolerance:float, cells:'vtkIdList') -> None: ...
    def FindCellsWithinBounds(self, bbox:MutableSequence[float], cells:'vtkIdList') -> None: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float], closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float) -> None: ...
    @overload
    def FindClosestPoint(self, x:Sequence[float], closestPoint:MutableSequence[float], cellId:int, subId:int, dist2:float) -> None: ...
    @overload
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float, inside:int) -> int: ...
    @overload
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cellId:int, subId:int, dist2:float) -> int: ...
    @overload
    def FindClosestPointWithinRadius(self, x:MutableSequence[float], radius:float, closestPoint:MutableSequence[float], cell:'vtkGenericCell', cellId:int, subId:int, dist2:float) -> int: ...
    def ForceBuildLocator(self) -> None: ...
    def FreeSearchStructure(self) -> None: ...
    def GenerateRepresentation(self, level:int, pd:'vtkPolyData') -> None: ...
    def GetCellLocator(self) -> 'vtkAbstractCellLocator': ...
    def GetIsLinearTransformation(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseAllPoints(self) -> bool: ...
    def InsideCellBounds(self, x:MutableSequence[float], cellId:int) -> bool: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int, cell:'vtkGenericCell') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList', cell:'vtkGenericCell') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], points:'vtkPoints', cellIds:'vtkIdList') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLinearTransformCellLocator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLinearTransformCellLocator': ...
    def SetCellLocator(self, locator:'vtkAbstractCellLocator') -> None: ...
    def SetUseAllPoints(self, _arg:bool) -> None: ...
    def ShallowCopy(self, locator:'vtkAbstractCellLocator') -> None: ...
    def UseAllPointsOff(self) -> None: ...
    def UseAllPointsOn(self) -> None: ...

class vtkModifiedBSPTree(vtkmodules.vtkCommonDataModel.vtkAbstractCellLocator):
    leaf_node_cell_information:'getset_descriptor'
    def BuildLocator(self) -> None: ...
    @overload
    def FindCell(self, x:MutableSequence[float], tol2:float, GenCell:'vtkGenericCell', subId:int, pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float]) -> int: ...
    @overload
    def FindCell(self, x:MutableSequence[float], tol2:float, GenCell:'vtkGenericCell', pcoords:MutableSequence[float], weights:MutableSequence[float]) -> int: ...
    def FindCellsAlongLine(self, p1:Sequence[float], p2:Sequence[float], tolerance:float, cellsIds:'vtkIdList') -> None: ...
    def ForceBuildLocator(self) -> None: ...
    def FreeSearchStructure(self) -> None: ...
    def GenerateRepresentation(self, level:int, pd:'vtkPolyData') -> None: ...
    def GenerateRepresentationLeafs(self, pd:'vtkPolyData') -> None: ...
    def GetLeafNodeCellInformation(self) -> 'vtkIdListCollection': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int, cell:'vtkGenericCell') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList', cell:'vtkGenericCell') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], points:'vtkPoints', cellIds:'vtkIdList') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkModifiedBSPTree': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkModifiedBSPTree': ...
    def ShallowCopy(self, locator:'vtkAbstractCellLocator') -> None: ...

class vtkParallelVectors(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    first_vector_field_name:'getset_descriptor'
    second_vector_field_name:'getset_descriptor'
    def GetFirstVectorFieldName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSecondVectorFieldName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkParallelVectors': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkParallelVectors': ...
    def SetFirstVectorFieldName(self, _arg:str) -> None: ...
    def SetSecondVectorFieldName(self, _arg:str) -> None: ...

class vtkParticleTracerBase(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class MeshOverTimeTypes(int): ...
    class Solvers(int): ...
    DIFFERENT:'MeshOverTimeTypes'
    INTERPOLATOR_WITH_CELL_LOCATOR:int
    INTERPOLATOR_WITH_DATASET_POINT_LOCATOR:int
    LINEAR_TRANSFORMATION:'MeshOverTimeTypes'
    NONE:'Solvers'
    RUNGE_KUTTA2:'Solvers'
    RUNGE_KUTTA4:'Solvers'
    RUNGE_KUTTA45:'Solvers'
    SAME_TOPOLOGY:'MeshOverTimeTypes'
    STATIC:'MeshOverTimeTypes'
    UNKNOWN:'Solvers'
    compute_vorticity:'getset_descriptor'
    controller:'getset_descriptor'
    disable_reset_cache:'getset_descriptor'
    enable_particle_writing:'getset_descriptor'
    force_reinjection_every_n_steps:'getset_descriptor'
    force_serial_execution:'getset_descriptor'
    ignore_pipeline_time:'getset_descriptor'
    integrator:'getset_descriptor'
    integrator_type:'getset_descriptor'
    interpolator_type:'getset_descriptor'
    mesh_over_time:'getset_descriptor'
    particle_file_name:'getset_descriptor'
    particle_writer:'getset_descriptor'
    rotation_scale:'getset_descriptor'
    start_time:'getset_descriptor'
    static_seeds:'getset_descriptor'
    terminal_speed:'getset_descriptor'
    termination_time:'getset_descriptor'
    def AddSourceConnection(self, input:'vtkAlgorithmOutput') -> None: ...
    def DisableResetCacheOff(self) -> None: ...
    def DisableResetCacheOn(self) -> None: ...
    def EnableParticleWritingOff(self) -> None: ...
    def EnableParticleWritingOn(self) -> None: ...
    def ForceSerialExecutionOff(self) -> None: ...
    def ForceSerialExecutionOn(self) -> None: ...
    def GetComputeVorticity(self) -> bool: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetDisableResetCache(self) -> bool: ...
    def GetEnableParticleWriting(self) -> int: ...
    def GetForceReinjectionEveryNSteps(self) -> int: ...
    def GetForceSerialExecution(self) -> bool: ...
    def GetIgnorePipelineTime(self) -> int: ...
    def GetIntegrator(self) -> 'vtkInitialValueProblemSolver': ...
    def GetIntegratorType(self) -> int: ...
    def GetMeshOverTime(self) -> int: ...
    def GetMeshOverTimeMaxValue(self) -> int: ...
    def GetMeshOverTimeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParticleFileName(self) -> str: ...
    def GetParticleWriter(self) -> 'vtkAbstractParticleWriter': ...
    def GetRotationScale(self) -> float: ...
    def GetStartTime(self) -> float: ...
    def GetStaticSeeds(self) -> int: ...
    def GetTerminalSpeed(self) -> float: ...
    def GetTerminationTime(self) -> float: ...
    def IgnorePipelineTimeOff(self) -> None: ...
    def IgnorePipelineTimeOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkParticleTracerBase': ...
    def PrintParticleHistories(self) -> None: ...
    def RemoveAllSources(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkParticleTracerBase': ...
    def SetComputeVorticity(self, __a:bool) -> None: ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetDisableResetCache(self, __a:bool) -> None: ...
    def SetEnableParticleWriting(self, _arg:int) -> None: ...
    def SetForceReinjectionEveryNSteps(self, __a:int) -> None: ...
    def SetForceSerialExecution(self, _arg:bool) -> None: ...
    def SetIgnorePipelineTime(self, _arg:int) -> None: ...
    def SetIntegrator(self, __a:'vtkInitialValueProblemSolver') -> None: ...
    def SetIntegratorType(self, type:int) -> None: ...
    def SetInterpolatorType(self, interpolatorType:int) -> None: ...
    def SetInterpolatorTypeToCellLocator(self) -> None: ...
    def SetInterpolatorTypeToDataSetPointLocator(self) -> None: ...
    def SetMeshOverTime(self, meshOverTime:int) -> None: ...
    def SetMeshOverTimeToDifferent(self) -> None: ...
    def SetMeshOverTimeToLinearTransformation(self) -> None: ...
    def SetMeshOverTimeToSameTopology(self) -> None: ...
    def SetMeshOverTimeToStatic(self) -> None: ...
    def SetParticleFileName(self, _arg:str) -> None: ...
    def SetParticleWriter(self, pw:'vtkAbstractParticleWriter') -> None: ...
    def SetRotationScale(self, __a:float) -> None: ...
    def SetStartTime(self, __a:float) -> None: ...
    def SetStaticSeeds(self, _arg:int) -> None: ...
    def SetTerminalSpeed(self, __a:float) -> None: ...
    def SetTerminationTime(self, __a:float) -> None: ...
    @staticmethod
    def TimeStepsArrayName() -> str: ...

class vtkParticlePathFilter(vtkParticleTracerBase):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkParticlePathFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkParticlePathFilter': ...

class vtkParticleTracer(vtkParticleTracerBase):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkParticleTracer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkParticleTracer': ...

class vtkStreaklineFilter(vtkParticleTracerBase):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStreaklineFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStreaklineFilter': ...

class vtkStreamTracer(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class Units(int): ...
    class ReasonForTermination(int): ...
    class Solvers(int): ...
    BACKWARD:int
    BOTH:int
    CELL_LENGTH_UNIT:'Units'
    FIXED_REASONS_FOR_TERMINATION_COUNT:'ReasonForTermination'
    FORWARD:int
    INTERPOLATOR_WITH_CELL_LOCATOR:int
    INTERPOLATOR_WITH_DATASET_POINT_LOCATOR:int
    LENGTH_UNIT:'Units'
    NONE:'Solvers'
    NOT_INITIALIZED:'ReasonForTermination'
    OUT_OF_DOMAIN:'ReasonForTermination'
    OUT_OF_LENGTH:'ReasonForTermination'
    OUT_OF_STEPS:'ReasonForTermination'
    RUNGE_KUTTA2:'Solvers'
    RUNGE_KUTTA4:'Solvers'
    RUNGE_KUTTA45:'Solvers'
    STAGNATION:'ReasonForTermination'
    UNEXPECTED_VALUE:'ReasonForTermination'
    UNKNOWN:'Solvers'
    compute_vorticity:'getset_descriptor'
    force_serial_execution:'getset_descriptor'
    initial_integration_step:'getset_descriptor'
    integration_direction:'getset_descriptor'
    integration_step_unit:'getset_descriptor'
    integrator:'getset_descriptor'
    integrator_type:'getset_descriptor'
    interpolator_prototype:'getset_descriptor'
    interpolator_type:'getset_descriptor'
    maximum_error:'getset_descriptor'
    maximum_integration_step:'getset_descriptor'
    maximum_number_of_steps:'getset_descriptor'
    maximum_propagation:'getset_descriptor'
    minimum_integration_step:'getset_descriptor'
    rotation_scale:'getset_descriptor'
    source:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    start_position:'getset_descriptor'
    surface_streamlines:'getset_descriptor'
    terminal_speed:'getset_descriptor'
    use_local_seed_source:'getset_descriptor'
    def CalculateVorticity(self, cell:'vtkGenericCell', pcoords:MutableSequence[float], cellVectors:'vtkDoubleArray', vorticity:MutableSequence[float]) -> None: ...
    def ConvertIntervals(self, step:float, minStep:float, maxStep:float, direction:int, cellLength:float) -> None: ...
    def ForceSerialExecutionOff(self) -> None: ...
    def ForceSerialExecutionOn(self) -> None: ...
    def GenerateNormals(self, output:'vtkPolyData', firstNormal:MutableSequence[float], vecName:str) -> None: ...
    def GetComputeVorticity(self) -> bool: ...
    def GetForceSerialExecution(self) -> bool: ...
    def GetInitialIntegrationStep(self) -> float: ...
    def GetIntegrationDirection(self) -> int: ...
    def GetIntegrationDirectionMaxValue(self) -> int: ...
    def GetIntegrationDirectionMinValue(self) -> int: ...
    def GetIntegrationStepUnit(self) -> int: ...
    def GetIntegrator(self) -> 'vtkInitialValueProblemSolver': ...
    def GetIntegratorType(self) -> int: ...
    def GetMaximumError(self) -> float: ...
    def GetMaximumIntegrationStep(self) -> float: ...
    def GetMaximumNumberOfSteps(self) -> int: ...
    def GetMaximumPropagation(self) -> float: ...
    def GetMinimumIntegrationStep(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRotationScale(self) -> float: ...
    def GetSource(self) -> 'vtkDataSet': ...
    def GetStartPosition(self) -> Tuple[float, float, float]: ...
    def GetSurfaceStreamlines(self) -> bool: ...
    def GetTerminalSpeed(self) -> float: ...
    def GetUseLocalSeedSource(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStreamTracer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStreamTracer': ...
    def SetComputeVorticity(self, _arg:bool) -> None: ...
    def SetForceSerialExecution(self, _arg:bool) -> None: ...
    def SetInitialIntegrationStep(self, _arg:float) -> None: ...
    def SetIntegrationDirection(self, _arg:int) -> None: ...
    def SetIntegrationDirectionToBackward(self) -> None: ...
    def SetIntegrationDirectionToBoth(self) -> None: ...
    def SetIntegrationDirectionToForward(self) -> None: ...
    def SetIntegrationStepUnit(self, unit:int) -> None: ...
    def SetIntegrator(self, __a:'vtkInitialValueProblemSolver') -> None: ...
    def SetIntegratorType(self, type:int) -> None: ...
    def SetIntegratorTypeToRungeKutta2(self) -> None: ...
    def SetIntegratorTypeToRungeKutta4(self) -> None: ...
    def SetIntegratorTypeToRungeKutta45(self) -> None: ...
    def SetInterpolatorPrototype(self, ivf:'vtkAbstractInterpolatedVelocityField') -> None: ...
    def SetInterpolatorType(self, interpType:int) -> None: ...
    def SetInterpolatorTypeToCellLocator(self) -> None: ...
    def SetInterpolatorTypeToDataSetPointLocator(self) -> None: ...
    def SetMaximumError(self, _arg:float) -> None: ...
    def SetMaximumIntegrationStep(self, _arg:float) -> None: ...
    def SetMaximumNumberOfSteps(self, _arg:int) -> None: ...
    def SetMaximumPropagation(self, _arg:float) -> None: ...
    def SetMinimumIntegrationStep(self, _arg:float) -> None: ...
    def SetRotationScale(self, _arg:float) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkDataSet') -> None: ...
    @overload
    def SetStartPosition(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetStartPosition(self, _arg:Sequence[float]) -> None: ...
    def SetSurfaceStreamlines(self, _arg:bool) -> None: ...
    def SetTerminalSpeed(self, _arg:float) -> None: ...
    def SetUseLocalSeedSource(self, _arg:bool) -> None: ...
    def SurfaceStreamlinesOff(self) -> None: ...
    def SurfaceStreamlinesOn(self) -> None: ...
    def UseLocalSeedSourceOff(self) -> None: ...
    def UseLocalSeedSourceOn(self) -> None: ...

class vtkStreamSurface(vtkStreamTracer):
    use_iterative_seeding:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseIterativeSeeding(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStreamSurface': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStreamSurface': ...
    def SetUseIterativeSeeding(self, _arg:bool) -> None: ...
    def UseIterativeSeedingOff(self) -> None: ...
    def UseIterativeSeedingOn(self) -> None: ...

class vtkTemporalInterpolatedVelocityField(vtkmodules.vtkCommonMath.vtkFunctionSet):
    class MeshOverTimeTypes(int): ...
    class IDStates(int): ...
    DIFFERENT:'MeshOverTimeTypes'
    INSIDE_ALL:'IDStates'
    LINEAR_TRANSFORMATION:'MeshOverTimeTypes'
    OUTSIDE_ALL:'IDStates'
    OUTSIDE_T0:'IDStates'
    OUTSIDE_T1:'IDStates'
    SAME_TOPOLOGY:'MeshOverTimeTypes'
    STATIC:'MeshOverTimeTypes'
    current_weight:'getset_descriptor'
    find_cell_strategy:'getset_descriptor'
    last_good_velocity:'getset_descriptor'
    mesh_over_time:'getset_descriptor'
    def AddDataSetAtTime(self, N:int, T:float, dataset:'vtkDataSet') -> None: ...
    def AdvanceOneTimeStep(self) -> None: ...
    def ClearCache(self) -> None: ...
    def CopyParameters(self, from_:'vtkTemporalInterpolatedVelocityField') -> None: ...
    @overload
    def FunctionValues(self, x:MutableSequence[float], u:MutableSequence[float]) -> int: ...
    @overload
    def FunctionValues(self, x:MutableSequence[float], f:MutableSequence[float], userData:Pointer) -> int: ...
    def FunctionValuesAtT(self, T:int, x:MutableSequence[float], u:MutableSequence[float]) -> int: ...
    def GetCachedCellIds(self, id:MutableSequence[int], ds:MutableSequence[int]) -> bool: ...
    def GetCurrentWeight(self) -> float: ...
    def GetFindCellStrategy(self) -> 'vtkFindCellStrategy': ...
    def GetLastGoodVelocity(self) -> Tuple[float, float, float]: ...
    def GetMeshOverTime(self) -> int: ...
    def GetMeshOverTimeMaxValue(self) -> int: ...
    def GetMeshOverTimeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self, t0:'vtkCompositeDataSet', t1:'vtkCompositeDataSet') -> None: ...
    @overload
    def InterpolatePoint(self, outPD1:'vtkPointData', outPD2:'vtkPointData', outIndex:int) -> bool: ...
    @overload
    def InterpolatePoint(self, T:int, outPD1:'vtkPointData', outIndex:int) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTemporalInterpolatedVelocityField': ...
    def QuickTestPoint(self, x:MutableSequence[float]) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTemporalInterpolatedVelocityField': ...
    def SelectVectors(self, fieldName:str) -> None: ...
    def SetCachedCellIds(self, id:MutableSequence[int], ds:MutableSequence[int]) -> None: ...
    def SetFindCellStrategy(self, __a:'vtkFindCellStrategy') -> None: ...
    def SetMeshOverTime(self, _arg:int) -> None: ...
    def SetMeshOverTimeToDifferent(self) -> None: ...
    def SetMeshOverTimeToLinearTransformation(self) -> None: ...
    def SetMeshOverTimeToSameTopology(self) -> None: ...
    def SetMeshOverTimeToStatic(self) -> None: ...
    def ShowCacheResults(self) -> None: ...
    def TestPoint(self, x:MutableSequence[float]) -> int: ...

class vtkVectorFieldTopology(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    compute_surfaces:'getset_descriptor'
    epsilon_critical_point:'getset_descriptor'
    exclude_boundary:'getset_descriptor'
    integration_step_size:'getset_descriptor'
    integration_step_unit:'getset_descriptor'
    interpolator_type:'getset_descriptor'
    max_num_steps:'getset_descriptor'
    offset_away_from_boundary:'getset_descriptor'
    separatrix_distance:'getset_descriptor'
    use_boundary_switch_points:'getset_descriptor'
    use_iterative_seeding:'getset_descriptor'
    vector_angle_threshold:'getset_descriptor'
    def GetComputeSurfaces(self) -> bool: ...
    def GetEpsilonCriticalPoint(self) -> float: ...
    def GetExcludeBoundary(self) -> bool: ...
    def GetIntegrationStepSize(self) -> float: ...
    def GetIntegrationStepUnit(self) -> int: ...
    def GetMaxNumSteps(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffsetAwayFromBoundary(self) -> float: ...
    def GetSeparatrixDistance(self) -> float: ...
    def GetUseBoundarySwitchPoints(self) -> bool: ...
    def GetUseIterativeSeeding(self) -> bool: ...
    def GetVectorAngleThreshold(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVectorFieldTopology': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVectorFieldTopology': ...
    def SetComputeSurfaces(self, _arg:bool) -> None: ...
    def SetEpsilonCriticalPoint(self, _arg:float) -> None: ...
    def SetExcludeBoundary(self, _arg:bool) -> None: ...
    def SetIntegrationStepSize(self, _arg:float) -> None: ...
    def SetIntegrationStepUnit(self, _arg:int) -> None: ...
    def SetInterpolatorType(self, interpType:int) -> None: ...
    def SetInterpolatorTypeToCellLocator(self) -> None: ...
    def SetInterpolatorTypeToDataSetPointLocator(self) -> None: ...
    def SetMaxNumSteps(self, _arg:int) -> None: ...
    def SetOffsetAwayFromBoundary(self, _arg:float) -> None: ...
    def SetSeparatrixDistance(self, _arg:float) -> None: ...
    def SetUseBoundarySwitchPoints(self, _arg:bool) -> None: ...
    def SetUseIterativeSeeding(self, _arg:bool) -> None: ...
    def SetVectorAngleThreshold(self, _arg:float) -> None: ...

class vtkVortexCore(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    faster_approximation:'getset_descriptor'
    higher_order_method:'getset_descriptor'
    def FasterApproximationOff(self) -> None: ...
    def FasterApproximationOn(self) -> None: ...
    def GetFasterApproximation(self) -> bool: ...
    def GetHigherOrderMethod(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HigherOrderMethodOff(self) -> None: ...
    def HigherOrderMethodOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVortexCore': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVortexCore': ...
    def SetFasterApproximation(self, _arg:bool) -> None: ...
    def SetHigherOrderMethod(self, _arg:int) -> None: ...

