from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkFiltersCore

VTK_CCS_SCALAR_MODE_COLORS:int
VTK_CCS_SCALAR_MODE_LABELS:int
VTK_CCS_SCALAR_MODE_NONE:int
VTK_CURVATURE_GAUSS:int
VTK_CURVATURE_MAXIMUM:int
VTK_CURVATURE_MEAN:int
VTK_CURVATURE_MINIMUM:int
VTK_DICE_MODE_MEMORY_LIMIT:int
VTK_DICE_MODE_NUMBER_OF_POINTS:int
VTK_DICE_MODE_SPECIFIED_NUMBER:int
VTK_ICON_GRAVITY_BOTTOM_CENTER:int
VTK_ICON_GRAVITY_BOTTOM_LEFT:int
VTK_ICON_GRAVITY_BOTTOM_RIGHT:int
VTK_ICON_GRAVITY_CENTER_CENTER:int
VTK_ICON_GRAVITY_CENTER_LEFT:int
VTK_ICON_GRAVITY_CENTER_RIGHT:int
VTK_ICON_GRAVITY_TOP_CENTER:int
VTK_ICON_GRAVITY_TOP_LEFT:int
VTK_ICON_GRAVITY_TOP_RIGHT:int
VTK_ICON_SCALING_OFF:int
VTK_ICON_SCALING_USE_SCALING_ARRAY:int
VTK_INTEGRATE_BACKWARD:int
VTK_INTEGRATE_BOTH_DIRECTIONS:int
VTK_INTEGRATE_FORWARD:int
VTK_INTEGRATE_MAJOR_EIGENVECTOR:int
VTK_INTEGRATE_MEDIUM_EIGENVECTOR:int
VTK_INTEGRATE_MINOR_EIGENVECTOR:int
VTK_SUBDIVIDE_LENGTH:int
VTK_SUBDIVIDE_SPECIFIED:int
VTK_TCOORDS_FROM_LENGTH:int
VTK_TCOORDS_FROM_NORMALIZED_LENGTH:int
VTK_TCOORDS_FROM_SCALARS:int
VTK_TCOORDS_OFF:int
VTK_TENSOR_MODE_COMPUTE_GRADIENT:int
VTK_TENSOR_MODE_COMPUTE_GREEN_LAGRANGE_STRAIN:int
VTK_TENSOR_MODE_COMPUTE_STRAIN:int
VTK_TENSOR_MODE_PASS_TENSORS:int
VTK_VECTOR_MODE_COMPUTE_GRADIENT:int
VTK_VECTOR_MODE_COMPUTE_VORTICITY:int
VTK_VECTOR_MODE_PASS_VECTORS:int
VTK_VOXEL_TO_12_TET:int
VTK_VOXEL_TO_5_AND_12_TET:int
VTK_VOXEL_TO_5_TET:int
VTK_VOXEL_TO_6_TET:int

class vtkAnimateModes(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    animate_vibrations:'getset_descriptor'
    displacement_magnitude:'getset_descriptor'
    displacement_preapplied:'getset_descriptor'
    mode_shape:'getset_descriptor'
    mode_shapes_range:'getset_descriptor'
    time_range:'getset_descriptor'
    def AnimateVibrationsOff(self) -> None: ...
    def AnimateVibrationsOn(self) -> None: ...
    def DisplacementPreappliedOff(self) -> None: ...
    def DisplacementPreappliedOn(self) -> None: ...
    def GetAnimateVibrations(self) -> bool: ...
    def GetDisplacementMagnitude(self) -> float: ...
    def GetDisplacementPreapplied(self) -> bool: ...
    def GetModeShape(self) -> int: ...
    def GetModeShapeMaxValue(self) -> int: ...
    def GetModeShapeMinValue(self) -> int: ...
    def GetModeShapesRange(self) -> Tuple[int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTimeRange(self) -> Tuple[float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAnimateModes': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAnimateModes': ...
    def SetAnimateVibrations(self, _arg:bool) -> None: ...
    def SetDisplacementMagnitude(self, _arg:float) -> None: ...
    def SetDisplacementPreapplied(self, _arg:bool) -> None: ...
    def SetModeShape(self, _arg:int) -> None: ...

class vtkAnnotationLink(vtkmodules.vtkCommonExecutionModel.vtkAnnotationLayersAlgorithm):
    annotation_layers:'getset_descriptor'
    current_selection:'getset_descriptor'
    m_time:'getset_descriptor'
    def AddDomainMap(self, map:'vtkTable') -> None: ...
    def GetAnnotationLayers(self) -> 'vtkAnnotationLayers': ...
    def GetCurrentSelection(self) -> 'vtkSelection': ...
    def GetDomainMap(self, i:int) -> 'vtkTable': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfDomainMaps(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAnnotationLink': ...
    def RemoveAllDomainMaps(self) -> None: ...
    def RemoveDomainMap(self, map:'vtkTable') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAnnotationLink': ...
    def SetAnnotationLayers(self, layers:'vtkAnnotationLayers') -> None: ...
    def SetCurrentSelection(self, sel:'vtkSelection') -> None: ...

class vtkAppendLocationAttributes(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    append_cell_centers:'getset_descriptor'
    append_point_locations:'getset_descriptor'
    def AppendCellCentersOff(self) -> None: ...
    def AppendCellCentersOn(self) -> None: ...
    def AppendPointLocationsOff(self) -> None: ...
    def AppendPointLocationsOn(self) -> None: ...
    def GetAppendCellCenters(self) -> bool: ...
    def GetAppendPointLocations(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAppendLocationAttributes': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendLocationAttributes': ...
    def SetAppendCellCenters(self, _arg:bool) -> None: ...
    def SetAppendPointLocations(self, _arg:bool) -> None: ...

class vtkAppendPoints(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    input_id_array_name:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    def GetInputIdArrayName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAppendPoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAppendPoints': ...
    def SetInputIdArrayName(self, _arg:str) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...

class vtkSubdivisionFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    check_for_triangles:'getset_descriptor'
    number_of_subdivisions:'getset_descriptor'
    def CheckForTrianglesOff(self) -> None: ...
    def CheckForTrianglesOn(self) -> None: ...
    def GetCheckForTriangles(self) -> int: ...
    def GetCheckForTrianglesMaxValue(self) -> int: ...
    def GetCheckForTrianglesMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSubdivisions(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSubdivisionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSubdivisionFilter': ...
    def SetCheckForTriangles(self, _arg:int) -> None: ...
    def SetNumberOfSubdivisions(self, _arg:int) -> None: ...

class vtkApproximatingSubdivisionFilter(vtkSubdivisionFilter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkApproximatingSubdivisionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkApproximatingSubdivisionFilter': ...

class vtkAreaContourSpectrumFilter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    arc_id:'getset_descriptor'
    field_id:'getset_descriptor'
    number_of_samples:'getset_descriptor'
    output:'getset_descriptor'
    def GetArcId(self) -> int: ...
    def GetFieldId(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSamples(self) -> int: ...
    def GetOutput(self) -> 'vtkTable': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAreaContourSpectrumFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAreaContourSpectrumFilter': ...
    def SetArcId(self, _arg:int) -> None: ...
    def SetFieldId(self, _arg:int) -> None: ...
    def SetNumberOfSamples(self, _arg:int) -> None: ...

class vtkAxes(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    compute_normals:'getset_descriptor'
    origin:'getset_descriptor'
    scale_factor:'getset_descriptor'
    symmetric:'getset_descriptor'
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def GetComputeNormals(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetScaleFactor(self) -> float: ...
    def GetSymmetric(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAxes': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAxes': ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:Sequence[float]) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetSymmetric(self, _arg:int) -> None: ...
    def SymmetricOff(self) -> None: ...
    def SymmetricOn(self) -> None: ...

class vtkBlankStructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkStructuredGridAlgorithm):
    array_id:'getset_descriptor'
    array_name:'getset_descriptor'
    component:'getset_descriptor'
    max_blanking_value:'getset_descriptor'
    min_blanking_value:'getset_descriptor'
    def GetArrayId(self) -> int: ...
    def GetArrayName(self) -> str: ...
    def GetComponent(self) -> int: ...
    def GetComponentMaxValue(self) -> int: ...
    def GetComponentMinValue(self) -> int: ...
    def GetMaxBlankingValue(self) -> float: ...
    def GetMinBlankingValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBlankStructuredGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBlankStructuredGrid': ...
    def SetArrayId(self, _arg:int) -> None: ...
    def SetArrayName(self, _arg:str) -> None: ...
    def SetComponent(self, _arg:int) -> None: ...
    def SetMaxBlankingValue(self, _arg:float) -> None: ...
    def SetMinBlankingValue(self, _arg:float) -> None: ...

class vtkBlankStructuredGridWithImage(vtkmodules.vtkCommonExecutionModel.vtkStructuredGridAlgorithm):
    blanking_input:'getset_descriptor'
    blanking_input_data:'getset_descriptor'
    def GetBlankingInput(self) -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBlankStructuredGridWithImage': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBlankStructuredGridWithImage': ...
    def SetBlankingInputData(self, input:'vtkImageData') -> None: ...

class vtkBlockIdScalars(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBlockIdScalars': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBlockIdScalars': ...

class vtkBooleanOperationPolyDataFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class OperationType(int): ...
    VTK_DIFFERENCE:'OperationType'
    VTK_INTERSECTION:'OperationType'
    VTK_UNION:'OperationType'
    operation:'getset_descriptor'
    reorient_difference_cells:'getset_descriptor'
    tolerance:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOperation(self) -> int: ...
    def GetOperationMaxValue(self) -> int: ...
    def GetOperationMinValue(self) -> int: ...
    def GetReorientDifferenceCells(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBooleanOperationPolyDataFilter': ...
    def ReorientDifferenceCellsOff(self) -> None: ...
    def ReorientDifferenceCellsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBooleanOperationPolyDataFilter': ...
    def SetOperation(self, _arg:int) -> None: ...
    def SetOperationToDifference(self) -> None: ...
    def SetOperationToIntersection(self) -> None: ...
    def SetOperationToUnion(self) -> None: ...
    def SetReorientDifferenceCells(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkBoxClipDataSet(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    box_clip:'getset_descriptor'
    clipped_output:'getset_descriptor'
    generate_clip_scalars:'getset_descriptor'
    generate_clipped_output:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    orientation:'getset_descriptor'
    def CellGrid(self, typeobj:int, npts:int, cellIds:Sequence[int], newCellArray:'vtkCellArray') -> None: ...
    def ClipBox(self, newPoints:'vtkPoints', cell:'vtkGenericCell', locator:'vtkIncrementalPointLocator', tets:'vtkCellArray', inPD:'vtkPointData', outPD:'vtkPointData', inCD:'vtkCellData', cellId:int, outCD:'vtkCellData') -> None: ...
    def ClipBox0D(self, cell:'vtkGenericCell', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', inPD:'vtkPointData', outPD:'vtkPointData', inCD:'vtkCellData', cellId:int, outCD:'vtkCellData') -> None: ...
    def ClipBox1D(self, newPoints:'vtkPoints', cell:'vtkGenericCell', locator:'vtkIncrementalPointLocator', lines:'vtkCellArray', inPD:'vtkPointData', outPD:'vtkPointData', inCD:'vtkCellData', cellId:int, outCD:'vtkCellData') -> None: ...
    def ClipBox2D(self, newPoints:'vtkPoints', cell:'vtkGenericCell', locator:'vtkIncrementalPointLocator', tets:'vtkCellArray', inPD:'vtkPointData', outPD:'vtkPointData', inCD:'vtkCellData', cellId:int, outCD:'vtkCellData') -> None: ...
    def ClipHexahedron(self, newPoints:'vtkPoints', cell:'vtkGenericCell', locator:'vtkIncrementalPointLocator', tets:'vtkCellArray', inPD:'vtkPointData', outPD:'vtkPointData', inCD:'vtkCellData', cellId:int, outCD:'vtkCellData') -> None: ...
    def ClipHexahedron0D(self, cell:'vtkGenericCell', locator:'vtkIncrementalPointLocator', verts:'vtkCellArray', inPD:'vtkPointData', outPD:'vtkPointData', inCD:'vtkCellData', cellId:int, outCD:'vtkCellData') -> None: ...
    def ClipHexahedron1D(self, newPoints:'vtkPoints', cell:'vtkGenericCell', locator:'vtkIncrementalPointLocator', lines:'vtkCellArray', inPD:'vtkPointData', outPD:'vtkPointData', inCD:'vtkCellData', cellId:int, outCD:'vtkCellData') -> None: ...
    def ClipHexahedron2D(self, newPoints:'vtkPoints', cell:'vtkGenericCell', locator:'vtkIncrementalPointLocator', tets:'vtkCellArray', inPD:'vtkPointData', outPD:'vtkPointData', inCD:'vtkCellData', cellId:int, outCD:'vtkCellData') -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def CreateTetra(self, npts:int, cellIds:Sequence[int], newCellArray:'vtkCellArray') -> None: ...
    def GenerateClipScalarsOff(self) -> None: ...
    def GenerateClipScalarsOn(self) -> None: ...
    def GenerateClippedOutputOff(self) -> None: ...
    def GenerateClippedOutputOn(self) -> None: ...
    def GetClippedOutput(self) -> 'vtkUnstructuredGrid': ...
    def GetGenerateClipScalars(self) -> int: ...
    def GetGenerateClippedOutput(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfOutputs(self) -> int: ...
    def GetOrientation(self) -> int: ...
    @staticmethod
    def InterpolateEdge(attributes:'vtkDataSetAttributes', toId:int, fromId1:int, fromId2:int, t:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MinEdgeF(self, id_v:Sequence[int], cellIds:Sequence[int], edgF:MutableSequence[int]) -> None: ...
    def NewInstance(self) -> 'vtkBoxClipDataSet': ...
    def PyramidToTetra(self, pyramId:Sequence[int], cellIds:Sequence[int], newCellArray:'vtkCellArray') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBoxClipDataSet': ...
    @overload
    def SetBoxClip(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @overload
    def SetBoxClip(self, n0:Sequence[float], o0:Sequence[float], n1:Sequence[float] , o1:Sequence[float], n2:Sequence[float], o2:Sequence[float], n3:Sequence[float], o3:Sequence[float], n4:Sequence[float], o4:Sequence[float] , n5:Sequence[float], o5:Sequence[float]) -> None: ...
    def SetGenerateClipScalars(self, _arg:int) -> None: ...
    def SetGenerateClippedOutput(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetOrientation(self, _arg:int) -> None: ...
    def WedgeToTetra(self, wedgeId:Sequence[int], cellIds:Sequence[int], newCellArray:'vtkCellArray') -> None: ...

class vtkBrownianPoints(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    maximum_speed:'getset_descriptor'
    minimum_speed:'getset_descriptor'
    def GetMaximumSpeed(self) -> float: ...
    def GetMaximumSpeedMaxValue(self) -> float: ...
    def GetMaximumSpeedMinValue(self) -> float: ...
    def GetMinimumSpeed(self) -> float: ...
    def GetMinimumSpeedMaxValue(self) -> float: ...
    def GetMinimumSpeedMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBrownianPoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBrownianPoints': ...
    def SetMaximumSpeed(self, _arg:float) -> None: ...
    def SetMinimumSpeed(self, _arg:float) -> None: ...

class vtkCellDerivatives(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    tensor_mode:'getset_descriptor'
    vector_mode:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTensorMode(self) -> int: ...
    def GetTensorModeAsString(self) -> str: ...
    def GetVectorMode(self) -> int: ...
    def GetVectorModeAsString(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellDerivatives': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellDerivatives': ...
    def SetTensorMode(self, _arg:int) -> None: ...
    def SetTensorModeToComputeGradient(self) -> None: ...
    def SetTensorModeToComputeGreenLagrangeStrain(self) -> None: ...
    def SetTensorModeToComputeStrain(self) -> None: ...
    def SetTensorModeToPassTensors(self) -> None: ...
    def SetVectorMode(self, _arg:int) -> None: ...
    def SetVectorModeToComputeGradient(self) -> None: ...
    def SetVectorModeToComputeVorticity(self) -> None: ...
    def SetVectorModeToPassVectors(self) -> None: ...

class vtkCellValidator(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class State(int): ...
    FacesAreOrientedIncorrectly:'State'
    IntersectingEdges:'State'
    IntersectingFaces:'State'
    NoncontiguousEdges:'State'
    Nonconvex:'State'
    Valid:'State'
    WrongNumberOfPoints:'State'
    tolerance:'getset_descriptor'
    @overload
    @staticmethod
    def Check(__a:'vtkGenericCell', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkCell', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkEmptyCell', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkVertex', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkPolyVertex', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkLine', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkPolyLine', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkTriangle', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkTriangleStrip', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkPolygon', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkPixel', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkQuad', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkTetra', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkVoxel', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkHexahedron', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkWedge', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkPyramid', tolerance:float) -> 'State': ...
    @overload
    @staticmethod
    def Check(__a:'vtkPentagonalPrism', tolerance:float) -> 'State': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellValidator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellValidator': ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkCleanUnstructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    class DataWeighingType(int): ...
    AVERAGING:'DataWeighingType'
    FIRST_POINT:'DataWeighingType'
    NUMBER_OF_WEIGHING_TYPES:'DataWeighingType'
    SPATIAL_DENSITY:'DataWeighingType'
    absolute_tolerance:'getset_descriptor'
    locator:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    point_data_weighing_strategy:'getset_descriptor'
    remove_points_without_cells:'getset_descriptor'
    tolerance:'getset_descriptor'
    tolerance_is_absolute:'getset_descriptor'
    def CreateDefaultLocator(self, input:'vtkDataSet'=...) -> None: ...
    def GetAbsoluteTolerance(self) -> float: ...
    def GetAbsoluteToleranceMaxValue(self) -> float: ...
    def GetAbsoluteToleranceMinValue(self) -> float: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPointDataWeighingStrategy(self) -> int: ...
    def GetPointDataWeighingStrategyMaxValue(self) -> int: ...
    def GetPointDataWeighingStrategyMinValue(self) -> int: ...
    def GetRemovePointsWithoutCells(self) -> bool: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceIsAbsolute(self) -> bool: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCleanUnstructuredGrid': ...
    def ReleaseLocator(self) -> None: ...
    def RemovePointsWithoutCellsOff(self) -> None: ...
    def RemovePointsWithoutCellsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCleanUnstructuredGrid': ...
    def SetAbsoluteTolerance(self, _arg:float) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPointDataWeighingStrategy(self, _arg:int) -> None: ...
    def SetRemovePointsWithoutCells(self, _arg:bool) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceIsAbsolute(self, _arg:bool) -> None: ...
    def ToleranceIsAbsoluteOff(self) -> None: ...
    def ToleranceIsAbsoluteOn(self) -> None: ...

class vtkCleanUnstructuredGridCells(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCleanUnstructuredGridCells': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCleanUnstructuredGridCells': ...

class vtkClipClosedSurface(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    active_plane_color:'getset_descriptor'
    active_plane_id:'getset_descriptor'
    base_color:'getset_descriptor'
    clip_color:'getset_descriptor'
    clip_face_output:'getset_descriptor'
    clipping_planes:'getset_descriptor'
    generate_clip_face_output:'getset_descriptor'
    generate_faces:'getset_descriptor'
    generate_outline:'getset_descriptor'
    inside_out:'getset_descriptor'
    pass_point_data:'getset_descriptor'
    scalar_mode:'getset_descriptor'
    tolerance:'getset_descriptor'
    triangulation_error_display:'getset_descriptor'
    def GenerateClipFaceOutputOff(self) -> None: ...
    def GenerateClipFaceOutputOn(self) -> None: ...
    def GenerateFacesOff(self) -> None: ...
    def GenerateFacesOn(self) -> None: ...
    def GenerateOutlineOff(self) -> None: ...
    def GenerateOutlineOn(self) -> None: ...
    def GetActivePlaneColor(self) -> Tuple[float, float, float]: ...
    def GetActivePlaneId(self) -> int: ...
    def GetBaseColor(self) -> Tuple[float, float, float]: ...
    def GetClipColor(self) -> Tuple[float, float, float]: ...
    def GetClipFaceOutput(self) -> 'vtkPolyData': ...
    def GetClippingPlanes(self) -> 'vtkPlaneCollection': ...
    def GetGenerateClipFaceOutput(self) -> int: ...
    def GetGenerateFaces(self) -> int: ...
    def GetGenerateOutline(self) -> int: ...
    def GetInsideOut(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassPointData(self) -> int: ...
    def GetScalarMode(self) -> int: ...
    def GetScalarModeAsString(self) -> str: ...
    def GetScalarModeMaxValue(self) -> int: ...
    def GetScalarModeMinValue(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetTriangulationErrorDisplay(self) -> int: ...
    def InsideOutOff(self) -> None: ...
    def InsideOutOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkClipClosedSurface': ...
    def PassPointDataOff(self) -> None: ...
    def PassPointDataOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkClipClosedSurface': ...
    @overload
    def SetActivePlaneColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetActivePlaneColor(self, _arg:Sequence[float]) -> None: ...
    def SetActivePlaneId(self, _arg:int) -> None: ...
    @overload
    def SetBaseColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBaseColor(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetClipColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetClipColor(self, _arg:Sequence[float]) -> None: ...
    def SetClippingPlanes(self, planes:'vtkPlaneCollection') -> None: ...
    def SetGenerateClipFaceOutput(self, _arg:int) -> None: ...
    def SetGenerateFaces(self, _arg:int) -> None: ...
    def SetGenerateOutline(self, _arg:int) -> None: ...
    def SetInsideOut(self, _arg:int) -> None: ...
    def SetPassPointData(self, _arg:int) -> None: ...
    def SetScalarMode(self, _arg:int) -> None: ...
    def SetScalarModeToColors(self) -> None: ...
    def SetScalarModeToLabels(self) -> None: ...
    def SetScalarModeToNone(self) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetTriangulationErrorDisplay(self, _arg:int) -> None: ...
    def TriangulationErrorDisplayOff(self) -> None: ...
    def TriangulationErrorDisplayOn(self) -> None: ...

class vtkClipConvexPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    m_time:'getset_descriptor'
    planes:'getset_descriptor'
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlanes(self) -> 'vtkPlaneCollection': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkClipConvexPolyData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkClipConvexPolyData': ...
    def SetPlanes(self, planes:'vtkPlaneCollection') -> None: ...

class vtkClipDataSet(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    clip_function:'getset_descriptor'
    clipped_output:'getset_descriptor'
    generate_clip_scalars:'getset_descriptor'
    generate_clipped_output:'getset_descriptor'
    inside_out:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    merge_tolerance:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    stable_clip_non_linear:'getset_descriptor'
    use_value_as_offset:'getset_descriptor'
    value:'getset_descriptor'
    def CreateDefaultLocator(self) -> None: ...
    def GenerateClipScalarsOff(self) -> None: ...
    def GenerateClipScalarsOn(self) -> None: ...
    def GenerateClippedOutputOff(self) -> None: ...
    def GenerateClippedOutputOn(self) -> None: ...
    def GetClipFunction(self) -> 'vtkImplicitFunction': ...
    def GetClippedOutput(self) -> 'vtkUnstructuredGrid': ...
    def GetGenerateClipScalars(self) -> int: ...
    def GetGenerateClippedOutput(self) -> int: ...
    def GetInsideOut(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetMergeTolerance(self) -> float: ...
    def GetMergeToleranceMaxValue(self) -> float: ...
    def GetMergeToleranceMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def GetStableClipNonLinear(self) -> bool: ...
    def GetUseValueAsOffset(self) -> bool: ...
    def GetValue(self) -> float: ...
    def InsideOutOff(self) -> None: ...
    def InsideOutOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkClipDataSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkClipDataSet': ...
    def SetClipFunction(self, __a:'vtkImplicitFunction') -> None: ...
    def SetGenerateClipScalars(self, _arg:int) -> None: ...
    def SetGenerateClippedOutput(self, _arg:int) -> None: ...
    def SetInsideOut(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetMergeTolerance(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetStableClipNonLinear(self, _arg:bool) -> None: ...
    def SetUseValueAsOffset(self, _arg:bool) -> None: ...
    def SetValue(self, _arg:float) -> None: ...
    def StableClipNonLinearOff(self) -> None: ...
    def StableClipNonLinearOn(self) -> None: ...
    def UseValueAsOffsetOff(self) -> None: ...
    def UseValueAsOffsetOn(self) -> None: ...

class vtkClipVolume(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    clip_function:'getset_descriptor'
    clipped_output:'getset_descriptor'
    generate_clip_scalars:'getset_descriptor'
    generate_clipped_output:'getset_descriptor'
    inside_out:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    merge_tolerance:'getset_descriptor'
    mixed3d_cell_generation:'getset_descriptor'
    value:'getset_descriptor'
    def CreateDefaultLocator(self) -> None: ...
    def GenerateClipScalarsOff(self) -> None: ...
    def GenerateClipScalarsOn(self) -> None: ...
    def GenerateClippedOutputOff(self) -> None: ...
    def GenerateClippedOutputOn(self) -> None: ...
    def GetClipFunction(self) -> 'vtkImplicitFunction': ...
    def GetClippedOutput(self) -> 'vtkUnstructuredGrid': ...
    def GetGenerateClipScalars(self) -> int: ...
    def GetGenerateClippedOutput(self) -> int: ...
    def GetInsideOut(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetMergeTolerance(self) -> float: ...
    def GetMergeToleranceMaxValue(self) -> float: ...
    def GetMergeToleranceMinValue(self) -> float: ...
    def GetMixed3DCellGeneration(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self) -> float: ...
    def InsideOutOff(self) -> None: ...
    def InsideOutOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Mixed3DCellGenerationOff(self) -> None: ...
    def Mixed3DCellGenerationOn(self) -> None: ...
    def NewInstance(self) -> 'vtkClipVolume': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkClipVolume': ...
    def SetClipFunction(self, __a:'vtkImplicitFunction') -> None: ...
    def SetGenerateClipScalars(self, _arg:int) -> None: ...
    def SetGenerateClippedOutput(self, _arg:int) -> None: ...
    def SetInsideOut(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetMergeTolerance(self, _arg:float) -> None: ...
    def SetMixed3DCellGeneration(self, _arg:int) -> None: ...
    def SetValue(self, _arg:float) -> None: ...

class vtkCoincidentPoints(vtkmodules.vtkCommonCore.vtkObject):
    next_coincident_point_ids:'getset_descriptor'
    def AddPoint(self, Id:int, point:Sequence[float]) -> None: ...
    def Clear(self) -> None: ...
    def GetCoincidentPointIds(self, point:Sequence[float]) -> 'vtkIdList': ...
    def GetNextCoincidentPointIds(self) -> 'vtkIdList': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InitTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCoincidentPoints': ...
    def RemoveNonCoincidentPoints(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCoincidentPoints': ...
    @staticmethod
    def SpiralPoints(num:int, offsets:'vtkPoints') -> None: ...

class vtkContourTriangulator(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    triangulation_error:'getset_descriptor'
    triangulation_error_display:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTriangulationError(self) -> int: ...
    def GetTriangulationErrorDisplay(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContourTriangulator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContourTriangulator': ...
    def SetTriangulationErrorDisplay(self, _arg:int) -> None: ...
    @staticmethod
    def TriangulateContours(data:'vtkPolyData', firstLine:int, numLines:int, outputPolys:'vtkCellArray', normal:Sequence[float], self_:'vtkPolyDataAlgorithm'=...) -> int: ...
    @staticmethod
    def TriangulatePolygon(polygon:'vtkIdList', points:'vtkPoints', triangles:'vtkCellArray') -> int: ...
    def TriangulationErrorDisplayOff(self) -> None: ...
    def TriangulationErrorDisplayOn(self) -> None: ...

class vtkCountFaces(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    output_array_name:'getset_descriptor'
    use_implicit_array:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputArrayName(self) -> str: ...
    def GetUseImplicitArray(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCountFaces': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCountFaces': ...
    def SetOutputArrayName(self, _arg:str) -> None: ...
    def SetUseImplicitArray(self, _arg:bool) -> None: ...

class vtkCountVertices(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    output_array_name:'getset_descriptor'
    use_implicit_array:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputArrayName(self) -> str: ...
    def GetUseImplicitArray(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCountVertices': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCountVertices': ...
    def SetOutputArrayName(self, _arg:str) -> None: ...
    def SetUseImplicitArray(self, _arg:bool) -> None: ...

class vtkCursor2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    axes:'getset_descriptor'
    focal_point:'getset_descriptor'
    model_bounds:'getset_descriptor'
    outline:'getset_descriptor'
    point:'getset_descriptor'
    radius:'getset_descriptor'
    translation_mode:'getset_descriptor'
    wrap:'getset_descriptor'
    def AllOff(self) -> None: ...
    def AllOn(self) -> None: ...
    def AxesOff(self) -> None: ...
    def AxesOn(self) -> None: ...
    def GetAxes(self) -> int: ...
    def GetFocalPoint(self) -> Tuple[float, float, float]: ...
    def GetModelBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutline(self) -> int: ...
    def GetPoint(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetTranslationMode(self) -> int: ...
    def GetWrap(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCursor2D': ...
    def OutlineOff(self) -> None: ...
    def OutlineOn(self) -> None: ...
    def PointOff(self) -> None: ...
    def PointOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCursor2D': ...
    def SetAxes(self, _arg:int) -> None: ...
    @overload
    def SetFocalPoint(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetFocalPoint(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetModelBounds(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @overload
    def SetModelBounds(self, bounds:Sequence[float]) -> None: ...
    def SetOutline(self, _arg:int) -> None: ...
    def SetPoint(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetTranslationMode(self, _arg:int) -> None: ...
    def SetWrap(self, _arg:int) -> None: ...
    def TranslationModeOff(self) -> None: ...
    def TranslationModeOn(self) -> None: ...
    def WrapOff(self) -> None: ...
    def WrapOn(self) -> None: ...

class vtkCursor3D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    axes:'getset_descriptor'
    focal_point:'getset_descriptor'
    focus:'getset_descriptor'
    model_bounds:'getset_descriptor'
    outline:'getset_descriptor'
    translation_mode:'getset_descriptor'
    wrap:'getset_descriptor'
    x_shadows:'getset_descriptor'
    y_shadows:'getset_descriptor'
    z_shadows:'getset_descriptor'
    def AllOff(self) -> None: ...
    def AllOn(self) -> None: ...
    def AxesOff(self) -> None: ...
    def AxesOn(self) -> None: ...
    def GetAxes(self) -> int: ...
    def GetFocalPoint(self) -> Tuple[float, float, float]: ...
    def GetFocus(self) -> 'vtkPolyData': ...
    def GetModelBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutline(self) -> int: ...
    def GetTranslationMode(self) -> int: ...
    def GetWrap(self) -> int: ...
    def GetXShadows(self) -> int: ...
    def GetYShadows(self) -> int: ...
    def GetZShadows(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCursor3D': ...
    def OutlineOff(self) -> None: ...
    def OutlineOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCursor3D': ...
    def SetAxes(self, _arg:int) -> None: ...
    @overload
    def SetFocalPoint(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetFocalPoint(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetModelBounds(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @overload
    def SetModelBounds(self, bounds:Sequence[float]) -> None: ...
    def SetOutline(self, _arg:int) -> None: ...
    def SetTranslationMode(self, _arg:int) -> None: ...
    def SetWrap(self, _arg:int) -> None: ...
    def SetXShadows(self, _arg:int) -> None: ...
    def SetYShadows(self, _arg:int) -> None: ...
    def SetZShadows(self, _arg:int) -> None: ...
    def TranslationModeOff(self) -> None: ...
    def TranslationModeOn(self) -> None: ...
    def WrapOff(self) -> None: ...
    def WrapOn(self) -> None: ...
    def XShadowsOff(self) -> None: ...
    def XShadowsOn(self) -> None: ...
    def YShadowsOff(self) -> None: ...
    def YShadowsOn(self) -> None: ...
    def ZShadowsOff(self) -> None: ...
    def ZShadowsOn(self) -> None: ...

class vtkCurvatures(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    curvature_type:'getset_descriptor'
    invert_mean_curvature:'getset_descriptor'
    def GetCurvatureType(self) -> int: ...
    def GetInvertMeanCurvature(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InvertMeanCurvatureOff(self) -> None: ...
    def InvertMeanCurvatureOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCurvatures': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCurvatures': ...
    def SetCurvatureType(self, _arg:int) -> None: ...
    def SetCurvatureTypeToGaussian(self) -> None: ...
    def SetCurvatureTypeToMaximum(self) -> None: ...
    def SetCurvatureTypeToMean(self) -> None: ...
    def SetCurvatureTypeToMinimum(self) -> None: ...
    def SetInvertMeanCurvature(self, _arg:int) -> None: ...

class vtkDataSetGradient(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    result_array_name:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetResultArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataSetGradient': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetGradient': ...
    def SetResultArrayName(self, _arg:str) -> None: ...

class vtkDataSetGradientPrecompute(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GradientPrecompute(ds:'vtkDataSet', self_:'vtkDataSetAlgorithm'=...) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataSetGradientPrecompute': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetGradientPrecompute': ...

class vtkDataSetTriangleFilter(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    tetrahedra_only:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTetrahedraOnly(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataSetTriangleFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetTriangleFilter': ...
    def SetTetrahedraOnly(self, _arg:int) -> None: ...
    def TetrahedraOnlyOff(self) -> None: ...
    def TetrahedraOnlyOn(self) -> None: ...

class vtkDateToNumeric(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    date_format:'getset_descriptor'
    def GetDateFormat(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDateToNumeric': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDateToNumeric': ...
    def SetDateFormat(self, _arg:str) -> None: ...

class vtkDeflectNormals(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    scale_factor:'getset_descriptor'
    use_user_normal:'getset_descriptor'
    user_normal:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaleFactor(self) -> float: ...
    def GetUseUserNormal(self) -> bool: ...
    def GetUserNormal(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDeflectNormals': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDeflectNormals': ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetUseUserNormal(self, _arg:bool) -> None: ...
    @overload
    def SetUserNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetUserNormal(self, _arg:Sequence[float]) -> None: ...
    def UseUserNormalOff(self) -> None: ...
    def UseUserNormalOn(self) -> None: ...

class vtkDeformPointSet(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    control_mesh_connection:'getset_descriptor'
    control_mesh_data:'getset_descriptor'
    initialize_weights:'getset_descriptor'
    def GetControlMeshData(self) -> 'vtkPolyData': ...
    def GetInitializeWeights(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InitializeWeightsOff(self) -> None: ...
    def InitializeWeightsOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDeformPointSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDeformPointSet': ...
    def SetControlMeshConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetControlMeshData(self, controlMesh:'vtkPolyData') -> None: ...
    def SetInitializeWeights(self, _arg:int) -> None: ...

class vtkDensifyPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    number_of_subdivisions:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSubdivisions(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDensifyPolyData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDensifyPolyData': ...
    def SetNumberOfSubdivisions(self, _arg:int) -> None: ...

class vtkDicer(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    dice_mode:'getset_descriptor'
    field_data:'getset_descriptor'
    memory_limit:'getset_descriptor'
    number_of_actual_pieces:'getset_descriptor'
    number_of_pieces:'getset_descriptor'
    number_of_pieces_max_value:'getset_descriptor'
    number_of_pieces_min_value:'getset_descriptor'
    number_of_points_per_piece:'getset_descriptor'
    def FieldDataOff(self) -> None: ...
    def FieldDataOn(self) -> None: ...
    def GetDiceMode(self) -> int: ...
    def GetDiceModeMaxValue(self) -> int: ...
    def GetDiceModeMinValue(self) -> int: ...
    def GetFieldData(self) -> int: ...
    def GetMemoryLimit(self) -> int: ...
    def GetMemoryLimitMaxValue(self) -> int: ...
    def GetMemoryLimitMinValue(self) -> int: ...
    def GetNumberOfActualPieces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetNumberOfPiecesMaxValue(self) -> int: ...
    def GetNumberOfPiecesMinValue(self) -> int: ...
    def GetNumberOfPointsPerPiece(self) -> int: ...
    def GetNumberOfPointsPerPieceMaxValue(self) -> int: ...
    def GetNumberOfPointsPerPieceMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDicer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDicer': ...
    def SetDiceMode(self, _arg:int) -> None: ...
    def SetDiceModeToMemoryLimitPerPiece(self) -> None: ...
    def SetDiceModeToNumberOfPointsPerPiece(self) -> None: ...
    def SetDiceModeToSpecifiedNumberOfPieces(self) -> None: ...
    def SetFieldData(self, _arg:int) -> None: ...
    def SetMemoryLimit(self, _arg:int) -> None: ...
    def SetNumberOfPieces(self, _arg:int) -> None: ...
    def SetNumberOfPointsPerPiece(self, _arg:int) -> None: ...

class vtkDiscreteFlyingEdges2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    array_component:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    values:'getset_descriptor'
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDiscreteFlyingEdges2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDiscreteFlyingEdges2D': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkDiscreteFlyingEdges3D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    array_component:'getset_descriptor'
    compute_gradients:'getset_descriptor'
    compute_normals:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    interpolate_attributes:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    values:'getset_descriptor'
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetInterpolateAttributes(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def InterpolateAttributesOff(self) -> None: ...
    def InterpolateAttributesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDiscreteFlyingEdges3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDiscreteFlyingEdges3D': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetInterpolateAttributes(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkDiscreteFlyingEdgesClipper2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    array_component:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    values:'getset_descriptor'
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetArrayComponent(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDiscreteFlyingEdgesClipper2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDiscreteFlyingEdgesClipper2D': ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkDiscreteMarchingCubes(vtkmodules.vtkFiltersCore.vtkMarchingCubes):
    compute_adjacent_scalars:'getset_descriptor'
    def ComputeAdjacentScalarsOff(self) -> None: ...
    def ComputeAdjacentScalarsOn(self) -> None: ...
    def GetComputeAdjacentScalars(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDiscreteMarchingCubes': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDiscreteMarchingCubes': ...
    def SetComputeAdjacentScalars(self, _arg:int) -> None: ...

class vtkDistancePolyDataFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    compute_cell_center_distance:'getset_descriptor'
    compute_direction:'getset_descriptor'
    compute_second_distance:'getset_descriptor'
    negate_distance:'getset_descriptor'
    second_distance_output:'getset_descriptor'
    signed_distance:'getset_descriptor'
    def ComputeCellCenterDistanceOff(self) -> None: ...
    def ComputeCellCenterDistanceOn(self) -> None: ...
    def ComputeDirectionOff(self) -> None: ...
    def ComputeDirectionOn(self) -> None: ...
    def ComputeSecondDistanceOff(self) -> None: ...
    def ComputeSecondDistanceOn(self) -> None: ...
    def GetComputeCellCenterDistance(self) -> int: ...
    def GetComputeDirection(self) -> int: ...
    def GetComputeSecondDistance(self) -> int: ...
    def GetNegateDistance(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSecondDistanceOutput(self) -> 'vtkPolyData': ...
    def GetSignedDistance(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NegateDistanceOff(self) -> None: ...
    def NegateDistanceOn(self) -> None: ...
    def NewInstance(self) -> 'vtkDistancePolyDataFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDistancePolyDataFilter': ...
    def SetComputeCellCenterDistance(self, _arg:int) -> None: ...
    def SetComputeDirection(self, _arg:int) -> None: ...
    def SetComputeSecondDistance(self, _arg:int) -> None: ...
    def SetNegateDistance(self, _arg:int) -> None: ...
    def SetSignedDistance(self, _arg:int) -> None: ...
    def SignedDistanceOff(self) -> None: ...
    def SignedDistanceOn(self) -> None: ...

class vtkEdgePoints(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    value:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEdgePoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEdgePoints': ...
    def SetValue(self, _arg:float) -> None: ...

class vtkEqualizerFilter(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    all_columns:'getset_descriptor'
    array:'getset_descriptor'
    points:'getset_descriptor'
    sampling_frequency:'getset_descriptor'
    spectrum_gain:'getset_descriptor'
    def GetAllColumns(self) -> bool: ...
    def GetArray(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoints(self) -> str: ...
    def GetSamplingFrequency(self) -> int: ...
    def GetSpectrumGain(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEqualizerFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEqualizerFilter': ...
    def SetAllColumns(self, _arg:bool) -> None: ...
    def SetArray(self, arg:str) -> None: ...
    def SetPoints(self, points:str) -> None: ...
    def SetSamplingFrequency(self, _arg:int) -> None: ...
    def SetSpectrumGain(self, _arg:int) -> None: ...

class vtkExtractArray(vtkmodules.vtkCommonExecutionModel.vtkArrayDataAlgorithm):
    index:'getset_descriptor'
    def GetIndex(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractArray': ...
    def SetIndex(self, _arg:int) -> None: ...

class vtkExtractGhostCells(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    output_ghost_array_name:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputGhostArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractGhostCells': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractGhostCells': ...
    def SetOutputGhostArrayName(self, _arg:str) -> None: ...

class vtkExtractSelectionBase(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    preserve_topology:'getset_descriptor'
    selection_connection:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPreserveTopology(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractSelectionBase': ...
    def PreserveTopologyOff(self) -> None: ...
    def PreserveTopologyOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractSelectionBase': ...
    def SetPreserveTopology(self, _arg:int) -> None: ...
    def SetSelectionConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...

class vtkExtractSelectedFrustum(vtkExtractSelectionBase):
    clip_points:'getset_descriptor'
    containing_cells:'getset_descriptor'
    field_type:'getset_descriptor'
    frustum:'getset_descriptor'
    inside_out:'getset_descriptor'
    m_time:'getset_descriptor'
    show_bounds:'getset_descriptor'
    def CreateFrustum(self, vertices:MutableSequence[float]) -> None: ...
    def GetClipPoints(self) -> 'vtkPoints': ...
    def GetContainingCells(self) -> int: ...
    def GetFieldType(self) -> int: ...
    def GetFrustum(self) -> 'vtkPlanes': ...
    def GetInsideOut(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShowBounds(self) -> int: ...
    def InsideOutOff(self) -> None: ...
    def InsideOutOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractSelectedFrustum': ...
    def OverallBoundsTest(self, bounds:MutableSequence[float]) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractSelectedFrustum': ...
    def SetContainingCells(self, _arg:int) -> None: ...
    def SetFieldType(self, _arg:int) -> None: ...
    def SetFrustum(self, __a:'vtkPlanes') -> None: ...
    def SetInsideOut(self, _arg:int) -> None: ...
    def SetShowBounds(self, _arg:int) -> None: ...
    def ShowBoundsOff(self) -> None: ...
    def ShowBoundsOn(self) -> None: ...

class vtkFiniteElementFieldDistributor(vtkmodules.vtkCommonExecutionModel.vtkPartitionedDataSetCollectionAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFiniteElementFieldDistributor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFiniteElementFieldDistributor': ...

class vtkGradientFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class ContributingCellEnum(int): ...
    class ReplacementValueEnum(int): ...
    All:'ContributingCellEnum'
    DataSetMax:'ContributingCellEnum'
    DataTypeMax:'ReplacementValueEnum'
    DataTypeMin:'ReplacementValueEnum'
    NaN:'ReplacementValueEnum'
    Patch:'ContributingCellEnum'
    Zero:'ReplacementValueEnum'
    compute_divergence:'getset_descriptor'
    compute_gradient:'getset_descriptor'
    compute_q_criterion:'getset_descriptor'
    compute_vorticity:'getset_descriptor'
    contributing_cell_option:'getset_descriptor'
    divergence_array_name:'getset_descriptor'
    faster_approximation:'getset_descriptor'
    input_scalars:'getset_descriptor'
    q_criterion_array_name:'getset_descriptor'
    replacement_value_option:'getset_descriptor'
    result_array_name:'getset_descriptor'
    vorticity_array_name:'getset_descriptor'
    def ComputeDivergenceOff(self) -> None: ...
    def ComputeDivergenceOn(self) -> None: ...
    def ComputeGradientOff(self) -> None: ...
    def ComputeGradientOn(self) -> None: ...
    def ComputeQCriterionOff(self) -> None: ...
    def ComputeQCriterionOn(self) -> None: ...
    def ComputeVorticityOff(self) -> None: ...
    def ComputeVorticityOn(self) -> None: ...
    def FasterApproximationOff(self) -> None: ...
    def FasterApproximationOn(self) -> None: ...
    def GetComputeDivergence(self) -> int: ...
    def GetComputeGradient(self) -> int: ...
    def GetComputeQCriterion(self) -> int: ...
    def GetComputeVorticity(self) -> int: ...
    def GetContributingCellOption(self) -> int: ...
    def GetContributingCellOptionMaxValue(self) -> int: ...
    def GetContributingCellOptionMinValue(self) -> int: ...
    def GetDivergenceArrayName(self) -> str: ...
    def GetFasterApproximation(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetQCriterionArrayName(self) -> str: ...
    def GetReplacementValueOption(self) -> int: ...
    def GetReplacementValueOptionMaxValue(self) -> int: ...
    def GetReplacementValueOptionMinValue(self) -> int: ...
    def GetResultArrayName(self) -> str: ...
    def GetVorticityArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGradientFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGradientFilter': ...
    def SetComputeDivergence(self, _arg:int) -> None: ...
    def SetComputeGradient(self, _arg:int) -> None: ...
    def SetComputeQCriterion(self, _arg:int) -> None: ...
    def SetComputeVorticity(self, _arg:int) -> None: ...
    def SetContributingCellOption(self, _arg:int) -> None: ...
    def SetDivergenceArrayName(self, _arg:str) -> None: ...
    def SetFasterApproximation(self, _arg:int) -> None: ...
    @overload
    def SetInputScalars(self, fieldAssociation:int, name:str) -> None: ...
    @overload
    def SetInputScalars(self, fieldAssociation:int, fieldAttributeType:int) -> None: ...
    def SetQCriterionArrayName(self, _arg:str) -> None: ...
    def SetReplacementValueOption(self, _arg:int) -> None: ...
    def SetResultArrayName(self, _arg:str) -> None: ...
    def SetVorticityArrayName(self, _arg:str) -> None: ...

class vtkGraphLayoutFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    automatic_bounds_computation:'getset_descriptor'
    cool_down_rate:'getset_descriptor'
    graph_bounds:'getset_descriptor'
    max_number_of_iterations:'getset_descriptor'
    three_dimensional_layout:'getset_descriptor'
    def AutomaticBoundsComputationOff(self) -> None: ...
    def AutomaticBoundsComputationOn(self) -> None: ...
    def GetAutomaticBoundsComputation(self) -> int: ...
    def GetCoolDownRate(self) -> float: ...
    def GetCoolDownRateMaxValue(self) -> float: ...
    def GetCoolDownRateMinValue(self) -> float: ...
    def GetGraphBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetMaxNumberOfIterations(self) -> int: ...
    def GetMaxNumberOfIterationsMaxValue(self) -> int: ...
    def GetMaxNumberOfIterationsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetThreeDimensionalLayout(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphLayoutFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphLayoutFilter': ...
    def SetAutomaticBoundsComputation(self, _arg:int) -> None: ...
    def SetCoolDownRate(self, _arg:float) -> None: ...
    @overload
    def SetGraphBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetGraphBounds(self, _arg:Sequence[float]) -> None: ...
    def SetMaxNumberOfIterations(self, _arg:int) -> None: ...
    def SetThreeDimensionalLayout(self, _arg:int) -> None: ...
    def ThreeDimensionalLayoutOff(self) -> None: ...
    def ThreeDimensionalLayoutOn(self) -> None: ...

class vtkGraphToPoints(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphToPoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphToPoints': ...

class vtkGraphWeightFilter(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphWeightFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphWeightFilter': ...

class vtkGraphWeightEuclideanDistanceFilter(vtkGraphWeightFilter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphWeightEuclideanDistanceFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphWeightEuclideanDistanceFilter': ...

class vtkGroupDataSetsFilter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    output_type:'getset_descriptor'
    def ClearInputNames(self) -> None: ...
    def GetInputName(self, index:int) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputType(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGroupDataSetsFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGroupDataSetsFilter': ...
    def SetInputName(self, index:int, name:str) -> None: ...
    def SetOutputType(self, _arg:int) -> None: ...
    def SetOutputTypeToMultiBlockDataSet(self) -> None: ...
    def SetOutputTypeToPartitionedDataSet(self) -> None: ...
    def SetOutputTypeToPartitionedDataSetCollection(self) -> None: ...

class vtkGroupTimeStepsFilter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGroupTimeStepsFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGroupTimeStepsFilter': ...

class vtkOverlappingAMRLevelIdScalars(vtkmodules.vtkCommonExecutionModel.vtkOverlappingAMRAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOverlappingAMRLevelIdScalars': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOverlappingAMRLevelIdScalars': ...

class vtkLevelIdScalars(vtkOverlappingAMRLevelIdScalars):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLevelIdScalars': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLevelIdScalars': ...

class vtkHierarchicalDataLevelFilter(vtkLevelIdScalars):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHierarchicalDataLevelFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHierarchicalDataLevelFilter': ...

class vtkHyperStreamline(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    integration_direction:'getset_descriptor'
    integration_eigenvector:'getset_descriptor'
    integration_step_length:'getset_descriptor'
    log_scaling:'getset_descriptor'
    maximum_propagation_distance:'getset_descriptor'
    number_of_sides:'getset_descriptor'
    number_of_sides_max_value:'getset_descriptor'
    number_of_sides_min_value:'getset_descriptor'
    radius:'getset_descriptor'
    start_position:'getset_descriptor'
    step_length:'getset_descriptor'
    terminal_eigenvalue:'getset_descriptor'
    def GetIntegrationDirection(self) -> int: ...
    def GetIntegrationDirectionMaxValue(self) -> int: ...
    def GetIntegrationDirectionMinValue(self) -> int: ...
    def GetIntegrationEigenvector(self) -> int: ...
    def GetIntegrationEigenvectorMaxValue(self) -> int: ...
    def GetIntegrationEigenvectorMinValue(self) -> int: ...
    def GetIntegrationStepLength(self) -> float: ...
    def GetIntegrationStepLengthMaxValue(self) -> float: ...
    def GetIntegrationStepLengthMinValue(self) -> float: ...
    def GetLogScaling(self) -> int: ...
    def GetMaximumPropagationDistance(self) -> float: ...
    def GetMaximumPropagationDistanceMaxValue(self) -> float: ...
    def GetMaximumPropagationDistanceMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSides(self) -> int: ...
    def GetNumberOfSidesMaxValue(self) -> int: ...
    def GetNumberOfSidesMinValue(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetStartLocation(self, subId:int, pcoords:MutableSequence[float]) -> int: ...
    def GetStartPosition(self) -> Tuple[float, float, float]: ...
    def GetStepLength(self) -> float: ...
    def GetStepLengthMaxValue(self) -> float: ...
    def GetStepLengthMinValue(self) -> float: ...
    def GetTerminalEigenvalue(self) -> float: ...
    def GetTerminalEigenvalueMaxValue(self) -> float: ...
    def GetTerminalEigenvalueMinValue(self) -> float: ...
    def IntegrateMajorEigenvector(self) -> None: ...
    def IntegrateMediumEigenvector(self) -> None: ...
    def IntegrateMinorEigenvector(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LogScalingOff(self) -> None: ...
    def LogScalingOn(self) -> None: ...
    def NewInstance(self) -> 'vtkHyperStreamline': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperStreamline': ...
    def SetIntegrationDirection(self, _arg:int) -> None: ...
    def SetIntegrationDirectionToBackward(self) -> None: ...
    def SetIntegrationDirectionToForward(self) -> None: ...
    def SetIntegrationDirectionToIntegrateBothDirections(self) -> None: ...
    def SetIntegrationEigenvector(self, _arg:int) -> None: ...
    def SetIntegrationEigenvectorToMajor(self) -> None: ...
    def SetIntegrationEigenvectorToMedium(self) -> None: ...
    def SetIntegrationEigenvectorToMinor(self) -> None: ...
    def SetIntegrationStepLength(self, _arg:float) -> None: ...
    def SetLogScaling(self, _arg:int) -> None: ...
    def SetMaximumPropagationDistance(self, _arg:float) -> None: ...
    def SetNumberOfSides(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    @overload
    def SetStartLocation(self, cellId:int, subId:int, pcoords:MutableSequence[float]) -> None: ...
    @overload
    def SetStartLocation(self, cellId:int, subId:int, r:float, s:float, t:float) -> None: ...
    @overload
    def SetStartPosition(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetStartPosition(self, x:float, y:float, z:float) -> None: ...
    def SetStepLength(self, _arg:float) -> None: ...
    def SetTerminalEigenvalue(self, _arg:float) -> None: ...

class vtkIconGlyphFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    display_size:'getset_descriptor'
    gravity:'getset_descriptor'
    icon_scaling:'getset_descriptor'
    icon_sheet_size:'getset_descriptor'
    icon_size:'getset_descriptor'
    offset:'getset_descriptor'
    pass_scalars:'getset_descriptor'
    use_icon_size:'getset_descriptor'
    def GetDisplaySize(self) -> Tuple[int, int]: ...
    def GetGravity(self) -> int: ...
    def GetIconScaling(self) -> int: ...
    def GetIconSheetSize(self) -> Tuple[int, int]: ...
    def GetIconSize(self) -> Tuple[int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> Tuple[int, int]: ...
    def GetPassScalars(self) -> bool: ...
    def GetUseIconSize(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIconGlyphFilter': ...
    def PassScalarsOff(self) -> None: ...
    def PassScalarsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIconGlyphFilter': ...
    @overload
    def SetDisplaySize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetDisplaySize(self, _arg:Sequence[int]) -> None: ...
    def SetGravity(self, _arg:int) -> None: ...
    def SetGravityToBottomCenter(self) -> None: ...
    def SetGravityToBottomLeft(self) -> None: ...
    def SetGravityToBottomRight(self) -> None: ...
    def SetGravityToCenterCenter(self) -> None: ...
    def SetGravityToCenterLeft(self) -> None: ...
    def SetGravityToCenterRight(self) -> None: ...
    def SetGravityToTopCenter(self) -> None: ...
    def SetGravityToTopLeft(self) -> None: ...
    def SetGravityToTopRight(self) -> None: ...
    def SetIconScaling(self, _arg:int) -> None: ...
    def SetIconScalingToScalingArray(self) -> None: ...
    def SetIconScalingToScalingOff(self) -> None: ...
    @overload
    def SetIconSheetSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetIconSheetSize(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetIconSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetIconSize(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetOffset(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetOffset(self, _arg:Sequence[int]) -> None: ...
    def SetPassScalars(self, _arg:bool) -> None: ...
    def SetUseIconSize(self, _arg:bool) -> None: ...
    def UseIconSizeOff(self) -> None: ...
    def UseIconSizeOn(self) -> None: ...

class vtkImageDataToPointSet(vtkmodules.vtkCommonExecutionModel.vtkStructuredGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageDataToPointSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageDataToPointSet': ...

class vtkImageMarchingCubes(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    compute_gradients:'getset_descriptor'
    compute_normals:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    input_memory_limit:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    values:'getset_descriptor'
    def AddLocatorPoint(self, cellX:int, cellY:int, edge:int, ptId:int) -> None: ...
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetInputMemoryLimit(self) -> int: ...
    def GetLocatorPoint(self, cellX:int, cellY:int, edge:int) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IncrementLocatorZ(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageMarchingCubes': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageMarchingCubes': ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetInputMemoryLimit(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkInterpolateDataSetAttributes(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    input_list:'getset_descriptor'
    t:'getset_descriptor'
    def GetInputList(self) -> 'vtkDataSetCollection': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetT(self) -> float: ...
    def GetTMaxValue(self) -> float: ...
    def GetTMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInterpolateDataSetAttributes': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInterpolateDataSetAttributes': ...
    def SetT(self, _arg:float) -> None: ...

class vtkInterpolatingSubdivisionFilter(vtkSubdivisionFilter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInterpolatingSubdivisionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInterpolatingSubdivisionFilter': ...

class vtkIntersectionPolyDataFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    check_input:'getset_descriptor'
    check_mesh:'getset_descriptor'
    compute_intersection_point_array:'getset_descriptor'
    number_of_intersection_lines:'getset_descriptor'
    number_of_intersection_points:'getset_descriptor'
    relative_subtriangle_area:'getset_descriptor'
    split_first_output:'getset_descriptor'
    split_second_output:'getset_descriptor'
    status:'getset_descriptor'
    tolerance:'getset_descriptor'
    def CheckInputOff(self) -> None: ...
    def CheckInputOn(self) -> None: ...
    def CheckMeshOff(self) -> None: ...
    def CheckMeshOn(self) -> None: ...
    @staticmethod
    def CleanAndCheckInput(pd:'vtkPolyData', tolerance:float) -> None: ...
    @staticmethod
    def CleanAndCheckSurface(pd:'vtkPolyData', stats:MutableSequence[float], tolerance:float) -> None: ...
    def ComputeIntersectionPointArrayOff(self) -> None: ...
    def ComputeIntersectionPointArrayOn(self) -> None: ...
    def GetCheckInput(self) -> int: ...
    def GetCheckMesh(self) -> int: ...
    def GetComputeIntersectionPointArray(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIntersectionLines(self) -> int: ...
    def GetNumberOfIntersectionPoints(self) -> int: ...
    def GetRelativeSubtriangleArea(self) -> float: ...
    def GetSplitFirstOutput(self) -> int: ...
    def GetSplitSecondOutput(self) -> int: ...
    def GetStatus(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIntersectionPolyDataFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIntersectionPolyDataFilter': ...
    def SetCheckInput(self, _arg:int) -> None: ...
    def SetCheckMesh(self, _arg:int) -> None: ...
    def SetComputeIntersectionPointArray(self, _arg:int) -> None: ...
    def SetRelativeSubtriangleArea(self, _arg:float) -> None: ...
    def SetSplitFirstOutput(self, _arg:int) -> None: ...
    def SetSplitSecondOutput(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SplitFirstOutputOff(self) -> None: ...
    def SplitFirstOutputOn(self) -> None: ...
    def SplitSecondOutputOff(self) -> None: ...
    def SplitSecondOutputOn(self) -> None: ...
    @staticmethod
    def TriangleTriangleIntersection(p1:MutableSequence[float], q1:MutableSequence[float], r1:MutableSequence[float], p2:MutableSequence[float], q2:MutableSequence[float], r2:MutableSequence[float], coplanar:int, pt1:MutableSequence[float], pt2:MutableSequence[float], surfaceid:MutableSequence[float], tolerance:float) -> int: ...

class vtkJoinTables(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    class JoinMode(int): ...
    INTERSECTION:'JoinMode'
    LEFT:'JoinMode'
    RIGHT:'JoinMode'
    UNION:'JoinMode'
    left_key:'getset_descriptor'
    mode:'getset_descriptor'
    replacement_value:'getset_descriptor'
    right_key:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    def GetLeftKey(self) -> str: ...
    def GetMode(self) -> int: ...
    def GetModeMaxValue(self) -> int: ...
    def GetModeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReplacementValue(self) -> float: ...
    def GetRightKey(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkJoinTables': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkJoinTables': ...
    def SetLeftKey(self, arg:str) -> None: ...
    def SetMode(self, _arg:int) -> None: ...
    def SetReplacementValue(self, _arg:float) -> None: ...
    def SetRightKey(self, arg:str) -> None: ...
    def SetSourceConnection(self, source:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkTable') -> None: ...

class vtkLinkEdgels(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    gradient_threshold:'getset_descriptor'
    link_threshold:'getset_descriptor'
    phi_threshold:'getset_descriptor'
    def GetGradientThreshold(self) -> float: ...
    def GetLinkThreshold(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPhiThreshold(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLinkEdgels': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLinkEdgels': ...
    def SetGradientThreshold(self, _arg:float) -> None: ...
    def SetLinkThreshold(self, _arg:float) -> None: ...
    def SetPhiThreshold(self, _arg:float) -> None: ...

class vtkLoopBooleanPolyDataFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class NoIntersectionOutputType(int): ...
    class OperationType(int): ...
    VTK_BOTH:'NoIntersectionOutputType'
    VTK_DIFFERENCE:'OperationType'
    VTK_FIRST:'NoIntersectionOutputType'
    VTK_INTERSECTION:'OperationType'
    VTK_NEITHER:'NoIntersectionOutputType'
    VTK_SECOND:'NoIntersectionOutputType'
    VTK_UNION:'OperationType'
    no_intersection_output:'getset_descriptor'
    number_of_intersection_lines:'getset_descriptor'
    number_of_intersection_points:'getset_descriptor'
    operation:'getset_descriptor'
    status:'getset_descriptor'
    tolerance:'getset_descriptor'
    def GetNoIntersectionOutput(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIntersectionLines(self) -> int: ...
    def GetNumberOfIntersectionPoints(self) -> int: ...
    def GetOperation(self) -> int: ...
    def GetOperationMaxValue(self) -> int: ...
    def GetOperationMinValue(self) -> int: ...
    def GetStatus(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLoopBooleanPolyDataFilter': ...
    def NoIntersectionOutputOff(self) -> None: ...
    def NoIntersectionOutputOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLoopBooleanPolyDataFilter': ...
    def SetNoIntersectionOutput(self, _arg:int) -> None: ...
    def SetOperation(self, _arg:int) -> None: ...
    def SetOperationToDifference(self) -> None: ...
    def SetOperationToIntersection(self) -> None: ...
    def SetOperationToUnion(self) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkMarchingContourFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    compute_gradients:'getset_descriptor'
    compute_normals:'getset_descriptor'
    compute_scalars:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    use_scalar_tree:'getset_descriptor'
    values:'getset_descriptor'
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def ComputeNormalsOff(self) -> None: ...
    def ComputeNormalsOn(self) -> None: ...
    def ComputeScalarsOff(self) -> None: ...
    def ComputeScalarsOn(self) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetComputeGradients(self) -> int: ...
    def GetComputeNormals(self) -> int: ...
    def GetComputeScalars(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseScalarTree(self) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMarchingContourFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMarchingContourFilter': ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetComputeNormals(self, _arg:int) -> None: ...
    def SetComputeScalars(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetUseScalarTree(self, _arg:int) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...
    def UseScalarTreeOff(self) -> None: ...
    def UseScalarTreeOn(self) -> None: ...

class vtkMatricizeArray(vtkmodules.vtkCommonExecutionModel.vtkArrayDataAlgorithm):
    slice_dimension:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSliceDimension(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMatricizeArray': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMatricizeArray': ...
    def SetSliceDimension(self, _arg:int) -> None: ...

class vtkMergeArrays(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMergeArrays': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergeArrays': ...

class vtkMergeCells(vtkmodules.vtkCommonCore.vtkObject):
    merge_duplicate_points:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    point_merge_tolerance:'getset_descriptor'
    total_number_of_cells:'getset_descriptor'
    total_number_of_data_sets:'getset_descriptor'
    total_number_of_points:'getset_descriptor'
    unstructured_grid:'getset_descriptor'
    use_global_cell_ids:'getset_descriptor'
    use_global_ids:'getset_descriptor'
    def Finish(self) -> None: ...
    def GetMergeDuplicatePoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetPointMergeTolerance(self) -> float: ...
    def GetPointMergeToleranceMaxValue(self) -> float: ...
    def GetPointMergeToleranceMinValue(self) -> float: ...
    def GetTotalNumberOfCells(self) -> int: ...
    def GetTotalNumberOfDataSets(self) -> int: ...
    def GetTotalNumberOfPoints(self) -> int: ...
    def GetUnstructuredGrid(self) -> 'vtkUnstructuredGrid': ...
    def GetUseGlobalCellIds(self) -> int: ...
    def GetUseGlobalIds(self) -> int: ...
    def InvalidateCachedLocator(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergeDataSet(self, set:'vtkDataSet') -> int: ...
    def MergeDuplicatePointsOff(self) -> None: ...
    def MergeDuplicatePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkMergeCells': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergeCells': ...
    def SetMergeDuplicatePoints(self, _arg:bool) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetPointMergeTolerance(self, _arg:float) -> None: ...
    def SetTotalNumberOfCells(self, _arg:int) -> None: ...
    def SetTotalNumberOfDataSets(self, _arg:int) -> None: ...
    def SetTotalNumberOfPoints(self, _arg:int) -> None: ...
    def SetUnstructuredGrid(self, __a:'vtkUnstructuredGrid') -> None: ...
    def SetUseGlobalCellIds(self, _arg:int) -> None: ...
    def SetUseGlobalIds(self, _arg:int) -> None: ...
    def UseGlobalCellIdsOff(self) -> None: ...
    def UseGlobalCellIdsOn(self) -> None: ...
    def UseGlobalIdsOff(self) -> None: ...
    def UseGlobalIdsOn(self) -> None: ...

class vtkMergeTimeFilter(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    tolerance:'getset_descriptor'
    use_intersection:'getset_descriptor'
    use_relative_tolerance:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def GetUseIntersection(self) -> bool: ...
    def GetUseRelativeTolerance(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMergeTimeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergeTimeFilter': ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetUseIntersection(self, _arg:bool) -> None: ...
    def SetUseRelativeTolerance(self, _arg:bool) -> None: ...
    def UseIntersectionOff(self) -> None: ...
    def UseIntersectionOn(self) -> None: ...
    def UseRelativeToleranceOff(self) -> None: ...
    def UseRelativeToleranceOn(self) -> None: ...

class vtkMergeVectorComponents(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    attribute_type:'getset_descriptor'
    output_vector_name:'getset_descriptor'
    x_array_name:'getset_descriptor'
    y_array_name:'getset_descriptor'
    z_array_name:'getset_descriptor'
    def GetAttributeType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputVectorName(self) -> str: ...
    def GetXArrayName(self) -> str: ...
    def GetYArrayName(self) -> str: ...
    def GetZArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMergeVectorComponents': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergeVectorComponents': ...
    def SetAttributeType(self, _arg:int) -> None: ...
    def SetAttributeTypeToCellData(self) -> None: ...
    def SetAttributeTypeToPointData(self) -> None: ...
    def SetOutputVectorName(self, _arg:str) -> None: ...
    def SetXArrayName(self, _arg:str) -> None: ...
    def SetYArrayName(self, _arg:str) -> None: ...
    def SetZArrayName(self, _arg:str) -> None: ...

class vtkMultiBlockDataGroupFilter(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMultiBlockDataGroupFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiBlockDataGroupFilter': ...

class vtkMultiBlockMergeFilter(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    @overload
    def AddInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def AddInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMultiBlockMergeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiBlockMergeFilter': ...

class vtkMultiThreshold(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    class SetOperation(int): ...
    class Closure(int): ...
    class Norm(int): ...
    AND:'SetOperation'
    CLOSED:'Closure'
    L1_NORM:'Norm'
    L2_NORM:'Norm'
    LINFINITY_NORM:'Norm'
    NAND:'SetOperation'
    OPEN:'Closure'
    OR:'SetOperation'
    WOR:'SetOperation'
    XOR:'SetOperation'
    def AddBandpassIntervalSet(self, xmin:float, xmax:float, assoc:int, arrayName:str, component:int, allScalars:int) -> int: ...
    def AddBooleanSet(self, operation:int, numInputs:int, inputs:MutableSequence[int]) -> int: ...
    def AddHighpassIntervalSet(self, xmin:float, assoc:int, arrayName:str, component:int, allScalars:int) -> int: ...
    @overload
    def AddIntervalSet(self, xmin:float, xmax:float, omin:int, omax:int, assoc:int, arrayName:str, component:int, allScalars:int) -> int: ...
    @overload
    def AddIntervalSet(self, xmin:float, xmax:float, omin:int, omax:int, assoc:int, attribType:int, component:int, allScalars:int) -> int: ...
    def AddLowpassIntervalSet(self, xmax:float, assoc:int, arrayName:str, component:int, allScalars:int) -> int: ...
    def AddNotchIntervalSet(self, xlo:float, xhi:float, assoc:int, arrayName:str, component:int, allScalars:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMultiThreshold': ...
    def OutputSet(self, setId:int) -> int: ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiThreshold': ...

class vtkNormalizeMatrixVectors(vtkmodules.vtkCommonExecutionModel.vtkArrayDataAlgorithm):
    p_value:'getset_descriptor'
    vector_dimension:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPValue(self) -> float: ...
    def GetVectorDimension(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkNormalizeMatrixVectors': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkNormalizeMatrixVectors': ...
    def SetPValue(self, _arg:float) -> None: ...
    def SetVectorDimension(self, _arg:int) -> None: ...

class vtkOBBDicer(vtkDicer):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOBBDicer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOBBDicer': ...

class vtkOBBNode(object):
    def __init__(self) -> None: ...
    def DebugPrintTree(self, level:int, leaf_vol:MutableSequence[float], minCells:MutableSequence[int], maxCells:MutableSequence[int]) -> None: ...

class vtkOBBTree(vtkmodules.vtkCommonDataModel.vtkAbstractCellLocator):
    def BuildLocator(self) -> None: ...
    @overload
    @staticmethod
    def ComputeOBB(pts:'vtkPoints', corner:MutableSequence[float], max:MutableSequence[float], mid:MutableSequence[float], min:MutableSequence[float], size:MutableSequence[float]) -> None: ...
    @overload
    def ComputeOBB(self, input:'vtkDataSet', corner:MutableSequence[float], max:MutableSequence[float], mid:MutableSequence[float], min:MutableSequence[float], size:MutableSequence[float]) -> None: ...
    def ForceBuildLocator(self) -> None: ...
    def FreeSearchStructure(self) -> None: ...
    def GenerateRepresentation(self, level:int, pd:'vtkPolyData') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InsideOrOutside(self, point:Sequence[float]) -> int: ...
    @overload
    def IntersectWithLine(self, a0:Sequence[float], a1:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int, cell:'vtkGenericCell') -> int: ...
    @overload
    def IntersectWithLine(self, a0:Sequence[float], a1:Sequence[float], points:'vtkPoints', cellIds:'vtkIdList') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, t:float, x:MutableSequence[float], pcoords:MutableSequence[float], subId:int, cellId:int) -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList') -> int: ...
    @overload
    def IntersectWithLine(self, p1:Sequence[float], p2:Sequence[float], tol:float, points:'vtkPoints', cellIds:'vtkIdList', cell:'vtkGenericCell') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOBBTree': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOBBTree': ...

class vtkPassArrays(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    remove_arrays:'getset_descriptor'
    use_field_types:'getset_descriptor'
    def AddArray(self, fieldType:int, name:str) -> None: ...
    def AddCellDataArray(self, name:str) -> None: ...
    def AddFieldDataArray(self, name:str) -> None: ...
    def AddFieldType(self, fieldType:int) -> None: ...
    def AddPointDataArray(self, name:str) -> None: ...
    def ClearArrays(self) -> None: ...
    def ClearCellDataArrays(self) -> None: ...
    def ClearFieldDataArrays(self) -> None: ...
    def ClearFieldTypes(self) -> None: ...
    def ClearPointDataArrays(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRemoveArrays(self) -> bool: ...
    def GetUseFieldTypes(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPassArrays': ...
    def RemoveArray(self, fieldType:int, name:str) -> None: ...
    def RemoveArraysOff(self) -> None: ...
    def RemoveArraysOn(self) -> None: ...
    def RemoveCellDataArray(self, name:str) -> None: ...
    def RemoveFieldDataArray(self, name:str) -> None: ...
    def RemovePointDataArray(self, name:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPassArrays': ...
    def SetRemoveArrays(self, _arg:bool) -> None: ...
    def SetUseFieldTypes(self, _arg:bool) -> None: ...
    def UseFieldTypesOff(self) -> None: ...
    def UseFieldTypesOn(self) -> None: ...

class vtkPassSelectedArrays(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    cell_data_array_selection:'getset_descriptor'
    edge_data_array_selection:'getset_descriptor'
    enabled:'getset_descriptor'
    field_data_array_selection:'getset_descriptor'
    point_data_array_selection:'getset_descriptor'
    row_data_array_selection:'getset_descriptor'
    vertex_data_array_selection:'getset_descriptor'
    def EnabledOff(self) -> None: ...
    def EnabledOn(self) -> None: ...
    def GetArraySelection(self, association:int) -> 'vtkDataArraySelection': ...
    def GetCellDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetEdgeDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetEnabled(self) -> bool: ...
    def GetFieldDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetRowDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetVertexDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPassSelectedArrays': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPassSelectedArrays': ...
    def SetEnabled(self, _arg:bool) -> None: ...

class vtkPointConnectivityFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointConnectivityFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointConnectivityFilter': ...

class vtkPolyDataStreamer(vtkmodules.vtkFiltersCore.vtkStreamerBase):
    color_by_piece:'getset_descriptor'
    number_of_stream_divisions:'getset_descriptor'
    def ColorByPieceOff(self) -> None: ...
    def ColorByPieceOn(self) -> None: ...
    def GetColorByPiece(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfStreamDivisions(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataStreamer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataStreamer': ...
    def SetColorByPiece(self, _arg:int) -> None: ...
    def SetNumberOfStreamDivisions(self, num:int) -> None: ...

class vtkPolyDataToReebGraphFilter(vtkmodules.vtkCommonExecutionModel.vtkDirectedGraphAlgorithm):
    field_id:'getset_descriptor'
    output:'getset_descriptor'
    def GetFieldId(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self) -> 'vtkReebGraph': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataToReebGraphFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataToReebGraphFilter': ...
    def SetFieldId(self, _arg:int) -> None: ...

class vtkProbePolyhedron(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    probe_cell_data:'getset_descriptor'
    probe_point_data:'getset_descriptor'
    source:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProbeCellData(self) -> int: ...
    def GetProbePointData(self) -> int: ...
    def GetSource(self) -> 'vtkPolyData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProbePolyhedron': ...
    def ProbeCellDataOff(self) -> None: ...
    def ProbeCellDataOn(self) -> None: ...
    def ProbePointDataOff(self) -> None: ...
    def ProbePointDataOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProbePolyhedron': ...
    def SetProbeCellData(self, _arg:int) -> None: ...
    def SetProbePointData(self, _arg:int) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSourceData(self, source:'vtkPolyData') -> None: ...

class vtkQuadraturePointInterpolator(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadraturePointInterpolator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadraturePointInterpolator': ...

class vtkQuadraturePointsGenerator(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadraturePointsGenerator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadraturePointsGenerator': ...

class vtkQuadratureSchemeDictionaryGenerator(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadratureSchemeDictionaryGenerator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadratureSchemeDictionaryGenerator': ...

class vtkQuantizePolyDataPoints(vtkmodules.vtkFiltersCore.vtkCleanPolyData):
    q_factor:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetQFactor(self) -> float: ...
    def GetQFactorMaxValue(self) -> float: ...
    def GetQFactorMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuantizePolyDataPoints': ...
    def OperateOnBounds(self, in_:MutableSequence[float], out:MutableSequence[float]) -> None: ...
    def OperateOnPoint(self, in_:MutableSequence[float], out:MutableSequence[float]) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuantizePolyDataPoints': ...
    def SetQFactor(self, _arg:float) -> None: ...

class vtkRandomAttributeGenerator(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    attributes_constant_per_block:'getset_descriptor'
    component_range:'getset_descriptor'
    data_type:'getset_descriptor'
    generate_cell_array:'getset_descriptor'
    generate_cell_normals:'getset_descriptor'
    generate_cell_scalars:'getset_descriptor'
    generate_cell_t_coords:'getset_descriptor'
    generate_cell_tensors:'getset_descriptor'
    generate_cell_vectors:'getset_descriptor'
    generate_field_array:'getset_descriptor'
    generate_point_array:'getset_descriptor'
    generate_point_normals:'getset_descriptor'
    generate_point_scalars:'getset_descriptor'
    generate_point_t_coords:'getset_descriptor'
    generate_point_tensors:'getset_descriptor'
    generate_point_vectors:'getset_descriptor'
    maximum_component_value:'getset_descriptor'
    minimum_component_value:'getset_descriptor'
    number_of_components:'getset_descriptor'
    number_of_components_max_value:'getset_descriptor'
    number_of_components_min_value:'getset_descriptor'
    number_of_tuples:'getset_descriptor'
    number_of_tuples_max_value:'getset_descriptor'
    number_of_tuples_min_value:'getset_descriptor'
    def AttributesConstantPerBlockOff(self) -> None: ...
    def AttributesConstantPerBlockOn(self) -> None: ...
    def GenerateAllCellDataOff(self) -> None: ...
    def GenerateAllCellDataOn(self) -> None: ...
    def GenerateAllDataOff(self) -> None: ...
    def GenerateAllDataOn(self) -> None: ...
    def GenerateAllPointDataOff(self) -> None: ...
    def GenerateAllPointDataOn(self) -> None: ...
    def GenerateCellArrayOff(self) -> None: ...
    def GenerateCellArrayOn(self) -> None: ...
    def GenerateCellNormalsOff(self) -> None: ...
    def GenerateCellNormalsOn(self) -> None: ...
    def GenerateCellScalarsOff(self) -> None: ...
    def GenerateCellScalarsOn(self) -> None: ...
    def GenerateCellTCoordsOff(self) -> None: ...
    def GenerateCellTCoordsOn(self) -> None: ...
    def GenerateCellTensorsOff(self) -> None: ...
    def GenerateCellTensorsOn(self) -> None: ...
    def GenerateCellVectorsOff(self) -> None: ...
    def GenerateCellVectorsOn(self) -> None: ...
    def GenerateFieldArrayOff(self) -> None: ...
    def GenerateFieldArrayOn(self) -> None: ...
    def GeneratePointArrayOff(self) -> None: ...
    def GeneratePointArrayOn(self) -> None: ...
    def GeneratePointNormalsOff(self) -> None: ...
    def GeneratePointNormalsOn(self) -> None: ...
    def GeneratePointScalarsOff(self) -> None: ...
    def GeneratePointScalarsOn(self) -> None: ...
    def GeneratePointTCoordsOff(self) -> None: ...
    def GeneratePointTCoordsOn(self) -> None: ...
    def GeneratePointTensorsOff(self) -> None: ...
    def GeneratePointTensorsOn(self) -> None: ...
    def GeneratePointVectorsOff(self) -> None: ...
    def GeneratePointVectorsOn(self) -> None: ...
    def GetAttributesConstantPerBlock(self) -> bool: ...
    def GetDataType(self) -> int: ...
    def GetGenerateCellArray(self) -> int: ...
    def GetGenerateCellNormals(self) -> int: ...
    def GetGenerateCellScalars(self) -> int: ...
    def GetGenerateCellTCoords(self) -> int: ...
    def GetGenerateCellTensors(self) -> int: ...
    def GetGenerateCellVectors(self) -> int: ...
    def GetGenerateFieldArray(self) -> int: ...
    def GetGeneratePointArray(self) -> int: ...
    def GetGeneratePointNormals(self) -> int: ...
    def GetGeneratePointScalars(self) -> int: ...
    def GetGeneratePointTCoords(self) -> int: ...
    def GetGeneratePointTensors(self) -> int: ...
    def GetGeneratePointVectors(self) -> int: ...
    def GetMaximumComponentValue(self) -> float: ...
    def GetMinimumComponentValue(self) -> float: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfComponentsMaxValue(self) -> int: ...
    def GetNumberOfComponentsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetNumberOfTuplesMaxValue(self) -> int: ...
    def GetNumberOfTuplesMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRandomAttributeGenerator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRandomAttributeGenerator': ...
    def SetAttributesConstantPerBlock(self, _arg:bool) -> None: ...
    def SetComponentRange(self, minimumValue:float, maximumValue:float) -> None: ...
    def SetDataType(self, _arg:int) -> None: ...
    def SetDataTypeToBit(self) -> None: ...
    def SetDataTypeToChar(self) -> None: ...
    def SetDataTypeToDouble(self) -> None: ...
    def SetDataTypeToFloat(self) -> None: ...
    def SetDataTypeToIdType(self) -> None: ...
    def SetDataTypeToInt(self) -> None: ...
    def SetDataTypeToLong(self) -> None: ...
    def SetDataTypeToLongLong(self) -> None: ...
    def SetDataTypeToShort(self) -> None: ...
    def SetDataTypeToUnsignedChar(self) -> None: ...
    def SetDataTypeToUnsignedInt(self) -> None: ...
    def SetDataTypeToUnsignedLong(self) -> None: ...
    def SetDataTypeToUnsignedLongLong(self) -> None: ...
    def SetDataTypeToUnsignedShort(self) -> None: ...
    def SetGenerateCellArray(self, _arg:int) -> None: ...
    def SetGenerateCellNormals(self, _arg:int) -> None: ...
    def SetGenerateCellScalars(self, _arg:int) -> None: ...
    def SetGenerateCellTCoords(self, _arg:int) -> None: ...
    def SetGenerateCellTensors(self, _arg:int) -> None: ...
    def SetGenerateCellVectors(self, _arg:int) -> None: ...
    def SetGenerateFieldArray(self, _arg:int) -> None: ...
    def SetGeneratePointArray(self, _arg:int) -> None: ...
    def SetGeneratePointNormals(self, _arg:int) -> None: ...
    def SetGeneratePointScalars(self, _arg:int) -> None: ...
    def SetGeneratePointTCoords(self, _arg:int) -> None: ...
    def SetGeneratePointTensors(self, _arg:int) -> None: ...
    def SetGeneratePointVectors(self, _arg:int) -> None: ...
    def SetMaximumComponentValue(self, _arg:float) -> None: ...
    def SetMinimumComponentValue(self, _arg:float) -> None: ...
    def SetNumberOfComponents(self, _arg:int) -> None: ...
    def SetNumberOfTuples(self, _arg:int) -> None: ...

class vtkRectilinearGridClip(vtkmodules.vtkCommonExecutionModel.vtkRectilinearGridAlgorithm):
    clip_data:'getset_descriptor'
    output_whole_extent:'getset_descriptor'
    def ClipDataOff(self) -> None: ...
    def ClipDataOn(self) -> None: ...
    def GetClipData(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutputWholeExtent(self, extent:MutableSequence[int]) -> None: ...
    @overload
    def GetOutputWholeExtent(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRectilinearGridClip': ...
    def ResetOutputWholeExtent(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRectilinearGridClip': ...
    def SetClipData(self, _arg:int) -> None: ...
    @overload
    def SetOutputWholeExtent(self, extent:MutableSequence[int], outInfo:'vtkInformation'=...) -> None: ...
    @overload
    def SetOutputWholeExtent(self, minX:int, maxX:int, minY:int, maxY:int, minZ:int, maxZ:int) -> None: ...

class vtkRectilinearGridToPointSet(vtkmodules.vtkCommonExecutionModel.vtkStructuredGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRectilinearGridToPointSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRectilinearGridToPointSet': ...

class vtkRectilinearGridToTetrahedra(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    input:'getset_descriptor'
    remember_voxel_id:'getset_descriptor'
    tetra_per_cell:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRememberVoxelId(self) -> int: ...
    def GetTetraPerCell(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRectilinearGridToTetrahedra': ...
    def RememberVoxelIdOff(self) -> None: ...
    def RememberVoxelIdOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRectilinearGridToTetrahedra': ...
    @overload
    def SetInput(self, Extent:Sequence[float], Spacing:Sequence[float], tol:float=0.001) -> None: ...
    @overload
    def SetInput(self, ExtentX:float, ExtentY:float, ExtentZ:float, SpacingX:float, SpacingY:float, SpacingZ:float, tol:float=0.001) -> None: ...
    def SetRememberVoxelId(self, _arg:int) -> None: ...
    def SetTetraPerCell(self, _arg:int) -> None: ...
    def SetTetraPerCellTo12(self) -> None: ...
    def SetTetraPerCellTo5(self) -> None: ...
    def SetTetraPerCellTo5And12(self) -> None: ...
    def SetTetraPerCellTo6(self) -> None: ...

class vtkRecursiveDividingCubes(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    distance:'getset_descriptor'
    increment:'getset_descriptor'
    value:'getset_descriptor'
    def GetDistance(self) -> float: ...
    def GetDistanceMaxValue(self) -> float: ...
    def GetDistanceMinValue(self) -> float: ...
    def GetIncrement(self) -> int: ...
    def GetIncrementMaxValue(self) -> int: ...
    def GetIncrementMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRecursiveDividingCubes': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRecursiveDividingCubes': ...
    def SetDistance(self, _arg:float) -> None: ...
    def SetIncrement(self, _arg:int) -> None: ...
    def SetValue(self, _arg:float) -> None: ...

class vtkReflectionFilter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    class ReflectionPlane(int): ...
    USE_X:'ReflectionPlane'
    USE_X_MAX:'ReflectionPlane'
    USE_X_MIN:'ReflectionPlane'
    USE_Y:'ReflectionPlane'
    USE_Y_MAX:'ReflectionPlane'
    USE_Y_MIN:'ReflectionPlane'
    USE_Z:'ReflectionPlane'
    USE_Z_MAX:'ReflectionPlane'
    USE_Z_MIN:'ReflectionPlane'
    center:'getset_descriptor'
    copy_input:'getset_descriptor'
    flip_all_input_arrays:'getset_descriptor'
    plane:'getset_descriptor'
    def CopyInputOff(self) -> None: ...
    def CopyInputOn(self) -> None: ...
    def FlipAllInputArraysOff(self) -> None: ...
    def FlipAllInputArraysOn(self) -> None: ...
    def GetCenter(self) -> float: ...
    def GetCopyInput(self) -> int: ...
    def GetFlipAllInputArrays(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlane(self) -> int: ...
    def GetPlaneMaxValue(self) -> int: ...
    def GetPlaneMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkReflectionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkReflectionFilter': ...
    def SetCenter(self, _arg:float) -> None: ...
    def SetCopyInput(self, _arg:int) -> None: ...
    def SetFlipAllInputArrays(self, _arg:bool) -> None: ...
    def SetPlane(self, _arg:int) -> None: ...
    def SetPlaneToX(self) -> None: ...
    def SetPlaneToXMax(self) -> None: ...
    def SetPlaneToXMin(self) -> None: ...
    def SetPlaneToY(self) -> None: ...
    def SetPlaneToYMax(self) -> None: ...
    def SetPlaneToYMin(self) -> None: ...
    def SetPlaneToZ(self) -> None: ...
    def SetPlaneToZMax(self) -> None: ...
    def SetPlaneToZMin(self) -> None: ...

class vtkRemovePolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    cell_ids:'getset_descriptor'
    exact_match:'getset_descriptor'
    input:'getset_descriptor'
    point_ids:'getset_descriptor'
    def ExactMatchOff(self) -> None: ...
    def ExactMatchOn(self) -> None: ...
    def GetCellIds(self) -> 'vtkIdTypeArray': ...
    def GetExactMatch(self) -> bool: ...
    @overload
    def GetInput(self, idx:int) -> 'vtkPolyData': ...
    @overload
    def GetInput(self) -> 'vtkPolyData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointIds(self) -> 'vtkIdTypeArray': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRemovePolyData': ...
    def RemoveInputData(self, __a:'vtkPolyData') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRemovePolyData': ...
    def SetCellIds(self, __a:'vtkIdTypeArray') -> None: ...
    def SetExactMatch(self, _arg:bool) -> None: ...
    def SetPointIds(self, __a:'vtkIdTypeArray') -> None: ...

class vtkRotationFilter(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    class RotationAxis(int): ...
    USE_X:'RotationAxis'
    USE_Y:'RotationAxis'
    USE_Z:'RotationAxis'
    angle:'getset_descriptor'
    axis:'getset_descriptor'
    center:'getset_descriptor'
    copy_input:'getset_descriptor'
    number_of_copies:'getset_descriptor'
    def CopyInputOff(self) -> None: ...
    def CopyInputOn(self) -> None: ...
    def GetAngle(self) -> float: ...
    def GetAxis(self) -> int: ...
    def GetAxisMaxValue(self) -> int: ...
    def GetAxisMinValue(self) -> int: ...
    def GetCenter(self) -> Tuple[float, float, float]: ...
    def GetCopyInput(self) -> int: ...
    def GetNumberOfCopies(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRotationFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRotationFilter': ...
    def SetAngle(self, _arg:float) -> None: ...
    def SetAxis(self, _arg:int) -> None: ...
    def SetAxisToX(self) -> None: ...
    def SetAxisToY(self) -> None: ...
    def SetAxisToZ(self) -> None: ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:Sequence[float]) -> None: ...
    def SetCopyInput(self, _arg:int) -> None: ...
    def SetNumberOfCopies(self, _arg:int) -> None: ...

class vtkSampleImplicitFunctionFilter(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    compute_gradients:'getset_descriptor'
    gradient_array_name:'getset_descriptor'
    implicit_function:'getset_descriptor'
    m_time:'getset_descriptor'
    scalar_array_name:'getset_descriptor'
    def ComputeGradientsOff(self) -> None: ...
    def ComputeGradientsOn(self) -> None: ...
    def GetComputeGradients(self) -> int: ...
    def GetGradientArrayName(self) -> str: ...
    def GetImplicitFunction(self) -> 'vtkImplicitFunction': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarArrayName(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSampleImplicitFunctionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSampleImplicitFunctionFilter': ...
    def SetComputeGradients(self, _arg:int) -> None: ...
    def SetGradientArrayName(self, _arg:str) -> None: ...
    def SetImplicitFunction(self, __a:'vtkImplicitFunction') -> None: ...
    def SetScalarArrayName(self, _arg:str) -> None: ...

class vtkShrinkFilter(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    shrink_factor:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShrinkFactor(self) -> float: ...
    def GetShrinkFactorMaxValue(self) -> float: ...
    def GetShrinkFactorMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkShrinkFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkShrinkFilter': ...
    def SetShrinkFactor(self, _arg:float) -> None: ...

class vtkShrinkPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    shrink_factor:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShrinkFactor(self) -> float: ...
    def GetShrinkFactorMaxValue(self) -> float: ...
    def GetShrinkFactorMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkShrinkPolyData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkShrinkPolyData': ...
    def SetShrinkFactor(self, _arg:float) -> None: ...

class vtkSpatialRepresentationFilter(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    generate_leaves:'getset_descriptor'
    maximum_level:'getset_descriptor'
    spatial_representation:'getset_descriptor'
    def AddLevel(self, level:int) -> None: ...
    def GenerateLeavesOff(self) -> None: ...
    def GenerateLeavesOn(self) -> None: ...
    def GetGenerateLeaves(self) -> bool: ...
    def GetMaximumLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSpatialRepresentation(self) -> 'vtkLocator': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSpatialRepresentationFilter': ...
    def ResetLevels(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSpatialRepresentationFilter': ...
    def SetGenerateLeaves(self, _arg:bool) -> None: ...
    def SetSpatialRepresentation(self, __a:'vtkLocator') -> None: ...

class vtkSpatioTemporalHarmonicsAttribute(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    def AddHarmonic(self, amplitude:float, temporalFrequency:float, xWaveVector:float, yWaveVector:float, zWaveVector:float, phase:float) -> None: ...
    def ClearHarmonics(self) -> None: ...
    def ComputeValue(self, coords:MutableSequence[float], time:float) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasHarmonics(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSpatioTemporalHarmonicsAttribute': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSpatioTemporalHarmonicsAttribute': ...

class vtkSphericalHarmonics(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSphericalHarmonics': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSphericalHarmonics': ...

class vtkSplineFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    generate_t_coords:'getset_descriptor'
    length:'getset_descriptor'
    maximum_number_of_subdivisions:'getset_descriptor'
    number_of_subdivisions:'getset_descriptor'
    number_of_subdivisions_max_value:'getset_descriptor'
    number_of_subdivisions_min_value:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    spline:'getset_descriptor'
    subdivide:'getset_descriptor'
    texture_length:'getset_descriptor'
    def GetGenerateTCoords(self) -> int: ...
    def GetGenerateTCoordsAsString(self) -> str: ...
    def GetGenerateTCoordsMaxValue(self) -> int: ...
    def GetGenerateTCoordsMinValue(self) -> int: ...
    def GetLength(self) -> float: ...
    def GetLengthMaxValue(self) -> float: ...
    def GetLengthMinValue(self) -> float: ...
    def GetMaximumNumberOfSubdivisions(self) -> int: ...
    def GetMaximumNumberOfSubdivisionsMaxValue(self) -> int: ...
    def GetMaximumNumberOfSubdivisionsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSubdivisions(self) -> int: ...
    def GetNumberOfSubdivisionsMaxValue(self) -> int: ...
    def GetNumberOfSubdivisionsMinValue(self) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetSpline(self) -> 'vtkSpline': ...
    def GetSubdivide(self) -> int: ...
    def GetSubdivideAsString(self) -> str: ...
    def GetSubdivideMaxValue(self) -> int: ...
    def GetSubdivideMinValue(self) -> int: ...
    def GetTextureLength(self) -> float: ...
    def GetTextureLengthMaxValue(self) -> float: ...
    def GetTextureLengthMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSplineFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSplineFilter': ...
    def SetGenerateTCoords(self, _arg:int) -> None: ...
    def SetGenerateTCoordsToNormalizedLength(self) -> None: ...
    def SetGenerateTCoordsToOff(self) -> None: ...
    def SetGenerateTCoordsToUseLength(self) -> None: ...
    def SetGenerateTCoordsToUseScalars(self) -> None: ...
    def SetLength(self, _arg:float) -> None: ...
    def SetMaximumNumberOfSubdivisions(self, _arg:int) -> None: ...
    def SetNumberOfSubdivisions(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetSpline(self, __a:'vtkSpline') -> None: ...
    def SetSubdivide(self, _arg:int) -> None: ...
    def SetSubdivideToLength(self) -> None: ...
    def SetSubdivideToSpecified(self) -> None: ...
    def SetTextureLength(self, _arg:float) -> None: ...

class vtkSplitByCellScalarFilter(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    pass_all_points:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassAllPoints(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSplitByCellScalarFilter': ...
    def PassAllPointsOff(self) -> None: ...
    def PassAllPointsOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSplitByCellScalarFilter': ...
    def SetPassAllPoints(self, _arg:bool) -> None: ...

class vtkSplitColumnComponents(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    NAMES_WITH_PARENS:int
    NAMES_WITH_UNDERSCORES:int
    NUMBERS_WITH_PARENS:int
    NUMBERS_WITH_UNDERSCORES:int
    calculate_magnitudes:'getset_descriptor'
    naming_mode:'getset_descriptor'
    def CalculateMagnitudesOff(self) -> None: ...
    def CalculateMagnitudesOn(self) -> None: ...
    def GetCalculateMagnitudes(self) -> bool: ...
    def GetNamingMode(self) -> int: ...
    def GetNamingModeMaxValue(self) -> int: ...
    def GetNamingModeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSplitColumnComponents': ...
    @staticmethod
    def ORIGINAL_ARRAY_NAME() -> 'vtkInformationStringKey': ...
    @staticmethod
    def ORIGINAL_COMPONENT_NUMBER() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSplitColumnComponents': ...
    def SetCalculateMagnitudes(self, _arg:bool) -> None: ...
    def SetNamingMode(self, _arg:int) -> None: ...
    def SetNamingModeToNamesWithParens(self) -> None: ...
    def SetNamingModeToNamesWithUnderscores(self) -> None: ...
    def SetNamingModeToNumberWithParens(self) -> None: ...
    def SetNamingModeToNumberWithUnderscores(self) -> None: ...

class vtkSplitField(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    class FieldLocations(int): ...
    CELL_DATA:'FieldLocations'
    DATA_OBJECT:'FieldLocations'
    POINT_DATA:'FieldLocations'
    input_field:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSplitField': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSplitField': ...
    @overload
    def SetInputField(self, attributeType:int, fieldLoc:int) -> None: ...
    @overload
    def SetInputField(self, name:str, fieldLoc:int) -> None: ...
    @overload
    def SetInputField(self, name:str, fieldLoc:str) -> None: ...
    def Split(self, component:int, arrayName:str) -> None: ...

class vtkStructuredGridClip(vtkmodules.vtkCommonExecutionModel.vtkStructuredGridAlgorithm):
    clip_data:'getset_descriptor'
    output_whole_extent:'getset_descriptor'
    def ClipDataOff(self) -> None: ...
    def ClipDataOn(self) -> None: ...
    def GetClipData(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOutputWholeExtent(self, extent:MutableSequence[int]) -> None: ...
    @overload
    def GetOutputWholeExtent(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStructuredGridClip': ...
    def ResetOutputWholeExtent(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStructuredGridClip': ...
    def SetClipData(self, _arg:int) -> None: ...
    @overload
    def SetOutputWholeExtent(self, extent:MutableSequence[int], outInfo:'vtkInformation'=...) -> None: ...
    @overload
    def SetOutputWholeExtent(self, minX:int, maxX:int, minY:int, maxY:int, minZ:int, maxZ:int) -> None: ...

class vtkSubPixelPositionEdgels(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    grad_maps:'getset_descriptor'
    grad_maps_data:'getset_descriptor'
    target_flag:'getset_descriptor'
    target_value:'getset_descriptor'
    def GetGradMaps(self) -> 'vtkStructuredPoints': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTargetFlag(self) -> int: ...
    def GetTargetValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSubPixelPositionEdgels': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSubPixelPositionEdgels': ...
    def SetGradMapsData(self, gm:'vtkStructuredPoints') -> None: ...
    def SetTargetFlag(self, _arg:int) -> None: ...
    def SetTargetValue(self, _arg:float) -> None: ...
    def TargetFlagOff(self) -> None: ...
    def TargetFlagOn(self) -> None: ...

class vtkSynchronizeTimeFilter(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    relative_tolerance:'getset_descriptor'
    source_connection:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRelativeTolerance(self) -> float: ...
    def GetRelativeToleranceMaxValue(self) -> float: ...
    def GetRelativeToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSynchronizeTimeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSynchronizeTimeFilter': ...
    def SetRelativeTolerance(self, _arg:float) -> None: ...
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...

class vtkTableBasedClipDataSet(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    batch_size:'getset_descriptor'
    clip_function:'getset_descriptor'
    clipped_output:'getset_descriptor'
    generate_clip_scalars:'getset_descriptor'
    generate_clipped_output:'getset_descriptor'
    inside_out:'getset_descriptor'
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    merge_tolerance:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    use_value_as_offset:'getset_descriptor'
    value:'getset_descriptor'
    def GenerateClipScalarsOff(self) -> None: ...
    def GenerateClipScalarsOn(self) -> None: ...
    def GenerateClippedOutputOff(self) -> None: ...
    def GenerateClippedOutputOn(self) -> None: ...
    def GetBatchSize(self) -> int: ...
    def GetBatchSizeMaxValue(self) -> int: ...
    def GetBatchSizeMinValue(self) -> int: ...
    def GetClipFunction(self) -> 'vtkImplicitFunction': ...
    def GetClippedOutput(self) -> 'vtkUnstructuredGrid': ...
    def GetGenerateClipScalars(self) -> int: ...
    def GetGenerateClippedOutput(self) -> int: ...
    def GetInsideOut(self) -> int: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetMergeTolerance(self) -> float: ...
    def GetMergeToleranceMaxValue(self) -> float: ...
    def GetMergeToleranceMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def GetUseValueAsOffset(self) -> bool: ...
    def GetValue(self) -> float: ...
    def InsideOutOff(self) -> None: ...
    def InsideOutOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTableBasedClipDataSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTableBasedClipDataSet': ...
    def SetBatchSize(self, _arg:int) -> None: ...
    def SetClipFunction(self, __a:'vtkImplicitFunction') -> None: ...
    def SetGenerateClipScalars(self, _arg:int) -> None: ...
    def SetGenerateClippedOutput(self, _arg:int) -> None: ...
    def SetInsideOut(self, _arg:int) -> None: ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetMergeTolerance(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetUseValueAsOffset(self, _arg:bool) -> None: ...
    def SetValue(self, _arg:float) -> None: ...
    def UseValueAsOffsetOff(self) -> None: ...
    def UseValueAsOffsetOn(self) -> None: ...

class vtkTableFFT(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    BARTLETT:int
    BLACKMAN:int
    HANNING:int
    MAX_WINDOWING_FUNCTION:int
    RECTANGULAR:int
    SINE:int
    average_fft:'getset_descriptor'
    block_overlap:'getset_descriptor'
    block_size:'getset_descriptor'
    create_frequency_column:'getset_descriptor'
    default_sample_rate:'getset_descriptor'
    detrend:'getset_descriptor'
    normalize:'getset_descriptor'
    number_of_block:'getset_descriptor'
    optimize_for_real_input:'getset_descriptor'
    return_onesided:'getset_descriptor'
    scaling_method:'getset_descriptor'
    windowing_function:'getset_descriptor'
    def AverageFftOff(self) -> None: ...
    def AverageFftOn(self) -> None: ...
    def CreateFrequencyColumnOff(self) -> None: ...
    def CreateFrequencyColumnOn(self) -> None: ...
    def DetrendOff(self) -> None: ...
    def DetrendOn(self) -> None: ...
    def GetAverageFft(self) -> bool: ...
    def GetBlockOverlap(self) -> int: ...
    def GetBlockSize(self) -> int: ...
    def GetCreateFrequencyColumn(self) -> bool: ...
    def GetDefaultSampleRate(self) -> float: ...
    def GetDetrend(self) -> bool: ...
    def GetNormalize(self) -> bool: ...
    def GetNumberOfBlock(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOptimizeForRealInput(self) -> bool: ...
    def GetReturnOnesided(self) -> bool: ...
    def GetScalingMethod(self) -> int: ...
    def GetScalingMethodMaxValue(self) -> int: ...
    def GetScalingMethodMinValue(self) -> int: ...
    def GetWindowingFunction(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTableFFT': ...
    def NormalizeOff(self) -> None: ...
    def NormalizeOn(self) -> None: ...
    def OptimizeForRealInputOff(self) -> None: ...
    def OptimizeForRealInputOn(self) -> None: ...
    def ReturnOnesidedOff(self) -> None: ...
    def ReturnOnesidedOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTableFFT': ...
    def SetAverageFft(self, __a:bool) -> None: ...
    def SetBlockOverlap(self, _arg:int) -> None: ...
    def SetBlockSize(self, __a:int) -> None: ...
    def SetCreateFrequencyColumn(self, _arg:bool) -> None: ...
    def SetDefaultSampleRate(self, _arg:float) -> None: ...
    def SetDetrend(self, _arg:bool) -> None: ...
    def SetNormalize(self, _arg:bool) -> None: ...
    def SetNumberOfBlock(self, __a:int) -> None: ...
    def SetOptimizeForRealInput(self, _arg:bool) -> None: ...
    def SetReturnOnesided(self, _arg:bool) -> None: ...
    def SetScalingMethod(self, _arg:int) -> None: ...
    def SetWindowingFunction(self, __a:int) -> None: ...

class vtkTableToPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    create2d_points:'getset_descriptor'
    preserve_coordinate_columns_as_data_arrays:'getset_descriptor'
    x_column:'getset_descriptor'
    x_column_index:'getset_descriptor'
    x_component:'getset_descriptor'
    y_column:'getset_descriptor'
    y_column_index:'getset_descriptor'
    y_component:'getset_descriptor'
    z_column:'getset_descriptor'
    z_column_index:'getset_descriptor'
    z_component:'getset_descriptor'
    def Create2DPointsOff(self) -> None: ...
    def Create2DPointsOn(self) -> None: ...
    def GetCreate2DPoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPreserveCoordinateColumnsAsDataArrays(self) -> bool: ...
    def GetXColumn(self) -> str: ...
    def GetXColumnIndex(self) -> int: ...
    def GetXColumnIndexMaxValue(self) -> int: ...
    def GetXColumnIndexMinValue(self) -> int: ...
    def GetXComponent(self) -> int: ...
    def GetXComponentMaxValue(self) -> int: ...
    def GetXComponentMinValue(self) -> int: ...
    def GetYColumn(self) -> str: ...
    def GetYColumnIndex(self) -> int: ...
    def GetYColumnIndexMaxValue(self) -> int: ...
    def GetYColumnIndexMinValue(self) -> int: ...
    def GetYComponent(self) -> int: ...
    def GetYComponentMaxValue(self) -> int: ...
    def GetYComponentMinValue(self) -> int: ...
    def GetZColumn(self) -> str: ...
    def GetZColumnIndex(self) -> int: ...
    def GetZColumnIndexMaxValue(self) -> int: ...
    def GetZColumnIndexMinValue(self) -> int: ...
    def GetZComponent(self) -> int: ...
    def GetZComponentMaxValue(self) -> int: ...
    def GetZComponentMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTableToPolyData': ...
    def PreserveCoordinateColumnsAsDataArraysOff(self) -> None: ...
    def PreserveCoordinateColumnsAsDataArraysOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTableToPolyData': ...
    def SetCreate2DPoints(self, _arg:bool) -> None: ...
    def SetPreserveCoordinateColumnsAsDataArrays(self, _arg:bool) -> None: ...
    def SetXColumn(self, _arg:str) -> None: ...
    def SetXColumnIndex(self, _arg:int) -> None: ...
    def SetXComponent(self, _arg:int) -> None: ...
    def SetYColumn(self, _arg:str) -> None: ...
    def SetYColumnIndex(self, _arg:int) -> None: ...
    def SetYComponent(self, _arg:int) -> None: ...
    def SetZColumn(self, _arg:str) -> None: ...
    def SetZColumnIndex(self, _arg:int) -> None: ...
    def SetZComponent(self, _arg:int) -> None: ...

class vtkTableToStructuredGrid(vtkmodules.vtkCommonExecutionModel.vtkStructuredGridAlgorithm):
    whole_extent:'getset_descriptor'
    x_column:'getset_descriptor'
    x_component:'getset_descriptor'
    y_column:'getset_descriptor'
    y_component:'getset_descriptor'
    z_column:'getset_descriptor'
    z_component:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWholeExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetXColumn(self) -> str: ...
    def GetXComponent(self) -> int: ...
    def GetXComponentMaxValue(self) -> int: ...
    def GetXComponentMinValue(self) -> int: ...
    def GetYColumn(self) -> str: ...
    def GetYComponent(self) -> int: ...
    def GetYComponentMaxValue(self) -> int: ...
    def GetYComponentMinValue(self) -> int: ...
    def GetZColumn(self) -> str: ...
    def GetZComponent(self) -> int: ...
    def GetZComponentMaxValue(self) -> int: ...
    def GetZComponentMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTableToStructuredGrid': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTableToStructuredGrid': ...
    @overload
    def SetWholeExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetWholeExtent(self, _arg:Sequence[int]) -> None: ...
    def SetXColumn(self, _arg:str) -> None: ...
    def SetXComponent(self, _arg:int) -> None: ...
    def SetYColumn(self, _arg:str) -> None: ...
    def SetYComponent(self, _arg:int) -> None: ...
    def SetZColumn(self, _arg:str) -> None: ...
    def SetZComponent(self, _arg:int) -> None: ...

class vtkTemporalPathLineFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    backward_time:'getset_descriptor'
    id_channel_array:'getset_descriptor'
    keep_dead_trails:'getset_descriptor'
    mask_points:'getset_descriptor'
    max_step_distance:'getset_descriptor'
    max_track_length:'getset_descriptor'
    selection_connection:'getset_descriptor'
    selection_data:'getset_descriptor'
    def Flush(self) -> None: ...
    def GetBackwardTime(self) -> bool: ...
    def GetIdChannelArray(self) -> str: ...
    def GetKeepDeadTrails(self) -> bool: ...
    def GetMaskPoints(self) -> int: ...
    def GetMaxStepDistance(self) -> Tuple[float, float, float]: ...
    def GetMaxTrackLength(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTemporalPathLineFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTemporalPathLineFilter': ...
    def SetBackwardTime(self, backward:bool) -> None: ...
    def SetIdChannelArray(self, _arg:str) -> None: ...
    def SetKeepDeadTrails(self, _arg:bool) -> None: ...
    def SetMaskPoints(self, _arg:int) -> None: ...
    @overload
    def SetMaxStepDistance(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetMaxStepDistance(self, _arg:Sequence[float]) -> None: ...
    def SetMaxTrackLength(self, _arg:int) -> None: ...
    def SetSelectionConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSelectionData(self, input:'vtkDataSet') -> None: ...
    @staticmethod
    def TimeStepsArrayName() -> str: ...

class vtkTemporalStatistics(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    compute_average:'getset_descriptor'
    compute_maximum:'getset_descriptor'
    compute_minimum:'getset_descriptor'
    compute_standard_deviation:'getset_descriptor'
    def ComputeAverageOff(self) -> None: ...
    def ComputeAverageOn(self) -> None: ...
    def ComputeMaximumOff(self) -> None: ...
    def ComputeMaximumOn(self) -> None: ...
    def ComputeMinimumOff(self) -> None: ...
    def ComputeMinimumOn(self) -> None: ...
    def ComputeStandardDeviationOff(self) -> None: ...
    def ComputeStandardDeviationOn(self) -> None: ...
    def GetComputeAverage(self) -> int: ...
    def GetComputeMaximum(self) -> int: ...
    def GetComputeMinimum(self) -> int: ...
    def GetComputeStandardDeviation(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTemporalStatistics': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTemporalStatistics': ...
    def SetComputeAverage(self, _arg:int) -> None: ...
    def SetComputeMaximum(self, _arg:int) -> None: ...
    def SetComputeMinimum(self, _arg:int) -> None: ...
    def SetComputeStandardDeviation(self, _arg:int) -> None: ...
    @staticmethod
    def TimeStepsArrayName() -> str: ...

class vtkTessellatorFilter(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    chord_error:'getset_descriptor'
    m_time:'getset_descriptor'
    maximum_number_of_subdivisions:'getset_descriptor'
    merge_points:'getset_descriptor'
    output_dimension:'getset_descriptor'
    subdivider:'getset_descriptor'
    tessellator:'getset_descriptor'
    def GetChordError(self) -> float: ...
    def GetMTime(self) -> int: ...
    def GetMaximumNumberOfSubdivisions(self) -> int: ...
    def GetMergePoints(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputDimension(self) -> int: ...
    def GetOutputDimensionMaxValue(self) -> int: ...
    def GetOutputDimensionMinValue(self) -> int: ...
    def GetSubdivider(self) -> 'vtkDataSetEdgeSubdivisionCriterion': ...
    def GetTessellator(self) -> 'vtkStreamingTessellator': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePointsOff(self) -> None: ...
    def MergePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkTessellatorFilter': ...
    def ResetFieldCriteria(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTessellatorFilter': ...
    def SetChordError(self, ce:float) -> None: ...
    def SetFieldCriterion(self, field:int, err:float) -> None: ...
    def SetMaximumNumberOfSubdivisions(self, num_subdiv_in:int) -> None: ...
    def SetMergePoints(self, _arg:int) -> None: ...
    def SetOutputDimension(self, _arg:int) -> None: ...
    def SetSubdivider(self, __a:'vtkDataSetEdgeSubdivisionCriterion') -> None: ...
    def SetTessellator(self, __a:'vtkStreamingTessellator') -> None: ...

class vtkTimeSourceExample(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    analytic:'getset_descriptor'
    growing:'getset_descriptor'
    x_amplitude:'getset_descriptor'
    y_amplitude:'getset_descriptor'
    def AnalyticOff(self) -> None: ...
    def AnalyticOn(self) -> None: ...
    def GetAnalytic(self) -> int: ...
    def GetAnalyticMaxValue(self) -> int: ...
    def GetAnalyticMinValue(self) -> int: ...
    def GetGrowing(self) -> int: ...
    def GetGrowingMaxValue(self) -> int: ...
    def GetGrowingMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetXAmplitude(self) -> float: ...
    def GetYAmplitude(self) -> float: ...
    def GrowingOff(self) -> None: ...
    def GrowingOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTimeSourceExample': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTimeSourceExample': ...
    def SetAnalytic(self, _arg:int) -> None: ...
    def SetGrowing(self, _arg:int) -> None: ...
    def SetXAmplitude(self, _arg:float) -> None: ...
    def SetYAmplitude(self, _arg:float) -> None: ...

class vtkTransformFilter(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    m_time:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    transform:'getset_descriptor'
    transform_all_input_vectors:'getset_descriptor'
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetTransform(self) -> 'vtkAbstractTransform': ...
    def GetTransformAllInputVectors(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransformFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransformFilter': ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetTransform(self, __a:'vtkAbstractTransform') -> None: ...
    def SetTransformAllInputVectors(self, _arg:bool) -> None: ...
    def TransformAllInputVectorsOff(self) -> None: ...
    def TransformAllInputVectorsOn(self) -> None: ...

class vtkTransformPolyDataFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    m_time:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    transform:'getset_descriptor'
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetTransform(self) -> 'vtkAbstractTransform': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransformPolyDataFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransformPolyDataFilter': ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetTransform(self, __a:'vtkAbstractTransform') -> None: ...

class vtkUncertaintyTubeFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    number_of_sides:'getset_descriptor'
    number_of_sides_max_value:'getset_descriptor'
    number_of_sides_min_value:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSides(self) -> int: ...
    def GetNumberOfSidesMaxValue(self) -> int: ...
    def GetNumberOfSidesMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUncertaintyTubeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUncertaintyTubeFilter': ...
    def SetNumberOfSides(self, _arg:int) -> None: ...

class vtkVertexGlyphFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVertexGlyphFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVertexGlyphFilter': ...

class vtkVolumeContourSpectrumFilter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    arc_id:'getset_descriptor'
    field_id:'getset_descriptor'
    number_of_samples:'getset_descriptor'
    output:'getset_descriptor'
    def GetArcId(self) -> int: ...
    def GetFieldId(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSamples(self) -> int: ...
    def GetOutput(self) -> 'vtkTable': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVolumeContourSpectrumFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolumeContourSpectrumFilter': ...
    def SetArcId(self, _arg:int) -> None: ...
    def SetFieldId(self, _arg:int) -> None: ...
    def SetNumberOfSamples(self, _arg:int) -> None: ...

class vtkVoxelContoursToSurfaceFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    memory_limit_in_bytes:'getset_descriptor'
    spacing:'getset_descriptor'
    def GetMemoryLimitInBytes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSpacing(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVoxelContoursToSurfaceFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVoxelContoursToSurfaceFilter': ...
    def SetMemoryLimitInBytes(self, _arg:int) -> None: ...
    @overload
    def SetSpacing(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSpacing(self, _arg:Sequence[float]) -> None: ...

class vtkWarpLens(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    center:'getset_descriptor'
    format_height:'getset_descriptor'
    format_width:'getset_descriptor'
    image_height:'getset_descriptor'
    image_width:'getset_descriptor'
    k1:'getset_descriptor'
    k2:'getset_descriptor'
    kappa:'getset_descriptor'
    p1:'getset_descriptor'
    p2:'getset_descriptor'
    principal_point:'getset_descriptor'
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GetCenter(self) -> Tuple[float, float]: ...
    def GetFormatHeight(self) -> float: ...
    def GetFormatWidth(self) -> float: ...
    def GetImageHeight(self) -> int: ...
    def GetImageWidth(self) -> int: ...
    def GetK1(self) -> float: ...
    def GetK2(self) -> float: ...
    def GetKappa(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetP1(self) -> float: ...
    def GetP2(self) -> float: ...
    def GetPrincipalPoint(self) -> Tuple[float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWarpLens': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWarpLens': ...
    def SetCenter(self, centerX:float, centerY:float) -> None: ...
    def SetFormatHeight(self, _arg:float) -> None: ...
    def SetFormatWidth(self, _arg:float) -> None: ...
    def SetImageHeight(self, _arg:int) -> None: ...
    def SetImageWidth(self, _arg:int) -> None: ...
    def SetK1(self, _arg:float) -> None: ...
    def SetK2(self, _arg:float) -> None: ...
    def SetKappa(self, kappa:float) -> None: ...
    def SetP1(self, _arg:float) -> None: ...
    def SetP2(self, _arg:float) -> None: ...
    @overload
    def SetPrincipalPoint(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetPrincipalPoint(self, _arg:Sequence[float]) -> None: ...

class vtkWarpScalar(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    generate_enclosure:'getset_descriptor'
    normal:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    scale_factor:'getset_descriptor'
    use_normal:'getset_descriptor'
    xy_plane:'getset_descriptor'
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GenerateEnclosureOff(self) -> None: ...
    def GenerateEnclosureOn(self) -> None: ...
    def GetGenerateEnclosure(self) -> bool: ...
    def GetNormal(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetScaleFactor(self) -> float: ...
    def GetUseNormal(self) -> int: ...
    def GetXYPlane(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWarpScalar': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWarpScalar': ...
    def SetGenerateEnclosure(self, _arg:bool) -> None: ...
    @overload
    def SetNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNormal(self, _arg:Sequence[float]) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetUseNormal(self, _arg:int) -> None: ...
    def SetXYPlane(self, _arg:int) -> None: ...
    def UseNormalOff(self) -> None: ...
    def UseNormalOn(self) -> None: ...
    def XYPlaneOff(self) -> None: ...
    def XYPlaneOn(self) -> None: ...

class vtkWarpTo(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    absolute:'getset_descriptor'
    position:'getset_descriptor'
    scale_factor:'getset_descriptor'
    def AbsoluteOff(self) -> None: ...
    def AbsoluteOn(self) -> None: ...
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GetAbsolute(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPosition(self) -> Tuple[float, float, float]: ...
    def GetScaleFactor(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWarpTo': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWarpTo': ...
    def SetAbsolute(self, _arg:int) -> None: ...
    @overload
    def SetPosition(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPosition(self, _arg:Sequence[float]) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...

class vtkWarpVector(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    output_points_precision:'getset_descriptor'
    scale_factor:'getset_descriptor'
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetScaleFactor(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWarpVector': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWarpVector': ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...

class vtkYoungsMaterialInterface(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    MAX_CELL_POINTS:int
    axis_symetric:'getset_descriptor'
    fill_material:'getset_descriptor'
    inverse_normal:'getset_descriptor'
    number_of_domains:'getset_descriptor'
    number_of_materials:'getset_descriptor'
    onion_peel:'getset_descriptor'
    reverse_material_order:'getset_descriptor'
    use_all_blocks:'getset_descriptor'
    use_fraction_as_distance:'getset_descriptor'
    volume_fraction_range:'getset_descriptor'
    def AddMaterialBlockMapping(self, b:int) -> None: ...
    def AxisSymetricOff(self) -> None: ...
    def AxisSymetricOn(self) -> None: ...
    def FillMaterialOff(self) -> None: ...
    def FillMaterialOn(self) -> None: ...
    def GetAxisSymetric(self) -> int: ...
    def GetFillMaterial(self) -> int: ...
    def GetInverseNormal(self) -> int: ...
    def GetNumberOfDomains(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfMaterials(self) -> int: ...
    def GetOnionPeel(self) -> int: ...
    def GetReverseMaterialOrder(self) -> int: ...
    def GetUseAllBlocks(self) -> bool: ...
    def GetUseFractionAsDistance(self) -> int: ...
    def GetVolumeFractionRange(self) -> Tuple[float, float]: ...
    def InverseNormalOff(self) -> None: ...
    def InverseNormalOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkYoungsMaterialInterface': ...
    def OnionPeelOff(self) -> None: ...
    def OnionPeelOn(self) -> None: ...
    def RemoveAllMaterialBlockMappings(self) -> None: ...
    def RemoveAllMaterials(self) -> None: ...
    def ReverseMaterialOrderOff(self) -> None: ...
    def ReverseMaterialOrderOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkYoungsMaterialInterface': ...
    def SetAxisSymetric(self, _arg:int) -> None: ...
    def SetFillMaterial(self, _arg:int) -> None: ...
    def SetInverseNormal(self, _arg:int) -> None: ...
    @overload
    def SetMaterialArrays(self, i:int, volume:str, normalX:str, normalY:str, normalZ:str, ordering:str) -> None: ...
    @overload
    def SetMaterialArrays(self, i:int, volume:str, normal:str, ordering:str) -> None: ...
    @overload
    def SetMaterialNormalArray(self, i:int, normal:str) -> None: ...
    @overload
    def SetMaterialNormalArray(self, volume:str, normal:str) -> None: ...
    @overload
    def SetMaterialOrderingArray(self, i:int, ordering:str) -> None: ...
    @overload
    def SetMaterialOrderingArray(self, volume:str, ordering:str) -> None: ...
    def SetMaterialVolumeFractionArray(self, i:int, volume:str) -> None: ...
    def SetNumberOfMaterials(self, n:int) -> None: ...
    def SetOnionPeel(self, _arg:int) -> None: ...
    def SetReverseMaterialOrder(self, _arg:int) -> None: ...
    def SetUseAllBlocks(self, _arg:bool) -> None: ...
    def SetUseFractionAsDistance(self, _arg:int) -> None: ...
    @overload
    def SetVolumeFractionRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetVolumeFractionRange(self, _arg:Sequence[float]) -> None: ...
    def UseAllBlocksOff(self) -> None: ...
    def UseAllBlocksOn(self) -> None: ...
    def UseFractionAsDistanceOff(self) -> None: ...
    def UseFractionAsDistanceOn(self) -> None: ...

