from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkFiltersStatistics

class vtkComputeHistogram2DOutliers(vtkmodules.vtkCommonExecutionModel.vtkSelectionAlgorithm):
    class InputPorts(int): ...
    class OutputPorts(int): ...
    INPUT_HISTOGRAMS_IMAGE_DATA:'InputPorts'
    INPUT_HISTOGRAMS_MULTIBLOCK:'InputPorts'
    INPUT_TABLE_DATA:'InputPorts'
    OUTPUT_SELECTED_ROWS:'OutputPorts'
    OUTPUT_SELECTED_TABLE_DATA:'OutputPorts'
    input_histogram_image_data_connection:'getset_descriptor'
    input_histogram_multi_block_connection:'getset_descriptor'
    input_table_connection:'getset_descriptor'
    output_table:'getset_descriptor'
    preferred_number_of_outliers:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputTable(self) -> 'vtkTable': ...
    def GetPreferredNumberOfOutliers(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkComputeHistogram2DOutliers': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkComputeHistogram2DOutliers': ...
    def SetInputHistogramImageDataConnection(self, cxn:'vtkAlgorithmOutput') -> None: ...
    def SetInputHistogramMultiBlockConnection(self, cxn:'vtkAlgorithmOutput') -> None: ...
    def SetInputTableConnection(self, cxn:'vtkAlgorithmOutput') -> None: ...
    def SetPreferredNumberOfOutliers(self, _arg:int) -> None: ...

class vtkExtractHistogram2D(vtkmodules.vtkFiltersStatistics.vtkStatisticsAlgorithm):
    class OutputIndices(int): ...
    HISTOGRAM_IMAGE:'OutputIndices'
    components_to_process:'getset_descriptor'
    custom_histogram_extents:'getset_descriptor'
    histogram_extents:'getset_descriptor'
    maximum_bin_count:'getset_descriptor'
    number_of_bins:'getset_descriptor'
    output_histogram_image:'getset_descriptor'
    row_mask:'getset_descriptor'
    scalar_type:'getset_descriptor'
    swap_columns:'getset_descriptor'
    use_custom_histogram_extents:'getset_descriptor'
    def Aggregate(self, __a:'vtkDataObjectCollection', __b:'vtkMultiBlockDataSet') -> None: ...
    @overload
    def GetBinRange(self, binX:int, binY:int, range:MutableSequence[float]) -> int: ...
    @overload
    def GetBinRange(self, bin:int, range:MutableSequence[float]) -> int: ...
    def GetBinWidth(self, bw:MutableSequence[float]) -> None: ...
    def GetComponentsToProcess(self) -> Tuple[int, int]: ...
    def GetCustomHistogramExtents(self) -> Tuple[float, float, float, float]: ...
    def GetHistogramExtents(self) -> Pointer: ...
    def GetMaximumBinCount(self) -> float: ...
    def GetNumberOfBins(self) -> Tuple[int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputHistogramImage(self) -> 'vtkImageData': ...
    def GetRowMask(self) -> 'vtkDataArray': ...
    def GetScalarType(self) -> int: ...
    def GetSwapColumns(self) -> int: ...
    def GetUseCustomHistogramExtents(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractHistogram2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractHistogram2D': ...
    @overload
    def SetComponentsToProcess(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetComponentsToProcess(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetCustomHistogramExtents(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetCustomHistogramExtents(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetNumberOfBins(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetNumberOfBins(self, _arg:Sequence[int]) -> None: ...
    def SetRowMask(self, __a:'vtkDataArray') -> None: ...
    def SetScalarType(self, _arg:int) -> None: ...
    def SetScalarTypeToDouble(self) -> None: ...
    def SetScalarTypeToFloat(self) -> None: ...
    def SetScalarTypeToUnsignedChar(self) -> None: ...
    def SetScalarTypeToUnsignedInt(self) -> None: ...
    def SetScalarTypeToUnsignedLong(self) -> None: ...
    def SetScalarTypeToUnsignedShort(self) -> None: ...
    def SetSwapColumns(self, _arg:int) -> None: ...
    def SetUseCustomHistogramExtents(self, _arg:int) -> None: ...
    def SwapColumnsOff(self) -> None: ...
    def SwapColumnsOn(self) -> None: ...
    def UseCustomHistogramExtentsOff(self) -> None: ...
    def UseCustomHistogramExtentsOn(self) -> None: ...

class vtkPairwiseExtractHistogram2D(vtkmodules.vtkFiltersStatistics.vtkStatisticsAlgorithm):
    class OutputIndices(int): ...
    HISTOGRAM_IMAGE:'OutputIndices'
    custom_column_range_by_index:'getset_descriptor'
    custom_column_range_index:'getset_descriptor'
    maximum_bin_count:'getset_descriptor'
    number_of_bins:'getset_descriptor'
    scalar_type:'getset_descriptor'
    def Aggregate(self, __a:'vtkDataObjectCollection', __b:'vtkMultiBlockDataSet') -> None: ...
    @overload
    def GetBinRange(self, idx:int, binX:int, binY:int, range:MutableSequence[float]) -> int: ...
    @overload
    def GetBinRange(self, idx:int, bin:int, range:MutableSequence[float]) -> int: ...
    def GetBinWidth(self, idx:int, bw:MutableSequence[float]) -> None: ...
    def GetHistogramExtents(self, idx:int) -> Pointer: ...
    def GetHistogramFilter(self, idx:int) -> 'vtkExtractHistogram2D': ...
    @overload
    def GetMaximumBinCount(self, idx:int) -> float: ...
    @overload
    def GetMaximumBinCount(self) -> float: ...
    def GetNumberOfBins(self) -> Tuple[int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputHistogramImage(self, idx:int) -> 'vtkImageData': ...
    def GetScalarType(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPairwiseExtractHistogram2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPairwiseExtractHistogram2D': ...
    @overload
    def SetCustomColumnRange(self, col:int, range:MutableSequence[float]) -> None: ...
    @overload
    def SetCustomColumnRange(self, col:int, rmin:float, rmax:float) -> None: ...
    def SetCustomColumnRangeByIndex(self, __a:float, __b:float) -> None: ...
    def SetCustomColumnRangeIndex(self, _arg:int) -> None: ...
    @overload
    def SetNumberOfBins(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetNumberOfBins(self, _arg:Sequence[int]) -> None: ...
    def SetScalarType(self, _arg:int) -> None: ...
    def SetScalarTypeToUnsignedChar(self) -> None: ...
    def SetScalarTypeToUnsignedInt(self) -> None: ...
    def SetScalarTypeToUnsignedLong(self) -> None: ...
    def SetScalarTypeToUnsignedShort(self) -> None: ...

