from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkFiltersCore

class vtkAdaptiveResampleToImage(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    controller:'getset_descriptor'
    number_of_images:'getset_descriptor'
    number_of_images_max_value:'getset_descriptor'
    number_of_images_min_value:'getset_descriptor'
    sampling_dimensions:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfImages(self) -> int: ...
    def GetNumberOfImagesMaxValue(self) -> int: ...
    def GetNumberOfImagesMinValue(self) -> int: ...
    def GetSamplingDimensions(self) -> Tuple[int, int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAdaptiveResampleToImage': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAdaptiveResampleToImage': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetNumberOfImages(self, _arg:int) -> None: ...
    @overload
    def SetSamplingDimensions(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetSamplingDimensions(self, _arg:Sequence[int]) -> None: ...

class vtkExtractSubsetWithSeed(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    LINE_I:int
    LINE_J:int
    LINE_K:int
    PLANE_IJ:int
    PLANE_JK:int
    PLANE_KI:int
    controller:'getset_descriptor'
    direction:'getset_descriptor'
    seed:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetDirection(self) -> int: ...
    def GetDirectionMaxValue(self) -> int: ...
    def GetDirectionMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSeed(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractSubsetWithSeed': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractSubsetWithSeed': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetDirection(self, _arg:int) -> None: ...
    def SetDirectionToLineI(self) -> None: ...
    def SetDirectionToLineJ(self) -> None: ...
    def SetDirectionToLineK(self) -> None: ...
    def SetDirectionToPlaneIJ(self) -> None: ...
    def SetDirectionToPlaneJK(self) -> None: ...
    def SetDirectionToPlaneKI(self) -> None: ...
    @overload
    def SetSeed(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSeed(self, _arg:Sequence[float]) -> None: ...

class vtkGenerateGlobalIds(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    controller:'getset_descriptor'
    tolerance:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenerateGlobalIds': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenerateGlobalIds': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkGhostCellsGenerator(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    build_if_required:'getset_descriptor'
    controller:'getset_descriptor'
    generate_global_ids:'getset_descriptor'
    generate_process_ids:'getset_descriptor'
    number_of_ghost_layers:'getset_descriptor'
    number_of_ghost_layers_max_value:'getset_descriptor'
    number_of_ghost_layers_min_value:'getset_descriptor'
    synchronize_only:'getset_descriptor'
    use_static_mesh_cache:'getset_descriptor'
    def BuildIfRequiredOff(self) -> None: ...
    def BuildIfRequiredOn(self) -> None: ...
    def GenerateGlobalIdsOff(self) -> None: ...
    def GenerateGlobalIdsOn(self) -> None: ...
    def GenerateProcessIdsOff(self) -> None: ...
    def GenerateProcessIdsOn(self) -> None: ...
    def GetBuildIfRequired(self) -> bool: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetGenerateGlobalIds(self) -> bool: ...
    def GetGenerateProcessIds(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfGhostLayers(self) -> int: ...
    def GetNumberOfGhostLayersMaxValue(self) -> int: ...
    def GetNumberOfGhostLayersMinValue(self) -> int: ...
    def GetSynchronizeOnly(self) -> bool: ...
    def GetUseStaticMeshCache(self) -> bool: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGhostCellsGenerator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGhostCellsGenerator': ...
    def SetBuildIfRequired(self, _arg:bool) -> None: ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetGenerateGlobalIds(self, _arg:bool) -> None: ...
    def SetGenerateProcessIds(self, _arg:bool) -> None: ...
    def SetNumberOfGhostLayers(self, _arg:int) -> None: ...
    def SetSynchronizeOnly(self, _arg:bool) -> None: ...
    def SetUseStaticMeshCache(self, _arg:bool) -> None: ...
    def SynchronizeOnlyOff(self) -> None: ...
    def SynchronizeOnlyOn(self) -> None: ...
    def UseStaticMeshCacheOff(self) -> None: ...
    def UseStaticMeshCacheOn(self) -> None: ...

class vtkPartitioningStrategy(vtkmodules.vtkCommonCore.vtkObject):
    class PartitionedEntity(int): ...
    CELLS:'PartitionedEntity'
    POINTS:'PartitionedEntity'
    controller:'getset_descriptor'
    number_of_partitions:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPartitions(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPartitioningStrategy': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPartitioningStrategy': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetNumberOfPartitions(self, _arg:int) -> None: ...

class vtkNativePartitioningStrategy(vtkPartitioningStrategy):
    expand_explicit_cuts:'getset_descriptor'
    load_balance_across_all_blocks:'getset_descriptor'
    use_explicit_cuts:'getset_descriptor'
    @overload
    def AddExplicitCut(self, bbox:'vtkBoundingBox') -> None: ...
    @overload
    def AddExplicitCut(self, bbox:Sequence[float]) -> None: ...
    def ExpandExplicitCutsOff(self) -> None: ...
    def ExpandExplicitCutsOn(self) -> None: ...
    def GetExpandExplicitCuts(self) -> bool: ...
    def GetExplicitCut(self, index:int) -> 'vtkBoundingBox': ...
    def GetLoadBalanceAcrossAllBlocks(self) -> bool: ...
    def GetNumberOfExplicitCuts(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseExplicitCuts(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LoadBalanceAcrossAllBlocksOff(self) -> None: ...
    def LoadBalanceAcrossAllBlocksOn(self) -> None: ...
    def NewInstance(self) -> 'vtkNativePartitioningStrategy': ...
    def RemoveAllExplicitCuts(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkNativePartitioningStrategy': ...
    def SetExpandExplicitCuts(self, _arg:bool) -> None: ...
    def SetLoadBalanceAcrossAllBlocks(self, _arg:bool) -> None: ...
    def SetUseExplicitCuts(self, _arg:bool) -> None: ...
    def UseExplicitCutsOff(self) -> None: ...
    def UseExplicitCutsOn(self) -> None: ...

class vtkOverlappingCellsDetector(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    controller:'getset_descriptor'
    number_of_overlaps_per_cell_array_name:'getset_descriptor'
    tolerance:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfOverlapsPerCellArrayName(self) -> str: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOverlappingCellsDetector': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOverlappingCellsDetector': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetNumberOfOverlapsPerCellArrayName(self, _arg:str) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkPResampleToImage(vtkmodules.vtkFiltersCore.vtkResampleToImage):
    controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPResampleToImage': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPResampleToImage': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...

class vtkPResampleWithDataSet(vtkmodules.vtkFiltersCore.vtkResampleWithDataSet):
    controller:'getset_descriptor'
    use_balanced_partition_for_points_lookup:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseBalancedPartitionForPointsLookup(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPResampleWithDataSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPResampleWithDataSet': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetUseBalancedPartitionForPointsLookup(self, _arg:bool) -> None: ...
    def UseBalancedPartitionForPointsLookupOff(self) -> None: ...
    def UseBalancedPartitionForPointsLookupOn(self) -> None: ...

class vtkProbeLineFilter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    class SamplingPatternEnum(int): ...
    SAMPLE_LINE_AT_CELL_BOUNDARIES:'SamplingPatternEnum'
    SAMPLE_LINE_AT_SEGMENT_CENTERS:'SamplingPatternEnum'
    SAMPLE_LINE_UNIFORMLY:'SamplingPatternEnum'
    aggregate_as_poly_data:'getset_descriptor'
    compute_tolerance:'getset_descriptor'
    controller:'getset_descriptor'
    line_resolution:'getset_descriptor'
    pass_cell_arrays:'getset_descriptor'
    pass_field_arrays:'getset_descriptor'
    pass_partial_arrays:'getset_descriptor'
    pass_point_arrays:'getset_descriptor'
    sampling_pattern:'getset_descriptor'
    source_connection:'getset_descriptor'
    tolerance:'getset_descriptor'
    def AggregateAsPolyDataOff(self) -> None: ...
    def AggregateAsPolyDataOn(self) -> None: ...
    def ComputeToleranceOff(self) -> None: ...
    def ComputeToleranceOn(self) -> None: ...
    def GetAggregateAsPolyData(self) -> bool: ...
    def GetComputeTolerance(self) -> bool: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetLineResolution(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassCellArrays(self) -> bool: ...
    def GetPassFieldArrays(self) -> bool: ...
    def GetPassPartialArrays(self) -> bool: ...
    def GetPassPointArrays(self) -> bool: ...
    def GetSamplingPattern(self) -> int: ...
    def GetSamplingPatternMaxValue(self) -> int: ...
    def GetSamplingPatternMinValue(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProbeLineFilter': ...
    def PassCellArraysOff(self) -> None: ...
    def PassCellArraysOn(self) -> None: ...
    def PassFieldArraysOff(self) -> None: ...
    def PassFieldArraysOn(self) -> None: ...
    def PassPartialArraysOff(self) -> None: ...
    def PassPartialArraysOn(self) -> None: ...
    def PassPointArraysOff(self) -> None: ...
    def PassPointArraysOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProbeLineFilter': ...
    def SetAggregateAsPolyData(self, _arg:bool) -> None: ...
    def SetComputeTolerance(self, _arg:bool) -> None: ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetLineResolution(self, _arg:int) -> None: ...
    def SetPassCellArrays(self, _arg:bool) -> None: ...
    def SetPassFieldArrays(self, _arg:bool) -> None: ...
    def SetPassPartialArrays(self, _arg:bool) -> None: ...
    def SetPassPointArrays(self, _arg:bool) -> None: ...
    def SetSamplingPattern(self, _arg:int) -> None: ...
    def SetSourceConnection(self, input:'vtkAlgorithmOutput') -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkRedistributeDataSetFilter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    class BoundaryModes(int): ...
    ASSIGN_TO_ALL_INTERSECTING_REGIONS:'BoundaryModes'
    ASSIGN_TO_ONE_REGION:'BoundaryModes'
    SPLIT_BOUNDARY_CELLS:'BoundaryModes'
    boundary_mode:'getset_descriptor'
    controller:'getset_descriptor'
    enable_debugging:'getset_descriptor'
    expand_explicit_cuts:'getset_descriptor'
    generate_global_cell_ids:'getset_descriptor'
    load_balance_across_all_blocks:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_partitions:'getset_descriptor'
    preserve_partitions_in_output:'getset_descriptor'
    strategy:'getset_descriptor'
    use_explicit_cuts:'getset_descriptor'
    @overload
    def AddExplicitCut(self, bbox:'vtkBoundingBox') -> None: ...
    @overload
    def AddExplicitCut(self, bbox:Sequence[float]) -> None: ...
    def EnableDebuggingOff(self) -> None: ...
    def EnableDebuggingOn(self) -> None: ...
    def ExpandExplicitCutsOff(self) -> None: ...
    def ExpandExplicitCutsOn(self) -> None: ...
    def GenerateGlobalCellIdsOff(self) -> None: ...
    def GenerateGlobalCellIdsOn(self) -> None: ...
    def GetBoundaryMode(self) -> int: ...
    def GetBoundaryModeMaxValue(self) -> int: ...
    def GetBoundaryModeMinValue(self) -> int: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetEnableDebugging(self) -> bool: ...
    def GetExpandExplicitCuts(self) -> bool: ...
    def GetExplicitCut(self, index:int) -> 'vtkBoundingBox': ...
    def GetGenerateGlobalCellIds(self) -> bool: ...
    def GetLoadBalanceAcrossAllBlocks(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfExplicitCuts(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPartitions(self) -> int: ...
    def GetPreservePartitionsInOutput(self) -> bool: ...
    def GetStrategy(self) -> 'vtkPartitioningStrategy': ...
    def GetUseExplicitCuts(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LoadBalanceAcrossAllBlocksOff(self) -> None: ...
    def LoadBalanceAcrossAllBlocksOn(self) -> None: ...
    def NewInstance(self) -> 'vtkRedistributeDataSetFilter': ...
    def PreservePartitionsInOutputOff(self) -> None: ...
    def PreservePartitionsInOutputOn(self) -> None: ...
    def RemoveAllExplicitCuts(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRedistributeDataSetFilter': ...
    def SetBoundaryMode(self, _arg:int) -> None: ...
    def SetBoundaryModeToAssignToAllIntersectingRegions(self) -> None: ...
    def SetBoundaryModeToAssignToOneRegion(self) -> None: ...
    def SetBoundaryModeToSplitBoundaryCells(self) -> None: ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetEnableDebugging(self, _arg:bool) -> None: ...
    def SetExpandExplicitCuts(self, __a:bool) -> None: ...
    def SetGenerateGlobalCellIds(self, _arg:bool) -> None: ...
    def SetLoadBalanceAcrossAllBlocks(self, __a:bool) -> None: ...
    def SetNumberOfPartitions(self, __a:int) -> None: ...
    def SetPreservePartitionsInOutput(self, _arg:bool) -> None: ...
    def SetStrategy(self, __a:'vtkPartitioningStrategy') -> None: ...
    def SetUseExplicitCuts(self, __a:bool) -> None: ...
    def UseExplicitCutsOff(self) -> None: ...
    def UseExplicitCutsOn(self) -> None: ...

class vtkStitchImageDataWithGhosts(vtkGhostCellsGenerator):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStitchImageDataWithGhosts': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStitchImageDataWithGhosts': ...

