from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkIOExport

class WebGLObjectTypes(int): ...

VTK_ONLYCAMERA:int
VTK_ONLYWIDGET:int
VTK_PARSEALL:int
wLINES:'WebGLObjectTypes'
wPOINTS:'WebGLObjectTypes'
wTRIANGLES:'WebGLObjectTypes'

class vtkPVWebGLExporter(vtkmodules.vtkIOExport.vtkExporter):
    file_name:'getset_descriptor'
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPVWebGLExporter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPVWebGLExporter': ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkWebGLDataSet(vtkmodules.vtkCommonCore.vtkObject):
    binary_data:'getset_descriptor'
    binary_size:'getset_descriptor'
    colors:'getset_descriptor'
    matrix:'getset_descriptor'
    md5:'getset_descriptor'
    normals:'getset_descriptor'
    t_coords:'getset_descriptor'
    type:'getset_descriptor'
    def GenerateBinaryData(self) -> None: ...
    def GetBinaryData(self) -> Pointer: ...
    def GetBinarySize(self) -> int: ...
    def GetMD5(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasChanged(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWebGLDataSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWebGLDataSet': ...
    def SetColors(self, c:MutableSequence[int]) -> None: ...
    def SetIndexes(self, i:MutableSequence[int], size:int) -> None: ...
    def SetMatrix(self, m:MutableSequence[float]) -> None: ...
    def SetNormals(self, n:MutableSequence[float]) -> None: ...
    def SetPoints(self, p:MutableSequence[float], size:int) -> None: ...
    def SetTCoords(self, t:MutableSequence[float]) -> None: ...
    def SetType(self, t:'WebGLObjectTypes') -> None: ...
    def SetVertices(self, v:MutableSequence[float], size:int) -> None: ...

class vtkWebGLExporter(vtkmodules.vtkCommonCore.vtkObject):
    center_of_rotation:'getset_descriptor'
    id:'getset_descriptor'
    max_allowed_size:'getset_descriptor'
    number_of_objects:'getset_descriptor'
    @staticmethod
    def ComputeMD5(content:Sequence[int], size:int, hash:str) -> None: ...
    def GenerateMetadata(self) -> str: ...
    def GetId(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfObjects(self) -> int: ...
    def GetWebGLObject(self, index:int) -> 'vtkWebGLObject': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWebGLExporter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWebGLExporter': ...
    def SetCenterOfRotation(self, a1:float, a2:float, a3:float) -> None: ...
    @overload
    def SetMaxAllowedSize(self, mesh:int, lines:int) -> None: ...
    @overload
    def SetMaxAllowedSize(self, size:int) -> None: ...
    def exportStaticScene(self, renderers:'vtkRendererCollection', width:int, height:int, path:str) -> None: ...
    def hasChanged(self) -> bool: ...
    def parseScene(self, renderers:'vtkRendererCollection', viewId:str, parseType:int) -> None: ...

class vtkWebGLObject(vtkmodules.vtkCommonCore.vtkObject):
    has_transparency:'getset_descriptor'
    id:'getset_descriptor'
    interact_at_server:'getset_descriptor'
    is_widget:'getset_descriptor'
    layer:'getset_descriptor'
    md5:'getset_descriptor'
    number_of_parts:'getset_descriptor'
    renderer_id:'getset_descriptor'
    transformation_matrix:'getset_descriptor'
    type:'getset_descriptor'
    visibility:'getset_descriptor'
    wireframe_mode:'getset_descriptor'
    def GenerateBinaryData(self) -> None: ...
    @overload
    def GetBinaryData(self, part:int) -> Pointer: ...
    @overload
    def GetBinaryData(self, part:int, buffer:'vtkUnsignedCharArray') -> None: ...
    def GetBinarySize(self, part:int) -> int: ...
    def GetId(self) -> str: ...
    def GetLayer(self) -> int: ...
    def GetMD5(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfParts(self) -> int: ...
    def GetRendererId(self) -> int: ...
    def HasChanged(self) -> bool: ...
    def HasTransparency(self) -> bool: ...
    def InteractAtServer(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWebGLObject': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWebGLObject': ...
    def SetHasTransparency(self, t:bool) -> None: ...
    def SetId(self, i:str) -> None: ...
    def SetInteractAtServer(self, i:bool) -> None: ...
    def SetIsWidget(self, w:bool) -> None: ...
    def SetLayer(self, l:int) -> None: ...
    def SetRendererId(self, i:int) -> None: ...
    def SetTransformationMatrix(self, m:'vtkMatrix4x4') -> None: ...
    def SetType(self, t:'WebGLObjectTypes') -> None: ...
    def SetVisibility(self, vis:bool) -> None: ...
    def SetWireframeMode(self, wireframe:bool) -> None: ...
    def isVisible(self) -> bool: ...
    def isWidget(self) -> bool: ...
    def isWireframeMode(self) -> bool: ...

class vtkWebGLPolyData(vtkWebGLObject):
    number_of_parts:'getset_descriptor'
    transformation_matrix:'getset_descriptor'
    def GenerateBinaryData(self) -> None: ...
    def GetBinaryData(self, part:int) -> Pointer: ...
    def GetBinarySize(self, part:int) -> int: ...
    def GetColorsFromPointData(self, color:MutableSequence[int], pointdata:'vtkPointData', polydata:'vtkPolyData', actor:'vtkActor') -> None: ...
    def GetColorsFromPolyData(self, color:MutableSequence[int], polydata:'vtkPolyData', actor:'vtkActor') -> None: ...
    def GetLines(self, polydata:'vtkTriangleFilter', actor:'vtkActor', lineMaxSize:int) -> None: ...
    def GetLinesFromPolygon(self, mapper:'vtkMapper', actor:'vtkActor', lineMaxSize:int, edgeColor:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfParts(self) -> int: ...
    def GetPoints(self, polydata:'vtkTriangleFilter', actor:'vtkActor', maxSize:int) -> None: ...
    def GetPolygonsFromCellData(self, polydata:'vtkTriangleFilter', actor:'vtkActor', maxSize:int) -> None: ...
    def GetPolygonsFromPointData(self, polydata:'vtkTriangleFilter', actor:'vtkActor', maxSize:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWebGLPolyData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWebGLPolyData': ...
    def SetLine(self, _points:MutableSequence[float], _numberOfPoints:int, _index:MutableSequence[int], _numberOfIndex:int, _colors:MutableSequence[int], maxSize:int) -> None: ...
    def SetMesh(self, _vertices:MutableSequence[float], _numberOfVertices:int, _index:MutableSequence[int], _numberOfIndexes:int, _normals:MutableSequence[float], _colors:MutableSequence[int], _tcoords:MutableSequence[float], maxSize:int) -> None: ...
    def SetPoints(self, points:MutableSequence[float], numberOfPoints:int, colors:MutableSequence[int], maxSize:int) -> None: ...
    def SetTransformationMatrix(self, m:'vtkMatrix4x4') -> None: ...

class vtkWebGLWidget(vtkWebGLObject):
    number_of_parts:'getset_descriptor'
    def GenerateBinaryData(self) -> None: ...
    def GetBinaryData(self, part:int) -> Pointer: ...
    def GetBinarySize(self, part:int) -> int: ...
    def GetDataFromColorMap(self, actor:'vtkActor2D') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfParts(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWebGLWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWebGLWidget': ...

