# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTraceSnapshotDataResult',
    'AwaitableGetTraceSnapshotDataResult',
    'get_trace_snapshot_data',
    'get_trace_snapshot_data_output',
]

@pulumi.output_type
class GetTraceSnapshotDataResult:
    """
    A collection of values returned by getTraceSnapshotData.
    """
    def __init__(__self__, apm_domain_id=None, id=None, is_summarized=None, key=None, snapshot_time=None, thread_id=None, time_ended=None, time_started=None, trace_key=None, trace_snapshot_details=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_summarized and not isinstance(is_summarized, bool):
            raise TypeError("Expected argument 'is_summarized' to be a bool")
        pulumi.set(__self__, "is_summarized", is_summarized)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if snapshot_time and not isinstance(snapshot_time, str):
            raise TypeError("Expected argument 'snapshot_time' to be a str")
        pulumi.set(__self__, "snapshot_time", snapshot_time)
        if thread_id and not isinstance(thread_id, str):
            raise TypeError("Expected argument 'thread_id' to be a str")
        pulumi.set(__self__, "thread_id", thread_id)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if trace_key and not isinstance(trace_key, str):
            raise TypeError("Expected argument 'trace_key' to be a str")
        pulumi.set(__self__, "trace_key", trace_key)
        if trace_snapshot_details and not isinstance(trace_snapshot_details, list):
            raise TypeError("Expected argument 'trace_snapshot_details' to be a list")
        pulumi.set(__self__, "trace_snapshot_details", trace_snapshot_details)

    @_builtins.property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> _builtins.str:
        return pulumi.get(self, "apm_domain_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSummarized")
    def is_summarized(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_summarized")

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Name of the property.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="snapshotTime")
    def snapshot_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "snapshot_time")

    @_builtins.property
    @pulumi.getter(name="threadId")
    def thread_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "thread_id")

    @_builtins.property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> _builtins.str:
        """
        End time of the trace.
        """
        return pulumi.get(self, "time_ended")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        Start time of the trace.
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter(name="traceKey")
    def trace_key(self) -> _builtins.str:
        return pulumi.get(self, "trace_key")

    @_builtins.property
    @pulumi.getter(name="traceSnapshotDetails")
    def trace_snapshot_details(self) -> Sequence['outputs.GetTraceSnapshotDataTraceSnapshotDetailResult']:
        """
        Trace snapshots properties.
        """
        return pulumi.get(self, "trace_snapshot_details")


class AwaitableGetTraceSnapshotDataResult(GetTraceSnapshotDataResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTraceSnapshotDataResult(
            apm_domain_id=self.apm_domain_id,
            id=self.id,
            is_summarized=self.is_summarized,
            key=self.key,
            snapshot_time=self.snapshot_time,
            thread_id=self.thread_id,
            time_ended=self.time_ended,
            time_started=self.time_started,
            trace_key=self.trace_key,
            trace_snapshot_details=self.trace_snapshot_details)


def get_trace_snapshot_data(apm_domain_id: Optional[_builtins.str] = None,
                            is_summarized: Optional[_builtins.bool] = None,
                            snapshot_time: Optional[_builtins.str] = None,
                            thread_id: Optional[_builtins.str] = None,
                            trace_key: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTraceSnapshotDataResult:
    """
    This data source provides details about a specific Trace Snapshot Data resource in Oracle Cloud Infrastructure Apm Traces service.

    Gets the trace snapshots data identified by trace ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_trace_snapshot_data = oci.ApmTraces.get_trace_snapshot_data(apm_domain_id=test_apm_domain["id"],
        trace_key=trace_snapshot_data_trace_key,
        is_summarized=trace_snapshot_data_is_summarized,
        snapshot_time=trace_snapshot_data_snapshot_time,
        thread_id=test_thread["id"])
    ```


    :param _builtins.str apm_domain_id: The APM Domain ID for the intended request.
    :param _builtins.bool is_summarized: If enabled, only span level details are sent.
    :param _builtins.str snapshot_time: Epoch time of snapshot.
    :param _builtins.str thread_id: Thread ID for which snapshots need to be retrieved. This identifier of a thread is a long positive number generated when a thread is created.
    :param _builtins.str trace_key: Unique Application Performance Monitoring trace identifier (traceId).
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['isSummarized'] = is_summarized
    __args__['snapshotTime'] = snapshot_time
    __args__['threadId'] = thread_id
    __args__['traceKey'] = trace_key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmTraces/getTraceSnapshotData:getTraceSnapshotData', __args__, opts=opts, typ=GetTraceSnapshotDataResult).value

    return AwaitableGetTraceSnapshotDataResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        id=pulumi.get(__ret__, 'id'),
        is_summarized=pulumi.get(__ret__, 'is_summarized'),
        key=pulumi.get(__ret__, 'key'),
        snapshot_time=pulumi.get(__ret__, 'snapshot_time'),
        thread_id=pulumi.get(__ret__, 'thread_id'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        time_started=pulumi.get(__ret__, 'time_started'),
        trace_key=pulumi.get(__ret__, 'trace_key'),
        trace_snapshot_details=pulumi.get(__ret__, 'trace_snapshot_details'))
def get_trace_snapshot_data_output(apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   is_summarized: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                   snapshot_time: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   thread_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   trace_key: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTraceSnapshotDataResult]:
    """
    This data source provides details about a specific Trace Snapshot Data resource in Oracle Cloud Infrastructure Apm Traces service.

    Gets the trace snapshots data identified by trace ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_trace_snapshot_data = oci.ApmTraces.get_trace_snapshot_data(apm_domain_id=test_apm_domain["id"],
        trace_key=trace_snapshot_data_trace_key,
        is_summarized=trace_snapshot_data_is_summarized,
        snapshot_time=trace_snapshot_data_snapshot_time,
        thread_id=test_thread["id"])
    ```


    :param _builtins.str apm_domain_id: The APM Domain ID for the intended request.
    :param _builtins.bool is_summarized: If enabled, only span level details are sent.
    :param _builtins.str snapshot_time: Epoch time of snapshot.
    :param _builtins.str thread_id: Thread ID for which snapshots need to be retrieved. This identifier of a thread is a long positive number generated when a thread is created.
    :param _builtins.str trace_key: Unique Application Performance Monitoring trace identifier (traceId).
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['isSummarized'] = is_summarized
    __args__['snapshotTime'] = snapshot_time
    __args__['threadId'] = thread_id
    __args__['traceKey'] = trace_key
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApmTraces/getTraceSnapshotData:getTraceSnapshotData', __args__, opts=opts, typ=GetTraceSnapshotDataResult)
    return __ret__.apply(lambda __response__: GetTraceSnapshotDataResult(
        apm_domain_id=pulumi.get(__response__, 'apm_domain_id'),
        id=pulumi.get(__response__, 'id'),
        is_summarized=pulumi.get(__response__, 'is_summarized'),
        key=pulumi.get(__response__, 'key'),
        snapshot_time=pulumi.get(__response__, 'snapshot_time'),
        thread_id=pulumi.get(__response__, 'thread_id'),
        time_ended=pulumi.get(__response__, 'time_ended'),
        time_started=pulumi.get(__response__, 'time_started'),
        trace_key=pulumi.get(__response__, 'trace_key'),
        trace_snapshot_details=pulumi.get(__response__, 'trace_snapshot_details')))
