# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ComputeGpuMemoryFabricArgs', 'ComputeGpuMemoryFabric']

@pulumi.input_type
class ComputeGpuMemoryFabricArgs:
    def __init__(__self__, *,
                 compute_gpu_memory_fabric_id: pulumi.Input[_builtins.str],
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ComputeGpuMemoryFabric resource.
        :param pulumi.Input[_builtins.str] compute_gpu_memory_fabric_id: The OCID of the compute GPU memory fabric.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compute_gpu_memory_fabric_id", compute_gpu_memory_fabric_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @_builtins.property
    @pulumi.getter(name="computeGpuMemoryFabricId")
    def compute_gpu_memory_fabric_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the compute GPU memory fabric.
        """
        return pulumi.get(self, "compute_gpu_memory_fabric_id")

    @compute_gpu_memory_fabric_id.setter
    def compute_gpu_memory_fabric_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compute_gpu_memory_fabric_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _ComputeGpuMemoryFabricState:
    def __init__(__self__, *,
                 additional_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_gpu_memory_fabric_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_hpc_island_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_local_block_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_network_block_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fabric_health: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 healthy_host_count: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 total_host_count: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ComputeGpuMemoryFabric resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_data: Additional data that can be exposed to the customer. Right now it will include the switch tray ids.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        :param pulumi.Input[_builtins.str] compute_gpu_memory_fabric_id: The OCID of the compute GPU memory fabric.
        :param pulumi.Input[_builtins.str] compute_hpc_island_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique HPC Island
        :param pulumi.Input[_builtins.str] compute_local_block_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Local Block
        :param pulumi.Input[_builtins.str] compute_network_block_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Network Block
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] fabric_health: The health state of the GPU memory fabric
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] healthy_host_count: The total number of healthy bare metal hosts located in this compute GPU memory fabric.
        :param pulumi.Input[_builtins.str] state: The lifecycle state of the GPU memory fabric
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time that the compute GPU memory fabric record was created, in the format defined by [RFC3339] (https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] total_host_count: The total number of bare metal hosts located in this compute GPU memory fabric.
        """
        if additional_data is not None:
            pulumi.set(__self__, "additional_data", additional_data)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_gpu_memory_fabric_id is not None:
            pulumi.set(__self__, "compute_gpu_memory_fabric_id", compute_gpu_memory_fabric_id)
        if compute_hpc_island_id is not None:
            pulumi.set(__self__, "compute_hpc_island_id", compute_hpc_island_id)
        if compute_local_block_id is not None:
            pulumi.set(__self__, "compute_local_block_id", compute_local_block_id)
        if compute_network_block_id is not None:
            pulumi.set(__self__, "compute_network_block_id", compute_network_block_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fabric_health is not None:
            pulumi.set(__self__, "fabric_health", fabric_health)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if healthy_host_count is not None:
            pulumi.set(__self__, "healthy_host_count", healthy_host_count)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if total_host_count is not None:
            pulumi.set(__self__, "total_host_count", total_host_count)

    @_builtins.property
    @pulumi.getter(name="additionalData")
    def additional_data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Additional data that can be exposed to the customer. Right now it will include the switch tray ids.
        """
        return pulumi.get(self, "additional_data")

    @additional_data.setter
    def additional_data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_data", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="computeGpuMemoryFabricId")
    def compute_gpu_memory_fabric_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the compute GPU memory fabric.
        """
        return pulumi.get(self, "compute_gpu_memory_fabric_id")

    @compute_gpu_memory_fabric_id.setter
    def compute_gpu_memory_fabric_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_gpu_memory_fabric_id", value)

    @_builtins.property
    @pulumi.getter(name="computeHpcIslandId")
    def compute_hpc_island_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique HPC Island
        """
        return pulumi.get(self, "compute_hpc_island_id")

    @compute_hpc_island_id.setter
    def compute_hpc_island_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_hpc_island_id", value)

    @_builtins.property
    @pulumi.getter(name="computeLocalBlockId")
    def compute_local_block_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Local Block
        """
        return pulumi.get(self, "compute_local_block_id")

    @compute_local_block_id.setter
    def compute_local_block_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_local_block_id", value)

    @_builtins.property
    @pulumi.getter(name="computeNetworkBlockId")
    def compute_network_block_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Network Block
        """
        return pulumi.get(self, "compute_network_block_id")

    @compute_network_block_id.setter
    def compute_network_block_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_network_block_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="fabricHealth")
    def fabric_health(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The health state of the GPU memory fabric
        """
        return pulumi.get(self, "fabric_health")

    @fabric_health.setter
    def fabric_health(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fabric_health", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="healthyHostCount")
    def healthy_host_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The total number of healthy bare metal hosts located in this compute GPU memory fabric.
        """
        return pulumi.get(self, "healthy_host_count")

    @healthy_host_count.setter
    def healthy_host_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "healthy_host_count", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lifecycle state of the GPU memory fabric
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the compute GPU memory fabric record was created, in the format defined by [RFC3339] (https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="totalHostCount")
    def total_host_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The total number of bare metal hosts located in this compute GPU memory fabric.
        """
        return pulumi.get(self, "total_host_count")

    @total_host_count.setter
    def total_host_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "total_host_count", value)


@pulumi.type_token("oci:Core/computeGpuMemoryFabric:ComputeGpuMemoryFabric")
class ComputeGpuMemoryFabric(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_gpu_memory_fabric_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Compute Gpu Memory Fabric resource in Oracle Cloud Infrastructure Core service.

        Customer can update displayName and tags for compute GPU memory fabric record

        ## Import

        ComputeGpuMemoryFabrics can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/computeGpuMemoryFabric:ComputeGpuMemoryFabric test_compute_gpu_memory_fabric "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        :param pulumi.Input[_builtins.str] compute_gpu_memory_fabric_id: The OCID of the compute GPU memory fabric.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeGpuMemoryFabricArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Compute Gpu Memory Fabric resource in Oracle Cloud Infrastructure Core service.

        Customer can update displayName and tags for compute GPU memory fabric record

        ## Import

        ComputeGpuMemoryFabrics can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/computeGpuMemoryFabric:ComputeGpuMemoryFabric test_compute_gpu_memory_fabric "id"
        ```

        :param str resource_name: The name of the resource.
        :param ComputeGpuMemoryFabricArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeGpuMemoryFabricArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_gpu_memory_fabric_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeGpuMemoryFabricArgs.__new__(ComputeGpuMemoryFabricArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            if compute_gpu_memory_fabric_id is None and not opts.urn:
                raise TypeError("Missing required property 'compute_gpu_memory_fabric_id'")
            __props__.__dict__["compute_gpu_memory_fabric_id"] = compute_gpu_memory_fabric_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["additional_data"] = None
            __props__.__dict__["compute_hpc_island_id"] = None
            __props__.__dict__["compute_local_block_id"] = None
            __props__.__dict__["compute_network_block_id"] = None
            __props__.__dict__["fabric_health"] = None
            __props__.__dict__["healthy_host_count"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["total_host_count"] = None
        super(ComputeGpuMemoryFabric, __self__).__init__(
            'oci:Core/computeGpuMemoryFabric:ComputeGpuMemoryFabric',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_data: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute_gpu_memory_fabric_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute_hpc_island_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute_local_block_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute_network_block_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            fabric_health: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            healthy_host_count: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            total_host_count: Optional[pulumi.Input[_builtins.str]] = None) -> 'ComputeGpuMemoryFabric':
        """
        Get an existing ComputeGpuMemoryFabric resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_data: Additional data that can be exposed to the customer. Right now it will include the switch tray ids.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        :param pulumi.Input[_builtins.str] compute_gpu_memory_fabric_id: The OCID of the compute GPU memory fabric.
        :param pulumi.Input[_builtins.str] compute_hpc_island_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique HPC Island
        :param pulumi.Input[_builtins.str] compute_local_block_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Local Block
        :param pulumi.Input[_builtins.str] compute_network_block_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Network Block
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] fabric_health: The health state of the GPU memory fabric
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] healthy_host_count: The total number of healthy bare metal hosts located in this compute GPU memory fabric.
        :param pulumi.Input[_builtins.str] state: The lifecycle state of the GPU memory fabric
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time that the compute GPU memory fabric record was created, in the format defined by [RFC3339] (https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] total_host_count: The total number of bare metal hosts located in this compute GPU memory fabric.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeGpuMemoryFabricState.__new__(_ComputeGpuMemoryFabricState)

        __props__.__dict__["additional_data"] = additional_data
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_gpu_memory_fabric_id"] = compute_gpu_memory_fabric_id
        __props__.__dict__["compute_hpc_island_id"] = compute_hpc_island_id
        __props__.__dict__["compute_local_block_id"] = compute_local_block_id
        __props__.__dict__["compute_network_block_id"] = compute_network_block_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fabric_health"] = fabric_health
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["healthy_host_count"] = healthy_host_count
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["total_host_count"] = total_host_count
        return ComputeGpuMemoryFabric(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalData")
    def additional_data(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Additional data that can be exposed to the customer. Right now it will include the switch tray ids.
        """
        return pulumi.get(self, "additional_data")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment. This should always be the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="computeGpuMemoryFabricId")
    def compute_gpu_memory_fabric_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the compute GPU memory fabric.
        """
        return pulumi.get(self, "compute_gpu_memory_fabric_id")

    @_builtins.property
    @pulumi.getter(name="computeHpcIslandId")
    def compute_hpc_island_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique HPC Island
        """
        return pulumi.get(self, "compute_hpc_island_id")

    @_builtins.property
    @pulumi.getter(name="computeLocalBlockId")
    def compute_local_block_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Local Block
        """
        return pulumi.get(self, "compute_local_block_id")

    @_builtins.property
    @pulumi.getter(name="computeNetworkBlockId")
    def compute_network_block_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for Customer-unique Network Block
        """
        return pulumi.get(self, "compute_network_block_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="fabricHealth")
    def fabric_health(self) -> pulumi.Output[_builtins.str]:
        """
        The health state of the GPU memory fabric
        """
        return pulumi.get(self, "fabric_health")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="healthyHostCount")
    def healthy_host_count(self) -> pulumi.Output[_builtins.str]:
        """
        The total number of healthy bare metal hosts located in this compute GPU memory fabric.
        """
        return pulumi.get(self, "healthy_host_count")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The lifecycle state of the GPU memory fabric
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the compute GPU memory fabric record was created, in the format defined by [RFC3339] (https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="totalHostCount")
    def total_host_count(self) -> pulumi.Output[_builtins.str]:
        """
        The total number of bare metal hosts located in this compute GPU memory fabric.
        """
        return pulumi.get(self, "total_host_count")

