# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPluggableDatabaseSnapshotsResult',
    'AwaitableGetPluggableDatabaseSnapshotsResult',
    'get_pluggable_database_snapshots',
    'get_pluggable_database_snapshots_output',
]

@pulumi.output_type
class GetPluggableDatabaseSnapshotsResult:
    """
    A collection of values returned by getPluggableDatabaseSnapshots.
    """
    def __init__(__self__, cluster_id=None, compartment_id=None, filters=None, id=None, name=None, pluggable_database_id=None, pluggable_database_snapshots=None, state=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pluggable_database_id and not isinstance(pluggable_database_id, str):
            raise TypeError("Expected argument 'pluggable_database_id' to be a str")
        pulumi.set(__self__, "pluggable_database_id", pluggable_database_id)
        if pluggable_database_snapshots and not isinstance(pluggable_database_snapshots, list):
            raise TypeError("Expected argument 'pluggable_database_snapshots' to be a list")
        pulumi.set(__self__, "pluggable_database_snapshots", pluggable_database_snapshots)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPluggableDatabaseSnapshotsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The user-friendly name for the Database Snapshot. The name should be unique.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pluggableDatabaseId")
    def pluggable_database_id(self) -> Optional[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Pluggable Database.
        """
        return pulumi.get(self, "pluggable_database_id")

    @_builtins.property
    @pulumi.getter(name="pluggableDatabaseSnapshots")
    def pluggable_database_snapshots(self) -> Sequence['outputs.GetPluggableDatabaseSnapshotsPluggableDatabaseSnapshotResult']:
        """
        The list of pluggable_database_snapshots.
        """
        return pulumi.get(self, "pluggable_database_snapshots")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Exadata Pluggable Database Snapshot.
        """
        return pulumi.get(self, "state")


class AwaitableGetPluggableDatabaseSnapshotsResult(GetPluggableDatabaseSnapshotsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPluggableDatabaseSnapshotsResult(
            cluster_id=self.cluster_id,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            pluggable_database_id=self.pluggable_database_id,
            pluggable_database_snapshots=self.pluggable_database_snapshots,
            state=self.state)


def get_pluggable_database_snapshots(cluster_id: Optional[_builtins.str] = None,
                                     compartment_id: Optional[_builtins.str] = None,
                                     filters: Optional[Sequence[Union['GetPluggableDatabaseSnapshotsFilterArgs', 'GetPluggableDatabaseSnapshotsFilterArgsDict']]] = None,
                                     name: Optional[_builtins.str] = None,
                                     pluggable_database_id: Optional[_builtins.str] = None,
                                     state: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPluggableDatabaseSnapshotsResult:
    """
    This data source provides the list of Pluggable Database Snapshots in Oracle Cloud Infrastructure Database service.

    Gets a list of the Exadata Pluggable Database Snapshots in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pluggable_database_snapshots = oci.Database.get_pluggable_database_snapshots(cluster_id=test_cluster["id"],
        compartment_id=compartment_id,
        name=pluggable_database_snapshot_name,
        pluggable_database_id=test_pluggable_database["id"],
        state=pluggable_database_snapshot_state)
    ```


    :param _builtins.str cluster_id: A filter to return only Exadata Database Node Snapshots that match the given VM cluster.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str name: A filter to return only resources that match the entire name given. The match is not case sensitive.
    :param _builtins.str pluggable_database_id: A filter to return only Exadata Pluggable Database Snapshots that match the given database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str state: A filter to return only Exadata Pluggable Database Snapshots that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['pluggableDatabaseId'] = pluggable_database_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getPluggableDatabaseSnapshots:getPluggableDatabaseSnapshots', __args__, opts=opts, typ=GetPluggableDatabaseSnapshotsResult).value

    return AwaitableGetPluggableDatabaseSnapshotsResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        pluggable_database_id=pulumi.get(__ret__, 'pluggable_database_id'),
        pluggable_database_snapshots=pulumi.get(__ret__, 'pluggable_database_snapshots'),
        state=pulumi.get(__ret__, 'state'))
def get_pluggable_database_snapshots_output(cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPluggableDatabaseSnapshotsFilterArgs', 'GetPluggableDatabaseSnapshotsFilterArgsDict']]]]] = None,
                                            name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            pluggable_database_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPluggableDatabaseSnapshotsResult]:
    """
    This data source provides the list of Pluggable Database Snapshots in Oracle Cloud Infrastructure Database service.

    Gets a list of the Exadata Pluggable Database Snapshots in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pluggable_database_snapshots = oci.Database.get_pluggable_database_snapshots(cluster_id=test_cluster["id"],
        compartment_id=compartment_id,
        name=pluggable_database_snapshot_name,
        pluggable_database_id=test_pluggable_database["id"],
        state=pluggable_database_snapshot_state)
    ```


    :param _builtins.str cluster_id: A filter to return only Exadata Database Node Snapshots that match the given VM cluster.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str name: A filter to return only resources that match the entire name given. The match is not case sensitive.
    :param _builtins.str pluggable_database_id: A filter to return only Exadata Pluggable Database Snapshots that match the given database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str state: A filter to return only Exadata Pluggable Database Snapshots that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['pluggableDatabaseId'] = pluggable_database_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getPluggableDatabaseSnapshots:getPluggableDatabaseSnapshots', __args__, opts=opts, typ=GetPluggableDatabaseSnapshotsResult)
    return __ret__.apply(lambda __response__: GetPluggableDatabaseSnapshotsResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        pluggable_database_id=pulumi.get(__response__, 'pluggable_database_id'),
        pluggable_database_snapshots=pulumi.get(__response__, 'pluggable_database_snapshots'),
        state=pulumi.get(__response__, 'state')))
