# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DataAssetArgs', 'DataAsset']

@pulumi.input_type
class DataAssetArgs:
    def __init__(__self__, *,
                 catalog_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 type_key: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DataAsset resource.
        :param pulumi.Input[_builtins.str] catalog_id: Unique catalog identifier.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] type_key: The key of the data asset type. This can be obtained via the '/types' endpoint.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] description: (Updatable) Detailed description of the data asset.
        """
        pulumi.set(__self__, "catalog_id", catalog_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "type_key", type_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique catalog identifier.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "catalog_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="typeKey")
    def type_key(self) -> pulumi.Input[_builtins.str]:
        """
        The key of the data asset type. This can be obtained via the '/types' endpoint.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type_key")

    @type_key.setter
    def type_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type_key", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Detailed description of the data asset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class _DataAssetState:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_key: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_harvested: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 type_key: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_by_id: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataAsset resources.
        :param pulumi.Input[_builtins.str] catalog_id: Unique catalog identifier.
        :param pulumi.Input[_builtins.str] created_by_id: OCID of the user who created the data asset.
        :param pulumi.Input[_builtins.str] description: (Updatable) Detailed description of the data asset.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] external_key: External URI that can be used to reference the object. Format will differ based on the type of object.
        :param pulumi.Input[_builtins.str] key: Unique data asset key that is immutable.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. An object not in ACTIVE state may have functional limitations, see service documentation for details.
        :param pulumi.Input[_builtins.str] state: The current state of the data asset.
        :param pulumi.Input[_builtins.str] time_created: The date and time the data asset was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2019-03-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_harvested: The last time that a harvest was performed on the data asset. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The last time that any change was made to the data asset. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param pulumi.Input[_builtins.str] type_key: The key of the data asset type. This can be obtained via the '/types' endpoint.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] updated_by_id: OCID of the user who last modified the data asset.
        :param pulumi.Input[_builtins.str] uri: URI to the data asset instance in the API.
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if created_by_id is not None:
            pulumi.set(__self__, "created_by_id", created_by_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_key is not None:
            pulumi.set(__self__, "external_key", external_key)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_harvested is not None:
            pulumi.set(__self__, "time_harvested", time_harvested)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type_key is not None:
            pulumi.set(__self__, "type_key", type_key)
        if updated_by_id is not None:
            pulumi.set(__self__, "updated_by_id", updated_by_id)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique catalog identifier.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @_builtins.property
    @pulumi.getter(name="createdById")
    def created_by_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the user who created the data asset.
        """
        return pulumi.get(self, "created_by_id")

    @created_by_id.setter
    def created_by_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Detailed description of the data asset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="externalKey")
    def external_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External URI that can be used to reference the object. Format will differ based on the type of object.
        """
        return pulumi.get(self, "external_key")

    @external_key.setter
    def external_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_key", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique data asset key that is immutable.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. An object not in ACTIVE state may have functional limitations, see service documentation for details.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the data asset.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the data asset was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2019-03-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeHarvested")
    def time_harvested(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last time that a harvest was performed on the data asset. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_harvested")

    @time_harvested.setter
    def time_harvested(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_harvested", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last time that any change was made to the data asset. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="typeKey")
    def type_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key of the data asset type. This can be obtained via the '/types' endpoint.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type_key")

    @type_key.setter
    def type_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type_key", value)

    @_builtins.property
    @pulumi.getter(name="updatedById")
    def updated_by_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the user who last modified the data asset.
        """
        return pulumi.get(self, "updated_by_id")

    @updated_by_id.setter
    def updated_by_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_by_id", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI to the data asset instance in the API.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)


@pulumi.type_token("oci:DataCatalog/dataAsset:DataAsset")
class DataAsset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Data Asset resource in Oracle Cloud Infrastructure Data Catalog service.

        Create a new data asset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_data_asset = oci.datacatalog.DataAsset("test_data_asset",
            catalog_id=test_catalog["id"],
            display_name=data_asset_display_name,
            type_key=data_asset_type_key,
            description=data_asset_description,
            properties=data_asset_properties)
        ```

        ## Import

        DataAssets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataCatalog/dataAsset:DataAsset test_data_asset "catalogs/{catalogId}/dataAssets/{dataAssetKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_id: Unique catalog identifier.
        :param pulumi.Input[_builtins.str] description: (Updatable) Detailed description of the data asset.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] type_key: The key of the data asset type. This can be obtained via the '/types' endpoint.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataAssetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Data Asset resource in Oracle Cloud Infrastructure Data Catalog service.

        Create a new data asset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_data_asset = oci.datacatalog.DataAsset("test_data_asset",
            catalog_id=test_catalog["id"],
            display_name=data_asset_display_name,
            type_key=data_asset_type_key,
            description=data_asset_description,
            properties=data_asset_properties)
        ```

        ## Import

        DataAssets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataCatalog/dataAsset:DataAsset test_data_asset "catalogs/{catalogId}/dataAssets/{dataAssetKey}"
        ```

        :param str resource_name: The name of the resource.
        :param DataAssetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataAssetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataAssetArgs.__new__(DataAssetArgs)

            if catalog_id is None and not opts.urn:
                raise TypeError("Missing required property 'catalog_id'")
            __props__.__dict__["catalog_id"] = catalog_id
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["properties"] = properties
            if type_key is None and not opts.urn:
                raise TypeError("Missing required property 'type_key'")
            __props__.__dict__["type_key"] = type_key
            __props__.__dict__["created_by_id"] = None
            __props__.__dict__["external_key"] = None
            __props__.__dict__["key"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_harvested"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["updated_by_id"] = None
            __props__.__dict__["uri"] = None
        super(DataAsset, __self__).__init__(
            'oci:DataCatalog/dataAsset:DataAsset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_by_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            external_key: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_harvested: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            type_key: Optional[pulumi.Input[_builtins.str]] = None,
            updated_by_id: Optional[pulumi.Input[_builtins.str]] = None,
            uri: Optional[pulumi.Input[_builtins.str]] = None) -> 'DataAsset':
        """
        Get an existing DataAsset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_id: Unique catalog identifier.
        :param pulumi.Input[_builtins.str] created_by_id: OCID of the user who created the data asset.
        :param pulumi.Input[_builtins.str] description: (Updatable) Detailed description of the data asset.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] external_key: External URI that can be used to reference the object. Format will differ based on the type of object.
        :param pulumi.Input[_builtins.str] key: Unique data asset key that is immutable.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message describing the current state in more detail. An object not in ACTIVE state may have functional limitations, see service documentation for details.
        :param pulumi.Input[_builtins.str] state: The current state of the data asset.
        :param pulumi.Input[_builtins.str] time_created: The date and time the data asset was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2019-03-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_harvested: The last time that a harvest was performed on the data asset. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param pulumi.Input[_builtins.str] time_updated: The last time that any change was made to the data asset. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        :param pulumi.Input[_builtins.str] type_key: The key of the data asset type. This can be obtained via the '/types' endpoint.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] updated_by_id: OCID of the user who last modified the data asset.
        :param pulumi.Input[_builtins.str] uri: URI to the data asset instance in the API.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataAssetState.__new__(_DataAssetState)

        __props__.__dict__["catalog_id"] = catalog_id
        __props__.__dict__["created_by_id"] = created_by_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["external_key"] = external_key
        __props__.__dict__["key"] = key
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["properties"] = properties
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_harvested"] = time_harvested
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type_key"] = type_key
        __props__.__dict__["updated_by_id"] = updated_by_id
        __props__.__dict__["uri"] = uri
        return DataAsset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique catalog identifier.
        """
        return pulumi.get(self, "catalog_id")

    @_builtins.property
    @pulumi.getter(name="createdById")
    def created_by_id(self) -> pulumi.Output[_builtins.str]:
        """
        OCID of the user who created the data asset.
        """
        return pulumi.get(self, "created_by_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Detailed description of the data asset.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalKey")
    def external_key(self) -> pulumi.Output[_builtins.str]:
        """
        External URI that can be used to reference the object. Format will differ based on the type of object.
        """
        return pulumi.get(self, "external_key")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        Unique data asset key that is immutable.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. An object not in ACTIVE state may have functional limitations, see service documentation for details.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the data asset.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the data asset was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2019-03-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeHarvested")
    def time_harvested(self) -> pulumi.Output[_builtins.str]:
        """
        The last time that a harvest was performed on the data asset. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_harvested")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The last time that any change was made to the data asset. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="typeKey")
    def type_key(self) -> pulumi.Output[_builtins.str]:
        """
        The key of the data asset type. This can be obtained via the '/types' endpoint.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type_key")

    @_builtins.property
    @pulumi.getter(name="updatedById")
    def updated_by_id(self) -> pulumi.Output[_builtins.str]:
        """
        OCID of the user who last modified the data asset.
        """
        return pulumi.get(self, "updated_by_id")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Output[_builtins.str]:
        """
        URI to the data asset instance in the API.
        """
        return pulumi.get(self, "uri")

