# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RepositoryArgs', 'Repository']

@pulumi.input_type
class RepositoryArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 repository_type: pulumi.Input[_builtins.str],
                 default_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mirror_repository_config: Optional[pulumi.Input['RepositoryMirrorRepositoryConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_repository_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Repository resource.
        :param pulumi.Input[_builtins.str] project_id: The OCID of the DevOps project containing the repository.
        :param pulumi.Input[_builtins.str] repository_type: (Updatable) Type of repository. Allowed values:  `MIRRORED`  `HOSTED` `FORKED` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] default_branch: (Updatable) The default branch of the repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Details of the repository. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input['RepositoryMirrorRepositoryConfigArgs'] mirror_repository_config: (Updatable) Configuration information for mirroring the repository.
        :param pulumi.Input[_builtins.str] name: (Updatable) Name of the repository. Should be unique within the project.
        :param pulumi.Input[_builtins.str] parent_repository_id: The OCID of the parent repository.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "repository_type", repository_type)
        if default_branch is not None:
            pulumi.set(__self__, "default_branch", default_branch)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if mirror_repository_config is not None:
            pulumi.set(__self__, "mirror_repository_config", mirror_repository_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_repository_id is not None:
            pulumi.set(__self__, "parent_repository_id", parent_repository_id)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the DevOps project containing the repository.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="repositoryType")
    def repository_type(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Type of repository. Allowed values:  `MIRRORED`  `HOSTED` `FORKED` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_type")

    @repository_type.setter
    def repository_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The default branch of the repository.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_branch", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Details of the repository. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="mirrorRepositoryConfig")
    def mirror_repository_config(self) -> Optional[pulumi.Input['RepositoryMirrorRepositoryConfigArgs']]:
        """
        (Updatable) Configuration information for mirroring the repository.
        """
        return pulumi.get(self, "mirror_repository_config")

    @mirror_repository_config.setter
    def mirror_repository_config(self, value: Optional[pulumi.Input['RepositoryMirrorRepositoryConfigArgs']]):
        pulumi.set(self, "mirror_repository_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Name of the repository. Should be unique within the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentRepositoryId")
    def parent_repository_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the parent repository.
        """
        return pulumi.get(self, "parent_repository_id")

    @parent_repository_id.setter
    def parent_repository_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_repository_id", value)


@pulumi.input_type
class _RepositoryState:
    def __init__(__self__, *,
                 branch_count: Optional[pulumi.Input[_builtins.int]] = None,
                 commit_count: Optional[pulumi.Input[_builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 http_url: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecyle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 mirror_repository_config: Optional[pulumi.Input['RepositoryMirrorRepositoryConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_type: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_bytes: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_url: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 trigger_build_events: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Repository resources.
        :param pulumi.Input[_builtins.int] branch_count: The count of the branches present in the repository.
        :param pulumi.Input[_builtins.int] commit_count: The count of the commits present in the repository.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the repository's compartment.
        :param pulumi.Input[_builtins.str] default_branch: (Updatable) The default branch of the repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Details of the repository. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] http_url: HTTP URL that you use to git clone, pull and push.
        :param pulumi.Input[_builtins.str] lifecyle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input['RepositoryMirrorRepositoryConfigArgs'] mirror_repository_config: (Updatable) Configuration information for mirroring the repository.
        :param pulumi.Input[_builtins.str] name: (Updatable) Name of the repository. Should be unique within the project.
        :param pulumi.Input[_builtins.str] namespace: Tenancy unique namespace.
        :param pulumi.Input[_builtins.str] parent_repository_id: The OCID of the parent repository.
        :param pulumi.Input[_builtins.str] project_id: The OCID of the DevOps project containing the repository.
        :param pulumi.Input[_builtins.str] project_name: Unique project name in a namespace.
        :param pulumi.Input[_builtins.str] repository_type: (Updatable) Type of repository. Allowed values:  `MIRRORED`  `HOSTED` `FORKED` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] size_in_bytes: The size of the repository in bytes.
        :param pulumi.Input[_builtins.str] ssh_url: SSH URL that you use to git clone, pull and push.
        :param pulumi.Input[_builtins.str] state: The current state of the repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the repository was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The time the repository was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trigger_build_events: Trigger build events supported for this repository: PUSH - Build is triggered when a push event occurs. PULL_REQUEST_CREATED - Build is triggered when a pull request is created in the repository. PULL_REQUEST_UPDATED - Build is triggered when a push is made to a branch with an open pull request. COMMIT_UPDATES - Build is triggered when new commits are mirrored into a repository.
        """
        if branch_count is not None:
            pulumi.set(__self__, "branch_count", branch_count)
        if commit_count is not None:
            pulumi.set(__self__, "commit_count", commit_count)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if default_branch is not None:
            pulumi.set(__self__, "default_branch", default_branch)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if http_url is not None:
            pulumi.set(__self__, "http_url", http_url)
        if lifecyle_details is not None:
            pulumi.set(__self__, "lifecyle_details", lifecyle_details)
        if mirror_repository_config is not None:
            pulumi.set(__self__, "mirror_repository_config", mirror_repository_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if parent_repository_id is not None:
            pulumi.set(__self__, "parent_repository_id", parent_repository_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if repository_type is not None:
            pulumi.set(__self__, "repository_type", repository_type)
        if size_in_bytes is not None:
            pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        if ssh_url is not None:
            pulumi.set(__self__, "ssh_url", ssh_url)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if trigger_build_events is not None:
            pulumi.set(__self__, "trigger_build_events", trigger_build_events)

    @_builtins.property
    @pulumi.getter(name="branchCount")
    def branch_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The count of the branches present in the repository.
        """
        return pulumi.get(self, "branch_count")

    @branch_count.setter
    def branch_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "branch_count", value)

    @_builtins.property
    @pulumi.getter(name="commitCount")
    def commit_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The count of the commits present in the repository.
        """
        return pulumi.get(self, "commit_count")

    @commit_count.setter
    def commit_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "commit_count", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the repository's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The default branch of the repository.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_branch", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Details of the repository. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="httpUrl")
    def http_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        HTTP URL that you use to git clone, pull and push.
        """
        return pulumi.get(self, "http_url")

    @http_url.setter
    def http_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_url", value)

    @_builtins.property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecyle_details")

    @lifecyle_details.setter
    def lifecyle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecyle_details", value)

    @_builtins.property
    @pulumi.getter(name="mirrorRepositoryConfig")
    def mirror_repository_config(self) -> Optional[pulumi.Input['RepositoryMirrorRepositoryConfigArgs']]:
        """
        (Updatable) Configuration information for mirroring the repository.
        """
        return pulumi.get(self, "mirror_repository_config")

    @mirror_repository_config.setter
    def mirror_repository_config(self, value: Optional[pulumi.Input['RepositoryMirrorRepositoryConfigArgs']]):
        pulumi.set(self, "mirror_repository_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Name of the repository. Should be unique within the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tenancy unique namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="parentRepositoryId")
    def parent_repository_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the parent repository.
        """
        return pulumi.get(self, "parent_repository_id")

    @parent_repository_id.setter
    def parent_repository_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_repository_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the DevOps project containing the repository.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique project name in a namespace.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter(name="repositoryType")
    def repository_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Type of repository. Allowed values:  `MIRRORED`  `HOSTED` `FORKED` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_type")

    @repository_type.setter
    def repository_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_type", value)

    @_builtins.property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The size of the repository in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @size_in_bytes.setter
    def size_in_bytes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size_in_bytes", value)

    @_builtins.property
    @pulumi.getter(name="sshUrl")
    def ssh_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SSH URL that you use to git clone, pull and push.
        """
        return pulumi.get(self, "ssh_url")

    @ssh_url.setter
    def ssh_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssh_url", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the repository.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the repository was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the repository was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter(name="triggerBuildEvents")
    def trigger_build_events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Trigger build events supported for this repository: PUSH - Build is triggered when a push event occurs. PULL_REQUEST_CREATED - Build is triggered when a pull request is created in the repository. PULL_REQUEST_UPDATED - Build is triggered when a push is made to a branch with an open pull request. COMMIT_UPDATES - Build is triggered when new commits are mirrored into a repository.
        """
        return pulumi.get(self, "trigger_build_events")

    @trigger_build_events.setter
    def trigger_build_events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "trigger_build_events", value)


@pulumi.type_token("oci:DevOps/repository:Repository")
class Repository(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mirror_repository_config: Optional[pulumi.Input[Union['RepositoryMirrorRepositoryConfigArgs', 'RepositoryMirrorRepositoryConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Repository resource in Oracle Cloud Infrastructure Devops service.

        Creates a new repository.

        ## Import

        Repositories can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/repository:Repository test_repository "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_branch: (Updatable) The default branch of the repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Details of the repository. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[Union['RepositoryMirrorRepositoryConfigArgs', 'RepositoryMirrorRepositoryConfigArgsDict']] mirror_repository_config: (Updatable) Configuration information for mirroring the repository.
        :param pulumi.Input[_builtins.str] name: (Updatable) Name of the repository. Should be unique within the project.
        :param pulumi.Input[_builtins.str] parent_repository_id: The OCID of the parent repository.
        :param pulumi.Input[_builtins.str] project_id: The OCID of the DevOps project containing the repository.
        :param pulumi.Input[_builtins.str] repository_type: (Updatable) Type of repository. Allowed values:  `MIRRORED`  `HOSTED` `FORKED` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Repository resource in Oracle Cloud Infrastructure Devops service.

        Creates a new repository.

        ## Import

        Repositories can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/repository:Repository test_repository "id"
        ```

        :param str resource_name: The name of the resource.
        :param RepositoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mirror_repository_config: Optional[pulumi.Input[Union['RepositoryMirrorRepositoryConfigArgs', 'RepositoryMirrorRepositoryConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryArgs.__new__(RepositoryArgs)

            __props__.__dict__["default_branch"] = default_branch
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["mirror_repository_config"] = mirror_repository_config
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_repository_id"] = parent_repository_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if repository_type is None and not opts.urn:
                raise TypeError("Missing required property 'repository_type'")
            __props__.__dict__["repository_type"] = repository_type
            __props__.__dict__["branch_count"] = None
            __props__.__dict__["commit_count"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["http_url"] = None
            __props__.__dict__["lifecyle_details"] = None
            __props__.__dict__["namespace"] = None
            __props__.__dict__["project_name"] = None
            __props__.__dict__["size_in_bytes"] = None
            __props__.__dict__["ssh_url"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["trigger_build_events"] = None
        super(Repository, __self__).__init__(
            'oci:DevOps/repository:Repository',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branch_count: Optional[pulumi.Input[_builtins.int]] = None,
            commit_count: Optional[pulumi.Input[_builtins.int]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_branch: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            http_url: Optional[pulumi.Input[_builtins.str]] = None,
            lifecyle_details: Optional[pulumi.Input[_builtins.str]] = None,
            mirror_repository_config: Optional[pulumi.Input[Union['RepositoryMirrorRepositoryConfigArgs', 'RepositoryMirrorRepositoryConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            parent_repository_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_name: Optional[pulumi.Input[_builtins.str]] = None,
            repository_type: Optional[pulumi.Input[_builtins.str]] = None,
            size_in_bytes: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_url: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            trigger_build_events: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Repository':
        """
        Get an existing Repository resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] branch_count: The count of the branches present in the repository.
        :param pulumi.Input[_builtins.int] commit_count: The count of the commits present in the repository.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the repository's compartment.
        :param pulumi.Input[_builtins.str] default_branch: (Updatable) The default branch of the repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) Details of the repository. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] http_url: HTTP URL that you use to git clone, pull and push.
        :param pulumi.Input[_builtins.str] lifecyle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Union['RepositoryMirrorRepositoryConfigArgs', 'RepositoryMirrorRepositoryConfigArgsDict']] mirror_repository_config: (Updatable) Configuration information for mirroring the repository.
        :param pulumi.Input[_builtins.str] name: (Updatable) Name of the repository. Should be unique within the project.
        :param pulumi.Input[_builtins.str] namespace: Tenancy unique namespace.
        :param pulumi.Input[_builtins.str] parent_repository_id: The OCID of the parent repository.
        :param pulumi.Input[_builtins.str] project_id: The OCID of the DevOps project containing the repository.
        :param pulumi.Input[_builtins.str] project_name: Unique project name in a namespace.
        :param pulumi.Input[_builtins.str] repository_type: (Updatable) Type of repository. Allowed values:  `MIRRORED`  `HOSTED` `FORKED` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] size_in_bytes: The size of the repository in bytes.
        :param pulumi.Input[_builtins.str] ssh_url: SSH URL that you use to git clone, pull and push.
        :param pulumi.Input[_builtins.str] state: The current state of the repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The time the repository was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The time the repository was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trigger_build_events: Trigger build events supported for this repository: PUSH - Build is triggered when a push event occurs. PULL_REQUEST_CREATED - Build is triggered when a pull request is created in the repository. PULL_REQUEST_UPDATED - Build is triggered when a push is made to a branch with an open pull request. COMMIT_UPDATES - Build is triggered when new commits are mirrored into a repository.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepositoryState.__new__(_RepositoryState)

        __props__.__dict__["branch_count"] = branch_count
        __props__.__dict__["commit_count"] = commit_count
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["default_branch"] = default_branch
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["http_url"] = http_url
        __props__.__dict__["lifecyle_details"] = lifecyle_details
        __props__.__dict__["mirror_repository_config"] = mirror_repository_config
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["parent_repository_id"] = parent_repository_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["repository_type"] = repository_type
        __props__.__dict__["size_in_bytes"] = size_in_bytes
        __props__.__dict__["ssh_url"] = ssh_url
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["trigger_build_events"] = trigger_build_events
        return Repository(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="branchCount")
    def branch_count(self) -> pulumi.Output[_builtins.int]:
        """
        The count of the branches present in the repository.
        """
        return pulumi.get(self, "branch_count")

    @_builtins.property
    @pulumi.getter(name="commitCount")
    def commit_count(self) -> pulumi.Output[_builtins.int]:
        """
        The count of the commits present in the repository.
        """
        return pulumi.get(self, "commit_count")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the repository's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The default branch of the repository.
        """
        return pulumi.get(self, "default_branch")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Details of the repository. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="httpUrl")
    def http_url(self) -> pulumi.Output[_builtins.str]:
        """
        HTTP URL that you use to git clone, pull and push.
        """
        return pulumi.get(self, "http_url")

    @_builtins.property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecyle_details")

    @_builtins.property
    @pulumi.getter(name="mirrorRepositoryConfig")
    def mirror_repository_config(self) -> pulumi.Output['outputs.RepositoryMirrorRepositoryConfig']:
        """
        (Updatable) Configuration information for mirroring the repository.
        """
        return pulumi.get(self, "mirror_repository_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Name of the repository. Should be unique within the project.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        Tenancy unique namespace.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="parentRepositoryId")
    def parent_repository_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the parent repository.
        """
        return pulumi.get(self, "parent_repository_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the DevOps project containing the repository.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique project name in a namespace.
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter(name="repositoryType")
    def repository_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Type of repository. Allowed values:  `MIRRORED`  `HOSTED` `FORKED` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repository_type")

    @_builtins.property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> pulumi.Output[_builtins.str]:
        """
        The size of the repository in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @_builtins.property
    @pulumi.getter(name="sshUrl")
    def ssh_url(self) -> pulumi.Output[_builtins.str]:
        """
        SSH URL that you use to git clone, pull and push.
        """
        return pulumi.get(self, "ssh_url")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the repository.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The time the repository was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time the repository was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="triggerBuildEvents")
    def trigger_build_events(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Trigger build events supported for this repository: PUSH - Build is triggered when a push event occurs. PULL_REQUEST_CREATED - Build is triggered when a pull request is created in the repository. PULL_REQUEST_UPDATED - Build is triggered when a push is made to a branch with an open pull request. COMMIT_UPDATES - Build is triggered when new commits are mirrored into a repository.
        """
        return pulumi.get(self, "trigger_build_events")

