# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWlmsWlsDomainScanResultsResult',
    'AwaitableGetWlmsWlsDomainScanResultsResult',
    'get_wlms_wls_domain_scan_results',
    'get_wlms_wls_domain_scan_results_output',
]

@pulumi.output_type
class GetWlmsWlsDomainScanResultsResult:
    """
    A collection of values returned by getWlmsWlsDomainScanResults.
    """
    def __init__(__self__, filters=None, id=None, scan_result_collections=None, server_name=None, wls_domain_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if scan_result_collections and not isinstance(scan_result_collections, list):
            raise TypeError("Expected argument 'scan_result_collections' to be a list")
        pulumi.set(__self__, "scan_result_collections", scan_result_collections)
        if server_name and not isinstance(server_name, str):
            raise TypeError("Expected argument 'server_name' to be a str")
        pulumi.set(__self__, "server_name", server_name)
        if wls_domain_id and not isinstance(wls_domain_id, str):
            raise TypeError("Expected argument 'wls_domain_id' to be a str")
        pulumi.set(__self__, "wls_domain_id", wls_domain_id)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWlmsWlsDomainScanResultsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="scanResultCollections")
    def scan_result_collections(self) -> Sequence['outputs.GetWlmsWlsDomainScanResultsScanResultCollectionResult']:
        """
        The list of scan_result_collection.
        """
        return pulumi.get(self, "scan_result_collections")

    @_builtins.property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[_builtins.str]:
        """
        The name of the WebLogic server to which the server check belongs.
        """
        return pulumi.get(self, "server_name")

    @_builtins.property
    @pulumi.getter(name="wlsDomainId")
    def wls_domain_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
        """
        return pulumi.get(self, "wls_domain_id")


class AwaitableGetWlmsWlsDomainScanResultsResult(GetWlmsWlsDomainScanResultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWlmsWlsDomainScanResultsResult(
            filters=self.filters,
            id=self.id,
            scan_result_collections=self.scan_result_collections,
            server_name=self.server_name,
            wls_domain_id=self.wls_domain_id)


def get_wlms_wls_domain_scan_results(filters: Optional[Sequence[Union['GetWlmsWlsDomainScanResultsFilterArgs', 'GetWlmsWlsDomainScanResultsFilterArgsDict']]] = None,
                                     server_name: Optional[_builtins.str] = None,
                                     wls_domain_id: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWlmsWlsDomainScanResultsResult:
    """
    This data source provides the list of Wls Domain Scan Results in Oracle Cloud Infrastructure Wlms service.

    Get all scan results for a server in a specific WebLogic domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wls_domain_scan_results = oci.oci.get_wlms_wls_domain_scan_results(wls_domain_id=test_wls_domain["id"],
        server_name=wls_domain_scan_result_server_name)
    ```


    :param _builtins.str server_name: The name of the server.
    :param _builtins.str wls_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['serverName'] = server_name
    __args__['wlsDomainId'] = wls_domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:oci/getWlmsWlsDomainScanResults:getWlmsWlsDomainScanResults', __args__, opts=opts, typ=GetWlmsWlsDomainScanResultsResult).value

    return AwaitableGetWlmsWlsDomainScanResultsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        scan_result_collections=pulumi.get(__ret__, 'scan_result_collections'),
        server_name=pulumi.get(__ret__, 'server_name'),
        wls_domain_id=pulumi.get(__ret__, 'wls_domain_id'))
def get_wlms_wls_domain_scan_results_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetWlmsWlsDomainScanResultsFilterArgs', 'GetWlmsWlsDomainScanResultsFilterArgsDict']]]]] = None,
                                            server_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            wls_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWlmsWlsDomainScanResultsResult]:
    """
    This data source provides the list of Wls Domain Scan Results in Oracle Cloud Infrastructure Wlms service.

    Get all scan results for a server in a specific WebLogic domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_wls_domain_scan_results = oci.oci.get_wlms_wls_domain_scan_results(wls_domain_id=test_wls_domain["id"],
        server_name=wls_domain_scan_result_server_name)
    ```


    :param _builtins.str server_name: The name of the server.
    :param _builtins.str wls_domain_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['serverName'] = server_name
    __args__['wlsDomainId'] = wls_domain_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:oci/getWlmsWlsDomainScanResults:getWlmsWlsDomainScanResults', __args__, opts=opts, typ=GetWlmsWlsDomainScanResultsResult)
    return __ret__.apply(lambda __response__: GetWlmsWlsDomainScanResultsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        scan_result_collections=pulumi.get(__response__, 'scan_result_collections'),
        server_name=pulumi.get(__response__, 'server_name'),
        wls_domain_id=pulumi.get(__response__, 'wls_domain_id')))
