# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnrollmentStatusArgs', 'EnrollmentStatus']

@pulumi.input_type
class EnrollmentStatusArgs:
    def __init__(__self__, *,
                 enrollment_status_id: pulumi.Input[_builtins.str],
                 status: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a EnrollmentStatus resource.
        :param pulumi.Input[_builtins.str] enrollment_status_id: The unique OCID associated with the enrollment status.
        :param pulumi.Input[_builtins.str] status: (Updatable) The Cloud Advisor enrollment status.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "enrollment_status_id", enrollment_status_id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="enrollmentStatusId")
    def enrollment_status_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique OCID associated with the enrollment status.
        """
        return pulumi.get(self, "enrollment_status_id")

    @enrollment_status_id.setter
    def enrollment_status_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "enrollment_status_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The Cloud Advisor enrollment status.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _EnrollmentStatusState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enrollment_status_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnrollmentStatus resources.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[_builtins.str] enrollment_status_id: The unique OCID associated with the enrollment status.
        :param pulumi.Input[_builtins.str] state: The enrollment status' current state.
        :param pulumi.Input[_builtins.str] status: (Updatable) The Cloud Advisor enrollment status.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] status_reason: The reason for the enrollment status of the tenancy.
        :param pulumi.Input[_builtins.str] time_created: The date and time the enrollment status was created, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the enrollment status was last updated, in the format defined by RFC3339.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if enrollment_status_id is not None:
            pulumi.set(__self__, "enrollment_status_id", enrollment_status_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_reason is not None:
            pulumi.set(__self__, "status_reason", status_reason)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="enrollmentStatusId")
    def enrollment_status_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique OCID associated with the enrollment status.
        """
        return pulumi.get(self, "enrollment_status_id")

    @enrollment_status_id.setter
    def enrollment_status_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enrollment_status_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enrollment status' current state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The Cloud Advisor enrollment status.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reason for the enrollment status of the tenancy.
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_reason", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the enrollment status was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the enrollment status was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:Optimizer/enrollmentStatus:EnrollmentStatus")
class EnrollmentStatus(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enrollment_status_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Enrollment Status resource in Oracle Cloud Infrastructure Optimizer service.

        Updates the enrollment status of the tenancy.

        ## Import

        EnrollmentStatus can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Optimizer/enrollmentStatus:EnrollmentStatus test_enrollment_status "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] enrollment_status_id: The unique OCID associated with the enrollment status.
        :param pulumi.Input[_builtins.str] status: (Updatable) The Cloud Advisor enrollment status.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnrollmentStatusArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Enrollment Status resource in Oracle Cloud Infrastructure Optimizer service.

        Updates the enrollment status of the tenancy.

        ## Import

        EnrollmentStatus can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Optimizer/enrollmentStatus:EnrollmentStatus test_enrollment_status "id"
        ```

        :param str resource_name: The name of the resource.
        :param EnrollmentStatusArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnrollmentStatusArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enrollment_status_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnrollmentStatusArgs.__new__(EnrollmentStatusArgs)

            if enrollment_status_id is None and not opts.urn:
                raise TypeError("Missing required property 'enrollment_status_id'")
            __props__.__dict__["enrollment_status_id"] = enrollment_status_id
            if status is None and not opts.urn:
                raise TypeError("Missing required property 'status'")
            __props__.__dict__["status"] = status
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["status_reason"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(EnrollmentStatus, __self__).__init__(
            'oci:Optimizer/enrollmentStatus:EnrollmentStatus',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            enrollment_status_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            status_reason: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'EnrollmentStatus':
        """
        Get an existing EnrollmentStatus resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The OCID of the compartment.
        :param pulumi.Input[_builtins.str] enrollment_status_id: The unique OCID associated with the enrollment status.
        :param pulumi.Input[_builtins.str] state: The enrollment status' current state.
        :param pulumi.Input[_builtins.str] status: (Updatable) The Cloud Advisor enrollment status.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] status_reason: The reason for the enrollment status of the tenancy.
        :param pulumi.Input[_builtins.str] time_created: The date and time the enrollment status was created, in the format defined by RFC3339.
        :param pulumi.Input[_builtins.str] time_updated: The date and time the enrollment status was last updated, in the format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnrollmentStatusState.__new__(_EnrollmentStatusState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["enrollment_status_id"] = enrollment_status_id
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["status_reason"] = status_reason
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return EnrollmentStatus(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="enrollmentStatusId")
    def enrollment_status_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique OCID associated with the enrollment status.
        """
        return pulumi.get(self, "enrollment_status_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The enrollment status' current state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The Cloud Advisor enrollment status.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Output[_builtins.str]:
        """
        The reason for the enrollment status of the tenancy.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the enrollment status was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the enrollment status was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

