# generated by datamodel-codegen:
#   filename:  data.json
#   timestamp: 2025-04-16T01:50:45+00:00

from __future__ import annotations

from datetime import datetime, timedelta
from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field, RootModel, constr


class DataType(str, Enum):
    oceanumDatamesh = 'oceanumDatamesh'
    dataset = 'dataset'
    featureCollection = 'featureCollection'


class AggregateOps(str, Enum):
    mean = 'mean'
    min = 'min'
    max = 'max'
    std = 'std'
    sum = 'sum'


class CoordSelector(EidosModel):
    coord: str = Field(..., title='Coordinate name')
    values: List[Union[str, int, float]] = Field(
        ..., title='List of coordinate values to select by'
    )


class Function(EidosModel):
    id: str = Field(..., title='Function id')
    args: Dict[str, Any] = Field(..., title='function arguments')
    vselect: Optional[List[str]] = Field(None, title='Apply function to variables')
    replace: Optional[bool] = Field(False, title='Replace input dataset')


class GeoFilterType(str, Enum):
    """
    Type of the geofilter. Can be one of:
    - 'feature': Select with a geojson feature
    - 'bbox': Select with a bounding box
    - 'radius': Select within radius of point
    """

    feature = 'feature'
    radius = 'radius'
    bbox = 'bbox'


class LineString(EidosModel):
    """
    LineString Model
    """

    bbox: Optional[List] = Field(None, title='Bbox')
    type: Literal['LineString'] = Field(..., title='Type')
    coordinates: List[List] = Field(..., min_length=2, title='Coordinates')


class MultiLineString(EidosModel):
    """
    MultiLineString Model
    """

    bbox: Optional[List] = Field(None, title='Bbox')
    type: Literal['MultiLineString'] = Field(..., title='Type')
    coordinates: List[List[List]] = Field(..., title='Coordinates')


class MultiPoint(EidosModel):
    """
    MultiPoint Model
    """

    bbox: Optional[List] = Field(None, title='Bbox')
    type: Literal['MultiPoint'] = Field(..., title='Type')
    coordinates: List[List] = Field(..., title='Coordinates')


class MultiPolygon(EidosModel):
    """
    MultiPolygon Model
    """

    bbox: Optional[List] = Field(None, title='Bbox')
    type: Literal['MultiPolygon'] = Field(..., title='Type')
    coordinates: List[List[List[List]]] = Field(..., title='Coordinates')


class Point(EidosModel):
    """
    Point Model
    """

    bbox: Optional[List] = Field(None, title='Bbox')
    type: Literal['Point'] = Field(..., title='Type')
    coordinates: List = Field(..., title='Coordinates')


class Polygon(EidosModel):
    """
    Polygon Model
    """

    bbox: Optional[List] = Field(None, title='Bbox')
    type: Literal['Polygon'] = Field(..., title='Type')
    coordinates: List[List[List]] = Field(..., title='Coordinates')


class ResampleType(str, Enum):
    mean = 'mean'
    nearest = 'nearest'


class TimeFilterType(str, Enum):
    """
    Type of the timefilter. Can be one of:
    - 'range': Select within a time range
    """

    range = 'range'
    series = 'series'


class Type(str, Enum):
    Feature = 'Feature'


class PointModel(EidosModel):
    """
    Point Model
    """

    coordinates: List[Union[float, int]] = Field(..., title='Coordinates')
    type: Literal['Point'] = Field('Point', title='Type')


class MultiPointModel(EidosModel):
    """
    MultiPoint Model
    """

    coordinates: List[List[Union[float, int]]] = Field(
        ..., min_length=1, title='Coordinates'
    )
    type: Literal['MultiPoint'] = Field('MultiPoint', title='Type')


class LineStringModel(EidosModel):
    """
    LineString Model
    """

    coordinates: List[List[Union[float, int]]] = Field(
        ..., min_length=2, title='Coordinates'
    )
    type: Literal['LineString'] = Field('LineString', title='Type')


class Coordinate(RootModel[List[List[Union[float, int]]]]):
    root: List[List[Union[float, int]]]


class MultiLineStringModel(EidosModel):
    """
    MultiLineString Model
    """

    coordinates: List[Coordinate] = Field(..., min_length=1, title='Coordinates')
    type: Literal['MultiLineString'] = Field('MultiLineString', title='Type')


class PolygonModel(EidosModel):
    """
    Polygon Model
    """

    coordinates: List[Coordinate] = Field(..., min_length=1, title='Coordinates')
    type: Literal['Polygon'] = Field('Polygon', title='Type')


class Coordinate2Item(RootModel[List[List[Union[float, int]]]]):
    root: List[List[Union[float, int]]]


class Coordinate2(RootModel[List[Coordinate2Item]]):
    root: List[Coordinate2Item]


class MultiPolygonModel(EidosModel):
    """
    MultiPolygon Model
    """

    coordinates: List[Coordinate2] = Field(..., min_length=1, title='Coordinates')
    type: Literal['MultiPolygon'] = Field('MultiPolygon', title='Type')


class GeometryCollection(EidosModel):
    """
    GeometryCollection Model
    """

    type: Literal['GeometryCollection'] = Field('GeometryCollection', title='Type')
    geometries: List[
        Union[
            PointModel,
            MultiPointModel,
            LineStringModel,
            MultiLineStringModel,
            PolygonModel,
            MultiPolygonModel,
        ]
    ] = Field(..., title='Geometries')


class Dtype(str, Enum):
    int32 = 'int32'
    int64 = 'int64'
    float32 = 'float32'
    float64 = 'float64'
    string = 'string'


class DataVariable(EidosModel):
    attributes: Optional[Dict[constr(pattern=r'^.*$'), Union[str, float]]] = None
    """
    Attributes of the data variable
    """
    data: List[Union[float, str, List]]
    """
    Data of the variable
    """
    dimensions: Optional[List[str]] = None
    """
    Dimensions of the variable
    """
    dtype: Optional[Dtype] = None


class Dataset(EidosModel):
    """
    Inline dataset
    """

    model_config = ConfigDict(
        extra='allow',
    )
    name: Optional[str] = None
    attributes: Optional[
        Dict[constr(pattern=r'^[A-Za-z0-9_]*$'), Union[str, float, int]]
    ] = None
    """
    Attributes of the dataset
    """
    variables: Dict[constr(pattern=r'^[A-Za-z0-9_]*$'), DataVariable]
    """
    Data variables
    """
    dimensions: Dict[constr(pattern=r'^.*$'), int]
    """
    Dimensions
    """
    coordkeys: Dict[constr(pattern=r'^[xyztg]$'), str]
    """
    Coordinate keys mapping variables to dimensions (x: longitude, y: latitude, z: depth/altitude, g: geometry, t: time)
    """


class Transform(EidosModel):
    """
    Specification for data transform.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    id: constr(pattern=r'^[A-Za-z0-9_]*$')
    name: Optional[str] = None
    """
    Human readable name of this transform instance
    """
    libraries: Optional[Dict[str, Any]] = None
    """
    Libraries to add as key:<Library URL>
    """
    inputs: Optional[List[constr(pattern=r'^[A-Za-z0-9_]*$')]] = None
    """
    List of input data sources
    """
    code: str = Field(..., title='Transform code')
    """
    Transform code as body of function
    """


class Aggregate(EidosModel):
    operations: Optional[List[AggregateOps]] = Field(
        ['mean'], title='Aggregate operations to perform'
    )
    spatial: Optional[bool] = Field(True, title='Aggregate over spatial filter')
    temporal: Optional[bool] = Field(True, title='Aggregate over temporal filter')


class Feature(EidosModel):
    """
    Feature Model
    """

    bbox: Optional[List] = Field(None, title='Bbox')
    type: Literal['Feature'] = Field(..., title='Type')
    geometry: Optional[
        Union[Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon]
    ] = Field(..., title='Geometry')
    properties: Optional[Dict[str, Any]] = Field(..., title='Properties')
    id: Optional[Union[int, str]] = Field(None, title='Id')


class GeoFilter(EidosModel):
    type: Optional[GeoFilterType] = Field('bbox', title='GeoFilter type')
    geom: Union[List[float], Feature] = Field(..., title='bbox OR geojson Feature')
    resolution: Optional[float] = Field(0.0, title='Maximum spatial resolution of data')
    alltouched: Optional[bool] = Field(None, title='Include all touched grid pixels')


class TimeFilter(EidosModel):
    type: Optional[TimeFilterType] = Field('range', title='Timefilter type')
    times: List[Optional[Union[datetime, timedelta]]] = Field(
        ..., title='Time range or series'
    )
    resolution: Optional[str] = Field('native', title='Temporal resolution of data')
    resample: Optional[ResampleType] = Field('mean', title='Resampling operator')


class FeatureModel(EidosModel):
    """
    Feature Model
    """

    type: Optional[Type] = Field(None, title='Type')
    geometry: Optional[
        Union[
            PointModel,
            MultiPointModel,
            LineStringModel,
            MultiLineStringModel,
            PolygonModel,
            MultiPolygonModel,
            GeometryCollection,
        ]
    ] = Field(None, title='Geometry')
    properties: Optional[Dict[str, Any]] = Field(None, title='Properties')
    id: Optional[str] = Field(None, title='Id')
    bbox: Optional[List[Union[float, int]]] = Field(None, title='Bbox')


class Oceanql(EidosModel):
    datasource: str = Field(..., title='The id of the datasource')
    parameters: Optional[Dict[str, Any]] = Field({}, title='Datasource parameters')
    description: Optional[str] = Field(None, title='Optional description of this query')
    variables: Optional[List[str]] = Field(None, title='List of selected variables')
    timefilter: Optional[TimeFilter] = Field(None, title='Time filter')
    geofilter: Optional[GeoFilter] = Field(None, title='Spatial filter or interpolator')
    coordfilter: Optional[List[CoordSelector]] = Field(
        None, title='List of additional coordinate filters'
    )
    crs: Optional[Union[int, str]] = Field(
        None, title='Spatial reference for filter and output'
    )
    aggregate: Optional[Aggregate] = Field(None, title='Aggregate operations')
    functions: Optional[List[Function]] = Field([], title='Functions')
    limit: Optional[int] = Field(None, title='Limit size of response')
    id: Optional[str] = Field(None, title='Unique ID of this query')


class FeatureCollection(EidosModel):
    """
    Feature collection
    """

    id: Optional[str] = None
    features: List[FeatureModel]
    coordkeys: Optional[Dict[str, Any]] = None


class EidosData(EidosModel):
    """
    EIDOS data specification
    """

    id: constr(pattern=r'^[A-Za-z0-9_-]+$')
    """
    Unique ID of the datasource
    """
    dataType: DataType
    dataSpec: Union[Dataset, FeatureCollection, Oceanql]
