# generated by datamodel-codegen:
#   filename:  node/menu.json
#   timestamp: 2025-04-16T01:50:45+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Literal, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict

from . import document, grid, plot, world


class Position(str, Enum):
    """
    Location of menu relative to content
    """

    top = 'top'
    left = 'left'
    bottom = 'bottom'
    right = 'right'


class Trigger(EidosModel):
    """
    Trigger button to open menu
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    label: Optional[str] = None
    icon: Optional[str] = None


class MenuLayoutItem(EidosModel):
    """
    Configuration of nodes in menu layout
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    label: Union[str, List[str]]
    icon: Optional[Union[str, List[str]]] = None


class Menu(EidosModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: str
    """
    Unique id of the node
    """
    nodeType: Literal['menu'] = 'menu'
    activeItem: Optional[str] = None
    position: Optional[Position] = 'top'
    """
    Location of menu relative to content
    """
    open: Optional[bool] = True
    """
    Whether menu is open
    """
    trigger: Optional[Trigger] = None
    """
    Trigger button to open menu
    """
    children: List[Union[world.World, plot.Plot, document.Document, grid.Grid]]
    expandOnMouseOver: Optional[bool] = False
    menuLayout: List[MenuLayoutItem]
