# generated by datamodel-codegen:
#   filename:  node/worldlayer/label.json
#   timestamp: 2025-04-16T01:50:45+00:00

from __future__ import annotations

from typing import Literal, Optional

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict

from .. import world


class LabelLayerDatakeys(EidosModel):
    """
    Mapping from data variables to time(t) and geometry(g)
    """

    g: Optional[str] = None
    t: Optional[str] = None


class LabelStyle(EidosModel):
    lineColor: Optional[world.Color] = None
    """
    Color of the lines
    """
    getBackgroundColor: Optional[world.StyleAccessor] = None
    """
    Background color of the label
    """
    getColor: Optional[world.StyleAccessor] = None
    """
    Font color of the label
    """
    lineWidth: Optional[int] = 1
    """
    Width of the lines
    """
    padding: Optional[int] = 2
    """
    Padding around the label
    """
    fontSize: Optional[int] = 14
    """
    Font size of the label
    """
    fontFamily: Optional[str] = 'Monaco, monospace'
    """
    Font family of the label
    """
    fontWeight: Optional[str] = 'normal'
    """
    Font weight of the label
    """
    iconURL: Optional[str] = ''
    """
    URL of icon to prepend to label
    """


class LabelLayerSpec(EidosModel):
    """
    Specification for Label overlay layer
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    layerType: Literal['label']
    datakeys: Optional[LabelLayerDatakeys] = None
    labelTemplate: str
    """
    Label format string as Handlebars template. See https://handlebarsjs.com/guide/#simple-expressions
    """
    colormap: Optional[world.Colormap] = None
    numberOfLabels: Optional[int] = 20
    """
    Number of labels to show
    """
    lineLength: Optional[int] = 1
    """
    Length of the anchor line
    """
    labelAngle: Optional[int] = 40
    """
    Angle of the label anchor
    """
    style: Optional[LabelStyle] = None
