# -*- coding: utf-8 -*-
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from .branch import Branch, BranchView
from .branch_service import GetBranchRequest, ListBranchesRequest, ListBranchesResponse
from .catalog import (
    AttributesConfig,
    Catalog,
    CatalogAttribute,
    CompletionConfig,
    MerchantCenterFeedFilter,
    MerchantCenterLink,
    MerchantCenterLinkingConfig,
    ProductLevelConfig,
)
from .catalog_service import (
    AddCatalogAttributeRequest,
    BatchRemoveCatalogAttributesRequest,
    BatchRemoveCatalogAttributesResponse,
    GetAttributesConfigRequest,
    GetCompletionConfigRequest,
    GetDefaultBranchRequest,
    GetDefaultBranchResponse,
    ListCatalogsRequest,
    ListCatalogsResponse,
    RemoveCatalogAttributeRequest,
    ReplaceCatalogAttributeRequest,
    SetDefaultBranchRequest,
    UpdateAttributesConfigRequest,
    UpdateCatalogRequest,
    UpdateCompletionConfigRequest,
)
from .common import (
    AttributeConfigLevel,
    Audience,
    ColorInfo,
    Condition,
    CustomAttribute,
    DoubleList,
    FulfillmentInfo,
    Image,
    Interval,
    LocalInventory,
    PinControlMetadata,
    PriceInfo,
    Rating,
    RecommendationsFilteringOption,
    Rule,
    SearchSolutionUseCase,
    SolutionType,
    StringList,
    UserInfo,
)
from .completion_service import CompleteQueryRequest, CompleteQueryResponse
from .control import Control
from .control_service import (
    CreateControlRequest,
    DeleteControlRequest,
    GetControlRequest,
    ListControlsRequest,
    ListControlsResponse,
    UpdateControlRequest,
)
from .conversational_search_service import (
    ConversationalSearchRequest,
    ConversationalSearchResponse,
)
from .export_config import (
    BigQueryOutputResult,
    ExportAnalyticsMetricsRequest,
    ExportAnalyticsMetricsResponse,
    ExportErrorsConfig,
    ExportMetadata,
    ExportProductsRequest,
    ExportProductsResponse,
    ExportUserEventsRequest,
    ExportUserEventsResponse,
    GcsOutputResult,
    OutputConfig,
    OutputResult,
)
from .generative_question import (
    GenerativeQuestionConfig,
    GenerativeQuestionsFeatureConfig,
)
from .generative_question_service import (
    BatchUpdateGenerativeQuestionConfigsRequest,
    BatchUpdateGenerativeQuestionConfigsResponse,
    GetGenerativeQuestionsFeatureConfigRequest,
    ListGenerativeQuestionConfigsRequest,
    ListGenerativeQuestionConfigsResponse,
    UpdateGenerativeQuestionConfigRequest,
    UpdateGenerativeQuestionsFeatureConfigRequest,
)
from .import_config import (
    BigQuerySource,
    CompletionDataInputConfig,
    GcsSource,
    ImportCompletionDataRequest,
    ImportCompletionDataResponse,
    ImportErrorsConfig,
    ImportMetadata,
    ImportProductsRequest,
    ImportProductsResponse,
    ImportUserEventsRequest,
    ImportUserEventsResponse,
    ProductInlineSource,
    ProductInputConfig,
    TransformedUserEventsMetadata,
    UserEventImportSummary,
    UserEventInlineSource,
    UserEventInputConfig,
)
from .merchant_center_account_link import (
    CreateMerchantCenterAccountLinkMetadata,
    MerchantCenterAccountLink,
)
from .merchant_center_account_link_service import (
    CreateMerchantCenterAccountLinkRequest,
    DeleteMerchantCenterAccountLinkRequest,
    ListMerchantCenterAccountLinksRequest,
    ListMerchantCenterAccountLinksResponse,
)
from .model import Model
from .model_service import (
    CreateModelMetadata,
    CreateModelRequest,
    DeleteModelRequest,
    GetModelRequest,
    ListModelsRequest,
    ListModelsResponse,
    PauseModelRequest,
    ResumeModelRequest,
    TuneModelMetadata,
    TuneModelRequest,
    TuneModelResponse,
    UpdateModelRequest,
)
from .prediction_service import PredictRequest, PredictResponse
from .product import Product
from .product_service import (
    AddFulfillmentPlacesMetadata,
    AddFulfillmentPlacesRequest,
    AddFulfillmentPlacesResponse,
    AddLocalInventoriesMetadata,
    AddLocalInventoriesRequest,
    AddLocalInventoriesResponse,
    CreateProductRequest,
    DeleteProductRequest,
    GetProductRequest,
    ListProductsRequest,
    ListProductsResponse,
    RemoveFulfillmentPlacesMetadata,
    RemoveFulfillmentPlacesRequest,
    RemoveFulfillmentPlacesResponse,
    RemoveLocalInventoriesMetadata,
    RemoveLocalInventoriesRequest,
    RemoveLocalInventoriesResponse,
    SetInventoryMetadata,
    SetInventoryRequest,
    SetInventoryResponse,
    UpdateProductRequest,
)
from .project import AlertConfig, LoggingConfig, Project
from .project_service import (
    AcceptTermsRequest,
    EnrollSolutionMetadata,
    EnrollSolutionRequest,
    EnrollSolutionResponse,
    GetAlertConfigRequest,
    GetLoggingConfigRequest,
    GetProjectRequest,
    ListEnrolledSolutionsRequest,
    ListEnrolledSolutionsResponse,
    UpdateAlertConfigRequest,
    UpdateLoggingConfigRequest,
)
from .promotion import Promotion
from .purge_config import (
    PurgeMetadata,
    PurgeProductsMetadata,
    PurgeProductsRequest,
    PurgeProductsResponse,
    PurgeUserEventsRequest,
    PurgeUserEventsResponse,
)
from .safety import HarmCategory, SafetySetting
from .search_service import (
    ExperimentInfo,
    ProductAttributeInterval,
    ProductAttributeValue,
    SearchRequest,
    SearchResponse,
    Tile,
)
from .serving_config import ServingConfig
from .serving_config_service import (
    AddControlRequest,
    CreateServingConfigRequest,
    DeleteServingConfigRequest,
    GetServingConfigRequest,
    ListServingConfigsRequest,
    ListServingConfigsResponse,
    RemoveControlRequest,
    UpdateServingConfigRequest,
)
from .user_event import CompletionDetail, ProductDetail, PurchaseTransaction, UserEvent
from .user_event_service import (
    CollectUserEventRequest,
    RejoinUserEventsMetadata,
    RejoinUserEventsRequest,
    RejoinUserEventsResponse,
    WriteUserEventRequest,
)

__all__ = (
    "Branch",
    "BranchView",
    "GetBranchRequest",
    "ListBranchesRequest",
    "ListBranchesResponse",
    "AttributesConfig",
    "Catalog",
    "CatalogAttribute",
    "CompletionConfig",
    "MerchantCenterFeedFilter",
    "MerchantCenterLink",
    "MerchantCenterLinkingConfig",
    "ProductLevelConfig",
    "AddCatalogAttributeRequest",
    "BatchRemoveCatalogAttributesRequest",
    "BatchRemoveCatalogAttributesResponse",
    "GetAttributesConfigRequest",
    "GetCompletionConfigRequest",
    "GetDefaultBranchRequest",
    "GetDefaultBranchResponse",
    "ListCatalogsRequest",
    "ListCatalogsResponse",
    "RemoveCatalogAttributeRequest",
    "ReplaceCatalogAttributeRequest",
    "SetDefaultBranchRequest",
    "UpdateAttributesConfigRequest",
    "UpdateCatalogRequest",
    "UpdateCompletionConfigRequest",
    "Audience",
    "ColorInfo",
    "Condition",
    "CustomAttribute",
    "DoubleList",
    "FulfillmentInfo",
    "Image",
    "Interval",
    "LocalInventory",
    "PinControlMetadata",
    "PriceInfo",
    "Rating",
    "Rule",
    "StringList",
    "UserInfo",
    "AttributeConfigLevel",
    "RecommendationsFilteringOption",
    "SearchSolutionUseCase",
    "SolutionType",
    "CompleteQueryRequest",
    "CompleteQueryResponse",
    "Control",
    "CreateControlRequest",
    "DeleteControlRequest",
    "GetControlRequest",
    "ListControlsRequest",
    "ListControlsResponse",
    "UpdateControlRequest",
    "ConversationalSearchRequest",
    "ConversationalSearchResponse",
    "BigQueryOutputResult",
    "ExportAnalyticsMetricsRequest",
    "ExportAnalyticsMetricsResponse",
    "ExportErrorsConfig",
    "ExportMetadata",
    "ExportProductsRequest",
    "ExportProductsResponse",
    "ExportUserEventsRequest",
    "ExportUserEventsResponse",
    "GcsOutputResult",
    "OutputConfig",
    "OutputResult",
    "GenerativeQuestionConfig",
    "GenerativeQuestionsFeatureConfig",
    "BatchUpdateGenerativeQuestionConfigsRequest",
    "BatchUpdateGenerativeQuestionConfigsResponse",
    "GetGenerativeQuestionsFeatureConfigRequest",
    "ListGenerativeQuestionConfigsRequest",
    "ListGenerativeQuestionConfigsResponse",
    "UpdateGenerativeQuestionConfigRequest",
    "UpdateGenerativeQuestionsFeatureConfigRequest",
    "BigQuerySource",
    "CompletionDataInputConfig",
    "GcsSource",
    "ImportCompletionDataRequest",
    "ImportCompletionDataResponse",
    "ImportErrorsConfig",
    "ImportMetadata",
    "ImportProductsRequest",
    "ImportProductsResponse",
    "ImportUserEventsRequest",
    "ImportUserEventsResponse",
    "ProductInlineSource",
    "ProductInputConfig",
    "TransformedUserEventsMetadata",
    "UserEventImportSummary",
    "UserEventInlineSource",
    "UserEventInputConfig",
    "CreateMerchantCenterAccountLinkMetadata",
    "MerchantCenterAccountLink",
    "CreateMerchantCenterAccountLinkRequest",
    "DeleteMerchantCenterAccountLinkRequest",
    "ListMerchantCenterAccountLinksRequest",
    "ListMerchantCenterAccountLinksResponse",
    "Model",
    "CreateModelMetadata",
    "CreateModelRequest",
    "DeleteModelRequest",
    "GetModelRequest",
    "ListModelsRequest",
    "ListModelsResponse",
    "PauseModelRequest",
    "ResumeModelRequest",
    "TuneModelMetadata",
    "TuneModelRequest",
    "TuneModelResponse",
    "UpdateModelRequest",
    "PredictRequest",
    "PredictResponse",
    "Product",
    "AddFulfillmentPlacesMetadata",
    "AddFulfillmentPlacesRequest",
    "AddFulfillmentPlacesResponse",
    "AddLocalInventoriesMetadata",
    "AddLocalInventoriesRequest",
    "AddLocalInventoriesResponse",
    "CreateProductRequest",
    "DeleteProductRequest",
    "GetProductRequest",
    "ListProductsRequest",
    "ListProductsResponse",
    "RemoveFulfillmentPlacesMetadata",
    "RemoveFulfillmentPlacesRequest",
    "RemoveFulfillmentPlacesResponse",
    "RemoveLocalInventoriesMetadata",
    "RemoveLocalInventoriesRequest",
    "RemoveLocalInventoriesResponse",
    "SetInventoryMetadata",
    "SetInventoryRequest",
    "SetInventoryResponse",
    "UpdateProductRequest",
    "AlertConfig",
    "LoggingConfig",
    "Project",
    "AcceptTermsRequest",
    "EnrollSolutionMetadata",
    "EnrollSolutionRequest",
    "EnrollSolutionResponse",
    "GetAlertConfigRequest",
    "GetLoggingConfigRequest",
    "GetProjectRequest",
    "ListEnrolledSolutionsRequest",
    "ListEnrolledSolutionsResponse",
    "UpdateAlertConfigRequest",
    "UpdateLoggingConfigRequest",
    "Promotion",
    "PurgeMetadata",
    "PurgeProductsMetadata",
    "PurgeProductsRequest",
    "PurgeProductsResponse",
    "PurgeUserEventsRequest",
    "PurgeUserEventsResponse",
    "SafetySetting",
    "HarmCategory",
    "ExperimentInfo",
    "ProductAttributeInterval",
    "ProductAttributeValue",
    "SearchRequest",
    "SearchResponse",
    "Tile",
    "ServingConfig",
    "AddControlRequest",
    "CreateServingConfigRequest",
    "DeleteServingConfigRequest",
    "GetServingConfigRequest",
    "ListServingConfigsRequest",
    "ListServingConfigsResponse",
    "RemoveControlRequest",
    "UpdateServingConfigRequest",
    "CompletionDetail",
    "ProductDetail",
    "PurchaseTransaction",
    "UserEvent",
    "CollectUserEventRequest",
    "RejoinUserEventsMetadata",
    "RejoinUserEventsRequest",
    "RejoinUserEventsResponse",
    "WriteUserEventRequest",
)
