# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetExternalListenerResult',
    'AwaitableGetExternalListenerResult',
    'get_external_listener',
    'get_external_listener_output',
]

@pulumi.output_type
class GetExternalListenerResult:
    """
    A collection of values returned by getExternalListener.
    """
    def __init__(__self__, additional_details=None, adr_home_directory=None, compartment_id=None, component_name=None, display_name=None, endpoints=None, external_connector_id=None, external_db_home_id=None, external_db_node_id=None, external_db_system_id=None, external_listener_id=None, host_name=None, id=None, lifecycle_details=None, listener_alias=None, listener_ora_location=None, listener_type=None, log_directory=None, oracle_home=None, serviced_asms=None, serviced_databases=None, state=None, time_created=None, time_updated=None, trace_directory=None, version=None):
        if additional_details and not isinstance(additional_details, dict):
            raise TypeError("Expected argument 'additional_details' to be a dict")
        pulumi.set(__self__, "additional_details", additional_details)
        if adr_home_directory and not isinstance(adr_home_directory, str):
            raise TypeError("Expected argument 'adr_home_directory' to be a str")
        pulumi.set(__self__, "adr_home_directory", adr_home_directory)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if component_name and not isinstance(component_name, str):
            raise TypeError("Expected argument 'component_name' to be a str")
        pulumi.set(__self__, "component_name", component_name)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if external_connector_id and not isinstance(external_connector_id, str):
            raise TypeError("Expected argument 'external_connector_id' to be a str")
        pulumi.set(__self__, "external_connector_id", external_connector_id)
        if external_db_home_id and not isinstance(external_db_home_id, str):
            raise TypeError("Expected argument 'external_db_home_id' to be a str")
        pulumi.set(__self__, "external_db_home_id", external_db_home_id)
        if external_db_node_id and not isinstance(external_db_node_id, str):
            raise TypeError("Expected argument 'external_db_node_id' to be a str")
        pulumi.set(__self__, "external_db_node_id", external_db_node_id)
        if external_db_system_id and not isinstance(external_db_system_id, str):
            raise TypeError("Expected argument 'external_db_system_id' to be a str")
        pulumi.set(__self__, "external_db_system_id", external_db_system_id)
        if external_listener_id and not isinstance(external_listener_id, str):
            raise TypeError("Expected argument 'external_listener_id' to be a str")
        pulumi.set(__self__, "external_listener_id", external_listener_id)
        if host_name and not isinstance(host_name, str):
            raise TypeError("Expected argument 'host_name' to be a str")
        pulumi.set(__self__, "host_name", host_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if listener_alias and not isinstance(listener_alias, str):
            raise TypeError("Expected argument 'listener_alias' to be a str")
        pulumi.set(__self__, "listener_alias", listener_alias)
        if listener_ora_location and not isinstance(listener_ora_location, str):
            raise TypeError("Expected argument 'listener_ora_location' to be a str")
        pulumi.set(__self__, "listener_ora_location", listener_ora_location)
        if listener_type and not isinstance(listener_type, str):
            raise TypeError("Expected argument 'listener_type' to be a str")
        pulumi.set(__self__, "listener_type", listener_type)
        if log_directory and not isinstance(log_directory, str):
            raise TypeError("Expected argument 'log_directory' to be a str")
        pulumi.set(__self__, "log_directory", log_directory)
        if oracle_home and not isinstance(oracle_home, str):
            raise TypeError("Expected argument 'oracle_home' to be a str")
        pulumi.set(__self__, "oracle_home", oracle_home)
        if serviced_asms and not isinstance(serviced_asms, list):
            raise TypeError("Expected argument 'serviced_asms' to be a list")
        pulumi.set(__self__, "serviced_asms", serviced_asms)
        if serviced_databases and not isinstance(serviced_databases, list):
            raise TypeError("Expected argument 'serviced_databases' to be a list")
        pulumi.set(__self__, "serviced_databases", serviced_databases)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if trace_directory and not isinstance(trace_directory, str):
            raise TypeError("Expected argument 'trace_directory' to be a str")
        pulumi.set(__self__, "trace_directory", trace_directory)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="additionalDetails")
    def additional_details(self) -> Mapping[str, Any]:
        """
        The additional details of the external listener defined in `{"key": "value"}` format. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "additional_details")

    @property
    @pulumi.getter(name="adrHomeDirectory")
    def adr_home_directory(self) -> str:
        """
        The directory that stores tracing and logging incidents when Automatic Diagnostic Repository (ADR) is enabled.
        """
        return pulumi.get(self, "adr_home_directory")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the external database resides.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="componentName")
    def component_name(self) -> str:
        """
        The name of the external listener.
        """
        return pulumi.get(self, "component_name")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetExternalListenerEndpointResult']:
        """
        The list of protocol addresses the listener is configured to listen on.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="externalConnectorId")
    def external_connector_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external connector.
        """
        return pulumi.get(self, "external_connector_id")

    @property
    @pulumi.getter(name="externalDbHomeId")
    def external_db_home_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB home.
        """
        return pulumi.get(self, "external_db_home_id")

    @property
    @pulumi.getter(name="externalDbNodeId")
    def external_db_node_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB node.
        """
        return pulumi.get(self, "external_db_node_id")

    @property
    @pulumi.getter(name="externalDbSystemId")
    def external_db_system_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external DB system that the listener is a part of.
        """
        return pulumi.get(self, "external_db_system_id")

    @property
    @pulumi.getter(name="externalListenerId")
    def external_listener_id(self) -> str:
        return pulumi.get(self, "external_listener_id")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        The name of the host on which the external listener is running.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external database.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="listenerAlias")
    def listener_alias(self) -> str:
        """
        The listener alias.
        """
        return pulumi.get(self, "listener_alias")

    @property
    @pulumi.getter(name="listenerOraLocation")
    def listener_ora_location(self) -> str:
        """
        The location of the listener configuration file listener.ora.
        """
        return pulumi.get(self, "listener_ora_location")

    @property
    @pulumi.getter(name="listenerType")
    def listener_type(self) -> str:
        """
        The type of listener.
        """
        return pulumi.get(self, "listener_type")

    @property
    @pulumi.getter(name="logDirectory")
    def log_directory(self) -> str:
        """
        The destination directory of the listener log file.
        """
        return pulumi.get(self, "log_directory")

    @property
    @pulumi.getter(name="oracleHome")
    def oracle_home(self) -> str:
        """
        The Oracle home location of the listener.
        """
        return pulumi.get(self, "oracle_home")

    @property
    @pulumi.getter(name="servicedAsms")
    def serviced_asms(self) -> Sequence['outputs.GetExternalListenerServicedAsmResult']:
        """
        The list of ASMs that are serviced by the listener.
        """
        return pulumi.get(self, "serviced_asms")

    @property
    @pulumi.getter(name="servicedDatabases")
    def serviced_databases(self) -> Sequence['outputs.GetExternalListenerServicedDatabaseResult']:
        """
        The list of databases that are serviced by the listener.
        """
        return pulumi.get(self, "serviced_databases")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the external listener.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the external listener was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the external listener was last updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="traceDirectory")
    def trace_directory(self) -> str:
        """
        The destination directory of the listener trace file.
        """
        return pulumi.get(self, "trace_directory")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The listener version.
        """
        return pulumi.get(self, "version")


class AwaitableGetExternalListenerResult(GetExternalListenerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalListenerResult(
            additional_details=self.additional_details,
            adr_home_directory=self.adr_home_directory,
            compartment_id=self.compartment_id,
            component_name=self.component_name,
            display_name=self.display_name,
            endpoints=self.endpoints,
            external_connector_id=self.external_connector_id,
            external_db_home_id=self.external_db_home_id,
            external_db_node_id=self.external_db_node_id,
            external_db_system_id=self.external_db_system_id,
            external_listener_id=self.external_listener_id,
            host_name=self.host_name,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            listener_alias=self.listener_alias,
            listener_ora_location=self.listener_ora_location,
            listener_type=self.listener_type,
            log_directory=self.log_directory,
            oracle_home=self.oracle_home,
            serviced_asms=self.serviced_asms,
            serviced_databases=self.serviced_databases,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated,
            trace_directory=self.trace_directory,
            version=self.version)


def get_external_listener(external_listener_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalListenerResult:
    """
    This data source provides details about a specific External Listener resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the external listener specified by `externalListenerId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_listener = oci.DatabaseManagement.get_external_listener(external_listener_id=oci_database_management_external_listener["test_external_listener"]["id"])
    ```


    :param str external_listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external listener.
    """
    __args__ = dict()
    __args__['externalListenerId'] = external_listener_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalListener:getExternalListener', __args__, opts=opts, typ=GetExternalListenerResult).value

    return AwaitableGetExternalListenerResult(
        additional_details=pulumi.get(__ret__, 'additional_details'),
        adr_home_directory=pulumi.get(__ret__, 'adr_home_directory'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        component_name=pulumi.get(__ret__, 'component_name'),
        display_name=pulumi.get(__ret__, 'display_name'),
        endpoints=pulumi.get(__ret__, 'endpoints'),
        external_connector_id=pulumi.get(__ret__, 'external_connector_id'),
        external_db_home_id=pulumi.get(__ret__, 'external_db_home_id'),
        external_db_node_id=pulumi.get(__ret__, 'external_db_node_id'),
        external_db_system_id=pulumi.get(__ret__, 'external_db_system_id'),
        external_listener_id=pulumi.get(__ret__, 'external_listener_id'),
        host_name=pulumi.get(__ret__, 'host_name'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        listener_alias=pulumi.get(__ret__, 'listener_alias'),
        listener_ora_location=pulumi.get(__ret__, 'listener_ora_location'),
        listener_type=pulumi.get(__ret__, 'listener_type'),
        log_directory=pulumi.get(__ret__, 'log_directory'),
        oracle_home=pulumi.get(__ret__, 'oracle_home'),
        serviced_asms=pulumi.get(__ret__, 'serviced_asms'),
        serviced_databases=pulumi.get(__ret__, 'serviced_databases'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        trace_directory=pulumi.get(__ret__, 'trace_directory'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_external_listener)
def get_external_listener_output(external_listener_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExternalListenerResult]:
    """
    This data source provides details about a specific External Listener resource in Oracle Cloud Infrastructure Database Management service.

    Gets the details for the external listener specified by `externalListenerId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_listener = oci.DatabaseManagement.get_external_listener(external_listener_id=oci_database_management_external_listener["test_external_listener"]["id"])
    ```


    :param str external_listener_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the external listener.
    """
    ...
