# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExportArgs', 'Export']

@pulumi.input_type
class ExportArgs:
    def __init__(__self__, *,
                 export_set_id: pulumi.Input[str],
                 file_system_id: pulumi.Input[str],
                 path: pulumi.Input[str],
                 export_options: Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportOptionArgs']]]] = None,
                 is_idmap_groups_for_sys_auth: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Export resource.
        :param pulumi.Input[str] export_set_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this export's export set.
        :param pulumi.Input[str] file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this export's file system.
        :param pulumi.Input[str] path: Path used to access the associated file system.
               
               Avoid entering confidential information.
               
               Example: `/mediafiles`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['ExportExportOptionArgs']]] export_options: (Updatable) Export options for the new export. If left unspecified, defaults to:
               [ { "source" : "0.0.0.0/0", "requirePrivilegedSourcePort" : false, "access": "READ_WRITE", "identitySquash": "NONE", "anonymousUid": 65534, "anonymousGid": 65534, "isAnonymousAccessAllowed": false, "allowedAuth": ["SYS"] } ]
               
               **Note:** Mount targets do not have Internet-routable IP addresses.  Therefore they will not be reachable from the Internet, even if an associated `ClientOptions` item has a source of `0.0.0.0/0`.
               
               **If set to the empty array then the export will not be visible to any clients.**
               
               The export's `exportOptions` can be changed after creation using the `UpdateExport` operation.
        :param pulumi.Input[bool] is_idmap_groups_for_sys_auth: (Updatable) Whether or not the export should use ID mapping for Unix groups rather than the group list provided within an NFS request's RPC header. When this flag is true the Unix UID from the RPC header is used to retrieve the list of secondary groups from a the ID mapping subsystem. The primary GID is always taken from the RPC header. If ID mapping is not configured, incorrectly configured, unavailable, or cannot be used to determine a list of secondary groups then an empty secondary group list is used for authorization. If the number of groups exceeds the limit of 256 groups, the list retrieved from LDAP is truncated to the first 256 groups read.
        """
        pulumi.set(__self__, "export_set_id", export_set_id)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "path", path)
        if export_options is not None:
            pulumi.set(__self__, "export_options", export_options)
        if is_idmap_groups_for_sys_auth is not None:
            pulumi.set(__self__, "is_idmap_groups_for_sys_auth", is_idmap_groups_for_sys_auth)

    @property
    @pulumi.getter(name="exportSetId")
    def export_set_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this export's export set.
        """
        return pulumi.get(self, "export_set_id")

    @export_set_id.setter
    def export_set_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "export_set_id", value)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this export's file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Path used to access the associated file system.

        Avoid entering confidential information.

        Example: `/mediafiles`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="exportOptions")
    def export_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportOptionArgs']]]]:
        """
        (Updatable) Export options for the new export. If left unspecified, defaults to:
        [ { "source" : "0.0.0.0/0", "requirePrivilegedSourcePort" : false, "access": "READ_WRITE", "identitySquash": "NONE", "anonymousUid": 65534, "anonymousGid": 65534, "isAnonymousAccessAllowed": false, "allowedAuth": ["SYS"] } ]

        **Note:** Mount targets do not have Internet-routable IP addresses.  Therefore they will not be reachable from the Internet, even if an associated `ClientOptions` item has a source of `0.0.0.0/0`.

        **If set to the empty array then the export will not be visible to any clients.**

        The export's `exportOptions` can be changed after creation using the `UpdateExport` operation.
        """
        return pulumi.get(self, "export_options")

    @export_options.setter
    def export_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportOptionArgs']]]]):
        pulumi.set(self, "export_options", value)

    @property
    @pulumi.getter(name="isIdmapGroupsForSysAuth")
    def is_idmap_groups_for_sys_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether or not the export should use ID mapping for Unix groups rather than the group list provided within an NFS request's RPC header. When this flag is true the Unix UID from the RPC header is used to retrieve the list of secondary groups from a the ID mapping subsystem. The primary GID is always taken from the RPC header. If ID mapping is not configured, incorrectly configured, unavailable, or cannot be used to determine a list of secondary groups then an empty secondary group list is used for authorization. If the number of groups exceeds the limit of 256 groups, the list retrieved from LDAP is truncated to the first 256 groups read.
        """
        return pulumi.get(self, "is_idmap_groups_for_sys_auth")

    @is_idmap_groups_for_sys_auth.setter
    def is_idmap_groups_for_sys_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_idmap_groups_for_sys_auth", value)


@pulumi.input_type
class _ExportState:
    def __init__(__self__, *,
                 export_options: Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportOptionArgs']]]] = None,
                 export_set_id: Optional[pulumi.Input[str]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 is_idmap_groups_for_sys_auth: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Export resources.
        :param pulumi.Input[Sequence[pulumi.Input['ExportExportOptionArgs']]] export_options: (Updatable) Export options for the new export. If left unspecified, defaults to:
               [ { "source" : "0.0.0.0/0", "requirePrivilegedSourcePort" : false, "access": "READ_WRITE", "identitySquash": "NONE", "anonymousUid": 65534, "anonymousGid": 65534, "isAnonymousAccessAllowed": false, "allowedAuth": ["SYS"] } ]
               
               **Note:** Mount targets do not have Internet-routable IP addresses.  Therefore they will not be reachable from the Internet, even if an associated `ClientOptions` item has a source of `0.0.0.0/0`.
               
               **If set to the empty array then the export will not be visible to any clients.**
               
               The export's `exportOptions` can be changed after creation using the `UpdateExport` operation.
        :param pulumi.Input[str] export_set_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this export's export set.
        :param pulumi.Input[str] file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this export's file system.
        :param pulumi.Input[bool] is_idmap_groups_for_sys_auth: (Updatable) Whether or not the export should use ID mapping for Unix groups rather than the group list provided within an NFS request's RPC header. When this flag is true the Unix UID from the RPC header is used to retrieve the list of secondary groups from a the ID mapping subsystem. The primary GID is always taken from the RPC header. If ID mapping is not configured, incorrectly configured, unavailable, or cannot be used to determine a list of secondary groups then an empty secondary group list is used for authorization. If the number of groups exceeds the limit of 256 groups, the list retrieved from LDAP is truncated to the first 256 groups read.
        :param pulumi.Input[str] path: Path used to access the associated file system.
               
               Avoid entering confidential information.
               
               Example: `/mediafiles`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of this export.
        :param pulumi.Input[str] time_created: The date and time the export was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        if export_options is not None:
            pulumi.set(__self__, "export_options", export_options)
        if export_set_id is not None:
            pulumi.set(__self__, "export_set_id", export_set_id)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if is_idmap_groups_for_sys_auth is not None:
            pulumi.set(__self__, "is_idmap_groups_for_sys_auth", is_idmap_groups_for_sys_auth)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="exportOptions")
    def export_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportOptionArgs']]]]:
        """
        (Updatable) Export options for the new export. If left unspecified, defaults to:
        [ { "source" : "0.0.0.0/0", "requirePrivilegedSourcePort" : false, "access": "READ_WRITE", "identitySquash": "NONE", "anonymousUid": 65534, "anonymousGid": 65534, "isAnonymousAccessAllowed": false, "allowedAuth": ["SYS"] } ]

        **Note:** Mount targets do not have Internet-routable IP addresses.  Therefore they will not be reachable from the Internet, even if an associated `ClientOptions` item has a source of `0.0.0.0/0`.

        **If set to the empty array then the export will not be visible to any clients.**

        The export's `exportOptions` can be changed after creation using the `UpdateExport` operation.
        """
        return pulumi.get(self, "export_options")

    @export_options.setter
    def export_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportOptionArgs']]]]):
        pulumi.set(self, "export_options", value)

    @property
    @pulumi.getter(name="exportSetId")
    def export_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this export's export set.
        """
        return pulumi.get(self, "export_set_id")

    @export_set_id.setter
    def export_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "export_set_id", value)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this export's file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="isIdmapGroupsForSysAuth")
    def is_idmap_groups_for_sys_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether or not the export should use ID mapping for Unix groups rather than the group list provided within an NFS request's RPC header. When this flag is true the Unix UID from the RPC header is used to retrieve the list of secondary groups from a the ID mapping subsystem. The primary GID is always taken from the RPC header. If ID mapping is not configured, incorrectly configured, unavailable, or cannot be used to determine a list of secondary groups then an empty secondary group list is used for authorization. If the number of groups exceeds the limit of 256 groups, the list retrieved from LDAP is truncated to the first 256 groups read.
        """
        return pulumi.get(self, "is_idmap_groups_for_sys_auth")

    @is_idmap_groups_for_sys_auth.setter
    def is_idmap_groups_for_sys_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_idmap_groups_for_sys_auth", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path used to access the associated file system.

        Avoid entering confidential information.

        Example: `/mediafiles`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of this export.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the export was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class Export(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 export_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExportExportOptionArgs']]]]] = None,
                 export_set_id: Optional[pulumi.Input[str]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 is_idmap_groups_for_sys_auth: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Export resource in Oracle Cloud Infrastructure File Storage service.

        Creates a new export in the specified export set, path, and
        file system.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_export = oci.file_storage.Export("testExport",
            export_set_id=oci_file_storage_export_set["test_export_set"]["id"],
            file_system_id=oci_file_storage_file_system["test_file_system"]["id"],
            path=var["export_path"],
            export_options=[oci.file_storage.ExportExportOptionArgs(
                source=var["export_export_options_source"],
                access=var["export_export_options_access"],
                allowed_auths=var["export_export_options_allowed_auth"],
                anonymous_gid=var["export_export_options_anonymous_gid"],
                anonymous_uid=var["export_export_options_anonymous_uid"],
                identity_squash=var["export_export_options_identity_squash"],
                is_anonymous_access_allowed=var["export_export_options_is_anonymous_access_allowed"],
                require_privileged_source_port=var["export_export_options_require_privileged_source_port"],
            )],
            is_idmap_groups_for_sys_auth=var["export_is_idmap_groups_for_sys_auth"])
        ```

        ## Import

        Exports can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:FileStorage/export:Export test_export "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExportExportOptionArgs']]]] export_options: (Updatable) Export options for the new export. If left unspecified, defaults to:
               [ { "source" : "0.0.0.0/0", "requirePrivilegedSourcePort" : false, "access": "READ_WRITE", "identitySquash": "NONE", "anonymousUid": 65534, "anonymousGid": 65534, "isAnonymousAccessAllowed": false, "allowedAuth": ["SYS"] } ]
               
               **Note:** Mount targets do not have Internet-routable IP addresses.  Therefore they will not be reachable from the Internet, even if an associated `ClientOptions` item has a source of `0.0.0.0/0`.
               
               **If set to the empty array then the export will not be visible to any clients.**
               
               The export's `exportOptions` can be changed after creation using the `UpdateExport` operation.
        :param pulumi.Input[str] export_set_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this export's export set.
        :param pulumi.Input[str] file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this export's file system.
        :param pulumi.Input[bool] is_idmap_groups_for_sys_auth: (Updatable) Whether or not the export should use ID mapping for Unix groups rather than the group list provided within an NFS request's RPC header. When this flag is true the Unix UID from the RPC header is used to retrieve the list of secondary groups from a the ID mapping subsystem. The primary GID is always taken from the RPC header. If ID mapping is not configured, incorrectly configured, unavailable, or cannot be used to determine a list of secondary groups then an empty secondary group list is used for authorization. If the number of groups exceeds the limit of 256 groups, the list retrieved from LDAP is truncated to the first 256 groups read.
        :param pulumi.Input[str] path: Path used to access the associated file system.
               
               Avoid entering confidential information.
               
               Example: `/mediafiles`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Export resource in Oracle Cloud Infrastructure File Storage service.

        Creates a new export in the specified export set, path, and
        file system.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_export = oci.file_storage.Export("testExport",
            export_set_id=oci_file_storage_export_set["test_export_set"]["id"],
            file_system_id=oci_file_storage_file_system["test_file_system"]["id"],
            path=var["export_path"],
            export_options=[oci.file_storage.ExportExportOptionArgs(
                source=var["export_export_options_source"],
                access=var["export_export_options_access"],
                allowed_auths=var["export_export_options_allowed_auth"],
                anonymous_gid=var["export_export_options_anonymous_gid"],
                anonymous_uid=var["export_export_options_anonymous_uid"],
                identity_squash=var["export_export_options_identity_squash"],
                is_anonymous_access_allowed=var["export_export_options_is_anonymous_access_allowed"],
                require_privileged_source_port=var["export_export_options_require_privileged_source_port"],
            )],
            is_idmap_groups_for_sys_auth=var["export_is_idmap_groups_for_sys_auth"])
        ```

        ## Import

        Exports can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:FileStorage/export:Export test_export "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 export_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExportExportOptionArgs']]]]] = None,
                 export_set_id: Optional[pulumi.Input[str]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 is_idmap_groups_for_sys_auth: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExportArgs.__new__(ExportArgs)

            __props__.__dict__["export_options"] = export_options
            if export_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'export_set_id'")
            __props__.__dict__["export_set_id"] = export_set_id
            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            __props__.__dict__["is_idmap_groups_for_sys_auth"] = is_idmap_groups_for_sys_auth
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(Export, __self__).__init__(
            'oci:FileStorage/export:Export',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            export_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExportExportOptionArgs']]]]] = None,
            export_set_id: Optional[pulumi.Input[str]] = None,
            file_system_id: Optional[pulumi.Input[str]] = None,
            is_idmap_groups_for_sys_auth: Optional[pulumi.Input[bool]] = None,
            path: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'Export':
        """
        Get an existing Export resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExportExportOptionArgs']]]] export_options: (Updatable) Export options for the new export. If left unspecified, defaults to:
               [ { "source" : "0.0.0.0/0", "requirePrivilegedSourcePort" : false, "access": "READ_WRITE", "identitySquash": "NONE", "anonymousUid": 65534, "anonymousGid": 65534, "isAnonymousAccessAllowed": false, "allowedAuth": ["SYS"] } ]
               
               **Note:** Mount targets do not have Internet-routable IP addresses.  Therefore they will not be reachable from the Internet, even if an associated `ClientOptions` item has a source of `0.0.0.0/0`.
               
               **If set to the empty array then the export will not be visible to any clients.**
               
               The export's `exportOptions` can be changed after creation using the `UpdateExport` operation.
        :param pulumi.Input[str] export_set_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this export's export set.
        :param pulumi.Input[str] file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this export's file system.
        :param pulumi.Input[bool] is_idmap_groups_for_sys_auth: (Updatable) Whether or not the export should use ID mapping for Unix groups rather than the group list provided within an NFS request's RPC header. When this flag is true the Unix UID from the RPC header is used to retrieve the list of secondary groups from a the ID mapping subsystem. The primary GID is always taken from the RPC header. If ID mapping is not configured, incorrectly configured, unavailable, or cannot be used to determine a list of secondary groups then an empty secondary group list is used for authorization. If the number of groups exceeds the limit of 256 groups, the list retrieved from LDAP is truncated to the first 256 groups read.
        :param pulumi.Input[str] path: Path used to access the associated file system.
               
               Avoid entering confidential information.
               
               Example: `/mediafiles`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of this export.
        :param pulumi.Input[str] time_created: The date and time the export was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExportState.__new__(_ExportState)

        __props__.__dict__["export_options"] = export_options
        __props__.__dict__["export_set_id"] = export_set_id
        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["is_idmap_groups_for_sys_auth"] = is_idmap_groups_for_sys_auth
        __props__.__dict__["path"] = path
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return Export(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="exportOptions")
    def export_options(self) -> pulumi.Output[Sequence['outputs.ExportExportOption']]:
        """
        (Updatable) Export options for the new export. If left unspecified, defaults to:
        [ { "source" : "0.0.0.0/0", "requirePrivilegedSourcePort" : false, "access": "READ_WRITE", "identitySquash": "NONE", "anonymousUid": 65534, "anonymousGid": 65534, "isAnonymousAccessAllowed": false, "allowedAuth": ["SYS"] } ]

        **Note:** Mount targets do not have Internet-routable IP addresses.  Therefore they will not be reachable from the Internet, even if an associated `ClientOptions` item has a source of `0.0.0.0/0`.

        **If set to the empty array then the export will not be visible to any clients.**

        The export's `exportOptions` can be changed after creation using the `UpdateExport` operation.
        """
        return pulumi.get(self, "export_options")

    @property
    @pulumi.getter(name="exportSetId")
    def export_set_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this export's export set.
        """
        return pulumi.get(self, "export_set_id")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this export's file system.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="isIdmapGroupsForSysAuth")
    def is_idmap_groups_for_sys_auth(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether or not the export should use ID mapping for Unix groups rather than the group list provided within an NFS request's RPC header. When this flag is true the Unix UID from the RPC header is used to retrieve the list of secondary groups from a the ID mapping subsystem. The primary GID is always taken from the RPC header. If ID mapping is not configured, incorrectly configured, unavailable, or cannot be used to determine a list of secondary groups then an empty secondary group list is used for authorization. If the number of groups exceeds the limit of 256 groups, the list retrieved from LDAP is truncated to the first 256 groups read.
        """
        return pulumi.get(self, "is_idmap_groups_for_sys_auth")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        Path used to access the associated file system.

        Avoid entering confidential information.

        Example: `/mediafiles`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of this export.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the export was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

