# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetProductLicensesResult',
    'AwaitableGetProductLicensesResult',
    'get_product_licenses',
    'get_product_licenses_output',
]

@pulumi.output_type
class GetProductLicensesResult:
    """
    A collection of values returned by getProductLicenses.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, is_compartment_id_in_subtree=None, product_license_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_compartment_id_in_subtree and not isinstance(is_compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'is_compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "is_compartment_id_in_subtree", is_compartment_id_in_subtree)
        if product_license_collections and not isinstance(product_license_collections, list):
            raise TypeError("Expected argument 'product_license_collections' to be a list")
        pulumi.set(__self__, "product_license_collections", product_license_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where the product license is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetProductLicensesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCompartmentIdInSubtree")
    def is_compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "is_compartment_id_in_subtree")

    @property
    @pulumi.getter(name="productLicenseCollections")
    def product_license_collections(self) -> Sequence['outputs.GetProductLicensesProductLicenseCollectionResult']:
        """
        The list of product_license_collection.
        """
        return pulumi.get(self, "product_license_collections")


class AwaitableGetProductLicensesResult(GetProductLicensesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProductLicensesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            is_compartment_id_in_subtree=self.is_compartment_id_in_subtree,
            product_license_collections=self.product_license_collections)


def get_product_licenses(compartment_id: Optional[str] = None,
                         filters: Optional[Sequence[pulumi.InputType['GetProductLicensesFilterArgs']]] = None,
                         is_compartment_id_in_subtree: Optional[bool] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProductLicensesResult:
    """
    This data source provides the list of Product Licenses in Oracle Cloud Infrastructure License Manager service.

    Retrieves all the product licenses from a given compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_product_licenses = oci.LicenseManager.get_product_licenses(compartment_id=var["compartment_id"],
        is_compartment_id_in_subtree=var["product_license_is_compartment_id_in_subtree"])
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) used for the license record, product license, and configuration.
    :param bool is_compartment_id_in_subtree: Indicates if the given compartment is the root compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LicenseManager/getProductLicenses:getProductLicenses', __args__, opts=opts, typ=GetProductLicensesResult).value

    return AwaitableGetProductLicensesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__ret__, 'is_compartment_id_in_subtree'),
        product_license_collections=pulumi.get(__ret__, 'product_license_collections'))


@_utilities.lift_output_func(get_product_licenses)
def get_product_licenses_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetProductLicensesFilterArgs']]]]] = None,
                                is_compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProductLicensesResult]:
    """
    This data source provides the list of Product Licenses in Oracle Cloud Infrastructure License Manager service.

    Retrieves all the product licenses from a given compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_product_licenses = oci.LicenseManager.get_product_licenses(compartment_id=var["compartment_id"],
        is_compartment_id_in_subtree=var["product_license_is_compartment_id_in_subtree"])
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) used for the license record, product license, and configuration.
    :param bool is_compartment_id_in_subtree: Indicates if the given compartment is the root compartment.
    """
    ...
