"""Python wrappers around TensorFlow ops.

This file is MACHINE GENERATED! Do not edit.
Original C++ source file: decode_proto_ops.cc
"""

import collections as _collections
import six as _six

from tensorflow.python import pywrap_tensorflow as _pywrap_tensorflow
from tensorflow.python.eager import context as _context
from tensorflow.python.eager import core as _core
from tensorflow.python.eager import execute as _execute
from tensorflow.python.framework import dtypes as _dtypes
from tensorflow.python.framework import errors as _errors
from tensorflow.python.framework import tensor_shape as _tensor_shape

from tensorflow.core.framework import op_def_pb2 as _op_def_pb2
# Needed to trigger the call to _set_call_cpp_shape_fn.
from tensorflow.python.framework import common_shapes as _common_shapes
from tensorflow.python.framework import op_def_registry as _op_def_registry
from tensorflow.python.framework import ops as _ops
from tensorflow.python.framework import op_def_library as _op_def_library
from tensorflow.python.util.deprecation import deprecated_endpoints
from tensorflow.python.util import dispatch as _dispatch
from tensorflow.python.util.tf_export import tf_export
from tensorflow.python.util.tf_export import kwarg_only as _kwarg_only
from tensorflow.tools.docs import doc_controls as _doc_controls


_decode_proto_v2_outputs = ["sizes", "values"]
_DecodeProtoV2Output = _collections.namedtuple(
    "DecodeProtoV2", _decode_proto_v2_outputs)


def decode_proto_v2(bytes, message_type, field_names, output_types, descriptor_source="local://", message_format="binary", sanitize=False, name=None):
  r"""The op extracts fields from a serialized protocol buffers message into tensors.

  The `decode_proto` op extracts fields from a serialized protocol buffers
  message into tensors.  The fields in `field_names` are decoded and converted
  to the corresponding `output_types` if possible.

  A `message_type` name must be provided to give context for the field
  names. The actual message descriptor can be looked up either in the
  linked-in descriptor pool or a filename provided by the caller using
  the `descriptor_source` attribute.

  Each output tensor is a dense tensor. This means that it is padded to
  hold the largest number of repeated elements seen in the input
  minibatch. (The shape is also padded by one to prevent zero-sized
  dimensions). The actual repeat counts for each example in the
  minibatch can be found in the `sizes` output. In many cases the output
  of `decode_proto` is fed immediately into tf.squeeze if missing values
  are not a concern. When using tf.squeeze, always pass the squeeze
  dimension explicitly to avoid surprises.

  For the most part, the mapping between Proto field types and
  TensorFlow dtypes is straightforward. However, there are a few
  special cases:

  - A proto field that contains a submessage or group can only be converted
  to `DT_STRING` (the serialized submessage). This is to reduce the
  complexity of the API. The resulting string can be used as input
  to another instance of the decode_proto op.

  - TensorFlow lacks support for unsigned integers. The ops represent uint64
  types as a `DT_INT64` with the same twos-complement bit pattern
  (the obvious way). Unsigned int32 values can be represented exactly by
  specifying type `DT_INT64`, or using twos-complement if the caller
  specifies `DT_INT32` in the `output_types` attribute.

  The `descriptor_source` attribute selects a source of protocol
  descriptors to consult when looking up `message_type`. This may be a
  filename containing a serialized `FileDescriptorSet` message,
  or the special value `local://`, in which case only descriptors linked
  into the code will be searched; the filename can be on any filesystem
  accessible to TensorFlow.

  You can build a `descriptor_source` file using the `--descriptor_set_out`
  and `--include_imports` options to the protocol compiler `protoc`.

  The `local://` database only covers descriptors linked into the
  code via C++ libraries, not Python imports. You can link in a proto descriptor
  by creating a cc_library target with alwayslink=1.

  Both binary and text proto serializations are supported, and can be
  chosen using the `format` attribute.

  Args:
    bytes: A `Tensor` of type `string`.
      Tensor of serialized protos with shape `batch_shape`.
    message_type: A `string`. Name of the proto message type to decode.
    field_names: A list of `strings`.
      List of strings containing proto field names. An extension field can be decoded
      by using its full name, e.g. EXT_PACKAGE.EXT_FIELD_NAME.
    output_types: A list of `tf.DTypes`.
      List of TF types to use for the respective field in field_names.
    descriptor_source: An optional `string`. Defaults to `"local://"`.
      Either the special value `local://` or a path to a file containing
      a serialized `FileDescriptorSet`.
    message_format: An optional `string`. Defaults to `"binary"`.
      Either `binary` or `text`.
    sanitize: An optional `bool`. Defaults to `False`.
      Whether to sanitize the result or not.
    name: A name for the operation (optional).

  Returns:
    A tuple of `Tensor` objects (sizes, values).

    sizes: A `Tensor` of type `int32`.
    values: A list of `Tensor` objects of type `output_types`.
  """
  _ctx = _context._context or _context.context()
  if _ctx is not None and _ctx._thread_local_data.is_eager:
    try:
      _result = _pywrap_tensorflow.TFE_Py_FastPathExecute(
        _ctx._context_handle, _ctx._thread_local_data.device_name,
        "DecodeProtoV2", name, _ctx._post_execution_callbacks, bytes,
        "message_type", message_type, "field_names", field_names,
        "output_types", output_types, "descriptor_source", descriptor_source,
        "message_format", message_format, "sanitize", sanitize)
      _result = _DecodeProtoV2Output._make(_result)
      return _result
    except _core._FallbackException:
      try:
        return decode_proto_v2_eager_fallback(
            bytes, message_type=message_type, field_names=field_names,
            output_types=output_types, descriptor_source=descriptor_source,
            message_format=message_format, sanitize=sanitize, name=name,
            ctx=_ctx)
      except _core._SymbolicException:
        pass  # Add nodes to the TensorFlow graph.
    except _core._NotOkStatusException as e:
      if name is not None:
        message = e.message + " name: " + name
      else:
        message = e.message
      _six.raise_from(_core._status_to_exception(e.code, message), None)
  # Add nodes to the TensorFlow graph.
  message_type = _execute.make_str(message_type, "message_type")
  if not isinstance(field_names, (list, tuple)):
    raise TypeError(
        "Expected list for 'field_names' argument to "
        "'decode_proto_v2' Op, not %r." % field_names)
  field_names = [_execute.make_str(_s, "field_names") for _s in field_names]
  if not isinstance(output_types, (list, tuple)):
    raise TypeError(
        "Expected list for 'output_types' argument to "
        "'decode_proto_v2' Op, not %r." % output_types)
  output_types = [_execute.make_type(_t, "output_types") for _t in output_types]
  if descriptor_source is None:
    descriptor_source = "local://"
  descriptor_source = _execute.make_str(descriptor_source, "descriptor_source")
  if message_format is None:
    message_format = "binary"
  message_format = _execute.make_str(message_format, "message_format")
  if sanitize is None:
    sanitize = False
  sanitize = _execute.make_bool(sanitize, "sanitize")
  _, _, _op = _op_def_lib._apply_op_helper(
        "DecodeProtoV2", bytes=bytes, message_type=message_type,
                         field_names=field_names, output_types=output_types,
                         descriptor_source=descriptor_source,
                         message_format=message_format, sanitize=sanitize,
                         name=name)
  _result = _op.outputs[:]
  _inputs_flat = _op.inputs
  _attrs = ("message_type", _op.get_attr("message_type"), "field_names",
            _op.get_attr("field_names"), "output_types",
            _op.get_attr("output_types"), "descriptor_source",
            _op.get_attr("descriptor_source"), "message_format",
            _op.get_attr("message_format"), "sanitize",
            _op.get_attr("sanitize"))
  _execute.record_gradient(
      "DecodeProtoV2", _inputs_flat, _attrs, _result, name)
  _result = _result[:1] + [_result[1:]]
  _result = _DecodeProtoV2Output._make(_result)
  return _result

def DecodeProtoV2(bytes, message_type, field_names, output_types, descriptor_source="local://", message_format="binary", sanitize=False, name=None):
  return decode_proto_v2(bytes=bytes, message_type=message_type, field_names=field_names, output_types=output_types, descriptor_source=descriptor_source, message_format=message_format, sanitize=sanitize, name=name)
DecodeProtoV2.__doc__ = decode_proto_v2.__doc__
DecodeProtoV2 = _doc_controls.do_not_generate_docs(_kwarg_only(DecodeProtoV2))
tf_export("raw_ops.DecodeProtoV2")(DecodeProtoV2)


def decode_proto_v2_eager_fallback(bytes, message_type, field_names, output_types, descriptor_source="local://", message_format="binary", sanitize=False, name=None, ctx=None):
  r"""This is the slowpath function for Eager mode.
  This is for function decode_proto_v2
  """
  _ctx = ctx if ctx else _context.context()
  message_type = _execute.make_str(message_type, "message_type")
  if not isinstance(field_names, (list, tuple)):
    raise TypeError(
        "Expected list for 'field_names' argument to "
        "'decode_proto_v2' Op, not %r." % field_names)
  field_names = [_execute.make_str(_s, "field_names") for _s in field_names]
  if not isinstance(output_types, (list, tuple)):
    raise TypeError(
        "Expected list for 'output_types' argument to "
        "'decode_proto_v2' Op, not %r." % output_types)
  output_types = [_execute.make_type(_t, "output_types") for _t in output_types]
  if descriptor_source is None:
    descriptor_source = "local://"
  descriptor_source = _execute.make_str(descriptor_source, "descriptor_source")
  if message_format is None:
    message_format = "binary"
  message_format = _execute.make_str(message_format, "message_format")
  if sanitize is None:
    sanitize = False
  sanitize = _execute.make_bool(sanitize, "sanitize")
  bytes = _ops.convert_to_tensor(bytes, _dtypes.string)
  _inputs_flat = [bytes]
  _attrs = ("message_type", message_type, "field_names", field_names,
  "output_types", output_types, "descriptor_source", descriptor_source,
  "message_format", message_format, "sanitize", sanitize)
  _result = _execute.execute(b"DecodeProtoV2", len(output_types) + 1,
                             inputs=_inputs_flat, attrs=_attrs, ctx=_ctx,
                             name=name)
  _execute.record_gradient(
      "DecodeProtoV2", _inputs_flat, _attrs, _result, name)
  _result = _result[:1] + [_result[1:]]
  _result = _DecodeProtoV2Output._make(_result)
  return _result

def _InitOpDefLibrary(op_list_proto_bytes):
  op_list = _op_def_pb2.OpList()
  op_list.ParseFromString(op_list_proto_bytes)
  _op_def_registry.register_op_list(op_list)
  op_def_lib = _op_def_library.OpDefLibrary()
  op_def_lib.add_op_list(op_list)
  return op_def_lib
# op {
#   name: "DecodeProtoV2"
#   input_arg {
#     name: "bytes"
#     type: DT_STRING
#   }
#   output_arg {
#     name: "sizes"
#     type: DT_INT32
#   }
#   output_arg {
#     name: "values"
#     type_list_attr: "output_types"
#   }
#   attr {
#     name: "message_type"
#     type: "string"
#   }
#   attr {
#     name: "field_names"
#     type: "list(string)"
#   }
#   attr {
#     name: "output_types"
#     type: "list(type)"
#     has_minimum: true
#   }
#   attr {
#     name: "descriptor_source"
#     type: "string"
#     default_value {
#       s: "local://"
#     }
#   }
#   attr {
#     name: "message_format"
#     type: "string"
#     default_value {
#       s: "binary"
#     }
#   }
#   attr {
#     name: "sanitize"
#     type: "bool"
#     default_value {
#       b: false
#     }
#   }
# }
_op_def_lib = _InitOpDefLibrary(b"\n\363\001\n\rDecodeProtoV2\022\t\n\005bytes\030\007\032\t\n\005sizes\030\003\032\026\n\006values2\014output_types\"\026\n\014message_type\022\006string\"\033\n\013field_names\022\014list(string)\"\034\n\014output_types\022\nlist(type)(\001\"\'\n\021descriptor_source\022\006string\032\n\022\010local://\"\"\n\016message_format\022\006string\032\010\022\006binary\"\024\n\010sanitize\022\004bool\032\002(\000")
