"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from orq_poc_python_client.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class PostContactsRequestBodyTypedDict(TypedDict):
    r"""Update user information payload"""

    external_id: str
    r"""Unique string value to identify the contact user in the customer's system"""
    display_name: NotRequired[Nullable[str]]
    r"""Display name or nickname of the user"""
    email: NotRequired[Nullable[str]]
    r"""Email address of the user"""
    avatar_url: NotRequired[Nullable[str]]
    r"""URL linking to the user's avatar image"""
    tags: NotRequired[List[str]]
    r"""Array of UUIDs representing tags associated with the user"""
    metadata: NotRequired[Dict[str, Any]]
    r"""Additional custom metadata associated with the user as key-value pairs"""


class PostContactsRequestBody(BaseModel):
    r"""Update user information payload"""

    external_id: str
    r"""Unique string value to identify the contact user in the customer's system"""

    display_name: OptionalNullable[str] = UNSET
    r"""Display name or nickname of the user"""

    email: OptionalNullable[str] = UNSET
    r"""Email address of the user"""

    avatar_url: OptionalNullable[str] = UNSET
    r"""URL linking to the user's avatar image"""

    tags: Optional[List[str]] = None
    r"""Array of UUIDs representing tags associated with the user"""

    metadata: Optional[Dict[str, Any]] = None
    r"""Additional custom metadata associated with the user as key-value pairs"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["display_name", "email", "avatar_url", "tags", "metadata"]
        nullable_fields = ["display_name", "email", "avatar_url"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostContactsResponseBodyTypedDict(TypedDict):
    r"""Successful operation"""

    success: bool
    r"""Indicate whether the contact have been added or updated."""


class PostContactsResponseBody(BaseModel):
    r"""Successful operation"""

    success: bool
    r"""Indicate whether the contact have been added or updated."""
