"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
import dateutil.parser
from enum import Enum
import io
from orq_poc_python_client.types import BaseModel
from orq_poc_python_client.utils import FieldMetadata, MultipartFormMetadata
import pydantic
from typing import IO, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class FileTypedDict(TypedDict):
    file_name: str
    content: Union[bytes, IO[bytes], io.BufferedReader]
    content_type: NotRequired[str]


class File(BaseModel):
    file_name: Annotated[
        str, pydantic.Field(alias="file"), FieldMetadata(multipart=True)
    ]

    content: Annotated[
        Union[bytes, IO[bytes], io.BufferedReader],
        pydantic.Field(alias=""),
        FieldMetadata(multipart=MultipartFormMetadata(content=True)),
    ]

    content_type: Annotated[
        Optional[str],
        pydantic.Field(alias="Content-Type"),
        FieldMetadata(multipart=True),
    ] = None


class Purpose(str, Enum):
    r"""The intended purpose of the uploaded file."""

    RETRIEVAL = "retrieval"


class PostV2FilesRequestBodyTypedDict(TypedDict):
    file: NotRequired[FileTypedDict]
    r"""The file to be uploaded."""
    purpose: NotRequired[Purpose]
    r"""The intended purpose of the uploaded file."""


class PostV2FilesRequestBody(BaseModel):
    file: Annotated[
        Optional[File],
        pydantic.Field(alias=""),
        FieldMetadata(multipart=MultipartFormMetadata(file=True)),
    ] = None
    r"""The file to be uploaded."""

    purpose: Annotated[Optional[Purpose], FieldMetadata(multipart=True)] = (
        Purpose.RETRIEVAL
    )
    r"""The intended purpose of the uploaded file."""


class PostV2FilesPurpose(str, Enum):
    r"""The intended purpose of the uploaded file."""

    RETRIEVAL = "retrieval"


class PostV2FilesResponseBodyTypedDict(TypedDict):
    r"""File uploaded successfully"""

    id: str
    object_name: str
    r"""path to the file in the storage"""
    purpose: PostV2FilesPurpose
    r"""The intended purpose of the uploaded file."""
    bytes: float
    file_name: str
    created: NotRequired[datetime]
    r"""The date and time the resource was created"""


class PostV2FilesResponseBody(BaseModel):
    r"""File uploaded successfully"""

    id: Annotated[str, pydantic.Field(alias="_id")]

    object_name: str
    r"""path to the file in the storage"""

    purpose: PostV2FilesPurpose
    r"""The intended purpose of the uploaded file."""

    bytes: float

    file_name: str

    created: Optional[datetime] = dateutil.parser.isoparse("2024-11-11T10:55:18.446Z")
    r"""The date and time the resource was created"""
