"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from orq_poc_python_client.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Any, AsyncGenerator, Dict, Generator, List, Optional, Union
from typing_extensions import NotRequired, TypedDict


class PostV2RouterChatCompletionsMessagesRouterPublicRole(str, Enum):
    r"""The role of the messages author, in this case **tool**."""

    TOOL = "tool"


class PostV2RouterChatCompletions2RouterPublicRequestRequestBodyMessagesType(str, Enum):
    IMAGE_URL = "image_url"


class PostV2RouterChatCompletions2Detail(str, Enum):
    r"""Specifies the detail level of the image."""

    LOW = "low"
    HIGH = "high"
    AUTO = "auto"


class PostV2RouterChatCompletions2RouterPublicImageURLTypedDict(TypedDict):
    url: str
    r"""Either a URL of the image or the base64 encoded image data."""
    detail: NotRequired[PostV2RouterChatCompletions2Detail]
    r"""Specifies the detail level of the image."""


class PostV2RouterChatCompletions2RouterPublicImageURL(BaseModel):
    url: str
    r"""Either a URL of the image or the base64 encoded image data."""

    detail: Optional[PostV2RouterChatCompletions2Detail] = None
    r"""Specifies the detail level of the image."""


class PostV2RouterChatCompletions2RouterPublic2TypedDict(TypedDict):
    type: PostV2RouterChatCompletions2RouterPublicRequestRequestBodyMessagesType
    image_url: PostV2RouterChatCompletions2RouterPublicImageURLTypedDict


class PostV2RouterChatCompletions2RouterPublic2(BaseModel):
    type: PostV2RouterChatCompletions2RouterPublicRequestRequestBodyMessagesType

    image_url: PostV2RouterChatCompletions2RouterPublicImageURL


class PostV2RouterChatCompletions2RouterPublicRequestRequestBodyType(str, Enum):
    TEXT = "text"


class PostV2RouterChatCompletions2RouterPublic1TypedDict(TypedDict):
    type: PostV2RouterChatCompletions2RouterPublicRequestRequestBodyType
    text: str


class PostV2RouterChatCompletions2RouterPublic1(BaseModel):
    type: PostV2RouterChatCompletions2RouterPublicRequestRequestBodyType

    text: str


PostV2RouterChatCompletionsContentRouterPublic2TypedDict = Union[
    PostV2RouterChatCompletions2RouterPublic1TypedDict,
    PostV2RouterChatCompletions2RouterPublic2TypedDict,
]


PostV2RouterChatCompletionsContentRouterPublic2 = Union[
    PostV2RouterChatCompletions2RouterPublic1, PostV2RouterChatCompletions2RouterPublic2
]


PostV2RouterChatCompletionsMessagesRouterPublicContentTypedDict = Union[
    str, List[PostV2RouterChatCompletionsContentRouterPublic2TypedDict]
]
r"""The contents of a particular role's message."""


PostV2RouterChatCompletionsMessagesRouterPublicContent = Union[
    str, List[PostV2RouterChatCompletionsContentRouterPublic2]
]
r"""The contents of a particular role's message."""


class FourTypedDict(TypedDict):
    role: PostV2RouterChatCompletionsMessagesRouterPublicRole
    r"""The role of the messages author, in this case **tool**."""
    tool_call_id: str
    content: PostV2RouterChatCompletionsMessagesRouterPublicContentTypedDict
    r"""The contents of a particular role's message."""


class Four(BaseModel):
    role: PostV2RouterChatCompletionsMessagesRouterPublicRole
    r"""The role of the messages author, in this case **tool**."""

    tool_call_id: str

    content: PostV2RouterChatCompletionsMessagesRouterPublicContent
    r"""The contents of a particular role's message."""


class PostV2RouterChatCompletionsMessagesRouterRole(str, Enum):
    r"""The role of the messages author, in this case **assistant**."""

    ASSISTANT = "assistant"


PostV2RouterChatCompletionsMessagesRouterContentTypedDict = Union[str, List[Any]]
r"""The contents of the assistant message. Required unless tool_calls is specified."""


PostV2RouterChatCompletionsMessagesRouterContent = Union[str, List[Any]]
r"""The contents of the assistant message. Required unless tool_calls is specified."""


class MessagesType(str, Enum):
    r"""The type of the tool. Currently, only **function** is supported."""

    FUNCTION = "function"


class MessagesFunctionTypedDict(TypedDict):
    r"""The function that the model called."""

    name: str
    r"""The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64."""
    arguments: str
    r"""The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function."""


class MessagesFunction(BaseModel):
    r"""The function that the model called."""

    name: str
    r"""The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64."""

    arguments: str
    r"""The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function."""


class MessagesToolCallsTypedDict(TypedDict):
    id: str
    r"""The ID of the tool call."""
    type: MessagesType
    r"""The type of the tool. Currently, only **function** is supported."""
    function: MessagesFunctionTypedDict
    r"""The function that the model called."""


class MessagesToolCalls(BaseModel):
    id: str
    r"""The ID of the tool call."""

    type: MessagesType
    r"""The type of the tool. Currently, only **function** is supported."""

    function: MessagesFunction
    r"""The function that the model called."""


class Messages3TypedDict(TypedDict):
    role: PostV2RouterChatCompletionsMessagesRouterRole
    r"""The role of the messages author, in this case **assistant**."""
    tool_calls: List[MessagesToolCallsTypedDict]
    r"""The tool calls generated by the model, such as function calls."""
    content: NotRequired[PostV2RouterChatCompletionsMessagesRouterContentTypedDict]
    r"""The contents of the assistant message. Required unless tool_calls is specified."""
    refusal: NotRequired[Nullable[str]]
    r"""The refusal message by the assistant."""
    name: NotRequired[str]
    r"""An optional name for the participant. Provides the model information to differentiate between participants of the same role."""


class Messages3(BaseModel):
    role: PostV2RouterChatCompletionsMessagesRouterRole
    r"""The role of the messages author, in this case **assistant**."""

    tool_calls: List[MessagesToolCalls]
    r"""The tool calls generated by the model, such as function calls."""

    content: Optional[PostV2RouterChatCompletionsMessagesRouterContent] = None
    r"""The contents of the assistant message. Required unless tool_calls is specified."""

    refusal: OptionalNullable[str] = UNSET
    r"""The refusal message by the assistant."""

    name: Optional[str] = None
    r"""An optional name for the participant. Provides the model information to differentiate between participants of the same role."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["content", "refusal", "name"]
        nullable_fields = ["refusal"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2RouterChatCompletionsMessagesRole(str, Enum):
    r"""The role of the messages author, in this case **user**."""

    USER = "user"


class PostV2RouterChatCompletions2RouterPublicRequestType(str, Enum):
    IMAGE_URL = "image_url"


class TwoDetail(str, Enum):
    r"""Specifies the detail level of the image."""

    LOW = "low"
    HIGH = "high"
    AUTO = "auto"


class PostV2RouterChatCompletions2RouterImageURLTypedDict(TypedDict):
    url: str
    r"""Either a URL of the image or the base64 encoded image data."""
    detail: NotRequired[TwoDetail]
    r"""Specifies the detail level of the image."""


class PostV2RouterChatCompletions2RouterImageURL(BaseModel):
    url: str
    r"""Either a URL of the image or the base64 encoded image data."""

    detail: Optional[TwoDetail] = None
    r"""Specifies the detail level of the image."""


class PostV2RouterChatCompletions2Router2TypedDict(TypedDict):
    type: PostV2RouterChatCompletions2RouterPublicRequestType
    image_url: PostV2RouterChatCompletions2RouterImageURLTypedDict


class PostV2RouterChatCompletions2Router2(BaseModel):
    type: PostV2RouterChatCompletions2RouterPublicRequestType

    image_url: PostV2RouterChatCompletions2RouterImageURL


class PostV2RouterChatCompletions2RouterPublicType(str, Enum):
    TEXT = "text"


class PostV2RouterChatCompletions2Router1TypedDict(TypedDict):
    type: PostV2RouterChatCompletions2RouterPublicType
    text: str


class PostV2RouterChatCompletions2Router1(BaseModel):
    type: PostV2RouterChatCompletions2RouterPublicType

    text: str


PostV2RouterChatCompletionsContentRouter2TypedDict = Union[
    PostV2RouterChatCompletions2Router1TypedDict,
    PostV2RouterChatCompletions2Router2TypedDict,
]


PostV2RouterChatCompletionsContentRouter2 = Union[
    PostV2RouterChatCompletions2Router1, PostV2RouterChatCompletions2Router2
]


PostV2RouterChatCompletionsMessagesContentTypedDict = Union[
    str, List[PostV2RouterChatCompletionsContentRouter2TypedDict]
]
r"""The contents of a particular role's message."""


PostV2RouterChatCompletionsMessagesContent = Union[
    str, List[PostV2RouterChatCompletionsContentRouter2]
]
r"""The contents of a particular role's message."""


class Messages2TypedDict(TypedDict):
    role: PostV2RouterChatCompletionsMessagesRole
    r"""The role of the messages author, in this case **user**."""
    content: PostV2RouterChatCompletionsMessagesContentTypedDict
    r"""The contents of a particular role's message."""
    name: NotRequired[str]
    r"""An optional name for the participant. Provides the model information to differentiate between participants of the same role."""


class Messages2(BaseModel):
    role: PostV2RouterChatCompletionsMessagesRole
    r"""The role of the messages author, in this case **user**."""

    content: PostV2RouterChatCompletionsMessagesContent
    r"""The contents of a particular role's message."""

    name: Optional[str] = None
    r"""An optional name for the participant. Provides the model information to differentiate between participants of the same role."""


class MessagesRole(str, Enum):
    r"""The role of the messages author, in this case **system**."""

    SYSTEM = "system"


class PostV2RouterChatCompletions2RouterType(str, Enum):
    IMAGE_URL = "image_url"


class Detail(str, Enum):
    r"""Specifies the detail level of the image."""

    LOW = "low"
    HIGH = "high"
    AUTO = "auto"


class PostV2RouterChatCompletions2ImageURLTypedDict(TypedDict):
    url: str
    r"""Either a URL of the image or the base64 encoded image data."""
    detail: NotRequired[Detail]
    r"""Specifies the detail level of the image."""


class PostV2RouterChatCompletions2ImageURL(BaseModel):
    url: str
    r"""Either a URL of the image or the base64 encoded image data."""

    detail: Optional[Detail] = None
    r"""Specifies the detail level of the image."""


class PostV2RouterChatCompletions22TypedDict(TypedDict):
    type: PostV2RouterChatCompletions2RouterType
    image_url: PostV2RouterChatCompletions2ImageURLTypedDict


class PostV2RouterChatCompletions22(BaseModel):
    type: PostV2RouterChatCompletions2RouterType

    image_url: PostV2RouterChatCompletions2ImageURL


class PostV2RouterChatCompletions2Type(str, Enum):
    TEXT = "text"


class PostV2RouterChatCompletions21TypedDict(TypedDict):
    type: PostV2RouterChatCompletions2Type
    text: str


class PostV2RouterChatCompletions21(BaseModel):
    type: PostV2RouterChatCompletions2Type

    text: str


PostV2RouterChatCompletionsContent2TypedDict = Union[
    PostV2RouterChatCompletions21TypedDict, PostV2RouterChatCompletions22TypedDict
]


PostV2RouterChatCompletionsContent2 = Union[
    PostV2RouterChatCompletions21, PostV2RouterChatCompletions22
]


MessagesContentTypedDict = Union[
    str, List[PostV2RouterChatCompletionsContent2TypedDict]
]
r"""The contents of a particular role's message."""


MessagesContent = Union[str, List[PostV2RouterChatCompletionsContent2]]
r"""The contents of a particular role's message."""


class Messages1TypedDict(TypedDict):
    role: MessagesRole
    r"""The role of the messages author, in this case **system**."""
    content: MessagesContentTypedDict
    r"""The contents of a particular role's message."""
    name: NotRequired[str]
    r"""An optional name for the participant. Provides the model information to differentiate between participants of the same role."""


class Messages1(BaseModel):
    role: MessagesRole
    r"""The role of the messages author, in this case **system**."""

    content: MessagesContent
    r"""The contents of a particular role's message."""

    name: Optional[str] = None
    r"""An optional name for the participant. Provides the model information to differentiate between participants of the same role."""


PostV2RouterChatCompletionsMessagesTypedDict = Union[
    Messages1TypedDict, Messages2TypedDict, FourTypedDict, Messages3TypedDict
]


PostV2RouterChatCompletionsMessages = Union[Messages1, Messages2, Four, Messages3]


class PostV2RouterChatCompletionsType(str, Enum):
    r"""The type of the tool. Currently, only function is supported."""

    FUNCTION = "function"


class PostV2RouterChatCompletionsRouterType(str, Enum):
    OBJECT = "object"


class ParametersTypedDict(TypedDict):
    r"""The parameters the functions accepts, described as a JSON Schema object"""

    type: PostV2RouterChatCompletionsRouterType
    properties: Dict[str, Any]
    required: NotRequired[List[str]]


class Parameters(BaseModel):
    r"""The parameters the functions accepts, described as a JSON Schema object"""

    type: PostV2RouterChatCompletionsRouterType

    properties: Dict[str, Any]

    required: Optional[List[str]] = None


class PostV2RouterChatCompletionsFunctionTypedDict(TypedDict):
    name: str
    r"""The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64."""
    description: NotRequired[str]
    r"""A description of what the function does, used by the model to choose when and how to call the function."""
    parameters: NotRequired[ParametersTypedDict]
    r"""The parameters the functions accepts, described as a JSON Schema object"""
    strict: NotRequired[Nullable[bool]]
    r"""Whether to enable strict schema adherence when generating the function call."""


class PostV2RouterChatCompletionsFunction(BaseModel):
    name: str
    r"""The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64."""

    description: Optional[str] = None
    r"""A description of what the function does, used by the model to choose when and how to call the function."""

    parameters: Optional[Parameters] = None
    r"""The parameters the functions accepts, described as a JSON Schema object"""

    strict: OptionalNullable[bool] = False
    r"""Whether to enable strict schema adherence when generating the function call."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "parameters", "strict"]
        nullable_fields = ["strict"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ToolsTypedDict(TypedDict):
    type: PostV2RouterChatCompletionsType
    r"""The type of the tool. Currently, only function is supported."""
    function: PostV2RouterChatCompletionsFunctionTypedDict


class Tools(BaseModel):
    type: PostV2RouterChatCompletionsType
    r"""The type of the tool. Currently, only function is supported."""

    function: PostV2RouterChatCompletionsFunction


class PostV2RouterChatCompletionsRequestBodyTypedDict(TypedDict):
    r"""Creates a model response for the given chat conversation."""

    model: str
    r"""ID of the model to use"""
    messages: List[PostV2RouterChatCompletionsMessagesTypedDict]
    r"""A list of messages comprising the conversation so far."""
    frequency_penalty: NotRequired[Nullable[float]]
    r"""Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim."""
    max_tokens: NotRequired[Nullable[float]]
    r"""The maximum number of tokens that can be generated in the chat completion."""
    presence_penalty: NotRequired[Nullable[float]]
    r"""Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics."""
    seed: NotRequired[Nullable[float]]
    r"""If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result."""
    stream: NotRequired[Nullable[bool]]
    r"""If set, partial message deltas will be sent, like in ChatGPT."""
    temperature: NotRequired[Nullable[float]]
    r"""What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic."""
    top_p: NotRequired[Nullable[float]]
    r"""An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass."""
    tools: NotRequired[List[ToolsTypedDict]]
    r"""A list of tools the model may call."""


class PostV2RouterChatCompletionsRequestBody(BaseModel):
    r"""Creates a model response for the given chat conversation."""

    model: str
    r"""ID of the model to use"""

    messages: List[PostV2RouterChatCompletionsMessages]
    r"""A list of messages comprising the conversation so far."""

    frequency_penalty: OptionalNullable[float] = 0
    r"""Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim."""

    max_tokens: OptionalNullable[float] = UNSET
    r"""The maximum number of tokens that can be generated in the chat completion."""

    presence_penalty: OptionalNullable[float] = 0
    r"""Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics."""

    seed: OptionalNullable[float] = UNSET
    r"""If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result."""

    stream: OptionalNullable[bool] = False
    r"""If set, partial message deltas will be sent, like in ChatGPT."""

    temperature: OptionalNullable[float] = 1
    r"""What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic."""

    top_p: OptionalNullable[float] = 1
    r"""An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass."""

    tools: Optional[List[Tools]] = None
    r"""A list of tools the model may call."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "frequency_penalty",
            "max_tokens",
            "presence_penalty",
            "seed",
            "stream",
            "temperature",
            "top_p",
            "tools",
        ]
        nullable_fields = [
            "frequency_penalty",
            "max_tokens",
            "presence_penalty",
            "seed",
            "stream",
            "temperature",
            "top_p",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2RouterChatCompletionsRouterResponseBodyTypedDict(TypedDict):
    r"""A response body that follows the official OpenAI schema"""

    data: str
    event: NotRequired[str]
    id: NotRequired[str]
    retry: NotRequired[int]


class PostV2RouterChatCompletionsRouterResponseBody(BaseModel):
    r"""A response body that follows the official OpenAI schema"""

    data: str

    event: Optional[str] = None

    id: Optional[str] = None

    retry: Optional[int] = None


class ResponseBodyFinishReason(str, Enum):
    r"""The reason the model stopped generating tokens."""

    STOP = "stop"
    LENGTH = "length"
    CONTENT_FILTER = "content_filter"
    TOOL_CALLS = "tool_calls"


class PostV2RouterChatCompletionsResponseBodyTopLogprobsTypedDict(TypedDict):
    token: str
    r"""The token."""
    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""
    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""


class PostV2RouterChatCompletionsResponseBodyTopLogprobs(BaseModel):
    token: str
    r"""The token."""

    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""

    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["bytes"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2RouterChatCompletionsResponseBodyContentTypedDict(TypedDict):
    token: str
    r"""The token."""
    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""
    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""
    top_logprobs: List[PostV2RouterChatCompletionsResponseBodyTopLogprobsTypedDict]
    r"""List of the most likely tokens and their log probability, at this token position."""


class PostV2RouterChatCompletionsResponseBodyContent(BaseModel):
    token: str
    r"""The token."""

    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""

    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""

    top_logprobs: List[PostV2RouterChatCompletionsResponseBodyTopLogprobs]
    r"""List of the most likely tokens and their log probability, at this token position."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["bytes"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2RouterChatCompletionsResponseBodyRouterTopLogprobsTypedDict(TypedDict):
    token: str
    r"""The token."""
    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""
    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""


class PostV2RouterChatCompletionsResponseBodyRouterTopLogprobs(BaseModel):
    token: str
    r"""The token."""

    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""

    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["bytes"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ResponseBodyRefusalTypedDict(TypedDict):
    token: str
    r"""The token."""
    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""
    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""
    top_logprobs: List[
        PostV2RouterChatCompletionsResponseBodyRouterTopLogprobsTypedDict
    ]
    r"""List of the most likely tokens and their log probability, at this token position."""


class ResponseBodyRefusal(BaseModel):
    token: str
    r"""The token."""

    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""

    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""

    top_logprobs: List[PostV2RouterChatCompletionsResponseBodyRouterTopLogprobs]
    r"""List of the most likely tokens and their log probability, at this token position."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["bytes"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ResponseBodyLogprobsTypedDict(TypedDict):
    r"""Log probability information for the choice."""

    content: Nullable[List[PostV2RouterChatCompletionsResponseBodyContentTypedDict]]
    r"""A list of message content tokens with log probability information."""
    refusal: Nullable[List[ResponseBodyRefusalTypedDict]]
    r"""A list of message refusal tokens with log probability information."""


class ResponseBodyLogprobs(BaseModel):
    r"""Log probability information for the choice."""

    content: Nullable[List[PostV2RouterChatCompletionsResponseBodyContent]]
    r"""A list of message content tokens with log probability information."""

    refusal: Nullable[List[ResponseBodyRefusal]]
    r"""A list of message refusal tokens with log probability information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["content", "refusal"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2RouterChatCompletionsResponseBodyType(str, Enum):
    FUNCTION = "function"


class PostV2RouterChatCompletionsResponseBodyFunctionTypedDict(TypedDict):
    r"""The function that the model called."""

    name: str
    r"""The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64."""
    arguments: str
    r"""The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function."""


class PostV2RouterChatCompletionsResponseBodyFunction(BaseModel):
    r"""The function that the model called."""

    name: str
    r"""The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64."""

    arguments: str
    r"""The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function."""


class PostV2RouterChatCompletionsResponseBodyToolCallsTypedDict(TypedDict):
    id: str
    type: PostV2RouterChatCompletionsResponseBodyType
    function: PostV2RouterChatCompletionsResponseBodyFunctionTypedDict
    r"""The function that the model called."""


class PostV2RouterChatCompletionsResponseBodyToolCalls(BaseModel):
    id: str

    type: PostV2RouterChatCompletionsResponseBodyType

    function: PostV2RouterChatCompletionsResponseBodyFunction
    r"""The function that the model called."""


class PostV2RouterChatCompletionsResponseBodyRole(str, Enum):
    SYSTEM = "system"
    ASSISTANT = "assistant"
    USER = "user"
    EXCEPTION = "exception"
    TOOL = "tool"
    PROMPT = "prompt"
    CORRECTION = "correction"
    EXPECTED_OUTPUT = "expected_output"


class DeltaTypedDict(TypedDict):
    r"""A chat completion delta generated by streamed model responses."""

    content: Nullable[str]
    refusal: Nullable[str]
    tool_calls: List[PostV2RouterChatCompletionsResponseBodyToolCallsTypedDict]
    role: PostV2RouterChatCompletionsResponseBodyRole


class Delta(BaseModel):
    r"""A chat completion delta generated by streamed model responses."""

    content: Nullable[str]

    refusal: Nullable[str]

    tool_calls: List[PostV2RouterChatCompletionsResponseBodyToolCalls]

    role: PostV2RouterChatCompletionsResponseBodyRole

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["content", "refusal"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2RouterChatCompletionsResponseBodyChoicesTypedDict(TypedDict):
    finish_reason: ResponseBodyFinishReason
    r"""The reason the model stopped generating tokens."""
    index: float
    r"""The index of the choice in the list of choices."""
    logprobs: Nullable[ResponseBodyLogprobsTypedDict]
    r"""Log probability information for the choice."""
    delta: DeltaTypedDict
    r"""A chat completion delta generated by streamed model responses."""


class PostV2RouterChatCompletionsResponseBodyChoices(BaseModel):
    finish_reason: ResponseBodyFinishReason
    r"""The reason the model stopped generating tokens."""

    index: float
    r"""The index of the choice in the list of choices."""

    logprobs: Nullable[ResponseBodyLogprobs]
    r"""Log probability information for the choice."""

    delta: Delta
    r"""A chat completion delta generated by streamed model responses."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["logprobs"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PostV2RouterChatCompletionsResponseBodyUsageTypedDict(TypedDict):
    r"""Usage statistics for the completion request."""

    completion_tokens: NotRequired[float]
    r"""Number of tokens in the generated completion."""
    prompt_tokens: NotRequired[float]
    r"""Number of tokens in the prompt."""
    total_tokens: NotRequired[float]
    r"""Total number of tokens used in the request (prompt + completion)."""


class PostV2RouterChatCompletionsResponseBodyUsage(BaseModel):
    r"""Usage statistics for the completion request."""

    completion_tokens: Optional[float] = None
    r"""Number of tokens in the generated completion."""

    prompt_tokens: Optional[float] = None
    r"""Number of tokens in the prompt."""

    total_tokens: Optional[float] = None
    r"""Total number of tokens used in the request (prompt + completion)."""


class ResponseBody2TypedDict(TypedDict):
    r"""Represents a streamed chunk of a chat completion response returned by model, based on the provided input."""

    id: str
    r"""A unique identifier for the chat completion."""
    choices: List[PostV2RouterChatCompletionsResponseBodyChoicesTypedDict]
    r"""A list of chat completion choices. Can contain more than one elements if n is greater than 1. Can also be empty for the last chunk if you set stream_options: {\"include_usage\": true}."""
    created: float
    r"""The Unix timestamp (in seconds) of when the chat completion was created."""
    model: str
    r"""The model used for the chat completion."""
    system_fingerprint: str
    r"""This fingerprint represents the backend configuration that the model runs with."""
    object: str
    r"""The object type"""
    usage: PostV2RouterChatCompletionsResponseBodyUsageTypedDict
    r"""Usage statistics for the completion request."""


class ResponseBody2(BaseModel):
    r"""Represents a streamed chunk of a chat completion response returned by model, based on the provided input."""

    id: str
    r"""A unique identifier for the chat completion."""

    choices: List[PostV2RouterChatCompletionsResponseBodyChoices]
    r"""A list of chat completion choices. Can contain more than one elements if n is greater than 1. Can also be empty for the last chunk if you set stream_options: {\"include_usage\": true}."""

    created: float
    r"""The Unix timestamp (in seconds) of when the chat completion was created."""

    model: str
    r"""The model used for the chat completion."""

    system_fingerprint: str
    r"""This fingerprint represents the backend configuration that the model runs with."""

    object: str
    r"""The object type"""

    usage: PostV2RouterChatCompletionsResponseBodyUsage
    r"""Usage statistics for the completion request."""


class PostV2RouterChatCompletionsResponseBodyFinishReason(str, Enum):
    r"""The reason the model stopped generating tokens."""

    STOP = "stop"
    LENGTH = "length"
    CONTENT_FILTER = "content_filter"
    TOOL_CALLS = "tool_calls"


class ResponseBodyType(str, Enum):
    FUNCTION = "function"


class ResponseBodyFunctionTypedDict(TypedDict):
    r"""The function that the model called."""

    name: str
    r"""The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64."""
    arguments: str
    r"""The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function."""


class ResponseBodyFunction(BaseModel):
    r"""The function that the model called."""

    name: str
    r"""The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64."""

    arguments: str
    r"""The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function."""


class ResponseBodyToolCallsTypedDict(TypedDict):
    id: str
    type: ResponseBodyType
    function: ResponseBodyFunctionTypedDict
    r"""The function that the model called."""


class ResponseBodyToolCalls(BaseModel):
    id: str

    type: ResponseBodyType

    function: ResponseBodyFunction
    r"""The function that the model called."""


class ResponseBodyRole(str, Enum):
    SYSTEM = "system"
    ASSISTANT = "assistant"
    USER = "user"
    EXCEPTION = "exception"
    TOOL = "tool"
    PROMPT = "prompt"
    CORRECTION = "correction"
    EXPECTED_OUTPUT = "expected_output"


class ResponseBodyMessageTypedDict(TypedDict):
    r"""A chat completion message generated by the model."""

    content: Nullable[str]
    refusal: Nullable[str]
    tool_calls: List[ResponseBodyToolCallsTypedDict]
    role: ResponseBodyRole


class ResponseBodyMessage(BaseModel):
    r"""A chat completion message generated by the model."""

    content: Nullable[str]

    refusal: Nullable[str]

    tool_calls: List[ResponseBodyToolCalls]

    role: ResponseBodyRole

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["content", "refusal"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TopLogprobsTypedDict(TypedDict):
    token: str
    r"""The token."""
    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""
    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""


class TopLogprobs(BaseModel):
    token: str
    r"""The token."""

    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""

    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["bytes"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ResponseBodyContentTypedDict(TypedDict):
    token: str
    r"""The token."""
    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""
    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""
    top_logprobs: List[TopLogprobsTypedDict]
    r"""List of the most likely tokens and their log probability, at this token position."""


class ResponseBodyContent(BaseModel):
    token: str
    r"""The token."""

    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""

    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""

    top_logprobs: List[TopLogprobs]
    r"""List of the most likely tokens and their log probability, at this token position."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["bytes"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ResponseBodyTopLogprobsTypedDict(TypedDict):
    token: str
    r"""The token."""
    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""
    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""


class ResponseBodyTopLogprobs(BaseModel):
    token: str
    r"""The token."""

    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""

    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["bytes"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class RefusalTypedDict(TypedDict):
    token: str
    r"""The token."""
    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""
    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""
    top_logprobs: List[ResponseBodyTopLogprobsTypedDict]
    r"""List of the most likely tokens and their log probability, at this token position."""


class Refusal(BaseModel):
    token: str
    r"""The token."""

    logprob: float
    r"""The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely."""

    bytes: Nullable[List[float]]
    r"""A list of integers representing the UTF-8 bytes representation of the token."""

    top_logprobs: List[ResponseBodyTopLogprobs]
    r"""List of the most likely tokens and their log probability, at this token position."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["bytes"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class LogprobsTypedDict(TypedDict):
    r"""Log probability information for the choice."""

    content: Nullable[List[ResponseBodyContentTypedDict]]
    r"""A list of message content tokens with log probability information."""
    refusal: Nullable[List[RefusalTypedDict]]
    r"""A list of message refusal tokens with log probability information."""


class Logprobs(BaseModel):
    r"""Log probability information for the choice."""

    content: Nullable[List[ResponseBodyContent]]
    r"""A list of message content tokens with log probability information."""

    refusal: Nullable[List[Refusal]]
    r"""A list of message refusal tokens with log probability information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["content", "refusal"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ResponseBodyChoicesTypedDict(TypedDict):
    finish_reason: PostV2RouterChatCompletionsResponseBodyFinishReason
    r"""The reason the model stopped generating tokens."""
    index: float
    r"""The index of the choice in the list of choices."""
    message: ResponseBodyMessageTypedDict
    r"""A chat completion message generated by the model."""
    logprobs: Nullable[LogprobsTypedDict]
    r"""Log probability information for the choice."""


class ResponseBodyChoices(BaseModel):
    finish_reason: PostV2RouterChatCompletionsResponseBodyFinishReason
    r"""The reason the model stopped generating tokens."""

    index: float
    r"""The index of the choice in the list of choices."""

    message: ResponseBodyMessage
    r"""A chat completion message generated by the model."""

    logprobs: Nullable[Logprobs]
    r"""Log probability information for the choice."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["logprobs"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ResponseBodyUsageTypedDict(TypedDict):
    r"""Usage statistics for the completion request."""

    completion_tokens: NotRequired[float]
    r"""Number of tokens in the generated completion."""
    prompt_tokens: NotRequired[float]
    r"""Number of tokens in the prompt."""
    total_tokens: NotRequired[float]
    r"""Total number of tokens used in the request (prompt + completion)."""


class ResponseBodyUsage(BaseModel):
    r"""Usage statistics for the completion request."""

    completion_tokens: Optional[float] = None
    r"""Number of tokens in the generated completion."""

    prompt_tokens: Optional[float] = None
    r"""Number of tokens in the prompt."""

    total_tokens: Optional[float] = None
    r"""Total number of tokens used in the request (prompt + completion)."""


class ResponseBody1TypedDict(TypedDict):
    r"""Represents a chat completion response returned by model, based on the provided input."""

    id: str
    r"""A unique identifier for the chat completion."""
    choices: List[ResponseBodyChoicesTypedDict]
    r"""A list of chat completion choices. Can be more than one if n is greater than 1."""
    created: float
    r"""The Unix timestamp (in seconds) of when the chat completion was created."""
    model: str
    r"""The model used for the chat completion."""
    system_fingerprint: str
    r"""This fingerprint represents the backend configuration that the model runs with."""
    object: str
    r"""The object type"""
    usage: ResponseBodyUsageTypedDict
    r"""Usage statistics for the completion request."""


class ResponseBody1(BaseModel):
    r"""Represents a chat completion response returned by model, based on the provided input."""

    id: str
    r"""A unique identifier for the chat completion."""

    choices: List[ResponseBodyChoices]
    r"""A list of chat completion choices. Can be more than one if n is greater than 1."""

    created: float
    r"""The Unix timestamp (in seconds) of when the chat completion was created."""

    model: str
    r"""The model used for the chat completion."""

    system_fingerprint: str
    r"""This fingerprint represents the backend configuration that the model runs with."""

    object: str
    r"""The object type"""

    usage: ResponseBodyUsage
    r"""Usage statistics for the completion request."""


PostV2RouterChatCompletionsResponseBodyTypedDict = Union[
    ResponseBody1TypedDict, ResponseBody2TypedDict
]
r"""A response body that follows the official OpenAI schema"""


PostV2RouterChatCompletionsResponseBody = Union[ResponseBody1, ResponseBody2]
r"""A response body that follows the official OpenAI schema"""


PostV2RouterChatCompletionsResponseTypedDict = Union[
    PostV2RouterChatCompletionsResponseBodyTypedDict,
    Union[
        Generator[PostV2RouterChatCompletionsRouterResponseBodyTypedDict, None, None],
        AsyncGenerator[PostV2RouterChatCompletionsRouterResponseBodyTypedDict, None],
    ],
]


PostV2RouterChatCompletionsResponse = Union[
    PostV2RouterChatCompletionsResponseBody,
    Union[
        Generator[PostV2RouterChatCompletionsRouterResponseBody, None, None],
        AsyncGenerator[PostV2RouterChatCompletionsRouterResponseBody, None],
    ],
]
