"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Packaging modes for file assets.
 */
var FileAssetPackaging;
(function (FileAssetPackaging) {
    /**
     * The asset source path points to a directory, which should be archived using
     * zip and and then uploaded to Amazon S3.
     */
    FileAssetPackaging["ZIP_DIRECTORY"] = "zip";
    /**
     * The asset source path points to a single file, which should be uploaded
     * to Amazon S3.
     */
    FileAssetPackaging["FILE"] = "file";
})(FileAssetPackaging = exports.FileAssetPackaging || (exports.FileAssetPackaging = {}));
//# sourceMappingURL=data:application/json;base64,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