import { Test } from 'nodeunit';
declare const _default: {
    'the "Root" construct is a special construct which can be used as the root of the tree'(test: Test): void;
    'constructs cannot be created with an empty name unless they are root'(test: Test): void;
    'construct.name returns the name of the construct'(test: Test): void;
    'construct id can use any character except the path separator'(test: Test): void;
    'if construct id contains path seperators, they will be replaced by double-dash'(test: Test): void;
    'if "undefined" is forcefully used as an "id", it will be treated as an empty string'(test: Test): void;
    "dont allow unresolved tokens to be used in construct IDs"(test: Test): void;
    'construct.uniqueId returns a tree-unique alphanumeric id of this construct'(test: Test): void;
    'cannot calculate uniqueId if the construct path is ["Default"]'(test: Test): void;
    'construct.getChildren() returns an array of all children'(test: Test): void;
    'construct.findChild(name) can be used to retrieve a child from a parent'(test: Test): void;
    'construct.getChild(name) can be used to retrieve a child from a parent'(test: Test): void;
    'can remove children from the tree using tryRemoveChild()'(test: Test): void;
    'construct.toString() and construct.toTreeString() can be used for diagnostics'(test: Test): void;
    'construct.getContext(key) can be used to read a value from context defined at the root level'(test: Test): void;
    'construct.setContext(k,v) sets context at some level and construct.getContext(key) will return the lowermost value defined in the stack'(test: Test): void;
    'construct.setContext(key, value) can only be called before adding any children'(test: Test): void;
    'fails if context key contains unresolved tokens'(test: Test): void;
    'construct.pathParts returns an array of strings of all names from root to node'(test: Test): void;
    'if a root construct has a name, it should be included in the path'(test: Test): void;
    'construct can not be created with the name of a sibling'(test: Test): void;
    'addMetadata(type, data) can be used to attach metadata to constructs FIND_ME'(test: Test): void;
    'addMetadata(type, undefined/null) is ignored'(test: Test): void;
    'addWarning(message) can be used to add a "WARNING" message entry to the construct'(test: Test): void;
    'addError(message) can be used to add a "ERROR" message entry to the construct'(test: Test): void;
    'addInfo(message) can be used to add an "INFO" message entry to the construct'(test: Test): void;
    'multiple children of the same type, with explicit names are welcome'(test: Test): void;
    'construct.validate() can be implemented to perform validation, ConstructNode.validate(construct.node) will return all errors from the subtree (DFS)'(test: Test): void;
    'construct.lock() protects against adding children anywhere under this construct (direct or indirect)'(test: Test): void;
    'findAll returns a list of all children in either DFS or BFS'(test: Test): void;
    'ancestors returns a list of parents up to root'(test: Test): void;
    '"root" returns the root construct'(test: Test): void;
    'defaultChild': {
        'returns the child with id "Resource"'(test: Test): void;
        'returns the child with id "Default"'(test: Test): void;
        'can override defaultChild'(test: Test): void;
        'returns "undefined" if there is no default'(test: Test): void;
        'fails if there are both "Resource" and "Default"'(test: Test): void;
    };
};
export = _default;
