"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDynamicReferenceService = exports.CfnDynamicReference = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const intrinsic_1 = require("./private/intrinsic");
/**
 * References a dynamically retrieved value.
 *
 * This is a Construct so that subclasses will (eventually) be able to attach
 * metadata to themselves without having to change call signatures.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html
 * @stability stable
 */
class CfnDynamicReference extends intrinsic_1.Intrinsic {
    /**
     * @stability stable
     */
    constructor(service, key) {
        super('{{resolve:' + service + ':' + key + '}}');
    }
}
exports.CfnDynamicReference = CfnDynamicReference;
_a = JSII_RTTI_SYMBOL_1;
CfnDynamicReference[_a] = { fqn: "@aws-cdk/core.CfnDynamicReference", version: "1.126.0" };
/**
 * The service to retrieve the dynamic reference from.
 *
 * @stability stable
 */
var CfnDynamicReferenceService;
(function (CfnDynamicReferenceService) {
    CfnDynamicReferenceService["SSM"] = "ssm";
    CfnDynamicReferenceService["SSM_SECURE"] = "ssm-secure";
    CfnDynamicReferenceService["SECRETS_MANAGER"] = "secretsmanager";
})(CfnDynamicReferenceService = exports.CfnDynamicReferenceService || (exports.CfnDynamicReferenceService = {}));
//# sourceMappingURL=data:application/json;base64,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